/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.mro;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.manuftech.utils.ManuftechCreateBillUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mmc.pom.common.mro.utils.MRONRCUtils;

public class MROSWSEntrySaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("sorderno");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("billtype");
        e.getFieldKeys().add("bizdate");
        e.getFieldKeys().add("remark");
        e.getFieldKeys().add("project");
        e.getFieldKeys().add("materielmtc");
        e.getFieldKeys().add("customer");
        e.getFieldKeys().add("area");
        e.getFieldKeys().add("srcbillid");
        e.getFieldKeys().add("billentry.seq");
        e.getFieldKeys().add("billentry.orderno");
        e.getFieldKeys().add("billentry.isexistorder");
        e.getFieldKeys().add("billentry.progroup");
        e.getFieldKeys().add("billentry.professiona");
        e.getFieldKeys().add("billentry.workdesc");
        e.getFieldKeys().add("billentry.doctype");
        e.getFieldKeys().add("billentry.manualcode");
        e.getFieldKeys().add("billentry.manualversion");
        e.getFieldKeys().add("billentry.workhours");
        e.getFieldKeys().add("billentry.enworkhourunit");
        e.getFieldKeys().add("billentry.entryprintformat");
        e.getFieldKeys().add("billentry.recheck");
        e.getFieldKeys().add("billentry.ishelp");
        e.getFieldKeys().add("billentry.helpuser");
        e.getFieldKeys().add("billentry.ishelpmanual");
        e.getFieldKeys().add("billentry.entrystatus");
        e.getFieldKeys().add("billentry.entrymodifier");
        e.getFieldKeys().add("billentry.entrymodifydate");
        e.getFieldKeys().add("billentry.entrycarduser");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        String operationKey = e.getOperationKey();
        Long userId = UserServiceHelper.getCurrentUserId();
        Map<Long, DynamicObject> userAuthAndUserManuPersMap = this.isUserAuthAndUserManuPersMap(dataEntities);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject org = dataEntity.getDynamicObject("org");
            Boolean sysIsAuth = MRONRCUtils.getSysIsAuth((DynamicObject)org);
            DynamicObjectCollection billentry = dataEntity.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : billentry) {
                DynamicObject entrycarduser;
                entry.set("entrymodifier", (Object)userId);
                entry.set("entrymodifydate", (Object)new Date());
                if (StringUtils.equals((CharSequence)"submit", (CharSequence)operationKey)) {
                    entry.set("entrystatus", (Object)"B");
                }
                if (StringUtils.equals((CharSequence)"audit", (CharSequence)operationKey)) {
                    entry.set("entrystatus", (Object)"C");
                }
                if (!sysIsAuth.booleanValue() || !StringUtils.equals((CharSequence)"submit", (CharSequence)operationKey) && !StringUtils.equals((CharSequence)"save", (CharSequence)operationKey) || null != (entrycarduser = entry.getDynamicObject("entrycarduser")) || userAuthAndUserManuPersMap == null) continue;
                entry.set("entrycarduser", (Object)userAuthAndUserManuPersMap.get(userId));
            }
        }
    }

    public Map<Long, DynamicObject> isUserAuthAndUserManuPersMap(DynamicObject[] dataEntities) {
        Map<Long, Object> userIdAndManuPersMap = new HashMap<Long, DynamicObject>(16);
        Boolean isAuth = this.getIsAuth(dataEntities);
        List<Long> userIdList = this.getUserList(dataEntities);
        if (isAuth.booleanValue()) {
            userIdAndManuPersMap = MRONRCUtils.getManuPersonByUserId(userIdList);
        }
        return userIdAndManuPersMap;
    }

    public Boolean getIsAuth(DynamicObject[] dataEntities) {
        Boolean isAuth = false;
        for (DynamicObject mrosws : dataEntities) {
            DynamicObject org = mrosws.getDynamicObject("org");
            Boolean sysIsAuth = MRONRCUtils.getSysIsAuth((DynamicObject)org);
            if (!sysIsAuth.booleanValue() || isAuth.booleanValue()) continue;
            isAuth = true;
        }
        return isAuth;
    }

    public List<Long> getUserList(DynamicObject[] dataEntities) {
        ArrayList<Long> userIdList = new ArrayList<Long>(16);
        Long userId = UserServiceHelper.getCurrentUserId();
        userIdList.add(userId);
        for (DynamicObject mrosws : dataEntities) {
            DynamicObjectCollection billentry = mrosws.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : billentry) {
                DynamicObject userInfo;
                DynamicObject entrycarduser = entry.getDynamicObject("entrycarduser");
                if (null == entrycarduser || null == (userInfo = entrycarduser.getDynamicObject("user"))) continue;
                Long pkValue = (Long)userInfo.getPkValue();
                userIdList.add(pkValue);
            }
        }
        return userIdList;
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)operationKey) || StringUtils.equals((CharSequence)"submit", (CharSequence)operationKey)) {
            DynamicObject[] dataEntities;
            HashSet<Long> selectEntryIds = new HashSet<Long>(16);
            for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
                DynamicObjectCollection billentry = dataEntity.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : billentry) {
                    Long entryPkValue = (Long)entry.getPkValue();
                    selectEntryIds.add(entryPkValue);
                }
            }
            this.buildMroswsBackBillNo(selectEntryIds);
            HashMap<String, List<DynamicObject>> mroswsSelectEntryIDMap = new HashMap<String, List<DynamicObject>>(16);
            this.dealChangeDataSync(e.getDataEntities(), mroswsSelectEntryIDMap);
            this.dealManuftechFromMro(mroswsSelectEntryIDMap);
        }
    }

    private void dealManuftechFromMro(Map<String, List<DynamicObject>> mroswsSelectEntryIDMap) {
        DynamicObject[] mroswsAllByOrderID;
        Map timeMap;
        DynamicObject[] pomMroOrders;
        QFilter mromanuFilter = new QFilter("manufactureorderid", "in", mroswsSelectEntryIDMap.keySet());
        DynamicObject[] mroManus = BusinessDataServiceHelper.load((String)"sfc_mromanuftech", (String)"manufactureorderid,manufactureorderid,baseunit,baseqty,manufactureorderid,org,billno,billtype,project,mftentryseq,processroute,oprentryentity,oprentryentity.seq,oprno,oprparent,machiningtype,oprprocessgroup,oprprofessiona,oprorg,oprplanbegintime,oprplanfinishtime,oprctrlstrategy,oprstandardqty,oprqty,oprunit,overlapunit,headqty,headunit,operationqty,oprdescription,oprworkhours,oprworkhourunit,oprstatus,oprsourcetype,oprswsentryid,groentryentity.seq,groprocessgroup,grogroupstatus,gromodifier,gromodifytime,groremark,org,qty,oprproductionqty,oprcustomhours,upperratio,floorratio,basebatchqty,upperqty,floorqty,mroswshours", (QFilter[])mromanuFilter.toArray());
        HashSet<Long> orderIdSet = new HashSet<Long>(16);
        HashMap orderIdAndTimeMap = new HashMap(16);
        for (DynamicObject manus : mroManus) {
            String manufactureorderid = manus.getString("manufactureorderid");
            orderIdSet.add(Long.parseLong(manufactureorderid));
        }
        QFilter orderQFilter = new QFilter("id", "in", orderIdSet);
        for (DynamicObject pomMroOrder : pomMroOrders = BusinessDataServiceHelper.load((String)"pom_mroorder", (String)"planbegintime,planendtime", (QFilter[])orderQFilter.toArray())) {
            Long pkValue = (Long)pomMroOrder.getPkValue();
            DynamicObjectCollection treeentryentity = pomMroOrder.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : treeentryentity) {
                timeMap = new HashMap<String, Object>(16);
                timeMap.put("planbegintime", entry.get("planbegintime"));
                timeMap.put("planendtime", entry.get("planendtime"));
                orderIdAndTimeMap.put(pkValue.toString(), timeMap);
            }
        }
        HashMap<String, BigDecimal> uniqueKeyAndHoursMap = new HashMap<String, BigDecimal>(16);
        QFilter mroswsFilter = new QFilter("srcbillid", "in", orderIdSet);
        for (DynamicObject mrosws : mroswsAllByOrderID = BusinessDataServiceHelper.load((String)"pom_mrosws", (String)"srcbillid,progroup,professiona,workhours", (QFilter[])mroswsFilter.toArray())) {
            long srcbillid = mrosws.getLong("srcbillid");
            DynamicObjectCollection billentry = mrosws.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : billentry) {
                DynamicObject professiona = entry.getDynamicObject("professiona");
                DynamicObject progroup = entry.getDynamicObject("progroup");
                String uniqueKey = srcbillid + "-" + this.getUniqueKey(progroup, professiona);
                BigDecimal workhoursSum = (BigDecimal)uniqueKeyAndHoursMap.get(uniqueKey);
                BigDecimal workhours = entry.getBigDecimal("workhours");
                workhoursSum = null != workhoursSum ? workhoursSum.add(workhours) : workhours;
                uniqueKeyAndHoursMap.put(uniqueKey, workhoursSum);
            }
        }
        for (DynamicObject sfc : mroManus) {
            String manufactureorderid = sfc.getString("manufactureorderid");
            if (!mroswsSelectEntryIDMap.containsKey(manufactureorderid)) continue;
            timeMap = (Map)orderIdAndTimeMap.get(manufactureorderid);
            List<DynamicObject> mroswsSelectEntry = mroswsSelectEntryIDMap.get(manufactureorderid);
            for (DynamicObject mroswsEntry : mroswsSelectEntry) {
                DynamicObject progroup = mroswsEntry.getDynamicObject("progroup");
                DynamicObject professiona = mroswsEntry.getDynamicObject("professiona");
                String mroswsgroupprokey = this.getUniqueKey(progroup, professiona);
                String hoursUniqueKey = manufactureorderid + "-" + this.getUniqueKey(progroup, professiona);
                DynamicObjectCollection oprentryentity = sfc.getDynamicObjectCollection("oprentryentity");
                BigDecimal hours = (BigDecimal)uniqueKeyAndHoursMap.get(hoursUniqueKey);
                boolean isCreate = false;
                int maxOprno = 0;
                for (DynamicObject sfcentry : oprentryentity) {
                    int oprno = Integer.parseInt(sfcentry.getString("oprno"));
                    if (maxOprno < oprno) {
                        maxOprno = oprno;
                    }
                    DynamicObject oprprocessgroup = sfcentry.getDynamicObject("oprprocessgroup");
                    DynamicObject oprprofessiona = sfcentry.getDynamicObject("oprprofessiona");
                    BigDecimal mroswshours = sfcentry.getBigDecimal("mroswshours");
                    String sfcuniqueKey = this.getUniqueKey(oprprocessgroup, oprprofessiona);
                    Long sfcentryId = (Long)sfcentry.getPkValue();
                    String sfcUniqueKey = manufactureorderid + "-" + sfcuniqueKey;
                    if (StringUtils.equals((CharSequence)mroswsgroupprokey, (CharSequence)sfcuniqueKey)) {
                        isCreate = true;
                        if (null == hours) continue;
                        sfcentry.set("mroswshours", (Object)hours);
                        continue;
                    }
                    if (sfcentryId == 0L || uniqueKeyAndHoursMap.containsKey(sfcUniqueKey) || null == mroswshours || mroswshours.compareTo(BigDecimal.ZERO) <= 0) continue;
                    sfcentry.set("mroswshours", (Object)BigDecimal.ZERO);
                }
                if (isCreate) continue;
                DynamicObject dynamicObject = oprentryentity.addNew();
                dynamicObject.set("oprno", (Object)String.valueOf(maxOprno + 10));
                dynamicObject.set("oprparent", (Object)"1");
                dynamicObject.set("oprorg", sfc.get("org"));
                dynamicObject.set("oprproductionqty", sfc.get("qty"));
                dynamicObject.set("oprstatus", (Object)"A");
                dynamicObject.set("oprprocessgroup", (Object)progroup);
                dynamicObject.set("oprprofessiona", (Object)professiona);
                dynamicObject.set("oprworkhourunit", mroswsEntry.get("enworkhourunit"));
                dynamicObject.set("oprworkhours", (Object)BigDecimal.ZERO);
                dynamicObject.set("oprcustomhours", (Object)BigDecimal.ZERO);
                dynamicObject.set("oprsourcetype", (Object)"C");
                dynamicObject.set("upperratio", (Object)BigDecimal.ZERO);
                dynamicObject.set("floorratio", (Object)BigDecimal.ZERO);
                dynamicObject.set("basebatchqty", (Object)BigDecimal.ONE);
                dynamicObject.set("headqty", (Object)BigDecimal.ONE);
                dynamicObject.set("operationqty", (Object)BigDecimal.ONE);
                dynamicObject.set("oprunit", mroswsEntry.get("enworkhourunit"));
                dynamicObject.set("headunit", mroswsEntry.get("enworkhourunit"));
                dynamicObject.set("upperqty", (Object)dynamicObject.getBigDecimal("oprqty"));
                dynamicObject.set("floorqty", (Object)dynamicObject.getBigDecimal("oprqty"));
                if (null != hours) {
                    dynamicObject.set("mroswshours", (Object)hours);
                } else {
                    dynamicObject.set("mroswshours", mroswsEntry.get("workhours"));
                }
                dynamicObject.set("oprplanbegintime", timeMap.get("planbegintime"));
                dynamicObject.set("oprplanfinishtime", timeMap.get("planendtime"));
            }
        }
        DispatchServiceHelper.invokeBizService((String)"mmc", (String)"sfc", (String)"MroManuftechAuditSaveService", (String)"saveAuditMroManuftech", (Object[])new Object[]{mroManus, "save"});
    }

    private void dealChangeDataSync(DynamicObject[] dataEntities, Map<String, List<DynamicObject>> mroswsSelectEntryIDMap) {
        QFilter mromanuftechFilter;
        DynamicObject[] load;
        HashMap mromanuftechUpdate = new HashMap(16);
        HashSet<Long> changeEntryIds = new HashSet<Long>(16);
        HashMap mroswsUpdate = new HashMap(16);
        for (DynamicObject mrosws : dataEntities) {
            DynamicObjectCollection billentry = mrosws.getDynamicObjectCollection("billentry");
            Long srcbillid = mrosws.getLong("srcbillid");
            ArrayList<DynamicObject> selectEntry = new ArrayList<DynamicObject>(16);
            for (DynamicObject entry : billentry) {
                long pkValue = (Long)entry.getPkValue();
                HashMap<String, Object> mroswsMap = new HashMap<String, Object>(16);
                String orderno = entry.getString("orderno");
                Object workdesc = entry.get("workdesc");
                Object workhours = entry.get("workhours");
                Object enworkhourunit = entry.get("enworkhourunit");
                Object progroup = entry.get("progroup");
                Object professiona = entry.get("professiona");
                mroswsMap.put("workdesc", workdesc);
                mroswsMap.put("workhours", workhours);
                mroswsMap.put("enworkhourunit", enworkhourunit);
                mroswsMap.put("orderno", orderno);
                mroswsMap.put("professiona", professiona);
                mroswsMap.put("progroup", progroup);
                mroswsUpdate.put(orderno, mroswsMap);
                mromanuftechUpdate.put(pkValue, mroswsMap);
                changeEntryIds.add(pkValue);
                selectEntry.add(entry);
            }
            mroswsSelectEntryIDMap.put(srcbillid.toString(), selectEntry);
        }
        if (!mroswsUpdate.isEmpty()) {
            DynamicObject[] pom_mroorders;
            Set orderNoSet = mroswsUpdate.keySet();
            QFilter orderFilter = new QFilter("billno", "in", orderNoSet);
            orderFilter.and(new QFilter("transactiontype.number", "=", (Object)"MRO-0004_S"));
            for (DynamicObject pom_mroorder : pom_mroorders = BusinessDataServiceHelper.load((String)"pom_mroorder", (String)"defectdesc,planhours,workhourunit,billno", (QFilter[])orderFilter.toArray())) {
                String billno = pom_mroorder.getString("billno");
                if (!orderNoSet.contains(billno)) continue;
                Map stringObjectMap = (Map)mroswsUpdate.get(billno);
                DynamicObjectCollection treeentryentity = pom_mroorder.getDynamicObjectCollection("treeentryentity");
                for (DynamicObject entry : treeentryentity) {
                    entry.set("defectdesc", stringObjectMap.get("workdesc"));
                    entry.set("planhours", stringObjectMap.get("workhours"));
                    entry.set("workhourunit", stringObjectMap.get("enworkhourunit"));
                }
            }
            SaveServiceHelper.save((DynamicObject[])pom_mroorders);
        }
        if (null != (load = BusinessDataServiceHelper.load((String)"sfc_mromanuftech", (String)"baseunit,baseqty,manufactureorderid,org,billno,billtype,mftentryseq,processroute,oprentryentity,oprno,oprparent,machiningtype,oprprocessgroup,oprprofessiona,oprorg,oprplanbegintime,oprplanfinishtime,oprctrlstrategy,oprstandardqty,oprqty,oprunit,overlapunit,headqty,headunit,operationqty,oprdescription,oprworkhours,oprworkhourunit,oprstatus,oprsourcetype,oprswsentryid,groprocessgroup,grogroupstatus,gromodifier,gromodifytime,groremark", (QFilter[])(mromanuftechFilter = new QFilter("oprentryentity.oprswsentryid", "in", changeEntryIds)).toArray())) && load.length > 0) {
            for (DynamicObject mromanuftech : load) {
                DynamicObjectCollection oprentryentity = mromanuftech.getDynamicObjectCollection("oprentryentity");
                for (DynamicObject oprentry : oprentryentity) {
                    long oprswsentryid = oprentry.getLong("oprswsentryid");
                    Set longs = mromanuftechUpdate.keySet();
                    if (!longs.contains(oprswsentryid)) continue;
                    Map stringObjectMap = (Map)mromanuftechUpdate.get(oprswsentryid);
                    oprentry.set("oprprocessgroup", stringObjectMap.get("progroup"));
                    oprentry.set("oprprofessiona", stringObjectMap.get("professiona"));
                    oprentry.set("oprworkhours", stringObjectMap.get("workhours"));
                }
                ManuftechCreateBillUtil.setGroEntryEntityValue((DynamicObject)mromanuftech, (Date)new Date(), (long)RequestContext.get().getCurrUserId());
            }
            SaveServiceHelper.save((DynamicObject[])load);
        }
    }

    private void buildMroswsBackBillNo(Set<Long> selectEntryIds) {
        if (!selectEntryIds.isEmpty()) {
            QFilter entryQFilter = new QFilter("id", "in", selectEntryIds);
            DynamicObject[] mroswsback = BusinessDataServiceHelper.load((String)"pom_mroswsback", (String)"billno", (QFilter[])entryQFilter.toArray());
            List numbers = CodeRuleServiceHelper.getNumbers((String)"pom_mroswsback", Arrays.asList((Object[])mroswsback.clone()));
            ArrayList<DynamicObject> updatemrosws = new ArrayList<DynamicObject>(16);
            for (int i = 0; i < mroswsback.length; ++i) {
                DynamicObject mrosws = mroswsback[i];
                String billno = mrosws.getString("billno");
                if (!StringUtils.isBlank((CharSequence)billno)) continue;
                mrosws.set("billno", numbers.get(i));
                updatemrosws.add(mrosws);
            }
            if (!updatemrosws.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])updatemrosws.toArray(new DynamicObject[updatemrosws.size()]));
            }
        }
    }

    public String getUniqueKey(DynamicObject progroupd, DynamicObject professiona) {
        String progroupdid = "";
        String professionaid = "";
        String result = "";
        if (null != progroupd) {
            progroupdid = progroupd.getPkValue().toString();
        }
        if (null != professiona) {
            professionaid = professiona.getPkValue().toString();
        }
        result = progroupdid + "-" + professionaid;
        return result;
    }
}

