/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.mrocard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.utils.CreateStockUtils;
import kd.bd.mpdm.common.mftorder.utils.OrderBaseData;
import kd.bd.mpdm.common.mftorder.utils.OrderOpUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pom.business.coderule.mro.MROOrderCodeRuleHelper;
import kd.mmc.pom.common.mro.utils.MRONRCUtils;

public class MROCreatStockOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(MROCreatStockOp.class);
    private List<DynamicObject> savedataEntities = new ArrayList<DynamicObject>(16);
    private List<DynamicObject> updatedataEntities = new ArrayList<DynamicObject>(16);
    private Set<Long> deleteStockIds = new HashSet<Long>(16);
    private static final String STR_PROJECT = "project";
    private static final String STR_SOURCEBILLNUMBER = "sourceBillNumber";
    private static final String STR_CODERULE = "codeRule";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("orderbillno");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("isshowlist");
        e.getFieldKeys().add("carduser");
        e.getFieldKeys().add("auditor");
        e.getFieldKeys().add("treeentryentity");
        e.getFieldKeys().add("producttype");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("unit");
        e.getFieldKeys().add("producedept");
        e.getFieldKeys().add("bomid");
        e.getFieldKeys().add("replaceno");
        e.getFieldKeys().add("auxproperty");
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("baseqty");
        e.getFieldKeys().add("baseunit");
        e.getFieldKeys().add("auxptyqty");
        e.getFieldKeys().add("auxptyunit");
        e.getFieldKeys().add("processroute");
        e.getFieldKeys().add("materielmasterid");
        e.getFieldKeys().add("transactiontype");
        e.getFieldKeys().add("bomid");
        e.getFieldKeys().add("planbegintime");
        e.getFieldKeys().add("planendtime");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("expendbomtime");
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("bomid");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("batchno");
        e.getFieldKeys().add("auxproperty");
        e.getFieldKeys().add("inwardept");
        e.getFieldKeys().add("warehouse");
        e.getFieldKeys().add("location");
        e.getFieldKeys().add("iscontrolqty");
        e.getFieldKeys().add("producttype");
        e.getFieldKeys().add("biztype");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("numberautogen");
        e.getFieldKeys().add("treeentryentity.auxproperty");
        e.getFieldKeys().add("planbegintime");
        e.getFieldKeys().add("treeentryentity.replaceno");
        e.getFieldKeys().add("treeentryentity.processroute");
        e.getFieldKeys().add("treeentryentity.seq");
        e.getFieldKeys().add("treeentryentity.material");
        e.getFieldKeys().add("treeentryentity.unit");
        e.getFieldKeys().add("treeentryentity.producedept");
        e.getFieldKeys().add("treeentryentity.bomid");
        e.getFieldKeys().add("treeentryentity.qty");
        e.getFieldKeys().add("headbillno");
        e.getFieldKeys().add("treeentryentity.sourcebilltype");
        e.getFieldKeys().add("treeentryentity.materielmasterid");
        e.getFieldKeys().add("treeentryentity.configuredcode");
        e.getFieldKeys().add("treeentryentity.tracknumber");
        e.getFieldKeys().add("treeentryentity.planstatus");
        e.getFieldKeys().add("treeentryentity.pickstatus");
        e.getFieldKeys().add("treeentryentity.taskstatus");
        e.getFieldKeys().add("treeentryentity.bizstatus");
        e.getFieldKeys().add("treeentryentity.manuversion");
        e.getFieldKeys().add("treeentryentity.ecnversion");
        e.getFieldKeys().add("treeentryentity.baseunit");
        e.getFieldKeys().add("treeentryentity.baseqty");
        e.getFieldKeys().add("treeentryentity.rcvinhighlimit");
        e.getFieldKeys().add("treeentryentity.rcvinlowlimit");
        e.getFieldKeys().add("treeentryentity.workcenter");
        e.getFieldKeys().add("treeentryentity.auxptyqty");
        e.getFieldKeys().add("treeentryentity.auxptyunit");
        e.getFieldKeys().add("treeentryentity.lot");
        e.getFieldKeys().add("treeentryentity.materielinv");
        e.getFieldKeys().add("treeentryentity.planpreparetime");
        e.getFieldKeys().add("treeentryentity.materialspread");
        e.getFieldKeys().add("treeentryentity.sourceentryseq");
        e.getFieldKeys().add("treeentryentity.headbillno");
        e.getFieldKeys().add("orderbilltype");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        ArrayList<DynamicObject> orderList = new ArrayList<DynamicObject>(16);
        for (DynamicObject order : e.getDataEntities()) {
            orderList.add(order);
        }
        OrderBaseData baseData = CreateStockUtils.getStocks(orderList, (String)"save", (String)"pom_mrostock");
        this.savedataEntities.addAll(baseData.getSaveStocks());
        this.updatedataEntities.addAll(baseData.getUpdateStocks());
        this.deleteStockIds.addAll(baseData.getDeleteOrderEntryIds());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        OrderOpUtils.handleStock((String)"pom_mrostock", this.savedataEntities, this.updatedataEntities, this.deleteStockIds, (Log)logger);
        for (DynamicObject order : e.getDataEntities()) {
            order.set("isshowlist", (Object)true);
            if (null != order && !StringUtils.isNotBlank((CharSequence)order.getString("orderbillno"))) continue;
        }
        this.generateNumber(e.getDataEntities());
        SaveServiceHelper.save((DynamicObject[])e.getDataEntities());
    }

    public void generateNumber(DynamicObject[] dynamicObjects) {
        HashMap<String, ArrayList<DynamicObject>> codeMap = new HashMap<String, ArrayList<DynamicObject>>(16);
        HashMap codeObjectMap = new HashMap(16);
        for (DynamicObject data : dynamicObjects) {
            DynamicObject transactiontype = (DynamicObject)data.get("transactiontype");
            DynamicObject codeRule = this.getCodeRule(transactiontype);
            if (codeRule == null) continue;
            DynamicObject project = MRONRCUtils.getProject((DynamicObject)data);
            String keyString = MRONRCUtils.getKeyString((DynamicObject)project, (DynamicObject)codeRule);
            ArrayList<DynamicObject> rowIndexList = (ArrayList<DynamicObject>)codeMap.get(keyString);
            if (rowIndexList == null) {
                rowIndexList = new ArrayList<DynamicObject>(16);
            }
            rowIndexList.add(data);
            codeMap.put(keyString, rowIndexList);
            HashMap<String, Object> codeObject = (HashMap<String, Object>)codeObjectMap.get(keyString);
            if (codeObject != null) continue;
            codeObject = new HashMap<String, Object>(16);
            codeObject.put(STR_PROJECT, project);
            codeObject.put(STR_SOURCEBILLNUMBER, "");
            codeObject.put(STR_CODERULE, codeRule);
            codeObjectMap.put(keyString, codeObject);
        }
        for (Map.Entry entry : codeMap.entrySet()) {
            String sourceBillNumber;
            String keyString = (String)entry.getKey();
            List rowIndexList = (List)entry.getValue();
            if (rowIndexList.isEmpty()) continue;
            Map codeObject = (Map)codeObjectMap.get(keyString);
            DynamicObject project = codeObject.get(STR_PROJECT) == null ? null : (DynamicObject)codeObject.get(STR_PROJECT);
            DynamicObject codeRule = codeObject.get(STR_CODERULE) == null ? null : (DynamicObject)codeObject.get(STR_CODERULE);
            List codeList = MROOrderCodeRuleHelper.genCodeRuleNumbersByImmediately((DynamicObject)codeRule, (DynamicObject)project, (String)(sourceBillNumber = codeObject.get(STR_SOURCEBILLNUMBER) == null ? null : (String)codeObject.get(STR_SOURCEBILLNUMBER)), (int)rowIndexList.size());
            int codeSize = codeList.size();
            if (codeSize <= 0) continue;
            for (int i = 0; i < rowIndexList.size(); ++i) {
                DynamicObject mroOrder = (DynamicObject)rowIndexList.get(i);
                if (codeSize < i + 1) {
                    logger.info("error:codeSize = " + codeSize + ",rowIndexList = " + rowIndexList.size());
                    continue;
                }
                String orderbillno = (String)codeList.get(i);
                mroOrder.set("orderbillno", (Object)orderbillno);
                mroOrder.set("numberautogen", (Object)true);
                DynamicObjectCollection entrys = mroOrder.getDynamicObjectCollection("treeentryentity");
                for (DynamicObject entry2 : entrys) {
                    entry2.set("headbillno", (Object)orderbillno);
                }
            }
        }
    }

    private DynamicObject getCodeRule(DynamicObject transactionType) {
        if (transactionType == null) {
            return null;
        }
        return MROOrderCodeRuleHelper.getTransactionTypeCodeMode((Long)transactionType.getLong("id"));
    }
}

