/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.orderrestructure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.helper.MaterialInvInfoHelper;
import kd.bd.mpdm.business.mftorder.OrderSpliteService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pom.business.orderrestructure.OrderRestructureService;

public class OrderRestructureOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(OrderRestructureOp.class);

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        this.dealRestructBillsEndOperationTransaction(e);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        try {
            ArrayList<DynamicObject> orderRestructureBills = new ArrayList<DynamicObject>(10);
            ArrayList<DynamicObject> orderRestructureOrderBills = new ArrayList<DynamicObject>(10);
            ArrayList<DynamicObject> orderRestructureInvBills = new ArrayList<DynamicObject>(10);
            HashMap<Long, ArrayList<Long>> orgMasterMap = new HashMap<Long, ArrayList<Long>>(16);
            for (DynamicObject orderRestructureBill : e.getDataEntities()) {
                Object stockEntry2;
                orderRestructureBills.add(orderRestructureBill);
                String restructurtype = orderRestructureBill.getString("restructurtype");
                if (StringUtils.equals((CharSequence)"B", (CharSequence)restructurtype)) {
                    orderRestructureOrderBills.add(orderRestructureBill);
                }
                if (StringUtils.equals((CharSequence)"A", (CharSequence)restructurtype)) {
                    orderRestructureInvBills.add(orderRestructureBill);
                }
                DynamicObjectCollection retstockentrys = orderRestructureBill.getDynamicObjectCollection("retstockentry");
                for (Object stockEntry2 : retstockentrys) {
                    DynamicObject material = stockEntry2.getDynamicObject("retmftmaterial");
                    DynamicObject supply = stockEntry2.getDynamicObject("retsupplyorgid");
                    if (material == null || supply == null || material.getDynamicObject("masterid") == null) continue;
                    DynamicObject masterid = material.getDynamicObject("masterid");
                    Long orgId = (Long)supply.getPkValue();
                    ArrayList<Long> list = (ArrayList<Long>)orgMasterMap.get(orgId);
                    if (list == null) {
                        list = new ArrayList<Long>(16);
                    }
                    list.add((Long)masterid.getPkValue());
                    orgMasterMap.put(orgId, list);
                }
                DynamicObjectCollection scrapstockentrys = orderRestructureBill.getDynamicObjectCollection("scrapstockentry");
                stockEntry2 = scrapstockentrys.iterator();
                while (stockEntry2.hasNext()) {
                    DynamicObject stockEntry3 = (DynamicObject)stockEntry2.next();
                    DynamicObject material = stockEntry3.getDynamicObject("scrapmftmaterial");
                    DynamicObject supply = stockEntry3.getDynamicObject("scrapsupplyorgid");
                    if (material == null || supply == null || material.getDynamicObject("masterid") == null) continue;
                    DynamicObject masterid = material.getDynamicObject("masterid");
                    Long orgId = (Long)supply.getPkValue();
                    ArrayList<Long> list = (ArrayList<Long>)orgMasterMap.get(orgId);
                    if (list == null) {
                        list = new ArrayList<Long>(16);
                    }
                    list.add((Long)masterid.getPkValue());
                    orgMasterMap.put(orgId, list);
                }
                DynamicObjectCollection mrqstockentrys = orderRestructureBill.getDynamicObjectCollection("mrqstockentry");
                for (DynamicObject stockEntry4 : mrqstockentrys) {
                    DynamicObject material = stockEntry4.getDynamicObject("mrqmftmaterial");
                    DynamicObject supply = stockEntry4.getDynamicObject("mrqsupplyorgid");
                    if (material == null || supply == null || material.getDynamicObject("masterid") == null) continue;
                    DynamicObject masterid = material.getDynamicObject("masterid");
                    Long orgId = (Long)supply.getPkValue();
                    ArrayList<Long> list = (ArrayList<Long>)orgMasterMap.get(orgId);
                    if (list == null) {
                        list = new ArrayList<Long>(16);
                    }
                    list.add((Long)masterid.getPkValue());
                    orgMasterMap.put(orgId, list);
                }
            }
            this.dealRestructureOrderBills(orderRestructureBills);
            logger.info("OrderRestructureOp afterExecuteOperationTransaction dealRestructureOrderBills -> end");
            HashMap<Long, DynamicObject> resEntryIdAndStockEntryMap = new HashMap<Long, DynamicObject>(16);
            HashMap<Long, DynamicObject> scrapEntryIdAndStockEntryMap = new HashMap<Long, DynamicObject>(16);
            Map res = MaterialInvInfoHelper.batchGetMaterialInvInfo(orgMasterMap);
            if (!CollectionUtils.isEmpty(orderRestructureOrderBills)) {
                this.dealRestructureOrderBillAdd(orderRestructureOrderBills, res, resEntryIdAndStockEntryMap, scrapEntryIdAndStockEntryMap);
                logger.info("OrderRestructureOp afterExecuteOperationTransaction dealRestructureOrderBillAdd -> end");
            }
            if (!CollectionUtils.isEmpty(orderRestructureInvBills)) {
                this.dealRestructureInvBillsAdd(orderRestructureInvBills, res);
                logger.info("OrderRestructureOp afterExecuteOperationTransaction dealRestructureInvBillsAdd -> end");
            }
            this.dealRestructureOrderBillsXAfter(orderRestructureOrderBills);
            logger.info("OrderRestructureOp afterExecuteOperationTransaction dealRestructureOrderBillsXAfter -> end");
            this.setResEntryIdAndStockEntry(orderRestructureOrderBills, resEntryIdAndStockEntryMap, scrapEntryIdAndStockEntryMap);
            logger.info("OrderRestructureOp afterExecuteOperationTransaction setResEntryIdAndStockEntry -> end");
            for (DynamicObject orderRestructureBill : orderRestructureBills) {
                orderRestructureBill.set("isrestructured", (Object)true);
            }
            logger.info("OrderRestructureOp afterExecuteOperationTransaction setisrestructured -> end");
            SaveServiceHelper.update((DynamicObject[])orderRestructureBills.toArray(new DynamicObject[orderRestructureBills.size()]));
        }
        catch (Exception e2) {
            ArrayList<DynamicObject> restructBills = new ArrayList<DynamicObject>(10);
            for (DynamicObject orderRestructureBill : e.getDataEntities()) {
                restructBills.add(orderRestructureBill);
            }
            OrderRestructureService.restructOpRollBack(restructBills);
            logger.info("OrderRestructureOp afterExecuteOperationTransaction restructOpRollBack -> end");
            logger.error("OrderRestructureOp" + e2);
            throw new KDBizException(new ErrorCode("orderrestructop", e2.getMessage()), new Object[0]);
        }
    }

    private void setResEntryIdAndStockEntry(List<DynamicObject> orderRestructureOrderBills, Map<Long, DynamicObject> resEntryIdAndStockEntryMap, Map<Long, DynamicObject> scrapEntryIdAndStockEntryMap) {
        if (!CollectionUtils.isEmpty(orderRestructureOrderBills)) {
            for (DynamicObject orderRestructureOrderBill : orderRestructureOrderBills) {
                DynamicObject object;
                if (!CollectionUtils.isEmpty(resEntryIdAndStockEntryMap)) {
                    DynamicObjectCollection retEntrys = orderRestructureOrderBill.getDynamicObjectCollection("retstockentry");
                    for (DynamicObject retEntry : retEntrys) {
                        Long retEntryId = retEntry.getLong("id");
                        object = resEntryIdAndStockEntryMap.get(retEntryId);
                        if (null == object) continue;
                        retEntry.set("retstockentryid", (Object)object.getLong("id"));
                    }
                }
                if (CollectionUtils.isEmpty(scrapEntryIdAndStockEntryMap)) continue;
                DynamicObjectCollection scrapEntrys = orderRestructureOrderBill.getDynamicObjectCollection("scrapstockentry");
                for (DynamicObject scrapEntry : scrapEntrys) {
                    Long scrapEntryId = scrapEntry.getLong("id");
                    object = scrapEntryIdAndStockEntryMap.get(scrapEntryId);
                    if (null == object) continue;
                    scrapEntry.set("scrapstockentryid", (Object)object.getLong("id"));
                }
            }
        }
    }

    private void dealRestructureOrderBillsXAfter(List<DynamicObject> orderRestructureOrderBills) {
        HashSet<Long> srcOrderEntryIds = new HashSet<Long>(16);
        HashSet<Long> xOrderIds = new HashSet<Long>(16);
        for (DynamicObject orderRestructureOrderBill : orderRestructureOrderBills) {
            DynamicObject pborderentryid = orderRestructureOrderBill.getDynamicObject("pborderentryid");
            if (null != pborderentryid) {
                srcOrderEntryIds.add(pborderentryid.getLong("id"));
            }
            xOrderIds.add(orderRestructureOrderBill.getLong("pbxorderid"));
        }
        String selectPro = OrderSpliteService.getBillAllPropers((String)"pom_mftorder", (String[])new String[]{"treeentryentity"});
        QFilter qFilter = new QFilter("treeentryentity.id", "in", srcOrderEntryIds);
        DynamicObject[] mftorderBillForPks = BusinessDataServiceHelper.load((String)"pom_mftorder", (String)selectPro, (QFilter[])new QFilter[]{qFilter});
        OrderRestructureService.xmftorderAfter(xOrderIds);
        OrderRestructureService.updateSrcOrder(Arrays.asList(mftorderBillForPks), orderRestructureOrderBills, srcOrderEntryIds);
    }

    private void dealRestructureOrderBillsX(List<DynamicObject> orderRestructureOrderBills) {
        HashSet<Long> srcOrderEntryIds = new HashSet<Long>(16);
        for (DynamicObject orderRestructureOrderBill : orderRestructureOrderBills) {
            DynamicObject pborderentryid = orderRestructureOrderBill.getDynamicObject("pborderentryid");
            if (null == pborderentryid) continue;
            srcOrderEntryIds.add(pborderentryid.getLong("id"));
        }
        String selectPro = OrderSpliteService.getBillAllPropers((String)"pom_mftorder", (String[])new String[]{"treeentryentity"});
        QFilter qFilter = new QFilter("treeentryentity.id", "in", srcOrderEntryIds);
        DynamicObject[] mftorderBillForPks = BusinessDataServiceHelper.load((String)"pom_mftorder", (String)selectPro, (QFilter[])new QFilter[]{qFilter});
        OrderRestructureService.xmftorder(Arrays.asList(mftorderBillForPks), orderRestructureOrderBills, srcOrderEntryIds);
    }

    private void dealRestructBillsEndOperationTransaction(EndOperationTransactionArgs e) {
        ArrayList<DynamicObject> orderRestructureOrderBills = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> orderRestructureBills = new ArrayList<DynamicObject>(10);
        for (DynamicObject orderRestructureBill : e.getDataEntities()) {
            String restructurtype = orderRestructureBill.getString("restructurtype");
            if (StringUtils.equals((CharSequence)"B", (CharSequence)restructurtype)) {
                orderRestructureOrderBills.add(orderRestructureBill);
            }
            orderRestructureBills.add(orderRestructureBill);
        }
        if (orderRestructureOrderBills.size() > 0) {
            this.genOrderCampOnInfoForX(orderRestructureOrderBills);
            this.dealRestructureOrderBillsX(orderRestructureOrderBills);
        }
        if (orderRestructureBills.size() > 0) {
            this.genOrderCampOnInfoForStockEntrys(orderRestructureBills);
        }
    }

    private void genOrderCampOnInfoForX(List<DynamicObject> restructureBills) {
        List xorderIds = OrderRestructureService.genLongIds((String)"pom_xmftorder", (int)restructureBills.size());
        int pkValueConner = 0;
        for (DynamicObject restructureBill : restructureBills) {
            long xorderId = (Long)xorderIds.get(pkValueConner);
            restructureBill.set("pbxorderid", (Object)xorderId);
            ++pkValueConner;
        }
    }

    private void genOrderCampOnInfoForStockEntrys(List<DynamicObject> restructureBills) {
        int stockEntryIdCout = 0;
        for (DynamicObject orderRestructureBill : restructureBills) {
            DynamicObjectCollection retstockentrys = orderRestructureBill.getDynamicObjectCollection("retstockentry");
            DynamicObjectCollection scrapstockentrys = orderRestructureBill.getDynamicObjectCollection("scrapstockentry");
            DynamicObjectCollection mrqstockentrys = orderRestructureBill.getDynamicObjectCollection("mrqstockentry");
            stockEntryIdCout += retstockentrys.size();
            stockEntryIdCout += scrapstockentrys.size();
            stockEntryIdCout += mrqstockentrys.size();
        }
        List stockEntryIds = OrderRestructureService.genLongIds((String)"pom_mftstock.stockentry", (int)stockEntryIdCout);
        int pkValueConner = 0;
        for (DynamicObject orderRestructureBill : restructureBills) {
            Object retstockentry2;
            DynamicObjectCollection retstockentrys = orderRestructureBill.getDynamicObjectCollection("retstockentry");
            for (Object retstockentry2 : retstockentrys) {
                long pkvalue = (Long)stockEntryIds.get(pkValueConner);
                retstockentry2.set("retstockentryid", (Object)pkvalue);
                ++pkValueConner;
            }
            DynamicObjectCollection scrapstockentrys = orderRestructureBill.getDynamicObjectCollection("scrapstockentry");
            retstockentry2 = scrapstockentrys.iterator();
            while (retstockentry2.hasNext()) {
                DynamicObject scrapstockentry = (DynamicObject)retstockentry2.next();
                long pkvalue = (Long)stockEntryIds.get(pkValueConner);
                scrapstockentry.set("scrapstockentryid", (Object)pkvalue);
                ++pkValueConner;
            }
            DynamicObjectCollection mrqstockentrys = orderRestructureBill.getDynamicObjectCollection("mrqstockentry");
            for (DynamicObject mrqstockentry : mrqstockentrys) {
                long pkvalue = (Long)stockEntryIds.get(pkValueConner);
                mrqstockentry.set("mrqbomentryid", (Object)pkvalue);
                ++pkValueConner;
            }
        }
    }

    private void dealRestructureOrderBillAdd(List<DynamicObject> orderRestructureOrderBills, Map<Long, Map<Long, DynamicObject>> res, Map<Long, DynamicObject> resEntryIdAndStockEntryMap, Map<Long, DynamicObject> scrapEntryIdAndStockEntryMap) {
        HashSet<Long> srcOrderEntryIds = new HashSet<Long>(16);
        HashSet<Long> restructBillIds = new HashSet<Long>(16);
        for (DynamicObject orderRestructureOrderBill : orderRestructureOrderBills) {
            DynamicObject pborderentryid = orderRestructureOrderBill.getDynamicObject("pborderentryid");
            if (null != pborderentryid) {
                srcOrderEntryIds.add(pborderentryid.getLong("id"));
            }
            restructBillIds.add(orderRestructureOrderBill.getLong("id"));
        }
        Map map = BFTrackerServiceHelper.findTargetBills((String)"pom_restructurbill", (Long[])restructBillIds.toArray(new Long[restructBillIds.size()]));
        Set newOrderEntryIds = (Set)map.get("pom_mftorder");
        Set stockIds = (Set)map.get("pom_mftstock");
        Set techIds = (Set)map.get("sfc_manftech");
        OrderRestructureService.addOrderStockEntrysNew(orderRestructureOrderBills, srcOrderEntryIds, (Set)stockIds, res, resEntryIdAndStockEntryMap, scrapEntryIdAndStockEntryMap);
        OrderRestructureService.addOrderTechEntrys(orderRestructureOrderBills, (Set)newOrderEntryIds, (Set)techIds);
    }

    private void dealRestructureInvBillsAdd(List<DynamicObject> orderRestructureInvBills, Map<Long, Map<Long, DynamicObject>> res) {
        HashSet<Long> restructBillIds = new HashSet<Long>(16);
        for (DynamicObject orderRestructureOrderBill : orderRestructureInvBills) {
            restructBillIds.add(orderRestructureOrderBill.getLong("id"));
        }
        Map map = BFTrackerServiceHelper.findTargetBills((String)"pom_restructurbill", (Long[])restructBillIds.toArray(new Long[restructBillIds.size()]));
        Set newOrderEntryIds = (Set)map.get("pom_mftorder");
        Set techIds = (Set)map.get("sfc_manftech");
        Set stockIds = (Set)map.get("pom_mftstock");
        OrderRestructureService.addInvStockEntrys(orderRestructureInvBills, (Set)stockIds, res);
        OrderRestructureService.addOrderTechEntrys(orderRestructureInvBills, (Set)newOrderEntryIds, (Set)techIds);
    }

    private void dealRestructureOrderBills(List<DynamicObject> orderRestructureOrderBills) {
        OrderRestructureService.genNewOrderBill(orderRestructureOrderBills, (boolean)false);
    }
}

