/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.orderrestructure;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pom.business.autopush.StockAutoPushReturnOder;

public class OrderReturnOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(OrderReturnOp.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        for (DynamicObject orderRestructureBill : this.dataEntities = e.getDataEntities()) {
            DynamicObjectCollection retstockentrys = orderRestructureBill.getDynamicObjectCollection("retstockentry");
            Long orderEntryId = 0L;
            String type = orderRestructureBill.getString("restructurtype");
            if (StringUtils.equals((CharSequence)"B", (CharSequence)type)) {
                DynamicObject pborderentryid = orderRestructureBill.getDynamicObject("pborderentryid");
                if (null != pborderentryid) {
                    orderEntryId = pborderentryid.getLong("id");
                }
            } else {
                DynamicObject paorderentryid = orderRestructureBill.getDynamicObject("paorderentryid");
                if (null != paorderentryid) {
                    orderEntryId = paorderentryid.getLong("id");
                }
            }
            QFilter qf = new QFilter("orderentryid", "=", (Object)orderEntryId);
            this.dealRestructureOrderBills(qf, retstockentrys);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        ArrayList<DynamicObject> orderRestructureBills = new ArrayList<DynamicObject>(10);
        for (DynamicObject orderRestructureBill : this.dataEntities) {
            orderRestructureBill.set("isreturned", (Object)true);
            orderRestructureBills.add(orderRestructureBill);
        }
        SaveServiceHelper.update((DynamicObject[])orderRestructureBills.toArray(new DynamicObject[orderRestructureBills.size()]));
    }

    private void dealRestructureOrderBills(QFilter qf, DynamicObjectCollection retstockentrys) {
        if (null != qf && null != retstockentrys) {
            HashMap<Long, Set<Map<Long, BigDecimal>>> stockMap = new HashMap<Long, Set<Map<Long, BigDecimal>>>(16);
            HashMap<Long, Map<String, Object>> stockEntryMap = new HashMap<Long, Map<String, Object>>(16);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"dealReturnBills", (String)"pom_mftstock", (String)"id,stockentry.id,stockentry.wipqty,stockentry.oprno,stockentry.processseq,stockentry.materialid,stockentry.entryconfiguredcode", (QFilter[])qf.toArray(), (String)"");){
                for (Row row : dataSet) {
                    Long stockId = row.getLong("id");
                    Long stockEntryId = row.getLong("stockentry.id");
                    BigDecimal wipqty = row.getBigDecimal("stockentry.wipqty");
                    String oprno = row.getString("stockentry.oprno");
                    String processseq = row.getString("stockentry.processseq");
                    Long materialid = row.getLong("stockentry.materialid");
                    Long configuredcodeId = row.getLong("stockentry.entryconfiguredcode");
                    HashMap<String, Object> temp = new HashMap<String, Object>(16);
                    temp.put("stockId", stockId);
                    temp.put("stockentryid", stockEntryId);
                    temp.put("wipqty", wipqty);
                    temp.put("oprno", oprno);
                    temp.put("processseq", processseq);
                    temp.put("materialid", materialid);
                    temp.put("configuredcodeId", configuredcodeId);
                    stockEntryMap.put(stockEntryId, temp);
                }
            }
            this.packagePushData(stockMap, stockEntryMap, retstockentrys);
            if (!stockMap.isEmpty()) {
                boolean issuccess;
                Map ressult = StockAutoPushReturnOder.autoPush(stockMap, (String)"return");
                if (null != ressult && !(issuccess = ((Boolean)ressult.get("success")).booleanValue())) {
                    throw new KDBizException(new ErrorCode("OrderRestructureLoadInfoOp", ressult.get("message").toString()), new Object[0]);
                }
            } else {
                throw new KDBizException(new ErrorCode("OrderRestructureLoadInfoOp", ResManager.loadKDString((String)"\u65e0\u7b26\u5408\u4e0b\u63a8\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"OrderReturnOp_0", (String)"mmc-pom-opplugin", (Object[])new Object[0])), new Object[0]);
            }
        }
    }

    private void packagePushData(Map<Long, Set<Map<Long, BigDecimal>>> stockMap, Map<Long, Map<String, Object>> stockEntryMap, DynamicObjectCollection retstockentrys) {
        if (null != stockMap && null != stockEntryMap && null != retstockentrys) {
            for (DynamicObject retstockentry : retstockentrys) {
                Long stockEntryInRes = retstockentry.getLong("retstockentryid");
                Long stockId = 0L;
                DynamicObject retmftmaterial = retstockentry.getDynamicObject("retmftmaterial");
                Long retmftmaterialId = 0L;
                if (null != retmftmaterial) {
                    retmftmaterialId = retmftmaterial.getLong("id");
                }
                DynamicObject configuredCode = retstockentry.getDynamicObject("retconfiguredcode");
                Long configuredCodeId = 0L;
                if (null != configuredCode) {
                    configuredCodeId = configuredCode.getLong("id");
                }
                String retoprparent = retstockentry.getString("retoprparent");
                String oprNo = retstockentry.getString("retoprno");
                BigDecimal retplanreturnbaseqty = retstockentry.getBigDecimal("retplanreturnbaseqty");
                if (retplanreturnbaseqty.compareTo(BigDecimal.ZERO) <= 0) continue;
                Map<String, Object> stockEntry = stockEntryMap.get(stockEntryInRes);
                if (null != stockEntry) {
                    Object wipqtyObj;
                    Object stockIdObj = stockEntry.get("stockId");
                    if (null != stockIdObj) {
                        stockId = Long.parseLong(stockIdObj.toString());
                    }
                    if (null != (wipqtyObj = stockEntry.get("wipqty"))) {
                        BigDecimal wipqty = BigDecimal.valueOf(Double.parseDouble(wipqtyObj.toString()));
                        retplanreturnbaseqty = this.subQty(wipqty, retplanreturnbaseqty, stockMap, stockEntry, stockEntryInRes, stockId);
                    }
                } else {
                    logger.info(String.format("%1$s ->[%2$s,%3$s] not find.", retstockentry.getString("seq"), stockEntryInRes, retstockentry.getString("id")));
                }
                for (Map.Entry<Long, Map<String, Object>> longMapEntry : stockEntryMap.entrySet()) {
                    if (retplanreturnbaseqty.compareTo(BigDecimal.ZERO) <= 0) continue;
                    Map<String, Object> stockEntryInfo = longMapEntry.getValue();
                    Object materialidObj = stockEntryInfo.get("materialid");
                    Object oprno = stockEntryInfo.get("oprno");
                    Object processseq = stockEntryInfo.get("processseq");
                    Object stockentryidObj = stockEntryInfo.get("stockentryid");
                    Object stockIdObj = stockEntryInfo.get("stockId");
                    Object configuredcodeId = stockEntryInfo.get("configuredcodeId");
                    if (null == stockIdObj || !stockId.equals(Long.parseLong(stockIdObj.toString())) || null == stockentryidObj || null == materialidObj || null == oprno || null == processseq || !retmftmaterialId.equals(Long.parseLong(materialidObj.toString())) || !configuredCodeId.equals(Long.parseLong(configuredcodeId.toString())) || !retoprparent.equals(processseq.toString()) || !oprNo.equals(oprno.toString())) continue;
                    Long aLong = Long.parseLong(stockentryidObj.toString());
                    Object wipqtyObj = stockEntryInfo.get("wipqty");
                    if (null == wipqtyObj || BigDecimal.valueOf(Double.parseDouble(wipqtyObj.toString())).compareTo(BigDecimal.ZERO) <= 0) continue;
                    BigDecimal wipqty = BigDecimal.valueOf(Double.parseDouble(wipqtyObj.toString()));
                    retplanreturnbaseqty = this.subQty(wipqty, retplanreturnbaseqty, stockMap, stockEntryInfo, aLong, Long.parseLong(stockIdObj.toString()));
                }
            }
        }
    }

    private BigDecimal subQty(BigDecimal wipqty, BigDecimal retplanreturnbaseqty, Map<Long, Set<Map<Long, BigDecimal>>> stockMap, Map<String, Object> value, Long stockEntryId, Long stockId) {
        BigDecimal newRetplanreturnbaseqty = BigDecimal.ZERO;
        if (null != value && null != stockMap && wipqty.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal subQty = BigDecimal.ZERO;
            if (retplanreturnbaseqty.compareTo(wipqty) > 0) {
                subQty = wipqty;
                newRetplanreturnbaseqty = retplanreturnbaseqty.subtract(wipqty);
                wipqty = BigDecimal.ZERO;
            } else {
                subQty = retplanreturnbaseqty;
                wipqty = wipqty.subtract(retplanreturnbaseqty);
                newRetplanreturnbaseqty = BigDecimal.ZERO;
            }
            Set<Map<Long, BigDecimal>> tempSet = stockMap.get(stockId);
            if (null == tempSet) {
                tempSet = new HashSet<Map<Long, BigDecimal>>(16);
            }
            HashMap<Long, BigDecimal> tempMap = new HashMap<Long, BigDecimal>(16);
            tempMap.put(stockEntryId, subQty);
            tempSet.add(tempMap);
            stockMap.put(stockId, tempSet);
            value.put("wipqty", wipqty);
        }
        return newRetplanreturnbaseqty;
    }
}

