/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.orderrestructure.val;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class OrderRestructureCheckNotAuditXBillVal
extends AbstractValidator {
    public void validate() {
        HashSet<String> orderEntryIds = new HashSet<String>(16);
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject restructBill = extendedDataEntity.getDataEntity();
            DynamicObject orderEntryF7 = restructBill.getDynamicObject("pborderentryid");
            if (null == orderEntryF7) continue;
            Long orderEntryId = orderEntryF7.getLong("id");
            orderEntryIds.add(orderEntryId.toString());
        }
        HashMap<Long, List<String>> notAuditXBillOrderEntryIds = new HashMap<Long, List<String>>(16);
        if (CollectionUtils.isNotEmpty(orderEntryIds)) {
            QFilter qf = new QFilter("treeentryentity.srcbillentryid", "in", orderEntryIds);
            qf.and("billstatus", "!=", (Object)"C");
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"CheckNotAuditXBill", (String)"pom_xmftorder", (String)"billno,treeentryentity.srcbillentryid", (QFilter[])qf.toArray(), (String)"");){
                for (Row row : dataSet) {
                    Long pborderentryid = row.getLong("treeentryentity.srcbillentryid");
                    ArrayList<String> pborderentryids = (ArrayList<String>)notAuditXBillOrderEntryIds.get(pborderentryid);
                    if (null == pborderentryids) {
                        pborderentryids = new ArrayList<String>(10);
                    }
                    String billNo = row.getString("billno");
                    pborderentryids.add(billNo);
                    notAuditXBillOrderEntryIds.put(pborderentryid, pborderentryids);
                }
            }
        }
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            this.checkNotRestructedBill(extendedDataEntity, notAuditXBillOrderEntryIds);
        }
    }

    private void checkNotRestructedBill(ExtendedDataEntity dataEntity, Map<Long, List<String>> notRestructedOrderEntryIds) {
        Long orderEntryId;
        List<String> billNoInfos;
        DynamicObject restructureBill = dataEntity.getDataEntity();
        DynamicObject orderEntryF7 = restructureBill.getDynamicObject("pborderentryid");
        if (null != orderEntryF7 && null != notRestructedOrderEntryIds && CollectionUtils.isNotEmpty(billNoInfos = notRestructedOrderEntryIds.get(orderEntryId = Long.valueOf(orderEntryF7.getLong("id"))))) {
            String errorInfo = String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\uff08%1$s\uff09\u5b58\u5728\u672a\u5ba1\u6838\u7684\u751f\u4ea7\u5de5\u5355\u53d8\u66f4\u5355\uff08%2$s\uff09\u3002", (String)"OrderRestructureCheckNotAuditXBillVal_0", (String)"mmc-pom-opplugin", (Object[])new Object[0]), restructureBill.getString("pbordernumber"), StringUtils.join(billNoInfos, (String)","));
            this.addErrorMessage(dataEntity, errorInfo);
        }
    }
}

