/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.orderrestructure.val;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class OrderRestructureCheckScrapBaseQtyVal
extends AbstractValidator {
    public void validate() {
        HashSet<Long> orderEntryIds = new HashSet<Long>(16);
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject orderRestructureBill = extendedDataEntity.getDataEntity();
            DynamicObject pborderentryid = orderRestructureBill.getDynamicObject("pborderentryid");
            if (null == pborderentryid) continue;
            orderEntryIds.add(pborderentryid.getLong("id"));
        }
        HashMap<String, BigDecimal> stockEntryMap = new HashMap<String, BigDecimal>(16);
        HashMap<Long, Long> stockIdMap = new HashMap<Long, Long>(16);
        if (CollectionUtils.isNotEmpty(orderEntryIds)) {
            QFilter qf = new QFilter("orderentryid", "in", orderEntryIds);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"dealReturnBills", (String)"pom_mftstock", (String)"id,stockentry.id,stockentry.wipqty,stockentry.oprno,stockentry.processseq,stockentry.materialid,stockentry.entryconfiguredcode", (QFilter[])qf.toArray(), (String)"");){
                DataSet copy = dataSet.copy();
                for (Row row : copy) {
                    Long stockId = row.getLong("id");
                    Long stockEntryId = row.getLong("stockentry.id");
                    stockIdMap.put(stockEntryId, stockId);
                }
                DataSet sum = dataSet.groupBy(new String[]{"id", "stockentry.oprno", "stockentry.processseq", "stockentry.materialid", "stockentry.entryconfiguredcode"}).sum("stockentry.wipqty").finish();
                for (Row row : sum) {
                    Long stockId = row.getLong("id");
                    Long stockEntryMaterialId = row.getLong("stockentry.materialid");
                    String stockEntryOprNo = row.getString("stockentry.oprno");
                    String stockEntryProcessSeq = row.getString("stockentry.processseq");
                    String entryconfiguredcode = row.getString("stockentry.entryconfiguredcode");
                    String combine = "combine" + stockId + stockEntryMaterialId + stockEntryProcessSeq + stockEntryOprNo + entryconfiguredcode;
                    stockEntryMap.put(combine, row.getBigDecimal("stockentry.wipqty"));
                }
            }
        }
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            this.checkReturnBaseQty(extendedDataEntity, stockEntryMap, stockIdMap);
        }
    }

    private void checkReturnBaseQty(ExtendedDataEntity dataEntity, Map<String, BigDecimal> stockEntryMap, Map<Long, Long> stockIdMap) {
        DynamicObject retmftmaterial;
        Long stockId;
        Long stockEntryInRes;
        DynamicObject restructureBill = dataEntity.getDataEntity();
        HashMap<String, BigDecimal> retEntryMap = new HashMap<String, BigDecimal>(16);
        DynamicObjectCollection retstockentrys = restructureBill.getDynamicObjectCollection("scrapstockentry");
        for (DynamicObject retstockentry : retstockentrys) {
            stockEntryInRes = retstockentry.getLong("scrapstockentryid");
            stockId = stockIdMap.get(stockEntryInRes);
            retmftmaterial = retstockentry.getDynamicObject("scrapmftmaterial");
            Long retmftmaterialId = 0L;
            if (null != retmftmaterial) {
                retmftmaterialId = retmftmaterial.getLong("id");
            }
            String retoprparent = retstockentry.getString("scrapoprparent");
            String oprNo = retstockentry.getString("scrapoprno");
            DynamicObject configuredCode = retstockentry.getDynamicObject("scrapconfiguredcode");
            Long configuredCodeId = 0L;
            if (null != configuredCode) {
                configuredCodeId = configuredCode.getLong("id");
            }
            String combine = "combine" + stockId + retmftmaterialId + retoprparent + oprNo + configuredCodeId;
            BigDecimal retplanreturnbaseqty = retstockentry.getBigDecimal("scrapplanreturnbaseqty");
            BigDecimal totalPlanreturnBaseQty = (BigDecimal)retEntryMap.get(combine);
            if (null == totalPlanreturnBaseQty) {
                totalPlanreturnBaseQty = BigDecimal.ZERO;
            }
            totalPlanreturnBaseQty = totalPlanreturnBaseQty.add(retplanreturnbaseqty);
            retEntryMap.put(combine, totalPlanreturnBaseQty);
        }
        for (DynamicObject retstockentry : retstockentrys) {
            stockEntryInRes = retstockentry.getLong("scrapstockentryid");
            stockId = stockIdMap.get(stockEntryInRes);
            retmftmaterial = retstockentry.getDynamicObject("scrapmftmaterial");
            DynamicObject retmaterial = retstockentry.getDynamicObject("scrapmaterial");
            Long retmftmaterialId = 0L;
            String retmaterialname = "unknown";
            if (null != retmftmaterial) {
                retmftmaterialId = retmftmaterial.getLong("id");
            }
            if (null != retmaterial) {
                retmaterialname = retmaterial.getString("name");
            }
            String retoprparent = retstockentry.getString("scrapoprparent");
            String oprNo = retstockentry.getString("scrapoprno");
            DynamicObject configuredCode = retstockentry.getDynamicObject("scrapconfiguredcode");
            Long configuredCodeId = 0L;
            if (null != configuredCode) {
                configuredCodeId = configuredCode.getLong("id");
            }
            String combine = "combine" + stockId + retmftmaterialId + retoprparent + oprNo + configuredCodeId;
            BigDecimal totalPlanreturnBaseQty = (BigDecimal)retEntryMap.get(combine);
            BigDecimal totalWipQty = stockEntryMap.get(combine);
            if (null == totalPlanreturnBaseQty || null == totalWipQty || totalPlanreturnBaseQty.compareTo(totalWipQty) <= 0) continue;
            String info = String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u62a5\u5e9f\u660e\u7ec6\u7b2c%1$s\u884c\u7269\u6599\u7f16\u7801\uff08%2$s\uff09\u3001\u5e8f\u5217\u53f7\uff08%3$s\uff09\u3001\u5de5\u5e8f\u53f7\uff08%4$s\uff09\u5408\u8ba1\u8ba1\u5212\u9000\u6599\u57fa\u672c\u6570\u91cf\uff08%5$s\uff09\u8d85\u8fc7\u7ec4\u4ef6\u6e05\u5355\u5728\u5236\u6570\u91cf\uff08%6$s\uff09\uff0c\u62a5\u5e9f\u5931\u8d25\u3002", (String)"OrderRestructureCheckScrapBaseQtyVal_0", (String)"mmc-pom-opplugin", (Object[])new Object[0]), retstockentry.get("seq"), retmaterialname, retoprparent, oprNo, totalPlanreturnBaseQty, totalWipQty.compareTo(BigDecimal.ZERO) == 0 ? "0" : totalWipQty);
            this.addErrorMessage(dataEntity, info);
        }
    }
}

