/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.opplugin.prodwip;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class ProdwipBillSaveOp
extends AbstractOperationServicePlugIn {
    private static final String FIELD_ORG = "org";
    private static final String FIELD_AUDITDATE = "auditdate";
    private static final String FIELD_WIPQTY = "wipqty";
    private static final String FIELD_CHECKQTY = "checkqty";
    private static final String FIELD_DIFFQTY = "diffqty";
    private static final String[] fields = new String[]{"orderno", "orderentryid", "orderid", "stockid", "stockentryid", "stockno", "materialmasterid", "childmasterid"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add(FIELD_ORG);
        e.getFieldKeys().add(FIELD_AUDITDATE);
        e.getFieldKeys().add("billentry.wipqty");
        e.getFieldKeys().add("billentry.checkqty");
        e.getFieldKeys().add("billentry.diffqty");
        e.getFieldKeys().add("billentry.id");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] reqChangeBills = e.getDataEntities();
        ArrayList<DynamicObject> saveLogList = new ArrayList<DynamicObject>(16);
        Map<Long, DynamicObject> reqIdDymMap = this.getReqIdDymMap(reqChangeBills);
        for (int i = 0; i < reqChangeBills.length; ++i) {
            DynamicObject reqChangeBill = reqChangeBills[i];
            DynamicObjectCollection entryCol = reqChangeBill.getDynamicObjectCollection("billentry");
            DynamicObject reqLog = this.getChangeLog(reqChangeBill, entryCol, reqIdDymMap);
            if (null == reqLog) continue;
            saveLogList.add(reqLog);
        }
        if (!saveLogList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])saveLogList.toArray(new DynamicObject[saveLogList.size()]));
        }
    }

    private DynamicObject getStockEntry(Long stockEntryId, DynamicObjectCollection srcEntrys) {
        for (int i = 0; i < srcEntrys.size(); ++i) {
            DynamicObject srcEntry = (DynamicObject)srcEntrys.get(i);
            Long srcStockEntryId = (Long)srcEntry.getPkValue();
            if (!srcStockEntryId.equals(stockEntryId)) continue;
            return srcEntry;
        }
        return null;
    }

    private DynamicObject getChangeLog(DynamicObject reqChangeBill, DynamicObjectCollection entryCol, Map<Long, DynamicObject> reqIdDymMap) {
        DynamicObject reqBill = reqIdDymMap.get(reqChangeBill.getPkValue());
        if (reqBill != null) {
            ORM orm = ORM.create();
            DynamicObject prodwipbill = orm.newDynamicObject("pom_prodwipbill_log");
            prodwipbill.set(FIELD_ORG, reqChangeBill.get(FIELD_ORG));
            prodwipbill.set(FIELD_AUDITDATE, reqChangeBill.get(FIELD_AUDITDATE));
            prodwipbill.set("srcbillid", reqChangeBill.getPkValue());
            long currentUserId = UserServiceHelper.getCurrentUserId();
            Date date = new Date();
            prodwipbill.set("creator", (Object)currentUserId);
            prodwipbill.set("createtime", (Object)date);
            prodwipbill.set("modifier", (Object)currentUserId);
            prodwipbill.set("modifytime", (Object)date);
            DynamicObjectCollection logEntrys = prodwipbill.getDynamicObjectCollection("billentry");
            DynamicObjectCollection srcEntrys = reqBill.getDynamicObjectCollection("billentry");
            HashMap<String, List<DynamicObject>> srcEntryMap = new HashMap<String, List<DynamicObject>>();
            srcEntrys.stream().forEach(t -> {
                String orderno = t.getString("orderno");
                if (srcEntryMap.containsKey(orderno)) {
                    ((List)srcEntryMap.get(orderno)).add(t);
                } else {
                    ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
                    dynamicObjects.add((DynamicObject)t);
                    srcEntryMap.put(orderno, dynamicObjects);
                }
            });
            for (int i = 0; i < entryCol.size(); ++i) {
                String colValue;
                DynamicObject billEntry = (DynamicObject)entryCol.get(i);
                DynamicObject srcEntry = this.getStockEntry(billEntry, srcEntryMap);
                BigDecimal useqtySrc = BigDecimal.ZERO;
                BigDecimal wipqtySrc = BigDecimal.ZERO;
                BigDecimal checkqtySrc = BigDecimal.ZERO;
                if (srcEntry != null) {
                    useqtySrc = srcEntry.getBigDecimal("useqty");
                    wipqtySrc = srcEntry.getBigDecimal(FIELD_WIPQTY);
                    checkqtySrc = srcEntry.getBigDecimal(FIELD_CHECKQTY);
                }
                BigDecimal useqty = billEntry.getBigDecimal("useqty");
                BigDecimal wipqty = billEntry.getBigDecimal(FIELD_WIPQTY);
                BigDecimal checkqty = billEntry.getBigDecimal(FIELD_CHECKQTY);
                if (useqtySrc.compareTo(useqty) == 0 && wipqtySrc.compareTo(wipqty) == 0 && checkqtySrc.compareTo(checkqty) == 0) continue;
                DynamicObject addNew = logEntrys.addNew();
                addNew.set("srcseq", (Object)(i + 1));
                for (String field : fields) {
                    addNew.set(field, billEntry.get(field));
                }
                addNew.set("useqty", (Object)this.getBigDecimalStr(useqty));
                addNew.set(FIELD_WIPQTY, (Object)this.getBigDecimalStr(wipqty));
                addNew.set(FIELD_CHECKQTY, (Object)this.getBigDecimalStr(checkqty));
                if (useqtySrc.compareTo(useqty) != 0) {
                    colValue = this.getBigDecimalStr(useqtySrc) + "->" + this.getBigDecimalStr(useqty);
                    if (useqtySrc.compareTo(useqty) < 0) {
                        colValue = colValue + " \u2191";
                    } else if (useqtySrc.compareTo(useqty) > 0) {
                        colValue = colValue + " \u2193";
                    }
                    addNew.set("useqty", (Object)colValue);
                }
                if (wipqtySrc.compareTo(wipqty) != 0) {
                    colValue = this.getBigDecimalStr(wipqtySrc) + "->" + this.getBigDecimalStr(wipqty);
                    if (wipqtySrc.compareTo(wipqty) < 0) {
                        colValue = colValue + " \u2191";
                    } else if (wipqtySrc.compareTo(wipqty) > 0) {
                        colValue = colValue + " \u2193";
                    }
                    addNew.set(FIELD_WIPQTY, (Object)colValue);
                }
                if (checkqtySrc.compareTo(checkqty) == 0) continue;
                colValue = this.getBigDecimalStr(checkqtySrc) + "->" + this.getBigDecimalStr(checkqty);
                if (checkqtySrc.compareTo(checkqty) < 0) {
                    colValue = colValue + " \u2191";
                } else if (checkqtySrc.compareTo(checkqty) > 0) {
                    colValue = colValue + " \u2193";
                }
                addNew.set(FIELD_CHECKQTY, (Object)colValue);
            }
            if (!logEntrys.isEmpty()) {
                return prodwipbill;
            }
        }
        return null;
    }

    private DynamicObject getStockEntry(DynamicObject billEntry, Map<String, List<DynamicObject>> srcEntryMap) {
        String orderno = billEntry.getString("orderno");
        if (srcEntryMap.containsKey(orderno)) {
            List<DynamicObject> dynamicObjects = srcEntryMap.get(orderno);
            if (dynamicObjects.size() == 1) {
                return dynamicObjects.get(0);
            }
            Long orderentryid = billEntry.getDynamicObject("orderentryid") == null ? Long.valueOf(0L) : (Long)billEntry.getDynamicObject("orderentryid").getPkValue();
            Long materialmasterid = billEntry.getDynamicObject("materialmasterid") == null ? Long.valueOf(0L) : (Long)billEntry.getDynamicObject("materialmasterid").getPkValue();
            Long childmasterid = billEntry.getDynamicObject("childmasterid") == null ? Long.valueOf(0L) : (Long)billEntry.getDynamicObject("childmasterid").getPkValue();
            Long entryconfigcode = billEntry.getDynamicObject("entryconfigcode") == null ? Long.valueOf(0L) : (Long)billEntry.getDynamicObject("entryconfigcode").getPkValue();
            Long childauxproperty = billEntry.getDynamicObject("childauxproperty") == null ? Long.valueOf(0L) : (Long)billEntry.getDynamicObject("childauxproperty").getPkValue();
            Long stockid = billEntry.getLong("stockid");
            for (DynamicObject dynamicObject : dynamicObjects) {
                Long srcOrderentryid = dynamicObject.getDynamicObject("orderentryid") == null ? Long.valueOf(0L) : (Long)dynamicObject.getDynamicObject("orderentryid").getPkValue();
                Long srcMaterialmasterid = dynamicObject.getDynamicObject("materialmasterid") == null ? Long.valueOf(0L) : (Long)dynamicObject.getDynamicObject("materialmasterid").getPkValue();
                Long srcChildmasterid = dynamicObject.getDynamicObject("childmasterid") == null ? Long.valueOf(0L) : (Long)dynamicObject.getDynamicObject("childmasterid").getPkValue();
                Long srcEntryconfigcode = dynamicObject.getDynamicObject("entryconfigcode") == null ? Long.valueOf(0L) : (Long)dynamicObject.getDynamicObject("entryconfigcode").getPkValue();
                Long srcChildauxproperty = dynamicObject.getDynamicObject("childauxproperty") == null ? Long.valueOf(0L) : (Long)dynamicObject.getDynamicObject("childauxproperty").getPkValue();
                Long srcStockid = dynamicObject.getLong("stockid");
                if (!orderentryid.equals(srcOrderentryid) || !materialmasterid.equals(srcMaterialmasterid) || !childmasterid.equals(srcChildmasterid) || !stockid.equals(srcStockid) || !entryconfigcode.equals(srcEntryconfigcode) || !childauxproperty.equals(srcChildauxproperty)) continue;
                return dynamicObject;
            }
        }
        return null;
    }

    private String getBigDecimalStr(BigDecimal useqtySrc) {
        String useqtyStr = "0";
        if (BigDecimal.ZERO.compareTo(useqtySrc) != 0) {
            useqtyStr = useqtySrc.stripTrailingZeros().toPlainString();
        }
        return useqtyStr;
    }

    private Map<Long, DynamicObject> getReqIdDymMap(DynamicObject[] objs) {
        DynamicObject[] loads;
        HashSet<Long> reqBillIdSet = new HashSet<Long>(16);
        for (DynamicObject obj : objs) {
            reqBillIdSet.add((Long)obj.getPkValue());
        }
        HashMap<Long, DynamicObject> reqIdDymMap = new HashMap<Long, DynamicObject>(16);
        QFilter q = new QFilter("id", "in", reqBillIdSet);
        for (DynamicObject load : loads = BusinessDataServiceHelper.load((String)"pom_prodwipbill", (String)"org,auditdate,orderno,orderentryid,orderid,stockid,stockentryid,materialmasterid,childmasterid,materialunit,useqty,wipqty,checkqty,entryconfigcode,childauxproperty", (QFilter[])new QFilter[]{q})) {
            reqIdDymMap.put((Long)load.getPkValue(), load);
        }
        return reqIdDymMap;
    }
}

