/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.business.autopush;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.helper.BillUnitAndQtytHelper;
import kd.bd.mpdm.common.mftorder.utils.OrderOpUtils;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.botp.runtime.SourceRowReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StockAutoPushReturnOder {
    private static final Log logger = LogFactory.getLog(StockAutoPushReturnOder.class);

    public static Map<String, Object> autoPush(Map<Long, Set<Map<Long, BigDecimal>>> param, String flag) {
        logger.info((Object)("\u7ec4\u4ef6\u4e0b\u63a8\u9000\u6599\u6539\u5236\u53c2\u6570" + param.toString()));
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("success", Boolean.TRUE);
        if (MapUtils.isEmpty(param)) {
            result.put("success", Boolean.FALSE);
            return result;
        }
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("pom_mftstock");
        pushArgs.setTargetEntityNumber("im_mdc_mftreturnorder");
        pushArgs.setHasRight(false);
        pushArgs.setRuleId("1013697181581874176");
        pushArgs.setBuildConvReport(true);
        ArrayList needPushRows = new ArrayList();
        param.forEach((k, v) -> {
            for (Map map : v) {
                for (Map.Entry aLong : map.entrySet()) {
                    ListSelectedRow srcBill = new ListSelectedRow(k);
                    srcBill.setEntryEntityKey("stockentry");
                    srcBill.setEntryPrimaryKeyValue(aLong.getKey());
                    needPushRows.add(srcBill);
                }
            }
        });
        pushArgs.setSelectedRows(needPushRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (!pushResult.isSuccess()) {
            StringBuilder errMessage = new StringBuilder().append(pushResult.getMessage());
            for (SourceBillReport billReport : pushResult.getBillReports()) {
                if (billReport.isSuccess()) continue;
                errMessage.append(billReport);
            }
            result.put("success", Boolean.FALSE);
            result.put("message", String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\uff1a%s", (String)"StockAutoPushReturnOder_0", (String)"mmc-pom-business", (Object[])new Object[0]), errMessage));
            return result;
        }
        StringBuilder errMessage = new StringBuilder();
        for (SourceBillReport billReport : pushResult.getBillReports()) {
            if (billReport.isSuccess()) continue;
            errMessage.append(billReport.getBillNo());
            List linkEntityRowReports = billReport.getLinkEntityRowReports();
            Iterator iterator = linkEntityRowReports.iterator();
            while (iterator.hasNext()) {
                SourceRowReport report = (SourceRowReport)iterator.next();
                errMessage.append(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u884c\uff1a%1$s", (String)"StockAutoPushReturnOder_3", (String)"mmc-pom-business", (Object[])new Object[0]), report.getEntrySeq()));
            }
            errMessage.append(billReport.getFailMessage());
        }
        if (StringUtils.isNotBlank((CharSequence)errMessage)) {
            result.put("success", Boolean.FALSE);
            result.put("message", String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\uff1a%s", (String)"StockAutoPushReturnOder_0", (String)"mmc-pom-business", (Object[])new Object[0]), errMessage));
            return result;
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"im_mdc_mftreturnorder");
        List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        for (DynamicObject object : targetBillObjs) {
            DynamicObjectCollection billEntry = object.getDynamicObjectCollection("billentry");
            for (DynamicObject entryObj : billEntry) {
                if ("scrap".equals(flag)) {
                    entryObj.set("returnmaterialtype", (Object)"C");
                    entryObj.set("outinvstatus", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)691928796160567296L, (String)"bd_invstatus", (String)"id"));
                }
                Long mainbillentryid = entryObj.getLong("mainbillentryid");
                Long mainbillid = entryObj.getLong("mainbillid");
                BigDecimal dealQty = BigDecimal.ZERO;
                for (Map.Entry<Long, Set<Map<Long, BigDecimal>>> longSetEntry : param.entrySet()) {
                    Map<Long, BigDecimal> next;
                    Iterator<Map<Long, BigDecimal>> iterator;
                    Set<Map<Long, BigDecimal>> innerSet;
                    Long stockId = longSetEntry.getKey();
                    if (!mainbillid.equals(stockId) || null == (innerSet = longSetEntry.getValue()) || !(iterator = innerSet.iterator()).hasNext() || null == (next = iterator.next()) || null == next.get(mainbillentryid)) continue;
                    dealQty = next.get(mainbillentryid);
                    iterator.remove();
                    break;
                }
                entryObj.set("baseqty", (Object)dealQty);
                DynamicObject unit = entryObj.getDynamicObject("unit");
                DynamicObject baseUnit = entryObj.getDynamicObject("baseunit");
                DynamicObject unit2ndUnit = entryObj.getDynamicObject("unit2nd");
                DynamicObject material = entryObj.getDynamicObject("material");
                if (null != material) {
                    material = material.getDynamicObject("masterid");
                }
                BigDecimal qty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)baseUnit, (BigDecimal)dealQty, (DynamicObject)unit);
                entryObj.set("qty", (Object)qty);
                BigDecimal qtyunit2nd = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)baseUnit, (BigDecimal)dealQty, (DynamicObject)unit2ndUnit);
                entryObj.set("qtyunit2nd", (Object)qtyunit2nd);
            }
        }
        OperateOption saveOption = StockAutoPushReturnOder.getOperateOption();
        try {
            OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"im_mdc_mftreturnorder", (DynamicObject[])targetBillObjs.toArray(new DynamicObject[0]), (OperateOption)saveOption);
            List saveSuccessPkIds = saveResult.getSuccessPkIds();
            if (saveSuccessPkIds.size() < targetBillObjs.size()) {
                String resStr = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a1%s", (String)"StockAutoPushReturnOder_2", (String)"mmc-pom-business", (Object[])new Object[0]), OrderOpUtils.getErrDetail((OperationResult)saveResult));
                result.put("success", Boolean.FALSE);
                result.put("message", resStr);
                OperationServiceHelper.executeOperate((String)"delete", (String)"im_mdc_mftreturnorder", (DynamicObject[])saveSuccessPkIds.toArray(new DynamicObject[0]), (OperateOption)saveOption);
                return result;
            }
        }
        catch (Exception e) {
            result.put("success", Boolean.FALSE);
            result.put("message", e.getMessage());
            return result;
        }
        return result;
    }

    public static OperateOption getOperateOption() {
        OperateOption saveOption = OperateOption.create();
        saveOption.setVariableValue("ignorewarn", String.valueOf(true));
        saveOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        saveOption.setVariableValue("strictvalidation", String.valueOf(false));
        saveOption.setVariableValue("ignoreValidation", String.valueOf(true));
        saveOption.setVariableValue("WF", "false");
        return saveOption;
    }
}

