/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.business.batchexecute;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import kd.bd.mpdm.common.mftorder.utils.OrderOpUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.mmc.pom.business.utils.OrderClearLockUtils;

public class MroOrderBatchOpTask
implements Callable<Map<String, Object>> {
    private static final Log logger = LogFactory.getLog(MroOrderBatchOpTask.class);
    private List<Long> billIdList;
    private String operationType;
    private String entityNumber;
    private List<Long> billEntryIdList;
    public Map<String, Boolean> rcErrorMap;
    private RequestContext rc;
    private boolean isTotalError;

    public MroOrderBatchOpTask(List<Long> billidlist, List<Long> billentryidlist, String operationtype, String entitynumber, Map<String, Boolean> rcErrormap, RequestContext rc, boolean isTotalError) {
        this.billIdList = billidlist;
        this.billEntryIdList = billentryidlist;
        this.operationType = operationtype;
        this.entityNumber = entitynumber;
        this.rcErrorMap = rcErrormap;
        this.rc = rc;
        this.isTotalError = isTotalError;
    }

    private synchronized boolean isThreadError(boolean isTotalError) {
        if (!isTotalError) {
            return false;
        }
        if (this.rcErrorMap != null) {
            return this.rcErrorMap.get("threadErrorKey");
        }
        return false;
    }

    @Override
    public Map<String, Object> call() throws Exception {
        Long currentUserID = RequestContext.get().getCurrUserId();
        logger.info("--------------MroOrderBatchOpTask  begin execute ,currentUserID=" + currentUserID + ",entityNumber=" + this.entityNumber + ",operationtype=" + this.operationType);
        RequestContext.copyAndSet((RequestContext)this.rc);
        ConcurrentHashMap<String, Object> returnMap = new ConcurrentHashMap<String, Object>(16);
        if (this.isThreadError(this.isTotalError)) {
            returnMap.put("status", false);
            returnMap.put("msg", "thread execute failed,isinterrupt.");
            returnMap.put("billIdList", this.billIdList);
            return returnMap;
        }
        OperateOption operateOption = OrderClearLockUtils.getOperateOption();
        if ("sfc_mromanuftech".equalsIgnoreCase(this.entityNumber) && this.billEntryIdList != null && !this.billEntryIdList.isEmpty()) {
            operateOption.setVariableValue("orderBillType", "pom_mroorder");
            operateOption.setVariableValue("orderBillName", ResManager.loadKDString((String)"\u68c0\u4fee\u5de5\u5355", (String)"MroOrderBatchOpTask_0", (String)"mmc-pom-business", (Object[])new Object[0]));
            operateOption.setVariableValue("stockBillType", "pom_mrostock");
            ArrayList<Long> message = new ArrayList<Long>(this.billEntryIdList.size());
            for (Long entryID : this.billEntryIdList) {
                message.add(entryID);
            }
            String sb = JSON.toJSONString(message);
            operateOption.setVariableValue("operateOption", sb);
        }
        OperationResult opResult = OperationServiceHelper.executeOperate((String)this.operationType, (String)this.entityNumber, (Object[])this.billIdList.toArray(), (OperateOption)operateOption);
        List sucessPkIds = opResult.getSuccessPkIds();
        if (!opResult.isSuccess()) {
            String errorString = "";
            if (opResult.getMessage() != null) {
                errorString = opResult.getMessage();
            }
            errorString = errorString + OrderOpUtils.getErrDetail((OperationResult)opResult);
            errorString = "operationType:" + this.operationType + ",entityNumber:" + this.entityNumber + ",errorString:" + errorString;
            logger.info(String.format("MroOrderBatchOpTask \u64cd\u4f5c\u5931\u8d25%s", errorString));
            returnMap.put("status", false);
            returnMap.put("msg", errorString);
            returnMap.put("billIdList", this.billIdList);
            returnMap.put("sucessPkIds", sucessPkIds);
            return returnMap;
        }
        returnMap.put("status", true);
        returnMap.put("msg", "");
        returnMap.put("billIdList", this.billIdList);
        returnMap.put("sucessPkIds", sucessPkIds);
        return returnMap;
    }
}

