/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.business.coderule.mro;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.mmc.pom.business.coderule.mro.IMROOrderCodeRule;
import kd.mmc.pom.business.coderule.mro.impl.MROOrderCodeRuleImpl;

public class MROOrderCodeRuleHelper {
    private static final ThreadLocal<Map<Object, DynamicObject>> transTypeThreadLocal = new ThreadLocal();

    public static IMROOrderCodeRule getImplClass() {
        return new MROOrderCodeRuleImpl();
    }

    public static synchronized List<String> genCodeRuleNumbers(DynamicObject transCodeDynamicObj, DynamicObject project, String sourceBillNo, int count) {
        return MROOrderCodeRuleHelper.getImplClass().genCodeRuleNumbers(transCodeDynamicObj, project, sourceBillNo, count, false);
    }

    public static synchronized List<String> genCodeRuleNumbersByImmediately(DynamicObject transCodeDynamicObj, DynamicObject project, String sourceBillNo, int count) {
        return MROOrderCodeRuleHelper.getImplClass().genCodeRuleNumbers(transCodeDynamicObj, project, sourceBillNo, count, true);
    }

    public static void recycleCodeRuleNumbers(DynamicObject transCodeDynamicObj, String projectKeys, Set<String> codeSet) {
        MROOrderCodeRuleHelper.getImplClass().recycleCodeRuleNumbers(transCodeDynamicObj, projectKeys, codeSet);
    }

    public static void deleteInterruptNo(DynamicObject transCodeDynamicObj, Set<String> codeSet) {
        MROOrderCodeRuleHelper.getImplClass().deleteInterruptNo(transCodeDynamicObj, codeSet);
    }

    public static DynamicObject getTransactionTypeCodeMode(Long transID) {
        DynamicObject dy;
        Map<Object, DynamicObject> map = transTypeThreadLocal.get();
        if (map == null) {
            map = new HashMap<Object, DynamicObject>(16);
            transTypeThreadLocal.set(map);
        }
        if ((dy = map.get(transID)) != null) {
            return dy;
        }
        dy = MROOrderCodeRuleHelper.getImplClass().getTransactionTypeCodeMode(transID);
        map.put(transID, dy);
        return dy;
    }

    public static String genProjectKeys(DynamicObject transactionType, DynamicObject project, String sourceBillNumber) {
        if (transactionType == null) {
            return "";
        }
        DynamicObject dy = MROOrderCodeRuleHelper.getTransactionTypeCodeMode(transactionType.getLong("id"));
        if (dy != null) {
            return MROOrderCodeRuleHelper.getImplClass().genProjectKeys(dy, project, sourceBillNumber);
        }
        return null;
    }

    public static boolean isUsed(String billno, Long id) {
        return MROOrderCodeRuleHelper.getImplClass().validateNumberInBusinessDBWithID(billno, id);
    }
}

