/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.business.coderule.mro.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.pom.business.coderule.mro.IMROOrderCodeRule;

public class MROOrderCodeRuleImpl
implements IMROOrderCodeRule {
    private static final Log logger = LogFactory.getLog(MROOrderCodeRuleImpl.class);
    private static final int BATCH_COUNT_INTERRUPT = 100;
    private static final int BATCH_COUNT_NORMAL = 50;
    private static final int CACHE_TIMELONG = 3600;
    private static final DBRoute scmDBRoute = new DBRoute("scm");
    private static final String KEY_NUMBER_STRING = "number";
    private static final String KEY_STR_CHAR = "char";
    private static final String KEY_STR_SEQ = "seq";
    private static final String KEY_STR_SPLITCHAR = "@@@";
    private static final String KEY_STR_NULL = "####";
    private static final DistributeSessionlessCache codeCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mmc-mroorder_coderule-cache");

    @Override
    public List<String> genCodeRuleNumbers(DynamicObject transCodeDynamicObj, DynamicObject project, String sourceBillNo, int count, boolean isImmediatelyUsed) {
        if (transCodeDynamicObj == null) {
            return Collections.emptyList();
        }
        int maxSeq = this.getLshMaxSeq(transCodeDynamicObj);
        if (count > maxSeq) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u6b21\u83b7\u53d6\u5355\u636e\u53f7\u6570\u91cf\uff1a %1$s \u8d85\u8fc7\u4e86\u7cfb\u7edf\u9650\u5b9a\u7684\u6700\u5927\u503c  %2$s \uff0c\u8bf7\u8c03\u6574\u6279\u91cf\u3002", (String)"MROOrderCodeRuleImpl_0", (String)"mmc-pom-business", (Object[])new Object[0]), count, maxSeq));
        }
        Long startdate = System.currentTimeMillis();
        boolean isinterruptno = this.isInterruptno(transCodeDynamicObj);
        String contcharrangle = this.getContChartRangle(transCodeDynamicObj);
        String codetype = this.getCodeType(transCodeDynamicObj);
        boolean isnoredis = this.isNoRedis(transCodeDynamicObj);
        String projectNumber = this.getProjectNumber(project);
        String projectKeys = this.getProjectKeys(codetype, projectNumber, sourceBillNo);
        List<String> charList = this.initContCharList(contcharrangle);
        List<String> cacheList = new ArrayList<String>(this.getBatchCount(isinterruptno));
        if (!isnoredis) {
            cacheList = this.getCodeRuleFromRedisCache(projectKeys);
        }
        Map<String, List<String>> valideMap = this.initValideCharNumberList(cacheList, charList, count);
        ArrayList valideNumberList = new ArrayList(16);
        ArrayList valideCharNumberList = new ArrayList(16);
        ArrayList delCodeList = new ArrayList(16);
        if (valideMap != null && !valideMap.isEmpty()) {
            valideNumberList = (ArrayList)valideMap.get("valideNumberList");
            valideCharNumberList = (ArrayList)valideMap.get("valideCharNumberList");
            delCodeList = (ArrayList)valideMap.get("delCodeList");
        }
        if (valideNumberList.size() >= count) {
            this.removeCacheListData(cacheList, valideCharNumberList);
            if (!isnoredis) {
                this.setCodeRuleFromRedisCache(projectKeys, cacheList);
            }
            if (isImmediatelyUsed) {
                delCodeList.addAll(valideNumberList);
            }
            if (isinterruptno && !delCodeList.isEmpty()) {
                this.deleteInterruptDB("", new HashSet<String>(delCodeList));
            }
            if (valideNumberList.size() < 2000) {
                logger.info("mmc-MroOrderCodeNumberImpl.getCodeNumbers8,from redis result=" + ((Object)valideNumberList).toString());
            }
            return valideNumberList;
        }
        int dbCount = count;
        int batchCount = this.getBatchCount(isinterruptno);
        if (dbCount < batchCount) {
            dbCount = batchCount;
        }
        if (isinterruptno) {
            this.initInterruptList(projectKeys, cacheList);
            logger.info("mmc-MroOrderCodeNumberImpl.getCodeNumbers2 from interrupt table: cost = " + (System.currentTimeMillis() - startdate) + " ms , params: projectKeys = " + projectKeys + ",cacheList =" + cacheList.size());
            valideMap = this.initValideCharNumberList(cacheList, charList, count);
            if (valideMap != null && !valideMap.isEmpty()) {
                valideNumberList = (ArrayList)valideMap.get("valideNumberList");
                valideCharNumberList = (ArrayList)valideMap.get("valideCharNumberList");
                delCodeList = (ArrayList)valideMap.get("delCodeList");
            }
            if (valideNumberList.size() >= count) {
                this.removeCacheListData(cacheList, valideCharNumberList);
                if (!isnoredis) {
                    this.setCodeRuleFromRedisCache(projectKeys, cacheList);
                }
                if (isImmediatelyUsed) {
                    delCodeList.addAll(valideNumberList);
                }
                if (isinterruptno && !delCodeList.isEmpty()) {
                    this.deleteInterruptDB("", new HashSet<String>(delCodeList));
                }
                if (valideNumberList.size() < 2000) {
                    logger.info("mmc-MroOrderCodeNumberImpl.getCodeNumbers8,from interruptno table result=" + ((Object)valideNumberList).toString());
                }
                return valideNumberList;
            }
            dbCount -= valideNumberList.size();
        }
        int nextSeq = -1;
        String nextChar = "";
        ArrayList dbList = new ArrayList(16);
        int currentSeq = -1;
        String currentChar = "";
        HashMap updateDBMap = null;
        if (dbCount > 0) {
            Map<String, Object> currentMap = this.getCurrentSeqs(transCodeDynamicObj, projectKeys, charList);
            currentSeq = (Integer)currentMap.get("currentSeq");
            currentChar = (String)currentMap.get("currentChar");
            HashMap charCurrentMap = (HashMap)currentMap.get("charCurrentMap");
            logger.info("mmc-MroOrderCodeNumberImpl.getCodeNumbers4 from normal table : cost = " + (System.currentTimeMillis() - startdate) + " ms , params: projectKeys = " + projectKeys + ",currentSeq=" + currentSeq + ",currentChar =" + currentChar);
            Map<String, Object> nextMap = this.getNextSeqs(transCodeDynamicObj, projectKeys, codetype, currentChar, currentSeq, dbCount, charList, charCurrentMap);
            nextSeq = (Integer)nextMap.get("nextSeq");
            nextChar = (String)nextMap.get("nextChar");
            dbList = (ArrayList)nextMap.get("dbList");
            updateDBMap = (HashMap)nextMap.get("updateDBMap");
            if (!dbList.isEmpty()) {
                cacheList.addAll(dbList);
                if (cacheList.size() > 1) {
                    this.sortList(cacheList);
                }
            }
        }
        if ((valideMap = this.initValideCharNumberList(cacheList, charList, count)) != null && !valideMap.isEmpty()) {
            valideNumberList = (ArrayList)valideMap.get("valideNumberList");
            valideCharNumberList = (ArrayList)valideMap.get("valideCharNumberList");
            delCodeList = (ArrayList)valideMap.get("delCodeList");
        }
        if (valideNumberList.size() < count) {
            logger.info("mmc-MroOrderCodeNumberImpl.getCodeNumbers6 no projectKeys: cost = " + (System.currentTimeMillis() - startdate) + " ms , params: projectNumber = " + projectNumber + ",sourceBillNo=" + (sourceBillNo == null ? "" : sourceBillNo));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ece\u6570\u636e\u5e93\u548c\u65ad\u53f7\u8868\u53caredis\u7f13\u5b58\u83b7\u53d6\u7684\u6570\u636e\u65e0\u6cd5\u6ee1\u8db3\u9700\u6c42\u6570\uff1a\u9700\u6c42\u6570 %1$s \uff0c\u5b9e\u9645\u53d6\u6570 %2$s ,\u53ef\u80fd\u5df2\u7ecf\u8fbe\u5230\u4e86\u5355\u636e\u53f7\u6781\u9650\uff0c\u8bf7\u67e5\u8bc1\u6216\u624b\u5de5\u8f93\u5165\u3002\u5f53\u524d\u987a\u5e8f\u53f7\uff1a %3$s ", (String)"MROOrderCodeRuleImpl_2", (String)"mmc-pom-business", (Object[])new Object[0]), count, valideNumberList.size(), currentChar + currentSeq));
        }
        this.updateDBSeqs(projectKeys, dbList, isinterruptno, updateDBMap);
        if (isImmediatelyUsed) {
            delCodeList.addAll(valideNumberList);
        }
        if (isinterruptno && !delCodeList.isEmpty()) {
            this.deleteInterruptDB("", new HashSet<String>(delCodeList));
        }
        this.removeCacheListData(cacheList, valideCharNumberList);
        if (!isnoredis) {
            this.setCodeRuleFromRedisCache(projectKeys, cacheList);
        }
        logger.info("mmc-MroOrderCodeNumberImpl.getCodeNumbers7 update db end: cost = " + (System.currentTimeMillis() - startdate) + " ms , params: projectKeys = " + projectKeys + ",nextSeq=" + nextSeq + ",nextChar =" + nextChar + ",valideNumberList.size = " + valideNumberList.size());
        if (valideNumberList.size() < 2000) {
            logger.info("mmc-MroOrderCodeNumberImpl.getCodeNumbers8,from db result=" + ((Object)valideNumberList).toString());
        }
        return valideNumberList;
    }

    public Map<String, List<String>> initValideCharNumberList(List<String> allList, List<String> charList, int count) {
        String number;
        if (allList == null || allList.isEmpty()) {
            return Collections.emptyMap();
        }
        int size = allList.size();
        ArrayList<String> valideNumberList = new ArrayList<String>(count);
        ArrayList<String> valideCharNumberList = new ArrayList<String>(count);
        ArrayList<String> delCodeList = new ArrayList<String>(count);
        ArrayList<String> allNumberList = new ArrayList<String>(count);
        for (int i = 0; i < size; ++i) {
            String allStr = allList.get(i);
            if (StringUtils.isEmpty((String)allStr)) continue;
            number = this.getNumber(allStr, true);
            String chars = this.getNumber(allStr, false);
            if (!charList.contains(chars)) continue;
            valideCharNumberList.add(allStr);
            allNumberList.add(number);
        }
        size = allNumberList.size();
        Set<String> existDBSet = this.validateNumberInBusinessDB(new HashSet<String>(allNumberList));
        for (int i = 0; i < size; ++i) {
            number = (String)allNumberList.get(i);
            if (existDBSet.contains(number)) {
                logger.info("mmc-MroOrderCodeNumberImpl add the number is in db,continue: " + number);
                delCodeList.add(number);
                continue;
            }
            valideNumberList.add(number);
            if (valideNumberList.size() >= count) break;
        }
        HashMap<String, List<String>> valideMap = new HashMap<String, List<String>>(2);
        valideMap.put("valideNumberList", valideNumberList);
        valideMap.put("valideCharNumberList", valideCharNumberList);
        valideMap.put("delCodeList", delCodeList);
        return valideMap;
    }

    private List<String> sortList(List<String> aList) {
        Collections.sort(aList);
        return aList;
    }

    private boolean isInterruptno(DynamicObject transCodeDynamicObj) {
        return (Boolean)transCodeDynamicObj.get("isinterruptno");
    }

    private String getContChartRangle(DynamicObject transCodeDynamicObj) {
        return (String)transCodeDynamicObj.get("contcharrangle");
    }

    private String getCodeType(DynamicObject transCodeDynamicObj) {
        return (String)transCodeDynamicObj.get("codetype");
    }

    public boolean isNoRedis(DynamicObject transCodeDynamicObj) {
        Object names = transCodeDynamicObj.get("name");
        return names != null && names.toString().endsWith("_noredis");
    }

    public int getBatchCount(boolean isInterrupt) {
        if (isInterrupt) {
            return 100;
        }
        return 50;
    }

    public synchronized void removeCacheListData(List<String> cacheList, List<String> valideCharNumberList) {
        for (int i = 0; i < valideCharNumberList.size(); ++i) {
            cacheList.remove(valideCharNumberList.get(i));
        }
    }

    public synchronized List<String> getCodeRuleFromRedisCache(String projectKeys) {
        String codeJson;
        List<String> cacheList = null;
        if (codeCache != null && codeCache.contains(projectKeys) && !StringUtils.isEmpty((String)(codeJson = (String)codeCache.get(projectKeys)))) {
            JSONArray filterArray = null;
            filterArray = JSONArray.parseArray((String)codeJson);
            cacheList = filterArray.toJavaList(String.class);
        }
        if (cacheList == null) {
            cacheList = new ArrayList<String>(16);
        }
        if (cacheList.size() > 1) {
            this.sortList(cacheList);
        }
        return cacheList;
    }

    private String getNumber(String str, boolean isleft) {
        String[] aplist = str.split(KEY_STR_SPLITCHAR);
        return isleft ? aplist[0] : aplist[1];
    }

    public synchronized void setCodeRuleFromRedisCache(String projectKeys, List<String> cacheList) {
        if (codeCache == null || StringUtils.isEmpty((String)projectKeys)) {
            return;
        }
        if (cacheList == null || cacheList.isEmpty()) {
            codeCache.put(projectKeys, (Object)"", 3600);
        } else {
            codeCache.put(projectKeys, (Object)JSON.toJSONString(cacheList), 3600);
        }
    }

    public synchronized void clearCodeRuleFromRedisCache(String projectKeys) {
        if (codeCache == null) {
            return;
        }
        codeCache.put(projectKeys, (Object)"", 3600);
    }

    public List<String> initContCharList(String contcharrangle) {
        ArrayList<String> charList = new ArrayList<String>(16);
        if (StringUtils.isEmpty((String)contcharrangle)) {
            charList.add(KEY_STR_NULL);
        } else {
            String[] splits = contcharrangle.split(",");
            for (int i = 0; i < splits.length; ++i) {
                String chars = splits[i];
                if (StringUtils.isEmpty((String)contcharrangle) || chars.equalsIgnoreCase("NULL")) {
                    charList.add(KEY_STR_NULL);
                    continue;
                }
                if (chars.equals(KEY_STR_NULL)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e8b\u52a1\u7c7b\u578b\u5bf9\u5e94\u7684\u7f16\u7801\u89c4\u5219\u914d\u7f6e\u4e2d\uff0c\u5e38\u91cf\u4f7f\u7528\u4e86\u5b57\u7b26\uff1a %1$s \uff0c\u4e0d\u5141\u8bb8\u3002", (String)"MROOrderCodeRuleImpl_3", (String)"mmc-pom-business", (Object[])new Object[0]), KEY_STR_NULL));
                }
                charList.add(chars);
            }
        }
        return charList;
    }

    private synchronized Map<String, Object> getNextSeqs(DynamicObject transCodeDynamicObj, String projectKeys, String codetype, String currentChar, int currentSeq, int count, List<String> charList, Map<String, Integer> charCurrentMap) {
        int indexBegin = charList.indexOf(currentChar);
        if (indexBegin < 0) {
            String errorStr = String.format(ResManager.loadKDString((String)"\u5b9a\u4e49\u7684\u5e38\u91cf\u5b57\u7b26\u8303\u56f4\u65e0\u6cd5\u627e\u5230\u5f53\u524d\u7684\u5e38\u91cf\u5b57\u7b26\uff0c\u8bf7\u67e5\u8bc1\u3002\u5e38\u91cf\u5b57\u7b26\u8303\u56f4\uff1a %1$s  \u5f53\u524d\u5e38\u91cf\u5b57\u7b26\uff1a %2$s ", (String)"MROOrderCodeRuleImpl_4", (String)"mmc-pom-business", (Object[])new Object[0]), charList.toString(), currentChar);
            throw new KDBizException(errorStr);
        }
        int syCount = count;
        HashMap<String, Integer> updateDBMap = new HashMap<String, Integer>(charList.size());
        int nextSeq = currentSeq;
        String nextChar = currentChar;
        ArrayList<String> allList = new ArrayList<String>(count);
        int maxSeq = this.getLshMaxSeq(transCodeDynamicObj);
        for (int i = indexBegin; i < charList.size() && syCount > 0; ++i) {
            int sySeq;
            String chars = charList.get(i);
            int beginSeq = 0;
            if (charCurrentMap != null && charCurrentMap.get(chars) != null) {
                beginSeq = charCurrentMap.get(chars);
            }
            if ((sySeq = maxSeq - beginSeq) <= 0) continue;
            int thisMaxSeq = 0;
            if (sySeq >= syCount) {
                thisMaxSeq = beginSeq + syCount;
                syCount = 0;
            } else {
                thisMaxSeq = maxSeq;
                syCount -= sySeq;
            }
            updateDBMap.put(chars, thisMaxSeq);
            nextChar = chars;
            nextSeq = thisMaxSeq;
            List<String> seqList = this.getSeqList(transCodeDynamicObj, projectKeys, codetype, chars, beginSeq, nextSeq);
            allList.addAll(seqList);
        }
        if (syCount > 0 && allList.size() < 1) {
            String errorStr = String.format(ResManager.loadKDString((String)"\u5e38\u91cf\u987a\u5e8f\u5b57\u7b26 %1$s  \u9012\u589e %2$s  \u4e2a\u5e8f\u5217\u540e\u7684\u65b0\u5e38\u91cf\u5b57\u7b26\u4e0d\u5728\u754c\u5b9a\u8303\u56f4\u5185\uff0c\u53ef\u80fd\u662f\u987a\u5e8f\u53f7\u5df2\u7528\u5b8c\uff0c\u8bf7\u67e5\u8bc1\u3002", (String)"MROOrderCodeRuleImpl_5", (String)"mmc-pom-business", (Object[])new Object[0]), currentChar, count);
            throw new KDBizException(errorStr);
        }
        HashMap<String, Object> nextMap = new HashMap<String, Object>(16);
        nextMap.put("nextChar", nextChar);
        nextMap.put("nextSeq", nextSeq);
        nextMap.put("syCount", syCount);
        nextMap.put("dbList", allList);
        nextMap.put("updateDBMap", updateDBMap);
        return nextMap;
    }

    private List<String> getSeqList(DynamicObject transCodeDynamicObj, String projectKeys, String codetype, String chars, int beiginSeq, int endSeq) {
        ArrayList<String> seqList = new ArrayList<String>(endSeq - beiginSeq);
        int thisSeq = 0;
        String thisChar = chars;
        if (KEY_STR_NULL.equalsIgnoreCase(thisChar)) {
            thisChar = "";
        }
        int lshLength = this.getLshLength(transCodeDynamicObj);
        String formatMask = "%0" + lshLength + "d";
        for (int i = beiginSeq + 1; i <= endSeq; ++i) {
            thisSeq = i;
            String lsh = thisChar + String.format(formatMask, thisSeq);
            String chkDigit = "";
            if ("A".equals(codetype)) {
                chkDigit = this.genChkDigit(projectKeys, lsh);
            }
            seqList.add((KEY_STR_NULL.equalsIgnoreCase(projectKeys) || "NULL".equalsIgnoreCase(projectKeys) ? "" : projectKeys) + lsh + chkDigit + KEY_STR_SPLITCHAR + chars);
        }
        return seqList;
    }

    public String getNextChar(String currentChar, int charSize, List<String> charList) {
        int currentIndexOf = charList.indexOf(currentChar);
        if (charList.size() >= (currentIndexOf += charSize) + 1) {
            return charList.get(currentIndexOf);
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5e38\u91cf\u987a\u5e8f\u5b57\u7b26 %1$s  \u9012\u589e %2$s  \u4e2a\u5e8f\u5217\u540e\u7684\u65b0\u5e38\u91cf\u5b57\u7b26\u4e0d\u5728\u754c\u5b9a\u8303\u56f4\u5185\uff0c\u53ef\u80fd\u662f\u987a\u5e8f\u53f7\u5df2\u7528\u5b8c\uff0c\u8bf7\u67e5\u8bc1\u3002", (String)"MROOrderCodeRuleImpl_5", (String)"mmc-pom-business", (Object[])new Object[0]), currentChar, charSize));
    }

    public synchronized void updateDBSeqs(String projectKeys, List<String> dbList, boolean isinterruptno, Map<String, Integer> updateDBMap) {
        block24: {
            StringBuilder bf = new StringBuilder();
            try (TXHandle txHandle = TX.requiresNew((String)"mmc-updateCurrentSeqs");){
                if (updateDBMap != null) {
                    try {
                        for (Map.Entry<String, Integer> entrys : updateDBMap.entrySet()) {
                            String chars = entrys.getKey();
                            Integer seqs = entrys.getValue();
                            if (this.isExistsSeq(projectKeys, chars)) {
                                this.updateCurrentSeqs(seqs, projectKeys, chars);
                                continue;
                            }
                            this.insertCurrentSeqs(projectKeys, chars, seqs, false);
                        }
                    }
                    catch (Exception exc) {
                        txHandle.markRollback();
                        this.clearCodeRuleFromRedisCache(projectKeys);
                        throw exc;
                    }
                }
                if (!isinterruptno || dbList == null || dbList.isEmpty()) break block24;
                int iSize = dbList.size();
                ArrayList<Object[]> paramList = new ArrayList<Object[]>(iSize);
                bf.setLength(0);
                bf.append(" insert into t_pom_mrointerruptno(fprojectkeys,fchar,fnumber) values(?,?,?) ");
                Set<String> existDBCodeSet = this.validateNumberInInterruptDB(new HashSet<String>(dbList));
                for (String codeNumbers : dbList) {
                    String codeNumber = this.getNumber(codeNumbers, true);
                    String chars = this.getNumber(codeNumbers, false);
                    if (existDBCodeSet.contains(codeNumber)) continue;
                    Object[] objects = new Object[]{projectKeys, chars, codeNumber};
                    paramList.add(objects);
                }
                if (paramList.isEmpty()) {
                    return;
                }
                try {
                    DB.executeBatch((DBRoute)scmDBRoute, (String)bf.toString(), paramList);
                }
                catch (Exception exc) {
                    txHandle.markRollback();
                    this.clearCodeRuleFromRedisCache(projectKeys);
                    throw exc;
                }
            }
        }
    }

    private synchronized void updateCurrentSeqs(Integer seqs, String projectKeys, String chars) {
        StringBuilder bf = new StringBuilder();
        ArrayList<Object> paramList = new ArrayList<Object>(16);
        paramList.add(seqs);
        paramList.add(projectKeys);
        paramList.add(chars);
        bf.append(" update t_pom_mrocoderuleseq set fseq = ? where fprojectkeys = ? and fchar = ? ");
        DB.execute((DBRoute)scmDBRoute, (String)bf.toString(), (Object[])paramList.toArray());
    }

    public synchronized void insertCurrentSeqs(String projectKeys, String currentChar, int currentSeq, boolean needTX) {
        block15: {
            StringBuilder bf = new StringBuilder();
            ArrayList<Object> paramList = new ArrayList<Object>(16);
            paramList.add(projectKeys);
            paramList.add(currentChar);
            paramList.add(currentSeq);
            bf.append(" insert into t_pom_mrocoderuleseq( fprojectkeys,fchar,fseq) values(?,?,?) ");
            if (needTX) {
                try (TXHandle txHandle = TX.requiresNew((String)"mmc-insertCurrentSeqs");){
                    try {
                        DB.execute((DBRoute)scmDBRoute, (String)bf.toString(), (Object[])paramList.toArray());
                        break block15;
                    }
                    catch (Exception exc) {
                        txHandle.markRollback();
                        throw exc;
                    }
                }
            }
            DB.execute((DBRoute)scmDBRoute, (String)bf.toString(), (Object[])paramList.toArray());
        }
    }

    public synchronized void deleteInterruptDB(String projectKeys, Set<String> codeSet) {
        StringBuilder bf = new StringBuilder();
        try (TXHandle txHandle = TX.requiresNew((String)"mmc-deleteInterruptByBusiness");){
            boolean codeIsEmpty = codeSet == null || codeSet.isEmpty();
            ArrayList<String> paramList = new ArrayList<String>(codeIsEmpty ? 1 : codeSet.size() + 1);
            bf.append(" delete from t_pom_mrointerruptno a where 1 = 1  ");
            if (!StringUtils.isEmpty((String)projectKeys)) {
                bf.append(" and fprojectkeys = ?  ");
                paramList.add(projectKeys);
            }
            if (codeIsEmpty) {
                bf.append(" and exists (Select 1 from t_pom_mroorder b where fbillno  = a.fnumber  ) ");
            } else {
                bf.append(" and fnumber in ( ");
                for (String codeNumber : codeSet) {
                    paramList.add(codeNumber);
                    bf.append(" ? ");
                    if (paramList.size() == codeSet.size()) continue;
                    bf.append(" , ");
                }
                bf.append(" ) ");
            }
            try {
                DB.execute((DBRoute)scmDBRoute, (String)bf.toString(), (Object[])paramList.toArray());
            }
            catch (Exception exc) {
                txHandle.markRollback();
                throw exc;
            }
        }
    }

    private synchronized void initInterruptList(String projectKeys, List<String> cacheList) {
        StringBuilder bf = new StringBuilder();
        bf.append(" Select fchar,fnumber  from t_pom_mrointerruptno where fprojectkeys = ? order by fchar, fnumber ");
        try (DataSet ds = DB.queryDataSet((String)"mmc-coderule-getInterruptList", (DBRoute)scmDBRoute, (String)bf.toString(), (Object[])new String[]{projectKeys});){
            for (Row row : ds) {
                String fnumber = row.getString("fnumber");
                String fchar = row.getString("fchar");
                String numbers = fnumber + KEY_STR_SPLITCHAR + fchar;
                if (cacheList.contains(numbers)) continue;
                cacheList.add(numbers);
            }
        }
        if (cacheList.size() > 1) {
            this.sortList(cacheList);
        }
    }

    public synchronized Map<String, Object> getCurrentSeqs(DynamicObject transCodeDynamicObj, String projectKeys, List<String> charList) {
        StringBuilder bf = new StringBuilder();
        String currentChar = "";
        int currentSeq = -1;
        bf.append(" Select fchar,fseq from t_pom_mrocoderuleseq where fprojectkeys = ? ");
        bf.append(" order by fchar,fseq  ");
        HashMap<String, Integer> charCurrentMap = new HashMap<String, Integer>(charList.size());
        int maxSeq = this.getLshMaxSeq(transCodeDynamicObj);
        try (DataSet ds = DB.queryDataSet((String)"mmc-coderule-queryCurrentSeqs", (DBRoute)scmDBRoute, (String)bf.toString(), (Object[])new String[]{projectKeys});){
            for (Row row : ds) {
                if (!charList.contains(row.getString("fchar"))) continue;
                charCurrentMap.put(row.getString("fchar"), row.getInteger("fseq"));
                if (row.getInteger("fseq") >= maxSeq || currentSeq != -1) continue;
                currentChar = row.getString("fchar");
                currentSeq = row.getInteger("fseq");
            }
        }
        if (charCurrentMap.size() < 1) {
            currentChar = charList.get(0);
            currentSeq = 0;
            this.insertCurrentSeqs(projectKeys, currentChar, currentSeq, true);
        } else if (currentSeq == -1) {
            for (int i = 0; i < charList.size(); ++i) {
                if (charCurrentMap.containsKey(charList.get(i))) continue;
                currentChar = charList.get(i);
                currentSeq = 0;
                this.insertCurrentSeqs(projectKeys, currentChar, currentSeq, true);
                break;
            }
        }
        if (currentSeq == -1) {
            String errorStr = String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u6ee1\u8db3\u6ee1\u8db3\u6761\u4ef6\u7684\u5355\u636e\u53f7\u987a\u5e8f\u503c\uff0c\u53ef\u80fd\u987a\u5e8f\u503c\u5df2\u7528\u5b8c\uff0c\u8bf7\u67e5\u8bc1! \u5355\u636e\u53f7\u952e\u503c\uff1a%1$s , \u5e38\u91cf\u5b57\u7b26\uff1a %2$s ,\u987a\u5e8f\u53f7\uff1a %3$s", (String)"MROOrderCodeRuleImpl_6", (String)"mmc-pom-business", (Object[])new Object[0]), projectKeys, charList.toString(), maxSeq);
            logger.info("mmc-MroOrderCodeNumberImpl.getCurrentSeqs " + errorStr);
            throw new KDBizException(errorStr);
        }
        if (StringUtils.isEmpty((String)currentChar)) {
            currentChar = KEY_STR_NULL;
        }
        HashMap<String, Object> currentMap = new HashMap<String, Object>(16);
        currentMap.put("currentChar", currentChar);
        currentMap.put("currentSeq", currentSeq);
        currentMap.put("charCurrentMap", charCurrentMap);
        return currentMap;
    }

    private synchronized boolean isExistsSeq(String projectKeys, String chars) {
        StringBuilder bf = new StringBuilder();
        bf.append(" Select fprojectkeys from t_pom_mrocoderuleseq where fprojectkeys = ? and fchar = ? ");
        boolean isfind = false;
        try (DataSet ds = DB.queryDataSet((String)"mmc-coderule-queryCurrentSeqs_isExistsSeq", (DBRoute)scmDBRoute, (String)bf.toString(), (Object[])new String[]{projectKeys, chars});){
            for (Row row : ds) {
                isfind = true;
            }
        }
        return isfind;
    }

    private String getProjectKeys(String codetype, String projectNumber, String sourceBillNo) {
        if ("A".equals(codetype)) {
            return projectNumber == null ? "NULL" : projectNumber;
        }
        return sourceBillNo == null ? "" : sourceBillNo;
    }

    public String getProjectNumber(DynamicObject project) {
        String pjNumber;
        if (project == null) {
            return "NULL";
        }
        if (project.containsProperty(KEY_NUMBER_STRING)) {
            pjNumber = project.getString(KEY_NUMBER_STRING);
        } else {
            DynamicObject dy = BusinessDataServiceHelper.loadSingleFromCache((Object)project.getPkValue(), (String)"pmpd_project", (String)KEY_NUMBER_STRING);
            pjNumber = dy.getString(KEY_NUMBER_STRING);
        }
        return pjNumber == null ? "NULL" : pjNumber;
    }

    @Override
    public void recycleCodeRuleNumbers(DynamicObject transCodeDynamicObj, String projectKeys, Set<String> codeSet) {
        if (transCodeDynamicObj == null) {
            return;
        }
        Long startdate = System.currentTimeMillis();
        boolean isinterruptno = this.isInterruptno(transCodeDynamicObj);
        if (!isinterruptno) {
            return;
        }
        if (StringUtils.isEmpty((String)projectKeys)) {
            return;
        }
        this.insertInterruptDB(transCodeDynamicObj, projectKeys, codeSet);
        logger.info("mmc-MroOrderCodeNumberImpl.recycleCodeRuleNumbers1 insert db end: cost = " + (System.currentTimeMillis() - startdate) + " ms , params: projectKeys = " + projectKeys + ",codeSet.size = " + codeSet.size());
        ArrayList<String> cacheList = new ArrayList<String>(this.getBatchCount(true));
        this.initInterruptList(projectKeys, cacheList);
        this.setCodeRuleFromRedisCache(projectKeys, cacheList);
        logger.info("mmc-MroOrderCodeNumberImpl.recycleCodeRuleNumbers2 load to redis cache end: cost = " + (System.currentTimeMillis() - startdate) + " ms , params: projectKeys = " + projectKeys + ",cacheList.size = " + cacheList.size());
    }

    private String getCharFromCode(DynamicObject transCodeDynamicObj, String codeType, String projectKeys, String codeNumber) {
        int endIndex;
        if (StringUtils.isEmpty((String)codeNumber)) {
            return KEY_STR_NULL;
        }
        String chars = null;
        int beginIndex = 0;
        if (!StringUtils.isEmpty((String)projectKeys) && !projectKeys.equals(KEY_STR_NULL)) {
            beginIndex = projectKeys.length();
        }
        if ((endIndex = codeNumber.length() - 1 - this.getLshLength(transCodeDynamicObj)) < beginIndex) {
            return KEY_STR_NULL;
        }
        chars = codeNumber.substring(beginIndex, endIndex);
        if (StringUtils.isEmpty((String)chars)) {
            return KEY_STR_NULL;
        }
        return chars;
    }

    private synchronized Set<String> insertInterruptDB(DynamicObject transCodeDynamicObj, String projectKeys, Set<String> codeSet) {
        StringBuilder bf = new StringBuilder();
        try (TXHandle txHandle = TX.requiresNew((String)"mmc-insertInterruptDB");){
            HashSet<String> hashSet;
            int iSize = codeSet.size();
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(iSize);
            bf.append(" insert into t_pom_mrointerruptno(fprojectkeys,fnumber,fchar) values(?,?,?) ");
            Set<String> existDBCodeSet2 = this.validateNumberInInterruptDB(codeSet);
            String codeType = this.getCodeType(transCodeDynamicObj);
            HashSet<String> returnSet = new HashSet<String>(codeSet.size());
            for (String codeNumber : codeSet) {
                if (existDBCodeSet2.contains(codeNumber)) {
                    logger.info("mmc-MroOrderCodeNumberImpl recycle the number is in db,continue: " + codeNumber);
                    continue;
                }
                returnSet.add(codeNumber);
                String chars = this.getCharFromCode(transCodeDynamicObj, codeType, projectKeys, codeNumber);
                Object[] objects = new Object[]{projectKeys, codeNumber, chars};
                paramList.add(objects);
            }
            if (paramList.isEmpty()) {
                hashSet = Collections.emptySet();
                return hashSet;
            }
            try {
                DB.executeBatch((DBRoute)scmDBRoute, (String)bf.toString(), paramList);
            }
            catch (Exception exc) {
                txHandle.markRollback();
                throw exc;
            }
            hashSet = returnSet;
            return hashSet;
        }
    }

    @Override
    public String genChkDigit(String projects, String lsh) {
        int intMode10;
        Long startdate = System.currentTimeMillis();
        String jobNo = (projects == null ? "" : projects.trim()) + (lsh == null ? "" : lsh.trim());
        int intSum = 0;
        for (int i = 0; i < jobNo.length(); ++i) {
            String firstChar = jobNo.substring(i, i + 1);
            int ascChar = this.stringToAsc(firstChar);
            int intMath = Math.abs(48 - ascChar);
            if ((i + 1) % 2 == 0) {
                intMath *= 2;
            }
            int intTenth = intMath / 10;
            int intUnit = intMath % 10;
            intSum += intTenth + intUnit;
        }
        int intChkDig = intMode10 = intSum % 10;
        if (intMode10 > 0) {
            intChkDig = 10 - intMode10;
        }
        String returnValue = String.valueOf(intChkDig);
        return returnValue;
    }

    private int stringToAsc(String ch) {
        return ch.charAt(0);
    }

    private Set<String> validateNumberInBusinessDB(Set<String> codeSet) {
        if (codeSet == null || codeSet.isEmpty()) {
            return Collections.emptySet();
        }
        SqlBuilder bf = new SqlBuilder();
        int iSize = codeSet.size();
        HashSet<String> existsDBSet = new HashSet<String>(iSize);
        bf.append(" Select fbillno from t_pom_mroorder where ", new Object[0]);
        bf.appendIn("fbillno", codeSet.toArray());
        try (DataSet ds = DB.queryDataSet((String)"mmc-coderule-queryCurrentSeqs", (DBRoute)scmDBRoute, (SqlBuilder)bf);){
            for (Row row : ds) {
                existsDBSet.add(row.getString("fbillno"));
            }
        }
        return existsDBSet;
    }

    @Override
    public boolean validateNumberInBusinessDB(String codeNumber) {
        HashSet<String> codeSet = new HashSet<String>(1);
        codeSet.add(codeNumber);
        Set<String> existsDBSet = this.validateNumberInBusinessDB(codeSet);
        return !existsDBSet.isEmpty();
    }

    private Set<String> validateNumberInInterruptDB(Set<String> codeSet) {
        SqlBuilder bf = new SqlBuilder();
        int iSize = codeSet.size();
        if (iSize <= 0) {
            return Collections.emptySet();
        }
        HashSet<String> existsDBSet = new HashSet<String>(iSize);
        bf.append(" Select fnumber from t_pom_mrointerruptno where  ", new Object[0]);
        bf.appendIn("fnumber", codeSet.toArray());
        try (DataSet ds = DB.queryDataSet((String)"mmc-coderule-queryCurrentSeqs", (DBRoute)scmDBRoute, (SqlBuilder)bf);){
            for (Row row : ds) {
                existsDBSet.add(row.getString("fnumber"));
            }
        }
        return existsDBSet;
    }

    @Override
    public DynamicObject getTransactionTypeCodeMode(Long transTypeID) {
        if (transTypeID == null || transTypeID == 0L) {
            return null;
        }
        QFilter qFilter = new QFilter("mrotranstype.id", "in", (Object)transTypeID);
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        return BusinessDataServiceHelper.loadSingleFromCache((String)"pom_mrotranstype_coderule", (String)"mrotranstype,isinterruptno,contcharrangle,codetype,name,lshlength", (QFilter[])new QFilter[]{qFilter});
    }

    @Override
    public String genProjectKeys(DynamicObject transCodeDynamicObj, DynamicObject project, String sourceBillNumber) {
        String codetype = transCodeDynamicObj.getString("codetype");
        String projectNumber = this.getProjectNumber(project);
        return this.getProjectKeys(codetype, projectNumber, sourceBillNumber);
    }

    @Override
    public void deleteInterruptNo(DynamicObject transCodeDynamicObj, Set<String> codeSet) {
        if (transCodeDynamicObj == null) {
            return;
        }
        boolean isinterruptno = this.isInterruptno(transCodeDynamicObj);
        if (!isinterruptno) {
            return;
        }
        this.deleteInterruptDB("", codeSet);
    }

    private int getLshMaxSeq(DynamicObject transCodeDynamicObj) {
        int lshlength = this.getLshLength(transCodeDynamicObj);
        return Integer.parseInt("9999999999".substring(0, lshlength));
    }

    private int getLshLength(DynamicObject transCodeDynamicObj) {
        int lshlength = 4;
        if (transCodeDynamicObj == null) {
            return lshlength;
        }
        Object lshlengthObj = transCodeDynamicObj.get("lshlength");
        if (lshlengthObj != null && (lshlength = transCodeDynamicObj.getInt("lshlength")) == 0) {
            lshlength = 4;
        }
        return lshlength;
    }

    @Override
    public boolean validateNumberInBusinessDBWithID(String codeNumber, Long billID) {
        StringBuilder bf = new StringBuilder();
        bf.append(" Select fid from t_pom_mroorder where ");
        bf.append(" fbillno = ? and fid <> ? ");
        boolean isExists = false;
        try (DataSet ds = DB.queryDataSet((String)"mmc-coderule-queryCurrentSeqs", (DBRoute)scmDBRoute, (String)bf.toString(), (Object[])new Object[]{codeNumber, billID});){
            for (Row row : ds) {
                isExists = true;
            }
        }
        return isExists;
    }
}

