/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.business.distr.algox;

import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import kd.bos.algo.RowMeta;
import kd.bos.algox.CoGroupFunction;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class DistrPlanMergeCycleCoGroupFunc
extends CoGroupFunction {
    private RowMeta leftRowMeta;
    private RowMeta rightRowMeta;

    public DistrPlanMergeCycleCoGroupFunc(RowMeta leftRowMeta, RowMeta rightRowMeta) {
        this.leftRowMeta = leftRowMeta;
        this.rightRowMeta = rightRowMeta;
    }

    public void coGroup(Iterable<RowX> iterable, Iterable<RowX> iterable1, Collector collector) {
        DynamicObject mpdmMergecycle = null;
        Iterator<RowX> iterator = iterable1.iterator();
        if (iterator.hasNext()) {
            RowX rightRowX = iterator.next();
            long mergecycle = rightRowX.getLong(this.rightRowMeta.getFieldIndex("mergecycle"));
            mpdmMergecycle = BusinessDataServiceHelper.loadSingleFromCache((Object)mergecycle, (String)"mpdm_mergecycle");
        }
        for (RowX leftRow : iterable) {
            if (mpdmMergecycle != null) {
                Calendar calendar;
                long billdateTime;
                DynamicObjectCollection entryentity;
                String cycleunit = mpdmMergecycle.getString("cycleunit");
                Date billdate = leftRow.getDate(this.leftRowMeta.getFieldIndex("billdate"));
                if (billdate == null) continue;
                if ("D".equals(cycleunit)) {
                    entryentity = mpdmMergecycle.getDynamicObjectCollection("entryentity");
                    billdateTime = billdate.getTime();
                    calendar = Calendar.getInstance();
                    calendar.setTime(billdate);
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                    Date dayStart = calendar.getTime();
                    long offset = billdateTime - dayStart.getTime();
                    offset /= 1000L;
                    for (DynamicObject entry : entryentity) {
                        long entrystarttime = entry.getLong("entrystarttime");
                        long entryendtime = entry.getLong("entryendtime");
                        int entrymergetime = entry.getInt("entrymergetime");
                        int entryoffsetday = entry.getInt("entryoffsetday");
                        if (offset < entrystarttime || offset >= entryendtime) continue;
                        calendar.add(13, entrymergetime);
                        calendar.add(5, entryoffsetday);
                        billdate = calendar.getTime();
                        leftRow.set(this.leftRowMeta.getFieldIndex("billdate"), (Object)billdate);
                        break;
                    }
                } else {
                    entryentity = mpdmMergecycle.getDynamicObjectCollection("entryentity");
                    billdateTime = billdate.getTime();
                    calendar = Calendar.getInstance();
                    for (DynamicObject entry : entryentity) {
                        Date entrystartdate = entry.getDate("entrystartdate");
                        Date entryenddate = entry.getDate("entryenddate");
                        calendar.setTime(entryenddate);
                        calendar.add(5, 1);
                        if (billdateTime < entrystartdate.getTime() || billdateTime >= calendar.getTime().getTime()) continue;
                        billdate = entry.getDate("entrymergedate");
                        leftRow.set(this.leftRowMeta.getFieldIndex("billdate"), (Object)billdate);
                        break;
                    }
                }
            }
            collector.collect(leftRow);
        }
    }

    public RowMeta getResultRowMeta() {
        return this.leftRowMeta;
    }
}

