/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.business.distr.algox;

import java.math.BigDecimal;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algox.CoGroupFunction;
import kd.bos.algox.Collector;
import kd.bos.algox.RowX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;

public class SupplyWriteOffCoGroupFunc
extends CoGroupFunction {
    private static Log logger = LogFactory.getLog(SupplyWriteOffCoGroupFunc.class);
    private RowMeta leftRowMeta;
    private RowMeta rightRowMeta;
    private int reqQtyFiledIndex;
    private int supplyQtyFieldIndex;

    public SupplyWriteOffCoGroupFunc(RowMeta leftRowMeta, RowMeta rightRowMeta, String reqQtyFiled, String supplyQtyField) {
        this.leftRowMeta = leftRowMeta;
        this.rightRowMeta = rightRowMeta;
        this.reqQtyFiledIndex = leftRowMeta.getFieldIndex(reqQtyFiled);
        this.supplyQtyFieldIndex = rightRowMeta.getFieldIndex(supplyQtyField);
    }

    public void coGroup(Iterable<RowX> iterable, Iterable<RowX> iterable1, Collector collector) {
        try {
            this.doCoGroup(iterable, iterable1, collector);
        }
        catch (Exception ex) {
            String errorMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)ex);
            logger.error(errorMessage);
            throw ex;
        }
    }

    public void doCoGroup(Iterable<RowX> iterable, Iterable<RowX> iterable1, Collector collector) {
        BigDecimal supplyQty = BigDecimal.ZERO;
        for (RowX rowX : iterable1) {
            BigDecimal qty = this.getBigDecimal(rowX.get(this.supplyQtyFieldIndex));
            supplyQty = supplyQty.add(qty);
        }
        for (RowX rowX : iterable) {
            BigDecimal reqQty = rowX.getBigDecimal(this.reqQtyFiledIndex);
            if (reqQty == null) continue;
            if (reqQty.compareTo(supplyQty) > 0) {
                reqQty = reqQty.subtract(supplyQty);
                rowX.set(this.reqQtyFiledIndex, (Object)reqQty);
                supplyQty = BigDecimal.ZERO;
                collector.collect(rowX);
                continue;
            }
            supplyQty = supplyQty.subtract(reqQty);
        }
    }

    protected BigDecimal getBigDecimal(Object value) {
        if ((value = DataType.convertValue((DataType)DataType.BigDecimalType, (Object)value)) instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        return BigDecimal.ZERO;
    }

    public RowMeta getResultRowMeta() {
        return this.leftRowMeta;
    }
}

