/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.business.distr.helper;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class DistrRunHelper {
    private static final Log log = LogFactory.getLog(DistrRunHelper.class);

    public static boolean triggerDistrExecView(IFormView view, String runNumber, StringBuilder errMsg, String algoCacheId, String entityId, String opKey, String idFieldName) {
        Map<String, Object> runSet = DistrRunHelper.loadRunSet(runNumber);
        if (runSet == null) {
            String msg = ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8fd0\u7b97\u65b9\u6848\uff0c\u8bf7\u786e\u8ba4\u8bbe\u7f6e\u3002", (String)"DistrRunHelper_0", (String)"mmc-pom-business", (Object[])new Object[0]);
            errMsg.append(msg);
            return false;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("pom_distrplan_exec");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("autoTrigger", (Object)runNumber);
        if (StringUtils.isNotEmpty((CharSequence)algoCacheId)) {
            formShowParameter.setCustomParam("mutexEntityId", (Object)entityId);
            formShowParameter.setCustomParam("mutexOpKey", (Object)opKey);
            formShowParameter.setCustomParam("mutexIdFieldName", (Object)idFieldName);
            formShowParameter.setCustomParam("algoCacheId", (Object)algoCacheId);
        }
        view.showForm(formShowParameter);
        return true;
    }

    public static boolean triggerDistrExecView(IFormView view, String runNumber, StringBuilder errMsg) {
        return DistrRunHelper.triggerDistrExecView(view, runNumber, errMsg, null, null, null, null);
    }

    public static Long triggerDistrExec(String runNumber, StringBuilder errMsg) {
        return DistrRunHelper.triggerDistrExec(runNumber, errMsg, null, null, null, null);
    }

    public static Long triggerDistrExec(String runNumber, StringBuilder errMsg, String entityId, String opKey, String idFieldName, String algoCacheId) {
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("entityId", entityId);
        params.put("opKey", opKey);
        params.put("idFieldName", idFieldName);
        params.put("algoCacheId", algoCacheId);
        return DistrRunHelper.triggerDistrExec(runNumber, errMsg, params);
    }

    public static Long triggerDistrExec(String runNumber, StringBuilder errMsg, Map<String, String> params) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mrp_caculate_log");
        String entityId = params.get("entityId");
        String opKey = params.get("opKey");
        String idFieldName = params.get("idFieldName");
        String algoCacheId = params.get("algoCacheId");
        String qFilterStr = params.get("qFilter");
        String srcBillEntity = params.get("srcBillEntity");
        CachedDataSet cachedDataSet = DistrRunHelper.testAlgoCache(algoCacheId);
        if (StringUtils.isNotEmpty((CharSequence)algoCacheId) && cachedDataSet == null) {
            String msg = ResManager.loadKDString((String)"\u9009\u5355\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"DistrRunHelper_1", (String)"mmc-pom-business", (Object[])new Object[0]);
            errMsg.append(msg);
            return 0L;
        }
        Map<String, Object> runSet = DistrRunHelper.loadRunSet(runNumber);
        if (runSet == null) {
            String msg = ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8fd0\u7b97\u65b9\u6848\uff0c\u8bf7\u786e\u8ba4\u8bbe\u7f6e\u3002", (String)"DistrRunHelper_0", (String)"mmc-pom-business", (Object[])new Object[0]);
            errMsg.append(msg);
            return 0L;
        }
        Long ctxId = (Long)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMRPCalcRuntimeService", (String)"initRuntime", (Object[])new Object[]{"mrp_caculate_log"});
        if (StringUtils.isNotEmpty((CharSequence)algoCacheId)) {
            cache.put(ctxId.toString(), "algoCacheId", (Object)algoCacheId);
        }
        if (StringUtils.isNotBlank((CharSequence)srcBillEntity) && StringUtils.isNotBlank((CharSequence)qFilterStr)) {
            cache.put(ctxId.toString(), "srcBillEntity", (Object)srcBillEntity);
            cache.put(ctxId.toString(), "qFilterStr", (Object)qFilterStr);
        }
        String title = ResManager.loadKDString((String)"\u914d\u9001\u8ba1\u5212", (String)"DistrRunHelper_2", (String)"mmc-pom-business", (Object[])new Object[0]);
        DynamicObject caculateLog = BusinessDataServiceHelper.loadSingle((Object)ctxId, (String)"mrp_caculate_log");
        caculateLog.set("createorg", runSet.get("scheduling_org"));
        caculateLog.set("useorg", runSet.get("scheduling_org"));
        caculateLog.set("status", (Object)"C");
        caculateLog.set("enable", (Object)"1");
        Object schemeId = runSet.get("scheduling_scheme");
        Object orgId = runSet.get("scheduling_org");
        DynamicObject schedulingScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)schemeId, (String)"pom_planprogram");
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org");
        caculateLog.set("plantype", (Object)title);
        caculateLog.set("plangram", (Object)schedulingScheme.getLong("id"));
        caculateLog.set("programname", (Object)schedulingScheme.getString("name"));
        caculateLog.set("programnumber", (Object)schedulingScheme.getString("number"));
        caculateLog.set("plangramentity", (Object)"pom_planprogram");
        caculateLog.set("plandate", (Object)new Date());
        caculateLog.set("creator", (Object)RequestContext.get().getCurrUserId());
        caculateLog.set("startdate", (Object)new Date());
        caculateLog.set("operatmode", (Object)title);
        caculateLog.set("operatmodekey", (Object)"pom_distrplan_exec");
        caculateLog.set("runtype", (Object)"DISTR");
        SaveServiceHelper.update((DynamicObject)caculateLog);
        Long evntid = (Long)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMRPCalcRuntimeService", (String)"startCalc", (Object[])new Object[]{ctxId, null, org.getLong("id"), org.getString("name"), "pom_distrplan_exec", title, "mrp_caculate_log"});
        return evntid;
    }

    private static CachedDataSet testAlgoCache(String algoCacheId) {
        CachedDataSet cachedDataSet = null;
        if (StringUtils.isNotEmpty((CharSequence)algoCacheId)) {
            try {
                cachedDataSet = Algo.getCacheDataSet((String)algoCacheId);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        return cachedDataSet;
    }

    public static Map<String, Object> loadRunSet(String runNumber) {
        Map<String, Object> result = null;
        return result;
    }

    public static boolean saveDataOperation(DynamicObject[] dynamicObjects, String entityNumber, String opKey, StringBuilder errMsg) {
        OperationResult operateResult = OperationServiceHelper.executeOperate((String)opKey, (String)entityNumber, (DynamicObject[])dynamicObjects, (OperateOption)OperateOption.create());
        if (!operateResult.isSuccess()) {
            StringBuilder errormsg = new StringBuilder();
            errormsg.append(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a", (String)"DistrPlanReceive_7", (String)"mmc-pom-business", (Object[])new Object[0]));
            ValidateResultCollection validateResultCollection = operateResult.getValidateResult();
            List validateErrors = validateResultCollection.getValidateErrors();
            String message = operateResult.getMessage();
            if (StringUtils.isNotEmpty((CharSequence)message)) {
                errormsg.append(message);
            } else {
                message = operateResult.getInteractionContext().getSimpleMessage();
                errormsg.append(message);
            }
            for (ValidateResult validateResult : validateErrors) {
                List allErrorInfo = validateResult.getAllErrorInfo();
                for (OperateErrorInfo operateErrorInfo : allErrorInfo) {
                    errormsg.append(operateErrorInfo.getMessage());
                }
            }
            if (errMsg != null) {
                errMsg.append((CharSequence)errormsg);
            }
        }
        return operateResult.isSuccess();
    }
}

