/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.business.distr.receive;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.mftorder.helper.BillUnitAndQtytHelper;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pom.business.distr.botp.PushOrderResult;
import kd.mmc.pom.business.distr.receive.DistrPlanReceiveReplace;

public class DistrPlanReceive {
    protected static final Log log = LogFactory.getLog(DistrPlanReceive.class);

    public Map<String, Object> receiveVerify(List<Map<String, Object>> params) {
        DistrPlanReceiveReplace receiveReplace = new DistrPlanReceiveReplace();
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        DataSet dataSet = this.buildDataSet(params);
        dataSet = dataSet.groupBy(new String[]{"distrplanid", "isvmi", "batchno", "supplierid", "outinvstatus", "deliverybillno", "isreplace", "materialreplace", "deliveryno"}).sum("qty").groupConcat("resultid").finish();
        for (Row row : dataSet) {
            Long distrplanid = row.getLong("distrplanid");
            Boolean isvmi = row.getBoolean("isvmi");
            String batchno = row.getString("batchno");
            Long supplierid = row.getLong("supplierid");
            BigDecimal qty = row.getBigDecimal("qty");
            String resultidStr = row.getString("resultid");
            Long outinvstatus = row.getLong("outinvstatus");
            String deliverybillno = row.getString("deliverybillno");
            Boolean isreplace = row.getBoolean("isreplace");
            String materialreplace = row.getString("materialreplace");
            String deliveryno = row.getString("deliveryno");
            String lockKey = "DistrPlanReceive-receiveVerify:" + distrplanid;
            String lockMsg = ResManager.loadKDString((String)"\u914d\u9001\u63a5\u6536\u5206\u5e03\u5f0f\u9501\u3002", (String)"DistrPlanReceive_6", (String)"mmc-pom-business", (Object[])new Object[0]);
            DLock lock = DLock.create((String)lockKey, (String)lockMsg);
            lock.lock();
            try {
                String[] resultIdArr;
                String msg = "";
                msg = isreplace != false ? receiveReplace.doReceive(resultidStr, distrplanid, isvmi, batchno, supplierid, outinvstatus, deliverybillno, qty, isreplace, materialreplace, deliveryno) : this.doReceive(distrplanid, isvmi, batchno, supplierid, outinvstatus, deliverybillno, qty, deliveryno);
                for (String resultId : resultIdArr = resultidStr.split(",")) {
                    HashMap<String, Object> resultDetail = new HashMap<String, Object>(16);
                    if (StringUtils.isNotEmpty((CharSequence)msg)) {
                        resultDetail.put("success", false);
                        resultDetail.put("msg", msg);
                    } else {
                        resultDetail.put("success", true);
                        resultDetail.put("msg", "");
                    }
                    result.put(resultId, resultDetail);
                }
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                lock.unlock();
            }
        }
        return result;
    }

    private String doReceive(Long distrplanid, Boolean isvmi, String batchno, Long supplierid, Long outinvstatus, String deliverybillno, BigDecimal qty, String deliveryno) {
        if (qty != null && qty.compareTo(BigDecimal.ZERO) > 0) {
            DynamicObject bd_invstatus = BusinessDataServiceHelper.loadSingleFromCache((Object)outinvstatus, (String)"bd_invstatus");
            DynamicObject bd_supplier = BusinessDataServiceHelper.loadSingleFromCache((Object)supplierid, (String)"bd_supplier");
            DynamicObject pomDistribplan = BusinessDataServiceHelper.loadSingle((Object)distrplanid, (String)"pom_distribplan", (String)"warehouse,stocklocat,reqqty,mtfdeliveryqty,unsendqty,entryentity.mftstockid,entryentity.mftstockentryid,entryentity.entrymtfdeliveryqty,entryentity.rqty,logid");
            DynamicObjectCollection entryentity = pomDistribplan.getDynamicObjectCollection("entryentity");
            RowMeta rowMeta = new RowMeta(new Field[]{new Field("mftstockid", (DataType)DataType.LongType), new Field("mftstockentryid", (DataType)DataType.LongType), new Field("outstockqty", (DataType)DataType.BigDecimalType)});
            DataSetBuilder builder = Algo.create((String)"kd.mmc.pom.business.distr.receive.DistrPlanReceive:outstockqty").createDataSetBuilder(rowMeta);
            BigDecimal reqqty = pomDistribplan.getBigDecimal("reqqty");
            BigDecimal mtfdeliveryqty = pomDistribplan.getBigDecimal("mtfdeliveryqty");
            DynamicObject warehouse = pomDistribplan.getDynamicObject("warehouse");
            DynamicObject stocklocat = pomDistribplan.getDynamicObject("stocklocat");
            if (warehouse != null) {
                warehouse = BusinessDataServiceHelper.loadSingleFromCache((Object)warehouse.getPkValue(), (String)"bd_warehouse");
            }
            if (stocklocat != null) {
                stocklocat = BusinessDataServiceHelper.loadSingleFromCache((Object)stocklocat.getPkValue(), (String)"bd_location");
            }
            mtfdeliveryqty = qty.add(mtfdeliveryqty);
            pomDistribplan.set("mtfdeliveryqty", (Object)mtfdeliveryqty);
            DistrPlanReceive.calcEntryEntity(qty, entryentity, builder);
            DataSet outStockDataSet = builder.build();
            outStockDataSet = outStockDataSet.groupBy(new String[]{"mftstockid", "mftstockentryid"}).sum("outstockqty").finish();
            RowMeta rowMeta1 = outStockDataSet.getRowMeta();
            LinkedList<Map<String, Object>> orders = new LinkedList<Map<String, Object>>();
            HashMap<Long, BigDecimal> mftstockEntryIdRelQtyMap = new HashMap<Long, BigDecimal>(16);
            for (Row row : outStockDataSet) {
                orders.add(rowMeta1.toMap(row));
                mftstockEntryIdRelQtyMap.put(row.getLong("mftstockentryid"), row.getBigDecimal("outstockqty"));
            }
            String ruleId = this.getConvertRuleId(isvmi);
            PushOrderResult pushOrderResult = this.push("pom_mftstock", "im_mdc_mftproorder", orders, ruleId);
            Map<Long, String> errorMap = pushOrderResult.getErrorMap();
            if (errorMap != null) {
                String error = errorMap.entrySet().stream().map(o -> o.getKey() + ":" + (String)o.getValue()).collect(Collectors.joining(";"));
                log.error(error);
                return error;
            }
            List<DynamicObject> targetOrders = pushOrderResult.getTargetOrders();
            for (DynamicObject mftProOrder : targetOrders) {
                DynamicObjectCollection billentry = mftProOrder.getDynamicObjectCollection("billentry");
                DynamicProperty zhnyDeliverynoProperty = mftProOrder.getDynamicObjectType().getProperty("zhny_deliveryno");
                DynamicProperty zhnyDelbillnoProperty = mftProOrder.getDynamicObjectType().getProperty("zhny_delbillno");
                DynamicProperty zhnyMulcaculateProperty = mftProOrder.getDynamicObjectType().getProperty("zhny_mulcaculate");
                if (zhnyDeliverynoProperty != null) {
                    mftProOrder.set("zhny_deliveryno", (Object)deliveryno);
                }
                if (zhnyDelbillnoProperty != null) {
                    mftProOrder.set("zhny_delbillno", (Object)deliverybillno);
                }
                if (zhnyMulcaculateProperty != null) {
                    DynamicObjectCollection collection = mftProOrder.getDynamicObjectCollection("zhny_mulcaculate");
                    DynamicObject dynamic = collection.addNew();
                    dynamic.set("fbasedataid", pomDistribplan.get("logid.id"));
                }
                if (isvmi.booleanValue()) {
                    mftProOrder.set("supplyowner", (Object)bd_supplier);
                }
                for (DynamicObject entry : billentry) {
                    Long srcbillentryid = entry.getLong("srcbillentryid");
                    DynamicObjectType entryDynamicObjectType = entry.getDynamicObjectType();
                    if (entryDynamicObjectType.getProperty("zhny_supplier") != null) {
                        entry.set("zhny_supplier", (Object)bd_supplier);
                    }
                    BigDecimal entryQty = (BigDecimal)mftstockEntryIdRelQtyMap.get(srcbillentryid);
                    DistrPlanReceive.writeQty(entry, entryQty);
                    entry.set("lotnumber", (Object)batchno);
                    entry.set("outinvstatus", (Object)bd_invstatus);
                    if (warehouse != null) {
                        entry.set("warehouse", (Object)warehouse);
                    }
                    if (stocklocat != null) {
                        entry.set("location", (Object)stocklocat);
                    }
                    if (!isvmi.booleanValue()) continue;
                    entry.set("outowner", (Object)bd_supplier);
                }
            }
            String opResult = this.saveDataOperation(targetOrders, "submit");
            if (StringUtils.isNotEmpty((CharSequence)opResult)) {
                return opResult;
            }
            opResult = this.saveDataOperation(targetOrders, "audit");
            if (StringUtils.isNotEmpty((CharSequence)opResult)) {
                this.saveDataOperation(targetOrders, "unsubmit");
                this.saveDataOperation(targetOrders, "delete");
                return opResult;
            }
            SaveServiceHelper.update((DynamicObject)pomDistribplan);
        }
        return null;
    }

    private static void writeQty(DynamicObject entry, BigDecimal entryQty) {
        DynamicObject unit = entry.getDynamicObject("unit");
        DynamicObject baseunit = entry.getDynamicObject("baseunit");
        DynamicObject unit2nd = entry.getDynamicObject("unit2nd");
        DynamicObject material = entry.getDynamicObject("material");
        BigDecimal baseQty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)unit, (BigDecimal)entryQty, (DynamicObject)baseunit);
        BigDecimal qtyunit2nd = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)unit, (BigDecimal)entryQty, (DynamicObject)unit2nd);
        entry.set("qty", (Object)entryQty);
        entry.set("baseqty", (Object)baseQty);
        entry.set("qtyunit2nd", (Object)qtyunit2nd);
    }

    private static void calcEntryEntity(BigDecimal qty, DynamicObjectCollection entryentity, DataSetBuilder builder) {
        Iterator iterator = entryentity.iterator();
        while (iterator.hasNext()) {
            DynamicObject row = (DynamicObject)iterator.next();
            boolean isLast = !iterator.hasNext();
            BigDecimal rqty = row.getBigDecimal("rqty");
            long mftstockid = row.getLong("mftstockid");
            long mftstockentryid = row.getLong("mftstockentryid");
            BigDecimal entrymtfdeliveryqty = row.getBigDecimal("entrymtfdeliveryqty");
            BigDecimal canReceivedqty = rqty.subtract(entrymtfdeliveryqty);
            BigDecimal outstockqty = BigDecimal.ZERO;
            if (isLast) {
                outstockqty = qty;
                qty = BigDecimal.ZERO;
            } else {
                if (canReceivedqty.compareTo(BigDecimal.ZERO) <= 0) continue;
                if (qty.compareTo(canReceivedqty) > 0) {
                    outstockqty = canReceivedqty;
                    qty = qty.subtract(outstockqty);
                } else {
                    outstockqty = qty;
                    qty = BigDecimal.ZERO;
                }
            }
            row.set("entrymtfdeliveryqty", (Object)entrymtfdeliveryqty.add(outstockqty));
            builder.append(new Object[]{mftstockid, mftstockentryid, outstockqty});
            if (BigDecimal.ZERO.compareTo(qty) < 0) continue;
            break;
        }
    }

    private String saveDataOperation(List<DynamicObject> targetOrders, String opKey) {
        OperationResult saveOperate = OperationServiceHelper.executeOperate((String)opKey, (String)"im_mdc_mftproorder", (DynamicObject[])targetOrders.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (!saveOperate.isSuccess()) {
            StringBuilder errormsg = new StringBuilder();
            errormsg.append(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a", (String)"DistrPlanReceive_7", (String)"mmc-pom-business", (Object[])new Object[0]));
            ValidateResultCollection validateResultCollection = saveOperate.getValidateResult();
            List validateErrors = validateResultCollection.getValidateErrors();
            String message = saveOperate.getMessage();
            if (StringUtils.isNotEmpty((CharSequence)message)) {
                errormsg.append(message);
            } else {
                message = saveOperate.getInteractionContext().getSimpleMessage();
                errormsg.append(message);
            }
            for (ValidateResult validateResult : validateErrors) {
                List allErrorInfo = validateResult.getAllErrorInfo();
                for (OperateErrorInfo operateErrorInfo : allErrorInfo) {
                    errormsg.append(operateErrorInfo.getMessage());
                }
            }
            log.error(errormsg.toString());
            return errormsg.toString();
        }
        return null;
    }

    private String getConvertRuleId(Boolean isvmi) {
        String ruleId = "919547717489881088";
        if (isvmi.booleanValue()) {
            ruleId = "1366636890060607488";
        }
        return ruleId;
    }

    private DataSet buildDataSet(List<Map<String, Object>> params) {
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("resultid", (DataType)DataType.StringType), new Field("distrplanid", (DataType)DataType.LongType), new Field("isvmi", (DataType)DataType.BooleanType), new Field("batchno", (DataType)DataType.StringType), new Field("qty", (DataType)DataType.BigDecimalType), new Field("outinvstatus", (DataType)DataType.LongType), new Field("supplierid", (DataType)DataType.LongType), new Field("deliverybillno", (DataType)DataType.StringType), new Field("isreplace", (DataType)DataType.BooleanType), new Field("materialreplace", (DataType)DataType.StringType), new Field("deliveryno", (DataType)DataType.StringType)});
        DataSetBuilder builder = Algo.create((String)"kd.mmc.pom.business.distr.receive.DistrPlanReceive:receiveVerify").createDataSetBuilder(rowMeta);
        for (Map<String, Object> row : params) {
            Object isreplaceObj = row.get("isreplace");
            Object materialreplaceObj = row.get("materialreplace");
            boolean isreplace = false;
            if (isreplaceObj instanceof Boolean) {
                isreplace = (Boolean)isreplaceObj;
            }
            String materialreplace = "";
            if (materialreplaceObj instanceof String) {
                materialreplace = (String)materialreplaceObj;
            }
            builder.append(new Object[]{String.valueOf(row.get("resultid")), row.get("distrplanid"), row.get("isvmi"), row.get("batchno"), row.get("qty"), row.get("outinvstatus"), row.get("supplierid"), row.get("deliverybillno"), isreplace, materialreplace, row.get("deliveryno")});
        }
        return builder.build();
    }

    private PushOrderResult push(String sourceEntity, String targetEntity, List<Map<String, Object>> orders, String ruleId) {
        PushOrderResult pushOrderResult = new PushOrderResult();
        HashMap<Long, String> errorMap = new HashMap<Long, String>(orders.size());
        try {
            if (StringUtils.isBlank((CharSequence)ruleId)) {
                StringBuilder error = new StringBuilder();
                error.append(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u4e0b\u63a8\u5931\u8d25\uff1a\u7ec4\u4ef6\u6e05\u5355ID\u3010%s\u3011\u4e0d\u5b58\u5728\u5339\u914d\u7684\u8f6c\u6362\u89c4\u5219,\u6216\u8005\u539f\u59cb\u8f6c\u6362\u89c4\u5219\u88ab\u7981\u7528\u3002", (String)"DistrPlanReceive_2", (String)"mmc-pom-business", (Object[])new Object[0]));
                this.failInfoUpdate(error.toString(), orders, pushOrderResult, errorMap);
                return pushOrderResult;
            }
            ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(orders.size());
            for (Map<String, Object> order : orders) {
                ListSelectedRow row = new ListSelectedRow();
                row.setPrimaryKeyValue(order.get("mftstockid"));
                row.setEntryPrimaryKeyValue(order.get("mftstockentryid"));
                row.setEntryEntityKey("stockentry");
                selectedRows.add(row);
            }
            PushArgs args = new PushArgs();
            args.setSourceEntityNumber(sourceEntity);
            args.setTargetEntityNumber(targetEntity);
            args.setRuleId(ruleId);
            args.setSelectedRows(selectedRows);
            ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)args);
            if (result.getBillReports().size() > 0) {
                for (SourceBillReport billReport : result.getBillReports()) {
                    if (billReport.isFullSuccess()) continue;
                    StringBuilder error = new StringBuilder();
                    String kdString = ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u4e0b\u63a8\u5355\u636e\u5931\u8d25\u3002", (String)"DistrPlanReceive_3", (String)"mmc-pom-business", (Object[])new Object[0]);
                    error.append(kdString);
                    error.append(':');
                    error.append(result.getMessage()).append('.').append("\r\n");
                    error.append(billReport.getRowInfo());
                    error.append(':');
                    error.append(billReport.buildSummary()).append('.').append("\r\n");
                    Object billId = billReport.getBillId();
                    Long orderId = Long.valueOf(billId.toString());
                    errorMap.put(orderId, error.toString());
                }
            } else if (result.getBillReports().size() == 0) {
                String message = result.getMessage();
                String[] messages = message.split("&&");
                if (messages.length == 2) {
                    messages[0] = messages[0].replace("[", "");
                    messages[0] = messages[0].replace("]", "");
                    String[] ids = messages[0].split(",");
                    String errormessage = messages[1];
                    if (ids != null && ids.length > 0) {
                        StringBuilder error = new StringBuilder();
                        String kdString = ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u4e0b\u63a8\u5355\u636e\u5931\u8d25\u3002", (String)"DistrPlanReceive_3", (String)"mmc-pom-business", (Object[])new Object[0]);
                        error.append(kdString);
                        error.append(':');
                        error.append(errormessage).append('.');
                        for (String id : ids) {
                            errorMap.put(Long.valueOf(id.trim()), error.toString());
                        }
                        log.error(error.toString(), (Object)error);
                    }
                } else {
                    if (message.length() > 450) {
                        message = message.substring(0, 450);
                    }
                    for (Map<String, Object> planorder : orders) {
                        Long orderId = (Long)planorder.get("mftstockid");
                        errorMap.put(orderId, message);
                    }
                    pushOrderResult.setErrorMap(errorMap);
                }
            }
            IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

                public void fillReferenceData(Object[] dynamicObjects, IDataEntityType dType) {
                    BusinessDataServiceHelper.loadRefence((Object[])dynamicObjects, (IDataEntityType)dType);
                }
            };
            MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)targetEntity);
            List targetDataObjects = result.loadTargetDataObjects(refDataProvider, mainType);
            pushOrderResult.setTargetOrders(targetDataObjects);
            if (errorMap.size() > 0) {
                pushOrderResult.setErrorMap(errorMap);
            }
            return pushOrderResult;
        }
        catch (Exception e) {
            StringBuilder error = new StringBuilder();
            String kdString = ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u4e0b\u63a8\u5931\u8d25\uff1a\u7ec4\u4ef6\u6e05\u5355ID\u3010%s\u3011\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a", (String)"DistrPlanReceive_4", (String)"mmc-pom-business", (Object[])new Object[0]);
            error.append(kdString);
            error.append(e.getMessage());
            this.failInfoUpdate(error.toString(), orders, pushOrderResult, errorMap);
            return pushOrderResult;
        }
    }

    private void failInfoUpdate(String error, List<Map<String, Object>> orders, PushOrderResult pushOrderResult, Map<Long, String> errorMap) {
        for (Map<String, Object> planorder : orders) {
            String errorStr = error;
            if (error == null) continue;
            if (error.split("%s").length == 2) {
                errorStr = String.format(error, planorder.get("mftstockid"));
            }
            Long orderId = (Long)planorder.get("mftstockid");
            if (errorStr.length() > 450) {
                errorStr = errorStr.substring(0, 450);
            }
            errorMap.put(orderId, errorStr);
        }
        pushOrderResult.setErrorMap(errorMap);
        pushOrderResult.setTargetOrders(new ArrayList<DynamicObject>());
    }
}

