/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.business.distr.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.BroadcastTask;
import kd.bos.schedule.api.ShardingUtil;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.pom.business.distr.botp.PushOrderResult;
import kd.mpscmm.msplan.mrp.business.helper.BOTPHelper;

public class DistrPlanPushTask
extends AbstractTask
implements BroadcastTask {
    protected static final Log log = LogFactory.getLog(DistrPlanPushTask.class);
    ConvertRuleElement defaultRule = null;
    private Object runlog;

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        String cacheId = (String)params.get("cacheId");
        int index = (Integer)params.get("index");
        int total = (Integer)params.get("total");
        Object logid = params.get("logid");
        String logEntityNumber = (String)params.get("logEntityNumber");
        String sourceEntity = "pom_distplansuggest";
        String targetEntity = "pom_distribplan";
        CachedDataSet cachedDataSet = Algo.getCacheDataSet((String)cacheId);
        DataSet dataSet = cachedDataSet.toDataSet(Algo.create((String)"DistrPlanPushTask:dataSet"), false);
        this.runlog = BusinessDataServiceHelper.loadSingle((Object)logid, (String)logEntityNumber);
        log.info(" taskIndex:" + index + "  taskTotal:" + total + " start...");
        this.defaultRule = this.getConvertRuleElement(sourceEntity, targetEntity);
        int count = cachedDataSet.getRowCount();
        int doCount = 0;
        LinkedList<Long> sourceBillPks = new LinkedList<Long>();
        int i = 0;
        for (Row row : dataSet) {
            if (i % total == index) {
                ++doCount;
                String idStr = row.getString("id");
                String[] idArr = idStr.split(",");
                List<String> sourceBillPksStr = Arrays.asList(idArr);
                List tempSourceBillPks = sourceBillPksStr.stream().map(Long::parseLong).collect(Collectors.toList());
                sourceBillPks.addAll(tempSourceBillPks);
                if (sourceBillPks.size() > 10000) {
                    this.doPush(sourceEntity, targetEntity, sourceBillPks);
                    sourceBillPks.clear();
                }
            }
            ++i;
        }
        if (sourceBillPks.size() > 0) {
            this.doPush(sourceEntity, targetEntity, sourceBillPks);
        }
        dataSet.close();
        log.info(" taskIndex:" + index + " taskTotal:" + total + " total:" + count + " curSize:" + doCount);
    }

    private void doPush(String sourceEntity, String targetEntity, List<Long> sourceBillPks) {
        PushOrderResult result = this.getPushOrderResult(sourceBillPks, sourceEntity, targetEntity);
        List<Object> targetOrders = result.getTargetOrders();
        targetOrders = targetOrders.stream().peek(o -> o.set("logid", this.runlog)).collect(Collectors.toList());
        this.saveData(targetOrders);
    }

    private PushOrderResult getPushOrderResult(List<Long> sourceBillPks, String sourceEntity, String targetEntity) {
        PushOrderResult result;
        Map<Long, String> errorMap;
        String defaultRuleId = "";
        if (this.defaultRule != null) {
            defaultRuleId = this.defaultRule.getId();
        }
        if ((errorMap = (result = this.push(sourceEntity, targetEntity, sourceBillPks, defaultRuleId)).getErrorMap()) != null) {
            String error = errorMap.entrySet().stream().map(o -> o.getKey() + ":" + (String)o.getValue()).collect(Collectors.joining(";"));
            log.error(error);
            throw new KDBizException(error);
        }
        return result;
    }

    private ConvertRuleElement getConvertRuleElement(String sourceEntity, String targetEntity) {
        List rules = BOTPHelper.getRules((String)sourceEntity, (String)targetEntity);
        if (rules == null || rules.size() == 0) {
            String error = ResManager.loadKDString((String)"\u8ba1\u5212\u5efa\u8bae\u6295\u653e\u4e0b\u6e38\u5355\u636e\u65f6\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5339\u914d\u7684\u8f6c\u6362\u89c4\u5219,\u6216\u8005\u539f\u59cb\u8f6c\u6362\u89c4\u5219\u88ab\u7981\u7528\u3002", (String)"DistrPlanPushTask_0", (String)"mmc-pom-business", (Object[])new Object[0]);
            throw new KDBizException(error);
        }
        ConvertRuleElement defaultRule = (ConvertRuleElement)rules.get(0);
        List defaultRules = rules.stream().filter(ConvertRuleElement::isDefRule).collect(Collectors.toList());
        if (defaultRules.size() > 0) {
            defaultRule = (ConvertRuleElement)defaultRules.get(0);
        }
        return defaultRule;
    }

    private void saveData(List<DynamicObject> targetOrders) {
        OperationResult saveOperate = SaveServiceHelper.saveOperate((String)"pom_distribplan", (DynamicObject[])targetOrders.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (!saveOperate.isSuccess()) {
            StringBuilder errormsg = new StringBuilder();
            errormsg.append(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a", (String)"CreateDistribPlan_7", (String)"mmc-pom-business", (Object[])new Object[0]));
            ValidateResultCollection validateResultCollection = saveOperate.getValidateResult();
            List validateErrors = validateResultCollection.getValidateErrors();
            for (ValidateResult validateResult : validateErrors) {
                List allErrorInfo = validateResult.getAllErrorInfo();
                for (OperateErrorInfo operateErrorInfo : allErrorInfo) {
                    errormsg.append(operateErrorInfo.getMessage());
                }
            }
            log.error(errormsg.toString());
            throw new KDBizException(errormsg.toString());
        }
    }

    private PushOrderResult push(String sourceEntity, String targetEntity, List<Long> sourceBillPks, String ruleId) {
        PushOrderResult pushOrderResult = new PushOrderResult();
        HashMap<Long, String> errorMap = new HashMap<Long, String>(sourceBillPks.size());
        try {
            if (StringUtils.isBlank((CharSequence)ruleId)) {
                StringBuilder error = new StringBuilder();
                error.append(ResManager.loadKDString((String)"\u8ba1\u5212\u5efa\u8bae\u6295\u653e\u4e0b\u6e38\u5355\u636e\u65f6\u5931\u8d25\uff1a\u4e0d\u5b58\u5728\u5339\u914d\u7684\u8f6c\u6362\u89c4\u5219,\u6216\u8005\u539f\u59cb\u8f6c\u6362\u89c4\u5219\u88ab\u7981\u7528\u3002", (String)"DistrPlanPushTask_0", (String)"mmc-pom-business", (Object[])new Object[0]));
                this.failInfoUpdate(error.toString(), 0L, pushOrderResult, errorMap);
                return pushOrderResult;
            }
            ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(sourceBillPks.size());
            for (Long pk : sourceBillPks) {
                ListSelectedRow row = new ListSelectedRow();
                row.setPrimaryKeyValue((Object)pk);
                selectedRows.add(row);
            }
            PushArgs args = new PushArgs();
            args.setSourceEntityNumber(sourceEntity);
            args.setTargetEntityNumber(targetEntity);
            args.setRuleId(ruleId);
            args.setSelectedRows(selectedRows);
            ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)args);
            if (result.getBillReports().size() > 0) {
                for (SourceBillReport billReport : result.getBillReports()) {
                    if (billReport.isFullSuccess()) continue;
                    StringBuilder error = new StringBuilder();
                    error.append(ResManager.loadKDString((String)"\u8ba1\u5212\u5efa\u8bae\u6295\u653e\u65f6\u4e0b\u63a8\u5355\u636e\u5931\u8d25\uff1a", (String)"CreateDistribPlan_3", (String)"mmc-pom-business", (Object[])new Object[0]));
                    error.append(result.getMessage()).append('\u3002').append("\r\n");
                    error.append(billReport.getRowInfo());
                    error.append(':');
                    error.append(billReport.buildSummary()).append('\u3002').append("\r\n");
                    Object billId = billReport.getBillId();
                    Long orderId = Long.valueOf(billId.toString());
                    errorMap.put(orderId, error.toString());
                    log.error(error.toString(), (Object)error);
                }
            } else if (result.getBillReports().size() == 0) {
                String message = result.getMessage();
                String[] messages = message.split("&&");
                if (messages.length == 2) {
                    messages[0] = messages[0].replace("[", "");
                    messages[0] = messages[0].replace("]", "");
                    String[] ids = messages[0].split(",");
                    String errormessage = messages[1];
                    if (ids != null && ids.length > 0) {
                        String error = ResManager.loadKDString((String)"\u8ba1\u5212\u5efa\u8bae\u6295\u653e\u65f6\u4e0b\u63a8\u5355\u636e\u5931\u8d25\uff1a%s\u3002", (String)"DistrPlanPushTask_1", (String)"mmc-pom-business", (Object[])new Object[0]);
                        for (String id : ids) {
                            errorMap.put(Long.valueOf(id.trim()), error);
                        }
                        log.error(error, (Object)error);
                    }
                } else {
                    if (message.length() > 450) {
                        message = message.substring(0, 450);
                    }
                    for (Long orderId : sourceBillPks) {
                        errorMap.put(orderId, message);
                    }
                    pushOrderResult.setErrorMap(errorMap);
                }
            }
            IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

                public void fillReferenceData(Object[] dynamicObjects, IDataEntityType dType) {
                    BusinessDataServiceHelper.loadRefence((Object[])dynamicObjects, (IDataEntityType)dType);
                }
            };
            MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)targetEntity);
            List targetDataObjects = result.loadTargetDataObjects(refDataProvider, mainType);
            pushOrderResult.setTargetOrders(targetDataObjects);
            if (errorMap.size() > 0) {
                pushOrderResult.setErrorMap(errorMap);
            }
            return pushOrderResult;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            String error = ResManager.loadKDString((String)"\u8ba1\u5212\u5efa\u8bae\u6295\u653e\u65f6\u4e0b\u63a8\u5355\u636e\u5931\u8d25\uff1a%s\u3002", (String)"DistrPlanPushTask_1", (String)"mmc-pom-business", (Object[])new Object[0]);
            error = String.format(error, e.getMessage());
            this.failInfoUpdate(error, 0L, pushOrderResult, errorMap);
            return pushOrderResult;
        }
    }

    private void failInfoUpdate(String error, Long orderId, PushOrderResult pushOrderResult, Map<Long, String> errorMap) {
        errorMap.put(orderId, error);
        pushOrderResult.setErrorMap(errorMap);
        pushOrderResult.setTargetOrders(new ArrayList<DynamicObject>());
    }

    public void execute(RequestContext requestContext, Map<String, Object> params, ShardingUtil.BroadcastVO broadcastVO) throws KDException {
        int index = broadcastVO.getIndex();
        int total = broadcastVO.getTotal();
        total = Math.max(total, 1);
        params.put("total", total);
        params.put("index", index);
        this.execute(requestContext, params);
    }
}

