/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.business.mftorder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.mftcommon.impl.MftCommonBusinessImpl;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class MftProorderCreateMftReturnorderBusiness
extends MftCommonBusinessImpl {
    private static final Log logger = LogFactory.getLog(MftProorderCreateMftReturnorderBusiness.class);

    public Map<String, Object> createMftReturnOrderBill(String billno, List<Map<String, Object>> paramList, String botpID) {
        String orderBillNo;
        String errorString;
        if (StringUtils.isEmpty((String)billno)) {
            String errorString2 = ResManager.loadKDString((String)"\u4f20\u5165\u7684\u751f\u4ea7\u9886\u6599\u5355\uff0c\u5355\u636e\u7f16\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"MftProorderCreateMftReturnorderBusiness_01", (String)"mmc-pom-business", (Object[])new Object[0]);
            String errorCode = "pom.100001";
            return this.genReturnMap(errorString2, Boolean.FALSE, errorCode);
        }
        Set lldIDSet = this.getMftProOrderID(billno);
        if (lldIDSet.isEmpty()) {
            String errorString3 = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u751f\u4ea7\u9886\u6599\u5355\u5355\u636e\u7f16\u53f7\uff08%1$s\uff09\u65e0\u6cd5\u5728\u7cfb\u7edf\u4e2d\u627e\u5230\u5bf9\u5e94\u7684\u5df2\u5ba1\u6838\u7684\u5355\u636e\u4fe1\u606f\u3002", (String)"MftProorderCreateMftReturnorderBusiness_02", (String)"mmc-pom-business", (Object[])new Object[0]), billno);
            String errorCode = "pom.100002";
            return this.genReturnMap(errorString3, Boolean.FALSE, errorCode);
        }
        if (lldIDSet.size() > 1) {
            String errorString4 = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u751f\u4ea7\u9886\u6599\u5355\u5355\u636e\u7f16\u53f7\uff08%1$s\uff09\u5728\u7cfb\u7edf\u4e2d\u5b58\u5728\u591a\u5f20\u5df2\u5ba1\u6838\u7684\u5355\u636e\u4fe1\u606f\u3002", (String)"MftProorderCreateMftReturnorderBusiness_03", (String)"mmc-pom-business", (Object[])new Object[0]), billno);
            String errorCode = "pom.100003";
            return this.genReturnMap(errorString4, Boolean.FALSE, errorCode);
        }
        logger.info("\u751f\u4ea7\u9886\u6599\u5355\u751f\u6210\u751f\u4ea7\u9000\u6599\u5355:" + billno + "-" + botpID);
        Long lldId = (Long)lldIDSet.iterator().next();
        Map entryDataMap = this.getMftProOrderEntryData(lldId);
        if (entryDataMap == null || entryDataMap.isEmpty()) {
            String errorString5 = String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u9886\u6599\u5355\uff08%1$s\uff09\u65e0\u5bf9\u5e94\u5206\u5f55\u4fe1\u606f\u3002", (String)"MftProorderCreateMftReturnorderBusiness_04", (String)"mmc-pom-business", (Object[])new Object[0]), billno);
            String errorCode = "pom.100004";
            return this.genReturnMap(errorString5, Boolean.FALSE, errorCode);
        }
        ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(16);
        Map materialMap = new HashMap(16);
        if (paramList != null && !paramList.isEmpty()) {
            String materialNumber;
            Map<String, Object> listMap;
            int i;
            HashSet<String> materialNumberSet = new HashSet<String>(paramList.size());
            HashSet<String> materialNumberSeqSet = new HashSet<String>(paramList.size());
            for (i = 0; i < paramList.size(); ++i) {
                listMap = paramList.get(i);
                materialNumber = this.getMaterialNumber(listMap);
                if ("".equals(materialNumber)) {
                    errorString = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u7269\u6599\uff08%1$s\uff09\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"MftProorderCreateMftReturnorderBusiness_05", (String)"mmc-pom-business", (Object[])new Object[0]), materialNumber);
                    String errorCode = "pom.100005";
                    return this.genReturnMap(errorString, Boolean.FALSE, errorCode);
                }
                BigDecimal outQty = this.getOutQty(listMap);
                if (outQty.compareTo(ZERO) <= 0) {
                    String errorString6 = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7269\u6599\uff08%1$s\uff09\u7684\u9000\u5e93\u6570\u91cf\uff08%2$s\uff09\u5c0f\u4e8e\u7b49\u4e8e0\u3002", (String)"MftProorderCreateMftReturnorderBusiness_06", (String)"mmc-pom-business", (Object[])new Object[0]), materialNumber, outQty);
                    String errorCode = "pom.100006";
                    return this.genReturnMap(errorString6, Boolean.FALSE, errorCode);
                }
                String oprNo = this.getOprNo(listMap);
                String processSeq = this.getProcessSeq(listMap);
                DynamicObject configuredCode = this.getConfiguredCode(listMap);
                orderBillNo = this.getOrderBillNo(listMap);
                if (configuredCode == null && listMap.get("configuredcode") != null && !"".equals(listMap.get("configuredcode").toString())) {
                    String errorString7 = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u914d\u7f6e\u53f7\uff08%1$s\uff09\u5728\u57fa\u7840\u8d44\u6599\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"MftProorderCreateMftReturnorderBusiness_07", (String)"mmc-pom-business", (Object[])new Object[0]), listMap.get("configuredcode"));
                    String errorCode = "pom.100007";
                    return this.genReturnMap(errorString7, Boolean.FALSE, errorCode);
                }
                Long configuredCodeID = 0L;
                if (configuredCode != null) {
                    configuredCodeID = configuredCode.getLong("id");
                }
                materialNumberSet.add(materialNumber);
                materialNumberSeqSet.add(this.getMftProOrderObjKeys(materialNumber, oprNo, processSeq, configuredCodeID, orderBillNo));
            }
            if (materialNumberSeqSet.size() != paramList.size()) {
                String errorString8 = ResManager.loadKDString((String)"\u4f20\u5165\u7684\u7269\u6599\u53ef\u80fd\u5b58\u5728\u91cd\u590d\u9879\uff0c\u8bf7\u68c0\u67e5\uff1a\u540c\u4e00\u7269\u6599\u3001\u751f\u4ea7\u5de5\u5355\u7f16\u53f7\u3001\u5de5\u5e8f\u5e8f\u5217\u3001\u5de5\u5e8f\u53f7\u3001\u914d\u7f6e\u53f7\uff0c\u53ea\u5141\u8bb8\u51fa\u73b0\u4e00\u6b21\u3002", (String)"MftProorderCreateMftReturnorderBusiness_08", (String)"mmc-pom-business", (Object[])new Object[0]);
                String errorCode = "pom.100008";
                return this.genReturnMap(errorString8, Boolean.FALSE, errorCode);
            }
            materialMap = this.getMaterialID(materialNumberSet);
            for (i = 0; i < paramList.size(); ++i) {
                String errorCode;
                String errorString9;
                String configuredCodeNumber;
                listMap = paramList.get(i);
                materialNumber = this.getMaterialNumber(listMap);
                String oprNo = this.getOprNo(listMap);
                String processSeq = this.getProcessSeq(listMap);
                Long materalID = (Long)materialMap.get(materialNumber);
                String orderBillNo2 = this.getOrderBillNo(listMap);
                if (materalID == null || materalID.equals(0L)) {
                    String errorString10 = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u7269\u6599\u7f16\u7801\uff08%1$s\uff09\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"MftProorderCreateMftReturnorderBusiness_09", (String)"mmc-pom-business", (Object[])new Object[0]), materialNumber);
                    String errorCode2 = "pom.100009";
                    return this.genReturnMap(errorString10, Boolean.FALSE, errorCode2);
                }
                Long configuredCodeID = this.getConfiguredCodeID(listMap);
                String keyString = this.getMftProOrderObjKeys(materalID, oprNo, processSeq, configuredCodeID, orderBillNo2);
                List entryList = (List)entryDataMap.get(keyString);
                if (this.isEmptyList(entryList)) {
                    configuredCodeNumber = listMap.get("configuredcode") == null ? "" : listMap.get("configuredcode").toString();
                    errorString9 = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u7269\u6599\u660e\u7ec6\u4fe1\u606f\uff08\u7269\u6599\u7f16\u7801\uff1a%1$s\uff1b\u751f\u4ea7\u5de5\u5355\u7f16\u53f7\uff1a%2$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%4$s\uff1b\u5de5\u5e8f\u53f7\uff1a%3$s\uff1b\u914d\u7f6e\u53f7\uff1a%5$s\uff09\u5728\u751f\u4ea7\u9886\u6599\u5355\uff08%6$s\uff09\u4e2d\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7269\u6599\u660e\u7ec6\u3002", (String)"MftProorderCreateMftReturnorderBusiness_10", (String)"mmc-pom-business", (Object[])new Object[0]), materialNumber, orderBillNo2, oprNo, processSeq, configuredCodeNumber, billno);
                    errorCode = "pom.100010";
                    return this.genReturnMap(errorString9, Boolean.FALSE, errorCode);
                }
                if (entryList.size() > 1) {
                    configuredCodeNumber = listMap.get("configuredcode") == null ? "" : listMap.get("configuredcode").toString();
                    errorString9 = String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u9886\u6599\u5355\uff08%6$s\uff09\u7684\u7269\u6599\u660e\u7ec6\u4e2d\u5b58\u5728\u91cd\u590d\u6570\u636e\uff08\u7269\u6599\u7f16\u7801\uff1a%1$s\uff1b\u751f\u4ea7\u5de5\u5355\u7f16\u53f7\uff1a%2$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%4$s\uff1b\u5de5\u5e8f\u53f7\uff1a%3$s\uff1b\u914d\u7f6e\u53f7\uff1a%5$s\uff09\u3002", (String)"MftProorderCreateMftReturnorderBusiness_11", (String)"mmc-pom-business", (Object[])new Object[0]), materialNumber, orderBillNo2, oprNo, processSeq, configuredCodeNumber, billno);
                    errorCode = "pom.100011";
                    return this.genReturnMap(errorString9, Boolean.FALSE, errorCode);
                }
                Map entryMap = (Map)entryList.get(0);
                Long lldEntryID = Long.parseLong(entryMap.get("entryid").toString());
                ListSelectedRow srcBil = new ListSelectedRow((Object)lldId);
                srcBil.setEntryEntityKey("billentry");
                srcBil.setEntryPrimaryKeyValue((Object)lldEntryID);
                needPushRows.add(srcBil);
            }
        } else {
            ListSelectedRow srcBil = new ListSelectedRow((Object)lldId);
            needPushRows.add(srcBil);
        }
        if (needPushRows.isEmpty()) {
            return this.genReturnMap("no push datas", Boolean.TRUE, "0");
        }
        PushArgs pushArgs = this.genPushArgs("im_mdc_mftproorder", "im_mdc_mftreturnorder", botpID);
        pushArgs.setSelectedRows(needPushRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"im_mdc_mftreturnorder");
        String targetBillNoStr = "";
        if (!pushResult.isSuccess()) {
            String errMessage = this.getErrByRes(pushResult);
            logger.info(String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u9886\u6599\u5355\u751f\u6210\u751f\u4ea7\u9000\u6599\u5355\u5931\u8d25:%1$s", (String)"MftProorderCreateMftReturnorderBusiness_16", (String)"mmc-pom-business", (Object[])new Object[0]), errMessage));
            throw new KDBizException(new ErrorCode("createMftReturnOrderBill", this.getErrByRes(pushResult)), new Object[0]);
        }
        List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        if (targetBillObjs.isEmpty()) {
            errorString = ResManager.loadKDString((String)"\u751f\u4ea7\u9000\u6599\u5355\u672a\u751f\u6210\uff0c\u8bf7\u68c0\u67e5\u751f\u4ea7\u9886\u6599\u5355\u751f\u6210\u751f\u4ea7\u9000\u6599\u5355\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"MftProorderCreateMftReturnorderBusiness_12", (String)"mmc-pom-business", (Object[])new Object[0]);
            throw new KDBizException(new ErrorCode("createMftReturnOrderBill", errorString), new Object[0]);
        }
        if (paramList != null && !paramList.isEmpty()) {
            for (int i = 0; i < paramList.size(); ++i) {
                Long configuredCodeID;
                String processSeq;
                String oprNo;
                Map<String, Object> listMap = paramList.get(i);
                String materialNumber = this.getMaterialNumber(listMap);
                Long materalID = (Long)materialMap.get(materialNumber);
                DynamicObject mftProOrderEntryDy = this.getMftReturnOrderEntry(targetBillObjs, materalID, orderBillNo = this.getOrderBillNo(listMap), oprNo = this.getOprNo(listMap), processSeq = this.getProcessSeq(listMap), configuredCodeID = this.getConfiguredCodeID(listMap));
                if (mftProOrderEntryDy == null) {
                    String errorString11 = String.format(ResManager.loadKDString((String)"\u751f\u6210\u7684\u9886\u6599\u9000\u5e93\u5355\u4e0d\u5b58\u5728\u7269\u6599\uff08%1$s\uff09\u3001\u751f\u4ea7\u5de5\u5355\u53f7\uff08%2$s\uff09\u3001\u5de5\u5e8f\u53f7\uff08%3$s\uff09\u3001\u987a\u5e8f\u53f7\uff08%4$s\uff09\u3001\u914d\u7f6e\u53f7\uff08%5$s\uff09\u3002", (String)"MftProorderCreateMftReturnorderBusiness_13", (String)"mmc-pom-business", (Object[])new Object[0]), materialNumber, orderBillNo, oprNo, processSeq, configuredCodeID);
                    throw new KDBizException(new ErrorCode("createMftReturnOrderBill", errorString11), new Object[0]);
                }
                BigDecimal outQtyNew = this.getOutQty(listMap);
                BigDecimal outQty = mftProOrderEntryDy.getBigDecimal("qty");
                if (outQty.compareTo(outQtyNew) < 0) {
                    String errorString12 = String.format(ResManager.loadKDString((String)"\u751f\u6210\u751f\u4ea7\u9000\u6599\u5355\uff08\u7269\u6599\uff1a%1$s\uff1b\u751f\u4ea7\u5de5\u5355\u7f16\u53f7\uff1a%2$s\uff09\u7684\u53ef\u9000\u5e93\u6570\u91cf\uff08%3$s\uff09\u5c0f\u4e8e\u672c\u6b21\u5f85\u9000\u5e93\u6570\u91cf\uff08%4$s\uff09\u3002", (String)"MftProorderCreateMftReturnorderBusiness_14", (String)"mmc-pom-business", (Object[])new Object[0]), materialNumber, orderBillNo, outQty, outQtyNew);
                    throw new KDBizException(new ErrorCode("createMftReturnOrderBill", errorString12), new Object[0]);
                }
                if (outQty.compareTo(outQtyNew) <= 0) continue;
                DynamicObject masterid = mftProOrderEntryDy.getDynamicObject("material").getDynamicObject("masterid");
                DynamicObject unit = mftProOrderEntryDy.getDynamicObject("unit");
                DynamicObject baseunit = mftProOrderEntryDy.getDynamicObject("baseunit");
                DynamicObject unit2nd = mftProOrderEntryDy.getDynamicObject("unit2nd");
                mftProOrderEntryDy.set("qty", (Object)this.getQtyByUnit(masterid, baseunit, unit, outQtyNew));
                mftProOrderEntryDy.set("baseqty", (Object)this.processPrecision(outQtyNew, baseunit));
                mftProOrderEntryDy.set("qtyunit2nd", (Object)this.getQtyByUnit(masterid, baseunit, unit2nd, outQtyNew));
            }
        }
        OperateOption create = OperateOption.create();
        create.setVariableValue("ignorewarn", "true");
        create.setVariableValue("ignoreinteraction", "true");
        OperationResult saveOperate = SaveServiceHelper.saveOperate((String)"im_mdc_mftreturnorder", (DynamicObject[])targetBillObjs.toArray(new DynamicObject[targetBillObjs.size()]), (OperateOption)create);
        if (!saveOperate.isSuccess()) {
            throw new KDBizException(new ErrorCode("createMftReturnOrderBill", String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4fdd\u5b58\u751f\u4ea7\u9000\u6599\u5355\u51fa\u73b0\u5f02\u5e38\uff1a%1$s", (String)"MftProorderCreateMftReturnorderBusiness_15", (String)"mmc-pom-business", (Object[])new Object[0]), this.getErrDetail(saveOperate))), new Object[0]);
        }
        targetBillNoStr = this.getTargetBillNoString(targetBillObjs);
        return this.genReturnMap(targetBillNoStr, Boolean.TRUE, "0");
    }

    private DynamicObject getMftReturnOrderEntry(List<DynamicObject> targetBillObjs, Long materalID, String orderBillNo, String oprNo, String processSeq, Long configuredcodeid) {
        for (DynamicObject targetBillObj : targetBillObjs) {
            DynamicObjectCollection coll = targetBillObj.getDynamicObjectCollection("billentry");
            for (int i = 0; i < coll.size(); ++i) {
                DynamicObject dy = (DynamicObject)coll.get(i);
                Long entryMaterialID = dy.getDynamicObject("material").getDynamicObject("masterid").getLong("id");
                if (!this.isLongEquals(materalID, entryMaterialID) || !this.isStrEquals(orderBillNo, dy.getString("manubill")) || !this.isStrEquals(oprNo, dy.getString("oprno")) || !this.isStrEquals(processSeq, dy.getString("processseq")) || !this.isLongEquals(configuredcodeid, dy.getDynamicObject("configuredcode") == null ? 0L : dy.getDynamicObject("configuredcode").getLong("id"))) continue;
                return dy;
            }
        }
        return null;
    }
}

