/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.business.mftorder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.mftcommon.impl.MftCommonBusinessImpl;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class MftStockCreateMftProorderBusiness
extends MftCommonBusinessImpl {
    private static final Log logger = LogFactory.getLog(MftStockCreateMftProorderBusiness.class);

    public Map<String, Object> createMftProOrderBill(String orderBillno, List<Map<String, Object>> paramList, String botpID) {
        Long configuredCodeID;
        String errorString;
        String processSeq;
        String oprNo;
        if (StringUtils.isEmpty((String)orderBillno)) {
            String errorString2 = ResManager.loadKDString((String)"\u4f20\u5165\u7684\u751f\u4ea7\u5de5\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MftStockCreateMftProorderBusiness_01", (String)"mmc-pom-business", (Object[])new Object[0]);
            String errorCode = "pom.100001";
            return this.genReturnMap(errorString2, Boolean.FALSE, errorCode);
        }
        Set orderIDSet = this.getOrderID(orderBillno);
        if (orderIDSet.isEmpty()) {
            String errorString3 = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u751f\u4ea7\u5de5\u5355\uff08\u7f16\u53f7\uff1a%1$s\uff09\u5728\u7cfb\u7edf\u4e2d\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u5355\u636e\u3002", (String)"MftStockCreateMftProorderBusiness_02", (String)"mmc-pom-business", (Object[])new Object[0]), orderBillno);
            String errorCode = "pom.100002";
            return this.genReturnMap(errorString3, Boolean.FALSE, errorCode);
        }
        if (orderIDSet.size() > 1) {
            String errorString4 = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u751f\u4ea7\u5de5\u5355\uff08\u7f16\u53f7\uff1a%1$s\uff09\u5728\u7cfb\u7edf\u4e2d\u5b58\u5728\u591a\u5f20\u5355\u636e\u3002", (String)"MftStockCreateMftProorderBusiness_03", (String)"mmc-pom-business", (Object[])new Object[0]), orderBillno);
            String errorCode = "pom.100003";
            return this.genReturnMap(errorString4, Boolean.FALSE, errorCode);
        }
        if (this.isEmptyList(paramList)) {
            String errorString5 = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u7269\u6599\u51fa\u5e93\u96c6\u5408\u6570\u636e\u4e3a\u7a7a\u3002", (String)"MftStockCreateMftProorderBusiness_16", (String)"mmc-pom-business", (Object[])new Object[0]), orderBillno);
            String errorCode = "pom.100016";
            return this.genReturnMap(errorString5, Boolean.FALSE, errorCode);
        }
        logger.info("\u7ec4\u4ef6\u6e05\u5355\u751f\u6210\u751f\u4ea7\u9886\u6599\u5355:" + orderBillno + "-" + botpID);
        Map stockDataMap = this.getStockData(orderBillno);
        if (stockDataMap == null || stockDataMap.isEmpty()) {
            String errorString6 = String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\uff08\u7f16\u53f7\uff1a%1$s\uff09\u4e0d\u5b58\u5728\u5df2\u5ba1\u6838\u7684\u7ec4\u4ef6\u6e05\u5355\u3002", (String)"MftStockCreateMftProorderBusiness_13", (String)"mmc-pom-business", (Object[])new Object[0]), orderBillno);
            String errorCode = "pom.100013";
            return this.genReturnMap(errorString6, Boolean.FALSE, errorCode);
        }
        ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(16);
        HashSet<String> materialNumberSet = new HashSet<String>(paramList.size());
        HashSet<String> materialNumberSeqSet = new HashSet<String>(paramList.size());
        for (int i = 0; i < paramList.size(); ++i) {
            Map<String, Object> listMap = paramList.get(i);
            String materialNumber = this.getMaterialNumber(listMap);
            if ("".equals(materialNumber)) {
                String errorString7 = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u7269\u6599\uff08%1$s\uff09\u4e3a\u7a7a\u3002", (String)"MftStockCreateMftProorderBusiness_04", (String)"mmc-pom-business", (Object[])new Object[0]), materialNumber);
                String errorCode = "pom.100004";
                return this.genReturnMap(errorString7, Boolean.FALSE, errorCode);
            }
            BigDecimal outQty = this.getOutQty(listMap);
            if (outQty.compareTo(ZERO) <= 0) {
                String errorString8 = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7269\u6599\uff08%1$s\uff09\u7684\u51fa\u5e93\u6570\u91cf\uff08%2$s\uff09\u5c0f\u4e8e\u7b49\u4e8e0\u3002", (String)"MftStockCreateMftProorderBusiness_05", (String)"mmc-pom-business", (Object[])new Object[0]), materialNumber, outQty);
                String errorCode = "pom.100005";
                return this.genReturnMap(errorString8, Boolean.FALSE, errorCode);
            }
            oprNo = this.getOprNo(listMap);
            processSeq = this.getProcessSeq(listMap);
            DynamicObject configuredCode = this.getConfiguredCode(listMap);
            if (configuredCode == null && listMap.get("configuredcode") != null && !"".equals(listMap.get("configuredcode").toString())) {
                errorString = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u914d\u7f6e\u53f7\uff08%1$s\uff09\u5728\u57fa\u7840\u8d44\u6599\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"MftStockCreateMftProorderBusiness_17", (String)"mmc-pom-business", (Object[])new Object[0]), listMap.get("configuredcode"));
                String errorCode = "pom.100017";
                return this.genReturnMap(errorString, Boolean.FALSE, errorCode);
            }
            configuredCodeID = 0L;
            if (configuredCode != null) {
                configuredCodeID = configuredCode.getLong("id");
            }
            materialNumberSet.add(materialNumber);
            materialNumberSeqSet.add(this.getObjKeys(materialNumber, oprNo, processSeq, configuredCodeID));
        }
        if (materialNumberSeqSet.size() != paramList.size()) {
            String errorString9 = ResManager.loadKDString((String)"\u4f20\u5165\u7684\u7269\u6599\u53ef\u80fd\u5b58\u5728\u91cd\u590d\u9879\uff0c\u8bf7\u68c0\u67e5\uff1a\u540c\u4e00\u7269\u6599\u3001\u751f\u4ea7\u5de5\u5355\u7f16\u53f7\u3001\u5de5\u5e8f\u5e8f\u5217\u3001\u5de5\u5e8f\u53f7\u3001\u914d\u7f6e\u53f7\uff0c\u53ea\u5141\u8bb8\u51fa\u73b0\u4e00\u6b21\u3002", (String)"MftStockCreateMftProorderBusiness_06", (String)"mmc-pom-business", (Object[])new Object[0]);
            String errorCode = "pom.100006";
            return this.genReturnMap(errorString9, Boolean.FALSE, errorCode);
        }
        Map materialMap = this.getMaterialID(materialNumberSet);
        for (int i = 0; i < paramList.size(); ++i) {
            String errorCode;
            String errorString10;
            String configuredCodeNumber;
            Map<String, Object> listMap = paramList.get(i);
            String materialNumber = this.getMaterialNumber(listMap);
            oprNo = this.getOprNo(listMap);
            processSeq = this.getProcessSeq(listMap);
            Long materalID = (Long)materialMap.get(materialNumber);
            if (materalID == null || materalID.equals(0L)) {
                errorString = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u7269\u6599\u7f16\u7801\uff08%1$s\uff09\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"MftStockCreateMftProorderBusiness_07", (String)"mmc-pom-business", (Object[])new Object[0]), materialNumber);
                String errorCode2 = "pom.100007";
                return this.genReturnMap(errorString, Boolean.FALSE, errorCode2);
            }
            configuredCodeID = this.getConfiguredCodeID(listMap);
            String keyString = this.getObjKeys(materalID, oprNo, processSeq, configuredCodeID);
            List stockList = (List)stockDataMap.get(keyString);
            if (this.isEmptyList(stockList)) {
                configuredCodeNumber = listMap.get("configuredcode") == null ? "" : listMap.get("configuredcode").toString();
                errorString10 = String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u7ec4\u4ef6\u660e\u7ec6\u4fe1\u606f\uff08\u7269\u6599\u7f16\u7801\uff1a%1$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%3$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff1b\u914d\u7f6e\u53f7\uff1a%4$s\uff09\u5728\u751f\u4ea7\u5de5\u5355\uff08%5$s\uff09\u7684\u7ec4\u4ef6\u6e05\u5355\u4e2d\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7ec4\u4ef6\u660e\u7ec6\u3002", (String)"MftStockCreateMftProorderBusiness_14", (String)"mmc-pom-business", (Object[])new Object[0]), materialNumber, oprNo, processSeq, configuredCodeNumber, orderBillno);
                errorCode = "pom.100014";
                return this.genReturnMap(errorString10, Boolean.FALSE, errorCode);
            }
            if (stockList.size() > 1) {
                configuredCodeNumber = listMap.get("configuredcode") == null ? "" : listMap.get("configuredcode").toString();
                errorString10 = String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\uff08%5$s\uff09\u7684\u7ec4\u4ef6\u6e05\u5355\u4e2d\u5b58\u5728\u91cd\u590d\u6570\u636e\uff08\u7269\u6599\u7f16\u7801\uff1a%1$s\uff1b\u5de5\u5e8f\u5e8f\u5217\uff1a%3$s\uff1b\u5de5\u5e8f\u53f7\uff1a%2$s\uff1b\u914d\u7f6e\u53f7\uff1a%4$s\uff09\u3002", (String)"MftStockCreateMftProorderBusiness_15", (String)"mmc-pom-business", (Object[])new Object[0]), materialNumber, oprNo, processSeq, configuredCodeNumber, orderBillno);
                errorCode = "pom.100015";
                return this.genReturnMap(errorString10, Boolean.FALSE, errorCode);
            }
            Map stockMap = (Map)stockList.get(0);
            Long stockEntryID = Long.parseLong(stockMap.get("entryid").toString());
            Long stockID = Long.parseLong(stockMap.get("id").toString());
            ListSelectedRow srcBil = new ListSelectedRow((Object)stockID);
            srcBil.setEntryEntityKey("stockentry");
            srcBil.setEntryPrimaryKeyValue((Object)stockEntryID);
            needPushRows.add(srcBil);
        }
        if (needPushRows.isEmpty()) {
            return this.genReturnMap("no push datas", Boolean.TRUE, "0");
        }
        PushArgs pushArgs = this.genPushArgs("pom_mftstock", "im_mdc_mftproorder", botpID);
        pushArgs.setSelectedRows(needPushRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"im_mdc_mftproorder");
        String targetBillNoStr = "";
        if (!pushResult.isSuccess()) {
            String errMessage = this.getErrByRes(pushResult);
            logger.info(String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u6e05\u5355\u751f\u6210\u751f\u4ea7\u9886\u6599\u5355\u5931\u8d25:%1$s", (String)"MftStockCreateMftProorderBusiness_18", (String)"mmc-pom-business", (Object[])new Object[0]), errMessage));
            throw new KDBizException(new ErrorCode("createMftProOrderBill", this.getErrByRes(pushResult)), new Object[0]);
        }
        List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        if (targetBillObjs.isEmpty()) {
            String errorString11 = ResManager.loadKDString((String)"\u751f\u4ea7\u9886\u6599\u5355\u672a\u751f\u6210\uff0c\u8bf7\u68c0\u67e5\u751f\u4ea7\u7ec4\u4ef6\u6e05\u5355\u751f\u6210\u751f\u4ea7\u9886\u6599\u5355\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"MftStockCreateMftProorderBusiness_09", (String)"mmc-pom-business", (Object[])new Object[0]);
            throw new KDBizException(new ErrorCode("createMftProOrderBill", errorString11), new Object[0]);
        }
        for (int i = 0; i < paramList.size(); ++i) {
            DynamicObject location;
            Long configuredCodeID2;
            String processSeq2;
            String oprNo2;
            Map<String, Object> listMap = paramList.get(i);
            String materialNumber = this.getMaterialNumber(listMap);
            Long materalID = (Long)materialMap.get(materialNumber);
            DynamicObject mftProOrderEntryDy = this.getMftProOrderEntry(targetBillObjs, materalID, oprNo2 = this.getOprNo(listMap), processSeq2 = this.getProcessSeq(listMap), configuredCodeID2 = this.getConfiguredCodeID(listMap));
            if (mftProOrderEntryDy == null) {
                String errorString12 = String.format(ResManager.loadKDString((String)"\u751f\u6210\u7684\u9886\u6599\u51fa\u5e93\u5355\u4e0d\u5b58\u5728\u7269\u6599\uff08%1$s\uff09\u3001\u5de5\u5e8f\u53f7\uff08%2$s\uff09\u3001\u987a\u5e8f\u53f7\uff08%3$s\uff09\u3001\u914d\u7f6e\u53f7\uff08%4$s\uff09\u3002", (String)"MftStockCreateMftProorderBusiness_10", (String)"mmc-pom-business", (Object[])new Object[0]), materialNumber, oprNo2, processSeq2, configuredCodeID2);
                throw new KDBizException(new ErrorCode("createMftProOrderBill", errorString12), new Object[0]);
            }
            BigDecimal outQtyNew = this.getOutQty(listMap);
            DynamicObject masterid = mftProOrderEntryDy.getDynamicObject("material").getDynamicObject("masterid");
            DynamicObject unit = mftProOrderEntryDy.getDynamicObject("unit");
            DynamicObject baseunit = mftProOrderEntryDy.getDynamicObject("baseunit");
            DynamicObject unit2nd = mftProOrderEntryDy.getDynamicObject("unit2nd");
            mftProOrderEntryDy.set("qty", (Object)this.getQtyByUnit(masterid, baseunit, unit, outQtyNew));
            mftProOrderEntryDy.set("baseqty", (Object)this.processPrecision(outQtyNew, baseunit));
            mftProOrderEntryDy.set("qtyunit2nd", (Object)this.getQtyByUnit(masterid, baseunit, unit2nd, outQtyNew));
            DynamicObject warehouse = this.getWarehouse(listMap);
            if (warehouse != null) {
                mftProOrderEntryDy.set("warehouse", (Object)warehouse);
                mftProOrderEntryDy.set("location", null);
            }
            if ((location = this.getLocation(listMap)) == null) continue;
            mftProOrderEntryDy.set("location", (Object)location);
        }
        OperateOption create = OperateOption.create();
        create.setVariableValue("ignorewarn", "true");
        create.setVariableValue("ignoreinteraction", "true");
        OperationResult saveOperate = SaveServiceHelper.saveOperate((String)"im_mdc_mftproorder", (DynamicObject[])targetBillObjs.toArray(new DynamicObject[targetBillObjs.size()]), (OperateOption)create);
        if (!saveOperate.isSuccess()) {
            throw new KDBizException(new ErrorCode("createMftProOrderBill", String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4fdd\u5b58\u751f\u4ea7\u9886\u6599\u5355\u51fa\u73b0\u5f02\u5e38\uff1a%1$s", (String)"MftStockCreateMftProorderBusiness_12", (String)"mmc-pom-business", (Object[])new Object[0]), this.getErrDetail(saveOperate))), new Object[0]);
        }
        targetBillNoStr = this.getTargetBillNoString(targetBillObjs);
        return this.genReturnMap(targetBillNoStr, Boolean.TRUE, "0");
    }

    private DynamicObject getMftProOrderEntry(List<DynamicObject> targetBillObjs, Long materalID, String oprNo, String processSeq, Long configuredcodeid) {
        for (DynamicObject targetBillObj : targetBillObjs) {
            DynamicObjectCollection coll = targetBillObj.getDynamicObjectCollection("billentry");
            for (int i = 0; i < coll.size(); ++i) {
                DynamicObject dy = (DynamicObject)coll.get(i);
                Long entryMaterialID = dy.getDynamicObject("material").getDynamicObject("masterid").getLong("id");
                if (!this.isLongEquals(materalID, entryMaterialID) || !this.isStrEquals(oprNo, dy.getString("oprno")) || !this.isStrEquals(processSeq, dy.getString("processseq")) || !this.isLongEquals(configuredcodeid, dy.getDynamicObject("configuredcode") == null ? 0L : dy.getDynamicObject("configuredcode").getLong("id"))) continue;
                return dy;
            }
        }
        return null;
    }
}

