/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.pom.business.orderrestructure;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bd.mpdm.business.helper.InvBillBotpHelper;
import kd.bd.mpdm.business.helper.MaterialInvInfoHelper;
import kd.bd.mpdm.business.helper.OrderSplitTechnicsHelper;
import kd.bd.mpdm.business.manuftech.OprUnitHelper;
import kd.bd.mpdm.business.mftorder.OrderSpliteService;
import kd.bd.mpdm.business.mftorder.StockCulUtils;
import kd.bd.mpdm.common.manuftech.utils.ManuftechCreateBillUtil;
import kd.bd.mpdm.common.mftorder.enums.PrecisionAccountEnum;
import kd.bd.mpdm.common.mftorder.helper.BillUnitAndQtytHelper;
import kd.bd.mpdm.common.mftorder.utils.CreateStockByBomUtils;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.mftorder.utils.OrderOpUtils;
import kd.bd.mpdm.common.query.helper.MaterialPlanQueryHelper;
import kd.bd.mpdm.common.utils.AuxQtyAndUnitHelper;
import kd.bd.mpdm.common.utils.UnitPrecisionUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.UnitConvertHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.mmc.pom.common.mftorder.utils.OrderUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class OrderRestructureService {
    private static Log logger = LogFactory.getLog(OrderRestructureService.class);

    public static List<DynamicObject> restructureBillPushOrderBills(List<DynamicObject> orderRestructureBills) {
        ArrayList<DynamicObject> newOrderBills = new ArrayList(10);
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("pom_restructurbill");
        pushArgs.setTargetEntityNumber("pom_mftorder");
        pushArgs.setHasRight(false);
        pushArgs.setRuleId("1475333867341664256");
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(10);
        for (DynamicObject orderRestructureBill : orderRestructureBills) {
            if (null == orderRestructureBill) continue;
            ListSelectedRow srcBill = new ListSelectedRow(orderRestructureBill.getPkValue());
            needPushRows.add(srcBill);
        }
        if (needPushRows.isEmpty()) {
            logger.info("\u5bf9\u5e94\u7684\u751f\u4ea7\u5de5\u5355\u6539\u5236\u7533\u8bf7\u5355\u6ca1\u6709\u9700\u8981\u4e0b\u63a8\u7684\u6570\u636e\u3002");
        }
        pushArgs.setSelectedRows(needPushRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        StringBuilder errMessage = new StringBuilder().append(pushResult.getMessage());
        for (SourceBillReport billReport : pushResult.getBillReports()) {
            errMessage.append(billReport.getFailMessage());
        }
        if (null != errMessage && !"null".equals(errMessage.toString()) && !"".equals(errMessage.toString())) {
            logger.info("\u4e0b\u63a8\u5931\u8d25:" + errMessage);
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"pom_mftorder");
        newOrderBills = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        return newOrderBills;
    }

    public static void deleteTempOrder(Set<Long> orderIds) {
        if (CollectionUtils.isNotEmpty(orderIds)) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            option.setVariableValue("ignorewarn", "true");
            option.setVariableValue("ignoreinteraction", "true");
            OperationResult executeOperate = OperationServiceHelper.executeOperate((String)"delete", (String)"pom_mftorder", (Object[])orderIds.toArray(new Long[orderIds.size()]), (OperateOption)option);
            if (!executeOperate.isSuccess()) {
                throw new KDBizException(new ErrorCode("OrderRestructureLoadInfoOp", String.format(ResManager.loadKDString((String)"\u5220\u9664\u4e34\u65f6\u5de5\u5355\u64cd\u4f5c\u5931\u8d25\uff1a%s\u3002", (String)"OrderRestructureService_0", (String)"mmc-pom-business", (Object[])new Object[0]), OrderOpUtils.getErrDetail((OperationResult)executeOperate))), new Object[0]);
            }
        }
    }

    public static void xmftorder(List<DynamicObject> srcOrderBills, List<DynamicObject> orderRestructureOrderBills, Set<Long> srcOrderEntryIds) {
        OrderRestructureService.genXmftorderBills(srcOrderBills, orderRestructureOrderBills, srcOrderEntryIds);
    }

    public static void xmftorderAfter(Set<Long> xmftorderBillIds) {
        OrderRestructureService.genXmftorderBillsAfter(xmftorderBillIds);
    }

    public static void genXmftorderBills(List<DynamicObject> srcOrderBills, List<DynamicObject> orderRestructureOrderBills, Set<Long> srcOrderEntryIds) {
        List<DynamicObject> xmftorderBills = OrderRestructureService.orderBillPushXorderBills(srcOrderBills, srcOrderEntryIds);
        OrderRestructureService.repackageXorderBills(xmftorderBills, orderRestructureOrderBills);
        if (CollectionUtils.isNotEmpty(xmftorderBills)) {
            SaveServiceHelper.save((DynamicObject[])xmftorderBills.toArray(new DynamicObject[0]));
            HashSet<Long> xmftorderBillIds = new HashSet<Long>(16);
            for (DynamicObject xmftorderBill : xmftorderBills) {
                xmftorderBillIds.add(xmftorderBill.getLong("id"));
            }
            OrderRestructureService.submitXmftorderBills(xmftorderBillIds, "submit", ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"OrderRestructureService_8", (String)"mmc-pom-business", (Object[])new Object[0]));
        }
    }

    public static void genXmftorderBillsAfter(Set<Long> xmftorderBillIds) {
        if (CollectionUtils.isNotEmpty(xmftorderBillIds)) {
            OrderRestructureService.auditXmftorderBills(xmftorderBillIds);
        }
    }

    public static void submitXmftorderBills(Set<Long> xmftorderBillIds, String op, String opName) {
        if (CollectionUtils.isNotEmpty(xmftorderBillIds)) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            option.setVariableValue("ignorewarn", "true");
            option.setVariableValue("ignoreinteraction", "true");
            OperationResult submitResult = OperationServiceHelper.executeOperate((String)op, (String)"pom_xmftorder", (Object[])xmftorderBillIds.toArray(), (OperateOption)option);
            if (!submitResult.isSuccess()) {
                throw new KDBizException(new ErrorCode("submitXmftorderBills", String.format(ResManager.loadKDString((String)"\u8c03\u7528\u53d8\u66f4\u5355%1$s\u64cd\u4f5c\u5931\u8d25\uff1a%2$s", (String)"OrderRestructureService_9", (String)"mmc-pom-business", (Object[])new Object[0]), opName, OrderOpUtils.getErrDetail((OperationResult)submitResult))), new Object[0]);
            }
        }
    }

    public static void auditXmftorderBills(Set<Long> xmftorderBillIds) {
        if (CollectionUtils.isNotEmpty(xmftorderBillIds)) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            option.setVariableValue("ignorewarn", "true");
            option.setVariableValue("ignoreinteraction", "true");
            OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"pom_xmftorder", (Object[])xmftorderBillIds.toArray(), (OperateOption)option);
            if (!auditResult.isSuccess()) {
                throw new KDBizException(new ErrorCode("submitXmftorderBills", String.format(ResManager.loadKDString((String)"\u8c03\u7528\u53d8\u66f4\u5355\u5ba1\u6838\u64cd\u4f5c\u5931\u8d25\uff1a%s", (String)"OrderRestructureService_3", (String)"mmc-pom-business", (Object[])new Object[0]), OrderOpUtils.getErrDetail((OperationResult)auditResult))), new Object[0]);
            }
        }
    }

    public static List<DynamicObject> repackageXorderBills(List<DynamicObject> xorderBills, List<DynamicObject> orderRestructureOrderBills) {
        ArrayList<DynamicObject> newXorderBills = new ArrayList<DynamicObject>(10);
        for (DynamicObject xorderBill : xorderBills) {
            OrderUtils.updatePID((DynamicObject)xorderBill);
            xorderBill.set("reason", (Object)ResManager.loadKDString((String)"\u5de5\u5355\u6539\u5236\u53d8\u66f4", (String)"OrderRestructureService_4", (String)"mmc-pom-business", (Object[])new Object[0]));
            OrderRestructureService.genOrderBillNo(xorderBill, "pom_xmftorder");
            DynamicObjectCollection xorderBillEntrys = xorderBill.getDynamicObjectCollection("treeentryentity");
            HashMap xorderEntryMap = new HashMap(16);
            for (DynamicObject xorderBillEntry : xorderBillEntrys) {
                BigDecimal repminqty;
                BigDecimal repmaxqty;
                BigDecimal inwarmin;
                BigDecimal inwarmax;
                HashMap<String, BigDecimal> temp;
                String producttype = xorderBillEntry.getString("producttype");
                if (StringUtils.equals((String)"C", (String)producttype)) {
                    String srcbillentryid = xorderBillEntry.getString("srcbillentryid");
                    DynamicObject orderRestructureOrderBill = OrderRestructureService.matchorderRestructureOrderBill(Long.parseLong(srcbillentryid), orderRestructureOrderBills);
                    if (null != orderRestructureOrderBill) {
                        xorderBill.set("id", (Object)orderRestructureOrderBill.getLong("pbxorderid"));
                        temp = new HashMap<String, BigDecimal>(16);
                        BigDecimal afterQty = xorderBillEntry.getBigDecimal("qty").subtract(orderRestructureOrderBill.getBigDecimal("pbrestructurqty"));
                        xorderBillEntry.set("qty", (Object)afterQty);
                        DynamicObject material = xorderBillEntry.getDynamicObject("material").getDynamicObject("masterid");
                        DynamicObject unit = xorderBillEntry.getDynamicObject("unit");
                        DynamicObject baseUnit = xorderBillEntry.getDynamicObject("baseunit");
                        DynamicObject auxptyUnit = xorderBillEntry.getDynamicObject("auxptyunit");
                        BigDecimal afterBaseQty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)unit, (BigDecimal)afterQty, (DynamicObject)baseUnit);
                        temp.put("baseqty", xorderBillEntry.getBigDecimal("baseqty"));
                        xorderBillEntry.set("baseqty", (Object)afterBaseQty);
                        AuxQtyAndUnitHelper.changeUntAndQty((DynamicObject)xorderBillEntry, (DynamicObject)material, (DynamicObject)auxptyUnit, (String)"baseqty", (String)"baseunit", (String)"auxptyqty");
                        temp.put("afterBaseQty", afterBaseQty);
                        xorderEntryMap.put(xorderBillEntry.getLong("id"), temp);
                    }
                } else {
                    long pid = xorderBillEntry.getLong("pid");
                    temp = (HashMap<String, BigDecimal>)xorderEntryMap.get(pid);
                    if (null != temp) {
                        BigDecimal baseqtyMain = (BigDecimal)temp.get("baseqty");
                        BigDecimal afterBaseQtyMain = (BigDecimal)temp.get("afterBaseQty");
                        if (null != afterBaseQtyMain && null != baseqtyMain && baseqtyMain.compareTo(BigDecimal.ZERO) > 0) {
                            BigDecimal afterBaseQty;
                            DynamicObject material = xorderBillEntry.getDynamicObject("material").getDynamicObject("masterid");
                            DynamicObject unit = xorderBillEntry.getDynamicObject("unit");
                            DynamicObject baseUnit = xorderBillEntry.getDynamicObject("baseunit");
                            DynamicObject auxptyUnit = xorderBillEntry.getDynamicObject("auxptyunit");
                            BigDecimal baseqty = xorderBillEntry.getBigDecimal("baseqty");
                            BigDecimal bigDecimal = afterBaseQty = null == baseqty ? BigDecimal.ZERO : baseqty;
                            if (null != baseqty && null != baseUnit) {
                                afterBaseQty = baseqty.multiply(afterBaseQtyMain.divide(baseqtyMain, baseUnit.getInt("precision"), PrecisionAccountEnum.getEnumByVal((int)Integer.parseInt(baseUnit.getString("precisionaccount")))));
                            }
                            xorderBillEntry.set("baseqty", (Object)afterBaseQty);
                            BigDecimal afterQty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)baseUnit, (BigDecimal)afterBaseQty, (DynamicObject)unit);
                            xorderBillEntry.set("qty", (Object)afterQty);
                            AuxQtyAndUnitHelper.changeUntAndQty((DynamicObject)xorderBillEntry, (DynamicObject)material, (DynamicObject)auxptyUnit, (String)"baseqty", (String)"baseunit", (String)"auxptyqty");
                        }
                    }
                }
                DynamicObject org = xorderBill.getDynamicObject("org");
                DynamicObject unit = xorderBillEntry.getDynamicObject("unit");
                DynamicObject baseUnit = xorderBillEntry.getDynamicObject("baseunit");
                BigDecimal baseQty = xorderBillEntry.getBigDecimal("baseqty");
                BigDecimal qty = xorderBillEntry.getBigDecimal("qty");
                BigDecimal estscrapqty = OrderSpliteService.calEstscrapqty((DynamicObject)xorderBillEntry, (DynamicObject)org);
                xorderBillEntry.set("estscrapqty", (Object)estscrapqty);
                BigDecimal highlimit = xorderBillEntry.getBigDecimal("rcvinhighlimit");
                BigDecimal bigDecimal = inwarmax = null == baseQty ? BigDecimal.ZERO : baseQty;
                if (null != baseQty && null != baseUnit && null != highlimit) {
                    inwarmax = baseQty.multiply(BigDecimal.ONE.add(highlimit.divide(BigDecimal.valueOf(100L), baseUnit.getInt("precision"), UnitPrecisionUtils.getPrecisionDeal((String)baseUnit.getString("precisionaccount")))));
                }
                xorderBillEntry.set("inwarmax", (Object)inwarmax);
                BigDecimal rcvinlowlimit = xorderBillEntry.getBigDecimal("rcvinlowlimit");
                BigDecimal bigDecimal2 = inwarmin = null == baseQty ? BigDecimal.ZERO : baseQty;
                if (null != baseQty && null != baseUnit && null != rcvinlowlimit) {
                    inwarmin = baseQty.multiply(BigDecimal.ONE.subtract(rcvinlowlimit.divide(BigDecimal.valueOf(100L), baseUnit.getInt("precision"), UnitPrecisionUtils.getPrecisionDeal((String)baseUnit.getString("precisionaccount")))));
                }
                xorderBillEntry.set("inwarmin", (Object)inwarmin);
                BigDecimal repmaxrate = xorderBillEntry.getBigDecimal("repmaxrate");
                BigDecimal bigDecimal3 = repmaxqty = null == qty ? BigDecimal.ZERO : qty;
                if (null != qty && null != unit && null != repmaxrate) {
                    repmaxqty = qty.multiply(BigDecimal.ONE.add(repmaxrate.divide(BigDecimal.valueOf(100L), unit.getInt("precision"), UnitPrecisionUtils.getPrecisionDeal((String)unit.getString("precisionaccount")))));
                }
                xorderBillEntry.set("repmaxqty", (Object)repmaxqty);
                BigDecimal repminrate = xorderBillEntry.getBigDecimal("repminrate");
                BigDecimal bigDecimal4 = repminqty = null == qty ? BigDecimal.ZERO : qty;
                if (null != qty && null != unit && null != repminrate) {
                    repminqty = qty.multiply(BigDecimal.ONE.subtract(repminrate.divide(BigDecimal.valueOf(100L), unit.getInt("precision"), UnitPrecisionUtils.getPrecisionDeal((String)unit.getString("precisionaccount")))));
                }
                xorderBillEntry.set("repminqty", (Object)repminqty);
            }
        }
        return newXorderBills;
    }

    public static DynamicObject matchorderRestructureOrderBill(Long srcOrderEntryId, List<DynamicObject> orderRestructureOrderBills) {
        DynamicObject result = null;
        for (DynamicObject orderRestructureOrderBill : orderRestructureOrderBills) {
            Long pborderentryid;
            DynamicObject pborderentryObj = orderRestructureOrderBill.getDynamicObject("pborderentryid");
            if (null == pborderentryObj || !srcOrderEntryId.equals(pborderentryid = Long.valueOf(pborderentryObj.getLong("id")))) continue;
            result = orderRestructureOrderBill;
            break;
        }
        return result;
    }

    public static DynamicObject matchorderRestructureOrderBillByPAorderEntryId(Long restructIdInOrderEntry, List<DynamicObject> orderRestructureOrderBills) {
        DynamicObject result = null;
        for (DynamicObject orderRestructureOrderBill : orderRestructureOrderBills) {
            Long restructBillId = orderRestructureOrderBill.getLong("id");
            if (!restructBillId.equals(restructIdInOrderEntry)) continue;
            result = orderRestructureOrderBill;
            break;
        }
        return result;
    }

    public static List<DynamicObject> orderBillPushXorderBills(List<DynamicObject> orderBills, Set<Long> srcOrderEntryIds) {
        ArrayList<DynamicObject> newOrderBills = new ArrayList(10);
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("pom_mftorder");
        pushArgs.setTargetEntityNumber("pom_xmftorder");
        pushArgs.setHasRight(false);
        pushArgs.setRuleId("950622056301679616");
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(10);
        for (DynamicObject mftorderBill : orderBills) {
            if (null == mftorderBill) continue;
            DynamicObjectCollection entrys = mftorderBill.getDynamicObjectCollection("treeentryentity");
            Iterator iterator = entrys.iterator();
            while (iterator.hasNext()) {
                DynamicObject entry = (DynamicObject)iterator.next();
                long entryId = entry.getLong("id");
                long entryPId = entry.getLong("pid");
                if (!srcOrderEntryIds.contains(entryId) && !srcOrderEntryIds.contains(entryPId)) continue;
                ListSelectedRow srcBill = new ListSelectedRow(mftorderBill.getPkValue());
                srcBill.setEntryEntityKey("treeentryentity");
                srcBill.setEntryPrimaryKeyValue((Object)entryId);
                needPushRows.add(srcBill);
            }
        }
        if (needPushRows.isEmpty()) {
            logger.info("\u5bf9\u5e94\u7684\u751f\u4ea7\u5de5\u5355\u6ca1\u6709\u9700\u8981\u4e0b\u63a8\u7684\u6570\u636e\u3002");
        }
        pushArgs.setSelectedRows(needPushRows);
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        StringBuilder errMessage = new StringBuilder().append(pushResult.getMessage());
        for (SourceBillReport billReport : pushResult.getBillReports()) {
            errMessage.append(billReport.getFailMessage());
        }
        if (null != errMessage && !"null".equals(errMessage.toString()) && !"".equals(errMessage.toString())) {
            throw new KDBizException(new ErrorCode("orderBillPushXorderBills", String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a\u751f\u4ea7\u5de5\u5355\u4e0b\u63a8\u53d8\u66f4\u5355%1$s", (String)"OrderRestructureService_5", (String)"mmc-pom-business", (Object[])new Object[0]), errMessage)), new Object[0]);
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"pom_xmftorder");
        newOrderBills = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
        return newOrderBills;
    }

    @Deprecated
    public static void addOrderStockEntrys(List<DynamicObject> orderRestructureOrderBills, Set<Long> srcOrderEntryIds, Set<Long> stockIds, Map<Long, Map<Long, DynamicObject>> res) {
    }

    public static void addOrderStockEntrysNew(List<DynamicObject> orderRestructureOrderBills, Set<Long> srcOrderEntryIds, Set<Long> stockIds, Map<Long, Map<Long, DynamicObject>> res, Map<Long, DynamicObject> resEntryIdAndStockEntryMap, Map<Long, DynamicObject> scrapEntryIdAndStockEntryMap) {
        DynamicObject orderRestructureOrderBill;
        DynamicObject orderentryDyn;
        ArrayList<Long> allOrderEntryIds = new ArrayList<Long>(10);
        allOrderEntryIds.addAll(srcOrderEntryIds);
        String stockEntityId = "pom_mftstock";
        DynamicObject[] stockBills = BusinessDataServiceHelper.load((String)stockEntityId, (String)(StockCulUtils.selectStockProperties((String)"pom_mftstock") + ",stockentry.seq"), (QFilter[])new QFilter[]{new QFilter("orderentryid", "in", allOrderEntryIds)});
        DynamicObject[] afterStockBills = BusinessDataServiceHelper.load((String)stockEntityId, (String)(StockCulUtils.selectStockProperties((String)"pom_mftstock") + ",stockentry.seq"), (QFilter[])new QFilter[]{new QFilter("id", "in", stockIds)});
        Date now = new Date();
        for (DynamicObject beforeStockBill : stockBills) {
            orderentryDyn = beforeStockBill.getDynamicObject("orderentryid");
            if (null == orderentryDyn) continue;
            Long srcOrderEntryId = orderentryDyn.getLong("id");
            orderRestructureOrderBill = OrderRestructureService.matchorderRestructureOrderBill(srcOrderEntryId, orderRestructureOrderBills);
            OrderRestructureService.repackageReStock(beforeStockBill, orderRestructureOrderBill, res, now, true, resEntryIdAndStockEntryMap);
            OrderRestructureService.repackageScrapStockPage(beforeStockBill, orderRestructureOrderBill, res, now, true, scrapEntryIdAndStockEntryMap);
        }
        for (DynamicObject afterStockBill : afterStockBills) {
            orderentryDyn = afterStockBill.getDynamicObject("orderentryid");
            if (null == orderentryDyn) continue;
            DynamicObjectCollection stockentry = afterStockBill.getDynamicObjectCollection("stockentry");
            stockentry.clear();
            orderRestructureOrderBill = OrderRestructureService.matchorderRestructureOrderBillByPAorderEntryId(orderentryDyn.getLong("sourceentryseq"), orderRestructureOrderBills);
            OrderRestructureService.repackageMrqStockPage(afterStockBill, orderRestructureOrderBill, res, now);
        }
        SaveServiceHelper.save((DynamicObject[])stockBills);
        SaveServiceHelper.save((DynamicObject[])afterStockBills);
    }

    public static void addInvStockEntrys(List<DynamicObject> orderRestructureInvBills, Set<Long> stockIds, Map<Long, Map<Long, DynamicObject>> res) {
        DynamicObject[] stockBills;
        String stockEntityId = "pom_mftstock";
        for (DynamicObject afterStockBill : stockBills = BusinessDataServiceHelper.load((String)stockEntityId, (String)(StockCulUtils.selectStockProperties((String)"pom_mftstock") + ",stockentry.seq"), (QFilter[])new QFilter[]{new QFilter("id", "in", stockIds)})) {
            DynamicObject orderentryDyn = afterStockBill.getDynamicObject("orderentryid");
            if (null == orderentryDyn) continue;
            DynamicObject orderRestructureOrderBill = OrderRestructureService.matchorderRestructureOrderBillByPAorderEntryId(orderentryDyn.getLong("sourceentryseq"), orderRestructureInvBills);
            DynamicObjectCollection stockentry = afterStockBill.getDynamicObjectCollection("stockentry");
            stockentry.clear();
            Date now = new Date();
            OrderRestructureService.repackageReStock(afterStockBill, orderRestructureOrderBill, res, now, false, null);
            OrderRestructureService.repackageScrapStockPage(afterStockBill, orderRestructureOrderBill, res, now, false, null);
            OrderRestructureService.repackageMrqStockPage(afterStockBill, orderRestructureOrderBill, res, now);
        }
        SaveServiceHelper.save((DynamicObject[])stockBills);
    }

    private static void repackageReStock(DynamicObject stockBill, DynamicObject orderRestructureOrderBill, Map<Long, Map<Long, DynamicObject>> res, Date now, boolean checkExistInStockEntryFlag, Map<Long, DynamicObject> resEntryIdAndStockEntryMap) {
        if (null != stockBill && null != orderRestructureOrderBill) {
            DynamicObjectCollection stockentry = stockBill.getDynamicObjectCollection("stockentry");
            DynamicObject orderentryidDyn = stockBill.getDynamicObject("orderentryid");
            Date planbegintime = orderentryidDyn.getDate("planbegintime");
            Date planendtime = orderentryidDyn.getDate("planendtime");
            DynamicObject org = stockBill.getDynamicObject("org");
            DynamicObjectCollection restockpage = orderRestructureOrderBill.getDynamicObjectCollection("retstockentry");
            int seq = stockentry.size();
            for (DynamicObject restock : restockpage) {
                DynamicObject matchStockEntry;
                DynamicObject retMftMaterial = restock.getDynamicObject("retmftmaterial");
                String oprparent = restock.getString("retoprparent");
                String oprno = restock.getString("retoprno");
                DynamicObject retconfiguredcode = restock.getDynamicObject("retconfiguredcode");
                if (checkExistInStockEntryFlag && null != (matchStockEntry = OrderRestructureService.checkExistInStockEntry(stockentry, retMftMaterial, oprparent, oprno, retconfiguredcode))) {
                    resEntryIdAndStockEntryMap.put(restock.getLong("id"), matchStockEntry);
                    continue;
                }
                DynamicObject newStockEntry = stockentry.addNew();
                newStockEntry.set("seq", (Object)(++seq));
                OrderRestructureService.restructOrderToStockEntryRE(stockBill, newStockEntry, orderRestructureOrderBill, restock);
                DynamicObject material = newStockEntry.getDynamicObject("materialid");
                DynamicObject supply = newStockEntry.getDynamicObject("supplyorgid");
                if (material != null && supply != null && material.getDynamicObject("masterid") != null) {
                    DynamicObject masterid = material.getDynamicObject("masterid");
                    Long orgId = (Long)supply.getPkValue();
                    Long masterId = (Long)masterid.getPkValue();
                    newStockEntry.set("materielinv", (Object)MaterialInvInfoHelper.getMaterialByRes(res, (Long)orgId, (Long)masterId));
                }
                newStockEntry.set("leadtime", (Object)BigDecimal.ZERO);
                newStockEntry.set("demanddate", CreateStockByBomUtils.getDemandDate((DynamicObject)org, (Date)planbegintime, (DynamicObject)newStockEntry, (Date)planendtime));
                newStockEntry.set("sourcetype", (Object)"B");
            }
        }
    }

    private static void repackageTechToEntryEntity(DynamicObject techBill, DynamicObject orderRestructureOrderBill, DynamicObject orderEntry, DynamicObject processRoute) {
        if (null != techBill && null != orderRestructureOrderBill) {
            DynamicObjectCollection proentryentity = techBill.getDynamicObjectCollection("proentryentity");
            if (proentryentity.size() == 0) {
                DynamicObject newTechOprEntry = proentryentity.addNew();
                newTechOprEntry.set("processseq", (Object)"1");
                newTechOprEntry.set("processseqname", (Object)ResManager.loadKDString((String)"\u4e3b\u5e8f\u5217", (String)"OrderRestructureService_7", (String)"mmc-pom-business", (Object[])new Object[0]));
                newTechOprEntry.set("processseqtype", (Object)"A");
                newTechOprEntry.set("processseqqty", (Object)techBill.getBigDecimal("baseqty"));
                newTechOprEntry.set("processplanbegintime", techBill.get("planstarttime"));
                newTechOprEntry.set("processplanendtime", techBill.get("planfinishtime"));
            }
            DynamicObjectCollection techOprEntry = techBill.getDynamicObjectCollection("oprentryentity");
            techOprEntry.clear();
            DynamicObjectCollection toentryentity = orderRestructureOrderBill.getDynamicObjectCollection("toentryentity");
            ArrayList<String> oprparentList = new ArrayList<String>(16);
            for (DynamicObject techToEntry : toentryentity) {
                DynamicObject newTechOprEntry;
                int seq;
                String tochangetype = techToEntry.getString("tochangetype");
                if (StringUtils.equals((String)"B", (String)tochangetype)) {
                    seq = techOprEntry.size();
                    newTechOprEntry = techOprEntry.addNew();
                    newTechOprEntry.set("seq", (Object)(++seq));
                    OrderRestructureService.restructTechToEntryEntity(techBill, newTechOprEntry, orderRestructureOrderBill, techToEntry, orderEntry, processRoute);
                    oprparentList.add(newTechOprEntry.getString("oprparent"));
                }
                if (!StringUtils.equals((String)"", (String)tochangetype)) continue;
                seq = techOprEntry.size();
                newTechOprEntry = techOprEntry.addNew();
                newTechOprEntry.set("seq", (Object)(++seq));
                OrderRestructureService.restructTechToEntryByRoute(techBill, newTechOprEntry, orderRestructureOrderBill, techToEntry, orderEntry, processRoute);
                oprparentList.add(newTechOprEntry.getString("oprparent"));
            }
            ArrayList<DynamicObject> newTechOprEntryList = new ArrayList<DynamicObject>(16);
            for (DynamicObject entryentity : proentryentity) {
                if (oprparentList.contains(entryentity.getString("processseq"))) continue;
                newTechOprEntryList.add(entryentity);
            }
            if (!newTechOprEntryList.isEmpty()) {
                proentryentity.removeAll(newTechOprEntryList);
            }
        }
    }

    private static void restructTechToEntryEntity(DynamicObject techBill, DynamicObject newTechOprEntry, DynamicObject orderRestructureOrderBill, DynamicObject techToEntry, DynamicObject orderEntry, DynamicObject processRouteObj) {
        newTechOprEntry.set("oprno", techToEntry.get("tooprno"));
        newTechOprEntry.set("oprparent", techToEntry.get("tooprparent"));
        newTechOprEntry.set("oprorg", techToEntry.get("tooprorg"));
        newTechOprEntry.set("oprworkcenter", techToEntry.get("tooprworkcenter"));
        newTechOprEntry.set("oprworkshop", techToEntry.get("tooprworkshop"));
        newTechOprEntry.set("oproperation", techToEntry.get("tooproperation"));
        newTechOprEntry.set("oprdescription", techToEntry.get("tooprdescription"));
        newTechOprEntry.set("oprctrlstrategy", techToEntry.get("tooprctrlstrategy"));
        newTechOprEntry.set("machiningtype", techToEntry.get("tomachiningtype"));
        newTechOprEntry.set("oprunit", techToEntry.get("tooprunit"));
        newTechOprEntry.set("headunit", techBill.get("baseunit"));
        DynamicObject entryObj = null;
        if (null != processRouteObj) {
            for (DynamicObject entry : processRouteObj.getDynamicObjectCollection("processentry")) {
                if (!entry.getString("parent").equals(techToEntry.getString("tooprparent")) || !entry.getString("operationno").equals(techToEntry.get("tooprno"))) continue;
                entryObj = entry;
                break;
            }
        }
        if (null != entryObj) {
            newTechOprEntry.set("upperratio", (Object)entryObj.getBigDecimal("upperratio"));
            newTechOprEntry.set("floorratio", (Object)entryObj.getBigDecimal("floorratio"));
            BigDecimal divide = entryObj.getBigDecimal("upperratio").divide(new BigDecimal("100"), 10, 4);
            newTechOprEntry.set("upperqty", (Object)divide.add(BigDecimal.ONE).multiply(newTechOprEntry.getBigDecimal("oprqty")));
            BigDecimal decimal = entryObj.getBigDecimal("floorratio").divide(new BigDecimal("100"), 10, 4);
            newTechOprEntry.set("floorqty", (Object)BigDecimal.ONE.subtract(decimal).multiply(newTechOprEntry.getBigDecimal("oprqty")));
            newTechOprEntry.set("basebatchqty", (Object)entryObj.getBigDecimal("basebatchqty"));
            newTechOprEntry.set("headqty", (Object)entryObj.getBigDecimal("headqty"));
            newTechOprEntry.set("headunit", (Object)entryObj.getDynamicObject("headunit"));
            newTechOprEntry.set("operationqty", (Object)entryObj.getBigDecimal("operationqty"));
            if ("1002".equals(newTechOprEntry.getString("machiningtype"))) {
                newTechOprEntry.set("purchaseorg", (Object)entryObj.getDynamicObject("purchaseorg"));
            }
            newTechOprEntry.set("purchasegroup", (Object)entryObj.getDynamicObject("purchasegroup"));
            newTechOprEntry.set("purchaseperson", (Object)entryObj.getDynamicObject("purchaseperson"));
            newTechOprEntry.set("purchaser", (Object)entryObj.getDynamicObject("purchaser"));
            newTechOprEntry.set("supplier", (Object)entryObj.getDynamicObject("supplier"));
            newTechOprEntry.set("currencyfield", (Object)entryObj.getDynamicObject("currencyfield"));
            newTechOprEntry.set("taxrate", (Object)entryObj.getDynamicObject("taxrate"));
            newTechOprEntry.set("taxprice", (Object)entryObj.getString("taxprice"));
            newTechOprEntry.set("price", (Object)entryObj.getString("price"));
            newTechOprEntry.set("settlementunit", (Object)entryObj.getDynamicObject("settlementunit"));
            newTechOprEntry.set("settlementcoefficient", (Object)entryObj.getString("settlementcoefficient"));
            newTechOprEntry.set("oprsourceentryid", entryObj.getPkValue());
            newTechOprEntry.set("ismilestoneprocess", entryObj.get("ismilestoneprocess"));
        } else {
            newTechOprEntry.set("upperratio", (Object)BigDecimal.ZERO);
            newTechOprEntry.set("floorratio", (Object)BigDecimal.ZERO);
            newTechOprEntry.set("basebatchqty", (Object)BigDecimal.ONE);
            newTechOprEntry.set("headqty", (Object)BigDecimal.ONE);
            newTechOprEntry.set("operationqty", (Object)BigDecimal.ONE);
            newTechOprEntry.set("settlementcoefficient", (Object)BigDecimal.ONE);
            newTechOprEntry.set("currencyfield", (Object)1L);
            newTechOprEntry.set("upperqty", (Object)newTechOprEntry.getBigDecimal("oprqty"));
            newTechOprEntry.set("floorqty", (Object)newTechOprEntry.getBigDecimal("oprqty"));
        }
        ManuftechCreateBillUtil.recalculateEntryQty((DynamicObject)newTechOprEntry, (DynamicObject)orderEntry);
        OrderRestructureService.setActSubEntryEntityValue(orderEntry, newTechOprEntry);
        newTechOprEntry.set("oprplanbegintime", orderEntry.get("planbegintime"));
        newTechOprEntry.set("oprplanfinishtime", orderEntry.get("planendtime"));
        newTechOprEntry.set("oprtotalsplitqty", (Object)BigDecimal.ZERO);
        newTechOprEntry.set("oprtotalsplitbaseqty", (Object)BigDecimal.ZERO);
        newTechOprEntry.set("oprstatus", (Object)"A");
        String oprsourcetype = "";
        String tochangetype = techToEntry.getString("tochangetype");
        if (StringUtils.equals((String)"B", (String)tochangetype)) {
            oprsourcetype = "B";
        }
        if (StringUtils.equals((String)"", (String)tochangetype)) {
            oprsourcetype = "A";
        }
        newTechOprEntry.set("oprsourcetype", (Object)oprsourcetype);
        newTechOprEntry.set("collaborative", (Object)false);
        newTechOprEntry.set("oprinvalid", (Object)false);
        newTechOprEntry.set("storagepoint", techToEntry.get("tostoragepoint"));
        newTechOprEntry.set("inspectiontype", techToEntry.get("toinspectiontype"));
    }

    public static void setActSubEntryEntityValue(DynamicObject orderEntryObj, DynamicObject newTechOprEntry) {
        if (null != newTechOprEntry) {
            DynamicObject workCenter = newTechOprEntry.getDynamicObject("oprworkcenter");
            workCenter = BusinessDataServiceHelper.loadSingleFromCache((Object)(workCenter == null ? Long.valueOf(0L) : workCenter.getPkValue()), (String)"mpdm_workcentre", (String)"id,entryresouce,entryresouce.resource,processactivetable,processactivetable.processnumber,processactivetable.processqty,processactivetable.activeformula,processactivetable.reportformula,processactivetable.processunit");
            DynamicObjectCollection reEntrys = workCenter.getDynamicObjectCollection("entryresouce");
            DynamicObjectCollection acEntrys = workCenter.getDynamicObjectCollection("processactivetable");
            if (acEntrys.size() != 0) {
                for (int x = 0; x < acEntrys.size(); ++x) {
                    DynamicObject acEntry = (DynamicObject)acEntrys.get(x);
                    if (null == acEntry.getDynamicObject("processnumber")) continue;
                    if (reEntrys.size() == 0) {
                        DynamicObject newSubEntryObj = newTechOprEntry.getDynamicObjectCollection("actsubentryentity").addNew();
                        OrderRestructureService.setActsubentryentity(acEntry, newSubEntryObj, orderEntryObj);
                        continue;
                    }
                    for (int y = 0; y < reEntrys.size(); ++y) {
                        DynamicObject reEntry = (DynamicObject)reEntrys.get(y);
                        DynamicObject newSubEntryObj = newTechOprEntry.getDynamicObjectCollection("actsubentryentity").addNew();
                        OrderRestructureService.setActsubentryentity(acEntry, newSubEntryObj, orderEntryObj);
                        newSubEntryObj.set("actresources", reEntry.get("resource"));
                    }
                }
            }
        }
    }

    private static void restructTechToEntryByRoute(DynamicObject techBill, DynamicObject newTechOprEntry, DynamicObject orderRestructureOrderBill, DynamicObject techToEntry, DynamicObject orderEntry, DynamicObject processRouteObj) {
        newTechOprEntry.set("oprno", techToEntry.get("tooprno"));
        newTechOprEntry.set("oprparent", techToEntry.get("tooprparent"));
        newTechOprEntry.set("oprorg", techToEntry.get("tooprorg"));
        newTechOprEntry.set("oprworkcenter", techToEntry.get("tooprworkcenter"));
        newTechOprEntry.set("workstation", techToEntry.get("workstation"));
        newTechOprEntry.set("oprworkshop", techToEntry.get("tooprworkshop"));
        newTechOprEntry.set("oproperation", techToEntry.get("tooproperation"));
        newTechOprEntry.set("oprdescription", techToEntry.get("tooprdescription"));
        newTechOprEntry.set("oprctrlstrategy", techToEntry.get("tooprctrlstrategy"));
        newTechOprEntry.set("machiningtype", techToEntry.get("tomachiningtype"));
        newTechOprEntry.set("oprunit", techToEntry.get("tooprunit"));
        newTechOprEntry.set("headunit", techBill.get("baseunit"));
        DynamicObject entryObj = null;
        if (null != processRouteObj) {
            for (DynamicObject entry : processRouteObj.getDynamicObjectCollection("processentry")) {
                if (!entry.getString("parent").equals(techToEntry.getString("tooprparent")) || !entry.getString("operationno").equals(techToEntry.get("tooprno"))) continue;
                entryObj = entry;
                break;
            }
        }
        if (null != entryObj) {
            newTechOprEntry.set("upperratio", (Object)entryObj.getBigDecimal("upperratio"));
            newTechOprEntry.set("floorratio", (Object)entryObj.getBigDecimal("floorratio"));
            BigDecimal divide = entryObj.getBigDecimal("upperratio").divide(new BigDecimal("100"), 10, 4);
            newTechOprEntry.set("upperqty", (Object)divide.add(BigDecimal.ONE).multiply(newTechOprEntry.getBigDecimal("oprqty")));
            BigDecimal decimal = entryObj.getBigDecimal("floorratio").divide(new BigDecimal("100"), 10, 4);
            newTechOprEntry.set("floorqty", (Object)BigDecimal.ONE.subtract(decimal).multiply(newTechOprEntry.getBigDecimal("oprqty")));
            newTechOprEntry.set("basebatchqty", (Object)entryObj.getBigDecimal("basebatchqty"));
            newTechOprEntry.set("headqty", (Object)entryObj.getBigDecimal("headqty"));
            newTechOprEntry.set("headunit", (Object)entryObj.getDynamicObject("headunit"));
            newTechOprEntry.set("operationqty", (Object)entryObj.getBigDecimal("operationqty"));
            if ("1002".equals(newTechOprEntry.getString("machiningtype"))) {
                newTechOprEntry.set("purchaseorg", (Object)entryObj.getDynamicObject("purchaseorg"));
            }
            newTechOprEntry.set("purchasegroup", (Object)entryObj.getDynamicObject("purchasegroup"));
            newTechOprEntry.set("purchaseperson", (Object)entryObj.getDynamicObject("purchaseperson"));
            newTechOprEntry.set("purchaser", (Object)entryObj.getDynamicObject("purchaser"));
            newTechOprEntry.set("supplier", (Object)entryObj.getDynamicObject("supplier"));
            newTechOprEntry.set("currencyfield", (Object)entryObj.getDynamicObject("currencyfield"));
            newTechOprEntry.set("taxrate", (Object)entryObj.getDynamicObject("taxrate"));
            newTechOprEntry.set("taxprice", (Object)entryObj.getString("taxprice"));
            newTechOprEntry.set("price", (Object)entryObj.getString("price"));
            newTechOprEntry.set("settlementunit", (Object)entryObj.getDynamicObject("settlementunit"));
            newTechOprEntry.set("settlementcoefficient", (Object)entryObj.getString("settlementcoefficient"));
            newTechOprEntry.set("oprsourceentryid", entryObj.getPkValue());
            newTechOprEntry.set("ismilestoneprocess", entryObj.get("ismilestoneprocess"));
        } else {
            newTechOprEntry.set("upperratio", (Object)BigDecimal.ZERO);
            newTechOprEntry.set("floorratio", (Object)BigDecimal.ZERO);
            newTechOprEntry.set("basebatchqty", (Object)BigDecimal.ONE);
            newTechOprEntry.set("headqty", (Object)BigDecimal.ONE);
            newTechOprEntry.set("operationqty", (Object)BigDecimal.ONE);
            newTechOprEntry.set("settlementcoefficient", (Object)BigDecimal.ONE);
            newTechOprEntry.set("currencyfield", (Object)1L);
            newTechOprEntry.set("upperqty", (Object)newTechOprEntry.getBigDecimal("oprqty"));
            newTechOprEntry.set("floorqty", (Object)newTechOprEntry.getBigDecimal("oprqty"));
        }
        ManuftechCreateBillUtil.recalculateEntryQty((DynamicObject)newTechOprEntry, (DynamicObject)orderEntry);
        String oprsourcetype = "";
        String tochangetype = techToEntry.getString("tochangetype");
        if (StringUtils.equals((String)"B", (String)tochangetype)) {
            oprsourcetype = "B";
        }
        if (StringUtils.equals((String)"", (String)tochangetype)) {
            oprsourcetype = "A";
        }
        newTechOprEntry.set("oprsourcetype", (Object)oprsourcetype);
        OrderRestructureService.setActSubEntryValueByRoute(orderEntry, newTechOprEntry);
        newTechOprEntry.set("oprplanbegintime", orderEntry.get("planbegintime"));
        newTechOprEntry.set("oprplanfinishtime", orderEntry.get("planendtime"));
        newTechOprEntry.set("oprtotalsplitqty", (Object)BigDecimal.ZERO);
        newTechOprEntry.set("oprtotalsplitbaseqty", (Object)BigDecimal.ZERO);
        newTechOprEntry.set("oprstatus", (Object)"A");
        newTechOprEntry.set("collaborative", (Object)false);
        newTechOprEntry.set("oprinvalid", (Object)false);
        newTechOprEntry.set("storagepoint", techToEntry.get("tostoragepoint"));
        newTechOprEntry.set("inspectiontype", techToEntry.get("toinspectiontype"));
        if (StringUtils.isBlank((String)newTechOprEntry.getString("oprtimeunit"))) {
            newTechOprEntry.set("oprtimeunit", (Object)"A");
        }
        if (StringUtils.isBlank((String)newTechOprEntry.getString("oproverlaptimeunit"))) {
            newTechOprEntry.set("oproverlaptimeunit", (Object)"A");
        }
    }

    public static void setActSubEntryValueByRoute(DynamicObject orderEntryObj, DynamicObject newTechOprEntry) {
        if (null != newTechOprEntry) {
            DynamicObject processRoute = orderEntryObj.getDynamicObject("processroute");
            processRoute = BusinessDataServiceHelper.loadSingleFromCache((Object)(processRoute == null ? Long.valueOf(0L) : processRoute.getPkValue()), (String)"pdm_route", (String)"id,processentry.operationno,actentryentity,actentryentity.activity,actentryentity.baseqty,actentryentity.standardformula,actentryentity.standardformula1,actentryentity.actresource,parent");
            String oprNo = newTechOprEntry.getString("oprno");
            String oprparent = newTechOprEntry.getString("oprparent");
            String oprSourceType = newTechOprEntry.getString("oprsourcetype");
            DynamicObjectCollection processEntrys = processRoute.getDynamicObjectCollection("processentry");
            for (DynamicObject processEntry : processEntrys) {
                String operationNo = processEntry.getString("operationno");
                String parent = processEntry.getString("parent");
                DynamicObjectCollection acEntrys = processEntry.getDynamicObjectCollection("actentryentity");
                if (acEntrys.size() == 0 || !oprNo.equals(operationNo) || !oprparent.equals(parent) || !"A".equals(oprSourceType)) continue;
                for (int x = 0; x < acEntrys.size(); ++x) {
                    DynamicObject acEntry = (DynamicObject)acEntrys.get(x);
                    DynamicObject newSubEntryObj = newTechOprEntry.getDynamicObjectCollection("actsubentryentity").addNew();
                    OrderRestructureService.setActsubentryentityByRoute(acEntry, newSubEntryObj, orderEntryObj);
                }
            }
        }
    }

    public static void setActsubentryentity(DynamicObject acEntry, DynamicObject newSubEntryObj, DynamicObject orderEntryObj) {
        newSubEntryObj.set("processstage", acEntry.getDynamicObject("processnumber").get("processstage"));
        newSubEntryObj.set("actactivity", acEntry.get("processnumber"));
        newSubEntryObj.set("actqty", acEntry.get("processqty"));
        newSubEntryObj.set("actunit", acEntry.get("processunit"));
        newSubEntryObj.set("actstandardformula", acEntry.get("activeformula"));
        newSubEntryObj.set("actstandardformula1", acEntry.get("reportformula"));
        newSubEntryObj.set("actplanbegintime", orderEntryObj.get("planbegintime"));
        newSubEntryObj.set("actplanfinishtime", orderEntryObj.get("planendtime"));
        ManuftechCreateBillUtil.runFormula((DynamicObject)newSubEntryObj, (String)"sfc_manftech");
    }

    public static void setActsubentryentityByRoute(DynamicObject acEntry, DynamicObject newSubEntryObj, DynamicObject orderEntryObj) {
        newSubEntryObj.set("processstage", acEntry.getDynamicObject("activity").get("processstage"));
        newSubEntryObj.set("actactivity", acEntry.get("activity"));
        newSubEntryObj.set("actqty", acEntry.get("baseqty"));
        newSubEntryObj.set("actunit", acEntry.getDynamicObject("activity").get("unit"));
        newSubEntryObj.set("actstandardformula", acEntry.get("standardformula"));
        newSubEntryObj.set("actstandardformula1", acEntry.get("standardformula1"));
        newSubEntryObj.set("actresources", acEntry.get("actresource"));
        newSubEntryObj.set("actplanbegintime", orderEntryObj.get("planbegintime"));
        newSubEntryObj.set("actplanfinishtime", orderEntryObj.get("planendtime"));
        ManuftechCreateBillUtil.runFormula((DynamicObject)newSubEntryObj, (String)"sfc_manftech");
    }

    public static void restructOrderToStockEntryRE(DynamicObject stockBill, DynamicObject stockEntry, DynamicObject orderRestructureOrderBill, DynamicObject restock) {
        DynamicObject planInfo;
        stockEntry.set("id", (Object)restock.getLong("retstockentryid"));
        DynamicObject mftmaterial = restock.getDynamicObject("retmftmaterial");
        stockEntry.set("materialid", (Object)mftmaterial);
        DynamicObject bdmaterial = mftmaterial.getDynamicObject("masterid");
        stockEntry.set("materielmasterid", (Object)bdmaterial);
        DynamicObject transactiontype = stockBill.getDynamicObject("transactiontypeid");
        boolean isconsiderloss = transactiontype.getBoolean("isconsiderloss");
        String processseq = StringUtils.isEmpty((String)restock.getString("retoprparent")) ? "1" : restock.getString("retoprparent");
        stockEntry.set("processseq", (Object)processseq);
        String retoprno = StringUtils.isEmpty((String)restock.getString("retoprno")) ? "10" : restock.getString("retoprno");
        stockEntry.set("oprno", (Object)retoprno);
        DynamicObject warehouse = restock.getDynamicObject("retwarehouseid");
        if (null == warehouse) {
            warehouse = mftmaterial.getDynamicObject("warehouse");
        }
        stockEntry.set("warehouseid", (Object)warehouse);
        String issuemode = restock.getString("retissuemode");
        if (StringUtils.isBlank((String)issuemode)) {
            String mftissuemode = mftmaterial.getString("issuemode");
            if (mftissuemode.equals("11010")) {
                issuemode = "A";
            }
            if (mftissuemode.equals("11050")) {
                issuemode = "B";
            }
            if (mftissuemode.equals("11040")) {
                issuemode = "C";
            }
        }
        stockEntry.set("issuemode", (Object)issuemode);
        String wastagerateformula = "B";
        if (isconsiderloss && null != (planInfo = MaterialPlanQueryHelper.getDataCacheByMaterial((DynamicObject)bdmaterial, (DynamicObject)stockBill.getDynamicObject("org")))) {
            wastagerateformula = planInfo.getString("wastagerateformula");
        }
        stockEntry.set("wastagerateformula", (Object)wastagerateformula);
        boolean iscannegative = true;
        stockEntry.set("iscannegative", (Object)iscannegative);
        stockEntry.set("materialunitid", restock.get("retmaterialunitid"));
        String qtytype = restock.getString("retqtytype");
        stockEntry.set("qtytype", (Object)qtytype);
        BigDecimal useratio = BigDecimal.valueOf(100L);
        stockEntry.set("useratio", (Object)useratio);
        BigDecimal qtynumerator = restock.getBigDecimal("retqtynumerator");
        stockEntry.set("qtynumerator", (Object)qtynumerator);
        BigDecimal qtydenominator = restock.getBigDecimal("retqtydenominator");
        stockEntry.set("qtydenominator", (Object)qtydenominator);
        BigDecimal fixscrap = BigDecimal.ZERO;
        stockEntry.set("fixscrap", (Object)fixscrap);
        BigDecimal scraprate = BigDecimal.ZERO;
        stockEntry.set("scraprate", (Object)scraprate);
        DynamicObject unit = restock.getDynamicObject("retmaterialunitid");
        BigDecimal orderQty = stockBill.getBigDecimal("baseqty");
        BigDecimal standQty = MPDMMftGenStocksUtils.calculateStandQty((DynamicObject)unit, (String)qtytype, (BigDecimal)useratio.divide(BigDecimal.valueOf(100L), 4, 4), (BigDecimal)orderQty, (BigDecimal)qtynumerator, (BigDecimal)qtydenominator);
        stockEntry.set("standqty", (Object)standQty);
        BigDecimal demandqty = MPDMMftGenStocksUtils.calculateDemadQty((DynamicObject)unit, (boolean)isconsiderloss, (BigDecimal)standQty, (BigDecimal)scraprate, (BigDecimal)fixscrap, (String)wastagerateformula);
        stockEntry.set("demandqty", (Object)demandqty);
        BigDecimal actissueqty = BigDecimal.ZERO;
        if (iscannegative) {
            actissueqty = demandqty;
        }
        stockEntry.set("actissueqty", (Object)actissueqty);
        stockEntry.set("unissueqty", MPDMMftGenStocksUtils.aculUnSendQty((DynamicObject)stockEntry));
        stockEntry.set("supplymode", restock.get("retsupplymode"));
        stockEntry.set("supplierid", restock.get("retsupplierid"));
        stockEntry.set("supplyorgid", restock.get("retsupplyorgid"));
        DynamicObject location = mftmaterial.getDynamicObject("location");
        stockEntry.set("location", (Object)location);
        boolean isstockallot = mftmaterial.getBoolean("isstockallot");
        stockEntry.set("isstockallot", (Object)isstockallot);
        stockEntry.set("outorgunitid", mftmaterial.get("outstorageunit"));
        stockEntry.set("outwarehouseid", mftmaterial.get("outwarehouse"));
        stockEntry.set("outlocation", mftmaterial.get("outwarelocation"));
        String isbackflush = mftmaterial.getString("isbackflush");
        stockEntry.set("isbackflush", (Object)isbackflush);
        stockEntry.set("isbulkmaterial", mftmaterial.get("isbulkmaterial"));
        String backflushtime = "";
        if ("B".equals(isbackflush)) {
            backflushtime = transactiontype.getString("backflushtime");
        }
        stockEntry.set("backflushtime", (Object)backflushtime);
        stockEntry.set("iskeypart", mftmaterial.get("iskeypart"));
        String overissuecontrl = "B";
        if (!mftmaterial.getBoolean("isquotacontrol")) {
            overissuecontrl = "A";
        }
        stockEntry.set("overissuecontrl", (Object)overissuecontrl);
        stockEntry.set("issinhighlimit", (Object)BigDecimal.ZERO);
        stockEntry.set("extraratioqty", (Object)demandqty);
        stockEntry.set("issinlowlimit", (Object)BigDecimal.ZERO);
        stockEntry.set("lackraitioqty", (Object)demandqty);
        stockEntry.set("ismainreplace", (Object)false);
        BigDecimal wipqty = MPDMMftGenStocksUtils.aculWIPQty((DynamicObject)stockEntry);
        stockEntry.set("wipqty", (Object)wipqty);
        stockEntry.set("childauxpropertyid", restock.get("retauxpropertyid"));
        stockEntry.set("entryconfiguredcode", restock.get("retconfiguredcode"));
        stockEntry.set("cansendqty", MPDMMftGenStocksUtils.aculCanSendQty((DynamicObject)stockEntry));
    }

    public static void restructOrderToStockEntryMRQ(DynamicObject stockBill, DynamicObject stockEntry, DynamicObject orderRestructureOrderBill, DynamicObject mrqstock) {
        DynamicObject planInfo;
        stockEntry.set("id", (Object)mrqstock.getLong("mrqbomentryid"));
        DynamicObject mftmaterial = mrqstock.getDynamicObject("mrqmftmaterial");
        stockEntry.set("materialid", (Object)mftmaterial);
        DynamicObject bdmaterial = mftmaterial.getDynamicObject("masterid");
        stockEntry.set("materielmasterid", (Object)bdmaterial);
        DynamicObject transactiontype = stockBill.getDynamicObject("transactiontypeid");
        boolean isconsiderloss = transactiontype.getBoolean("isconsiderloss");
        String processseq = StringUtils.isEmpty((String)mrqstock.getString("mrqprocessseq")) ? "1" : mrqstock.getString("mrqprocessseq");
        stockEntry.set("processseq", (Object)processseq);
        String retoprno = StringUtils.isEmpty((String)mrqstock.getString("mrqoprno")) ? "10" : mrqstock.getString("mrqoprno");
        stockEntry.set("oprno", (Object)retoprno);
        DynamicObject warehouse = mrqstock.getDynamicObject("mrqwarehouseid");
        if (null == warehouse) {
            warehouse = mftmaterial.getDynamicObject("warehouse");
        }
        stockEntry.set("warehouseid", (Object)warehouse);
        String issuemode = mrqstock.getString("mrqissuemode");
        if (StringUtils.isBlank((String)issuemode)) {
            String mftissuemode = mftmaterial.getString("issuemode");
            if (mftissuemode.equals("11010")) {
                issuemode = "A";
            }
            if (mftissuemode.equals("11050")) {
                issuemode = "B";
            }
            if (mftissuemode.equals("11040")) {
                issuemode = "C";
            }
        }
        stockEntry.set("issuemode", (Object)issuemode);
        String wastagerateformula = "B";
        if (isconsiderloss && null != (planInfo = MaterialPlanQueryHelper.getDataCacheByMaterial((DynamicObject)bdmaterial, (DynamicObject)stockBill.getDynamicObject("org")))) {
            wastagerateformula = planInfo.getString("wastagerateformula");
        }
        stockEntry.set("wastagerateformula", (Object)wastagerateformula);
        boolean iscannegative = false;
        stockEntry.set("iscannegative", (Object)iscannegative);
        stockEntry.set("materialunitid", mrqstock.get("mrqbaseunitid"));
        String qtytype = mrqstock.getString("mrqqtytype");
        stockEntry.set("qtytype", (Object)qtytype);
        BigDecimal useratio = mrqstock.getBigDecimal("mrquseratio");
        stockEntry.set("useratio", (Object)useratio);
        BigDecimal qtynumerator = mrqstock.getBigDecimal("mrqqtynumerator");
        stockEntry.set("qtynumerator", (Object)qtynumerator);
        BigDecimal qtydenominator = mrqstock.getBigDecimal("mrqqtydenominator");
        stockEntry.set("qtydenominator", (Object)qtydenominator);
        BigDecimal fixscrap = mrqstock.getBigDecimal("mrqfixscrap");
        stockEntry.set("fixscrap", (Object)fixscrap);
        BigDecimal scraprate = mrqstock.getBigDecimal("mrqscraprate");
        stockEntry.set("scraprate", (Object)scraprate);
        DynamicObject unit = mrqstock.getDynamicObject("mrqbaseunitid");
        BigDecimal orderQty = stockBill.getBigDecimal("baseqty");
        BigDecimal standQty = MPDMMftGenStocksUtils.calculateStandQty((DynamicObject)unit, (String)qtytype, (BigDecimal)useratio.divide(BigDecimal.valueOf(100L), 4, 4), (BigDecimal)orderQty, (BigDecimal)qtynumerator, (BigDecimal)qtydenominator);
        stockEntry.set("standqty", (Object)standQty);
        BigDecimal demandqty = MPDMMftGenStocksUtils.calculateDemadQty((DynamicObject)unit, (boolean)isconsiderloss, (BigDecimal)standQty, (BigDecimal)scraprate, (BigDecimal)fixscrap, (String)wastagerateformula);
        stockEntry.set("demandqty", (Object)demandqty);
        BigDecimal actissueqty = BigDecimal.ZERO;
        if (iscannegative) {
            actissueqty = demandqty;
        }
        stockEntry.set("actissueqty", (Object)actissueqty);
        stockEntry.set("unissueqty", MPDMMftGenStocksUtils.aculUnSendQty((DynamicObject)stockEntry));
        stockEntry.set("supplymode", mrqstock.get("mrqsupplymode"));
        stockEntry.set("supplierid", mrqstock.get("mrqsupplierid"));
        stockEntry.set("supplyorgid", mrqstock.get("mrqsupplyorgid"));
        DynamicObject location = mftmaterial.getDynamicObject("location");
        stockEntry.set("location", (Object)location);
        boolean isstockallot = mftmaterial.getBoolean("isstockallot");
        stockEntry.set("isstockallot", (Object)isstockallot);
        stockEntry.set("outorgunitid", mftmaterial.get("outstorageunit"));
        stockEntry.set("outwarehouseid", mftmaterial.get("outwarehouse"));
        stockEntry.set("outlocation", mftmaterial.get("outwarelocation"));
        String isbackflush = mftmaterial.getString("isbackflush");
        stockEntry.set("isbackflush", (Object)isbackflush);
        stockEntry.set("isbulkmaterial", mftmaterial.get("isbulkmaterial"));
        String backflushtime = "";
        if ("B".equals(isbackflush)) {
            backflushtime = transactiontype.getString("backflushtime");
        }
        stockEntry.set("backflushtime", (Object)backflushtime);
        stockEntry.set("iskeypart", mftmaterial.get("iskeypart"));
        String overissuecontrl = "B";
        if (!mftmaterial.getBoolean("isquotacontrol")) {
            overissuecontrl = "A";
        }
        stockEntry.set("overissuecontrl", (Object)overissuecontrl);
        stockEntry.set("issinhighlimit", (Object)BigDecimal.ZERO);
        stockEntry.set("extraratioqty", (Object)demandqty);
        stockEntry.set("issinlowlimit", (Object)BigDecimal.ZERO);
        stockEntry.set("lackraitioqty", (Object)demandqty);
        stockEntry.set("ismainreplace", (Object)false);
        BigDecimal wipqty = MPDMMftGenStocksUtils.aculWIPQty((DynamicObject)stockEntry);
        stockEntry.set("wipqty", (Object)wipqty);
        stockEntry.set("childauxpropertyid", mrqstock.get("mrqauxpropertyid"));
        stockEntry.set("entryconfiguredcode", mrqstock.get("mrqconfiguredcode"));
        stockEntry.set("cansendqty", MPDMMftGenStocksUtils.aculCanSendQty((DynamicObject)stockEntry));
    }

    private static void repackageScrapStockPage(DynamicObject stockBill, DynamicObject orderRestructureOrderBill, Map<Long, Map<Long, DynamicObject>> res, Date now, boolean checkExistInStockEntryFlag, Map<Long, DynamicObject> scrapEntryIdAndStockEntryMap) {
        if (null != stockBill && null != orderRestructureOrderBill) {
            DynamicObjectCollection stockentry = stockBill.getDynamicObjectCollection("stockentry");
            DynamicObject orderentryidDyn = stockBill.getDynamicObject("orderentryid");
            Date planbegintime = orderentryidDyn.getDate("planbegintime");
            Date planendtime = orderentryidDyn.getDate("planendtime");
            DynamicObject org = stockBill.getDynamicObject("org");
            DynamicObjectCollection scrapstockpage = orderRestructureOrderBill.getDynamicObjectCollection("scrapstockentry");
            int seq = stockentry.size();
            for (DynamicObject scrapstock : scrapstockpage) {
                DynamicObject matchStockEntry;
                DynamicObject scrapmftmaterial = scrapstock.getDynamicObject("scrapmftmaterial");
                String oprparent = scrapstock.getString("scrapoprparent");
                String oprno = scrapstock.getString("scrapoprno");
                DynamicObject configuredcode = scrapstock.getDynamicObject("scrapconfiguredcode");
                if (checkExistInStockEntryFlag && null != (matchStockEntry = OrderRestructureService.checkExistInStockEntry(stockentry, scrapmftmaterial, oprparent, oprno, configuredcode))) {
                    scrapEntryIdAndStockEntryMap.put(scrapstock.getLong("id"), matchStockEntry);
                    continue;
                }
                DynamicObject newStockEntry = stockentry.addNew();
                newStockEntry.set("seq", (Object)(++seq));
                OrderRestructureService.restructOrderToStockEntryScrap(stockBill, newStockEntry, orderRestructureOrderBill, scrapstock);
                DynamicObject material = newStockEntry.getDynamicObject("materialid");
                DynamicObject supply = newStockEntry.getDynamicObject("supplyorgid");
                if (material != null && supply != null && material.getDynamicObject("masterid") != null) {
                    DynamicObject masterid = material.getDynamicObject("masterid");
                    Long orgId = (Long)supply.getPkValue();
                    Long masterId = (Long)masterid.getPkValue();
                    newStockEntry.set("materielinv", (Object)MaterialInvInfoHelper.getMaterialByRes(res, (Long)orgId, (Long)masterId));
                }
                newStockEntry.set("leadtime", (Object)BigDecimal.ZERO);
                newStockEntry.set("demanddate", CreateStockByBomUtils.getDemandDate((DynamicObject)org, (Date)planbegintime, (DynamicObject)newStockEntry, (Date)planendtime));
                newStockEntry.set("sourcetype", (Object)"B");
            }
        }
    }

    private static DynamicObject checkExistInStockEntry(DynamicObjectCollection stockEntrys, DynamicObject scrapmftmaterial, String oprparent, String oprno, DynamicObject configuredcode) {
        DynamicObject result = null;
        if (null != stockEntrys && null != scrapmftmaterial) {
            for (DynamicObject stockEntry : stockEntrys) {
                DynamicObject mftMaterial = stockEntry.getDynamicObject("materialid");
                String oprparentInStockEntry = stockEntry.getString("processseq");
                String oprNoInStockEntry = stockEntry.getString("oprno");
                DynamicObject entryconfiguredcode = stockEntry.getDynamicObject("entryconfiguredcode");
                if (null == mftMaterial || !scrapmftmaterial.getString("id").equals(mftMaterial.getString("id")) || (null != entryconfiguredcode || null != configuredcode) && (null == entryconfiguredcode || null == configuredcode || !entryconfiguredcode.getString("id").equals(configuredcode.getString("id"))) || !StringUtils.equals((String)oprparent, (String)oprparentInStockEntry) || !StringUtils.equals((String)oprno, (String)oprNoInStockEntry)) continue;
                result = stockEntry;
                break;
            }
        }
        return result;
    }

    public static void restructOrderToStockEntryScrap(DynamicObject stockBill, DynamicObject stockEntry, DynamicObject orderRestructureOrderBill, DynamicObject scrapstock) {
        DynamicObject planInfo;
        stockEntry.set("id", (Object)scrapstock.getLong("scrapstockentryid"));
        DynamicObject mftmaterial = scrapstock.getDynamicObject("scrapmftmaterial");
        stockEntry.set("materialid", (Object)mftmaterial);
        DynamicObject bdmaterial = mftmaterial.getDynamicObject("masterid");
        stockEntry.set("materielmasterid", (Object)bdmaterial);
        DynamicObject transactiontype = stockBill.getDynamicObject("transactiontypeid");
        boolean isconsiderloss = transactiontype.getBoolean("isconsiderloss");
        String processseq = StringUtils.isEmpty((String)scrapstock.getString("scrapoprparent")) ? "1" : scrapstock.getString("scrapoprparent");
        stockEntry.set("processseq", (Object)processseq);
        String retoprno = StringUtils.isEmpty((String)scrapstock.getString("scrapoprno")) ? "10" : scrapstock.getString("scrapoprno");
        stockEntry.set("oprno", (Object)retoprno);
        DynamicObject warehouse = scrapstock.getDynamicObject("scrapwarehouseid");
        if (null == warehouse) {
            warehouse = mftmaterial.getDynamicObject("warehouse");
        }
        stockEntry.set("warehouseid", (Object)warehouse);
        String issuemode = scrapstock.getString("scrapissuemode");
        if (StringUtils.isBlank((String)issuemode)) {
            String mftissuemode = mftmaterial.getString("issuemode");
            if (mftissuemode.equals("11010")) {
                issuemode = "A";
            }
            if (mftissuemode.equals("11050")) {
                issuemode = "B";
            }
            if (mftissuemode.equals("11040")) {
                issuemode = "C";
            }
        }
        stockEntry.set("issuemode", (Object)issuemode);
        String wastagerateformula = "B";
        if (isconsiderloss && null != (planInfo = MaterialPlanQueryHelper.getDataCacheByMaterial((DynamicObject)bdmaterial, (DynamicObject)stockBill.getDynamicObject("org")))) {
            wastagerateformula = planInfo.getString("wastagerateformula");
        }
        stockEntry.set("wastagerateformula", (Object)wastagerateformula);
        boolean iscannegative = true;
        stockEntry.set("iscannegative", (Object)iscannegative);
        stockEntry.set("materialunitid", scrapstock.get("scrapmaterialunit"));
        String qtytype = scrapstock.getString("scrapqtytype");
        stockEntry.set("qtytype", (Object)qtytype);
        BigDecimal useratio = BigDecimal.valueOf(100L);
        stockEntry.set("useratio", (Object)useratio);
        BigDecimal qtynumerator = scrapstock.getBigDecimal("scrapqtynumerator");
        stockEntry.set("qtynumerator", (Object)qtynumerator);
        BigDecimal qtydenominator = scrapstock.getBigDecimal("scrapqtydenominator");
        stockEntry.set("qtydenominator", (Object)qtydenominator);
        BigDecimal fixscrap = BigDecimal.ZERO;
        stockEntry.set("fixscrap", (Object)fixscrap);
        BigDecimal scraprate = BigDecimal.ZERO;
        stockEntry.set("scraprate", (Object)scraprate);
        DynamicObject unit = scrapstock.getDynamicObject("scrapmaterialunit");
        BigDecimal orderQty = stockBill.getBigDecimal("baseqty");
        BigDecimal standQty = MPDMMftGenStocksUtils.calculateStandQty((DynamicObject)unit, (String)qtytype, (BigDecimal)useratio.divide(BigDecimal.valueOf(100L), 4, 4), (BigDecimal)orderQty, (BigDecimal)qtynumerator, (BigDecimal)qtydenominator);
        stockEntry.set("standqty", (Object)standQty);
        BigDecimal demandqty = MPDMMftGenStocksUtils.calculateDemadQty((DynamicObject)unit, (boolean)isconsiderloss, (BigDecimal)standQty, (BigDecimal)scraprate, (BigDecimal)fixscrap, (String)wastagerateformula);
        stockEntry.set("demandqty", (Object)demandqty);
        BigDecimal actissueqty = BigDecimal.ZERO;
        if (iscannegative) {
            actissueqty = demandqty;
        }
        stockEntry.set("actissueqty", (Object)actissueqty);
        stockEntry.set("unissueqty", MPDMMftGenStocksUtils.aculUnSendQty((DynamicObject)stockEntry));
        stockEntry.set("supplymode", scrapstock.get("scrapsupplymode"));
        stockEntry.set("supplierid", scrapstock.get("scrapsupplierid"));
        stockEntry.set("supplyorgid", scrapstock.get("scrapsupplyorgid"));
        DynamicObject location = mftmaterial.getDynamicObject("location");
        stockEntry.set("location", (Object)location);
        boolean isstockallot = mftmaterial.getBoolean("isstockallot");
        stockEntry.set("isstockallot", (Object)isstockallot);
        stockEntry.set("outorgunitid", mftmaterial.get("outstorageunit"));
        stockEntry.set("outwarehouseid", mftmaterial.get("outwarehouse"));
        stockEntry.set("outlocation", mftmaterial.get("outwarelocation"));
        String isbackflush = mftmaterial.getString("isbackflush");
        stockEntry.set("isbackflush", (Object)isbackflush);
        stockEntry.set("isbulkmaterial", mftmaterial.get("isbulkmaterial"));
        String backflushtime = "";
        if ("B".equals(isbackflush)) {
            backflushtime = transactiontype.getString("backflushtime");
        }
        stockEntry.set("backflushtime", (Object)backflushtime);
        stockEntry.set("iskeypart", mftmaterial.get("iskeypart"));
        String overissuecontrl = "B";
        if (!mftmaterial.getBoolean("isquotacontrol")) {
            overissuecontrl = "A";
        }
        stockEntry.set("overissuecontrl", (Object)overissuecontrl);
        stockEntry.set("issinhighlimit", (Object)BigDecimal.ZERO);
        stockEntry.set("extraratioqty", (Object)demandqty);
        stockEntry.set("issinlowlimit", (Object)BigDecimal.ZERO);
        stockEntry.set("lackraitioqty", (Object)demandqty);
        stockEntry.set("ismainreplace", (Object)false);
        BigDecimal wipqty = MPDMMftGenStocksUtils.aculWIPQty((DynamicObject)stockEntry);
        stockEntry.set("wipqty", (Object)wipqty);
        stockEntry.set("childauxpropertyid", scrapstock.get("scrapauxpropertyid"));
        stockEntry.set("entryconfiguredcode", scrapstock.get("scrapconfiguredcode"));
        stockEntry.set("cansendqty", MPDMMftGenStocksUtils.aculCanSendQty((DynamicObject)stockEntry));
    }

    private static void repackageMrqStockPage(DynamicObject stockBill, DynamicObject orderRestructureOrderBill, Map<Long, Map<Long, DynamicObject>> res, Date now) {
        if (null != stockBill && null != orderRestructureOrderBill) {
            DynamicObjectCollection stockentry = stockBill.getDynamicObjectCollection("stockentry");
            DynamicObject orderentryidDyn = stockBill.getDynamicObject("orderentryid");
            Date planbegintime = orderentryidDyn.getDate("planbegintime");
            Date planendtime = orderentryidDyn.getDate("planendtime");
            DynamicObject org = stockBill.getDynamicObject("org");
            DynamicObjectCollection mrqstockpage = orderRestructureOrderBill.getDynamicObjectCollection("mrqstockentry");
            int seq = stockentry.size();
            for (DynamicObject scrapstock : mrqstockpage) {
                DynamicObject newStockEntry = stockentry.addNew();
                newStockEntry.set("seq", (Object)(++seq));
                OrderRestructureService.restructOrderToStockEntryMRQ(stockBill, newStockEntry, orderRestructureOrderBill, scrapstock);
                DynamicObject material = newStockEntry.getDynamicObject("materialid");
                DynamicObject supply = newStockEntry.getDynamicObject("supplyorgid");
                if (material != null && supply != null && material.getDynamicObject("masterid") != null) {
                    DynamicObject masterid = material.getDynamicObject("masterid");
                    Long orgId = (Long)supply.getPkValue();
                    Long masterId = (Long)masterid.getPkValue();
                    newStockEntry.set("materielinv", (Object)MaterialInvInfoHelper.getMaterialByRes(res, (Long)orgId, (Long)masterId));
                }
                newStockEntry.set("leadtime", (Object)BigDecimal.ZERO);
                newStockEntry.set("demanddate", CreateStockByBomUtils.getDemandDate((DynamicObject)org, (Date)planbegintime, (DynamicObject)newStockEntry, (Date)planendtime));
                if (StringUtils.equals((String)"D", (String)scrapstock.getString("mrqsourcetype"))) {
                    newStockEntry.set("rework", (Object)true);
                }
                newStockEntry.set("sourcetype", (Object)"B");
            }
        }
    }

    public static void addOrderTechEntrys(List<DynamicObject> orderRestructureOrderBills, Set<Long> newOrderEntryIds, Set<Long> techIds) {
        String techEntityId = "sfc_manftech";
        DynamicObject[] afterTechBills = BusinessDataServiceHelper.load((String)techEntityId, (String)(OrderSplitTechnicsHelper.getAllProperties((String)"sfc_manftech", (String[])new String[]{"oprentryentity", "proentryentity", "ressubentryentity", "actsubentryentity", "repsubentryentity"}) + ",oprentryentity.seq"), (QFilter[])new QFilter[]{new QFilter("id", "in", techIds)});
        String selectPro = OrderSpliteService.getBillAllPropers((String)"pom_mftorder", (String[])new String[]{"treeentryentity"});
        QFilter qFilter = new QFilter("id", "in", newOrderEntryIds);
        DynamicObject[] mftorderBillForPks = BusinessDataServiceHelper.load((String)"pom_mftorder", (String)selectPro, (QFilter[])new QFilter[]{qFilter});
        HashSet<Object> processRouteIds = new HashSet<Object>(afterTechBills.length);
        for (DynamicObject afterTechBill : afterTechBills) {
            if (null == afterTechBill.getDynamicObject("processroute")) continue;
            processRouteIds.add(afterTechBill.getDynamicObject("processroute").getPkValue());
        }
        Map processRoutes = BusinessDataServiceHelper.loadFromCache((Object[])processRouteIds.toArray(new Object[processRouteIds.size()]), (String)"pdm_route");
        for (DynamicObject afterTechBill : afterTechBills) {
            Long srcOrderEntryId;
            DynamicObject orderEntry;
            DynamicObject orderentryDyn = afterTechBill.getDynamicObject("mftentryseq");
            DynamicObject processRouteObj = null;
            if (null != afterTechBill.getDynamicObject("processroute")) {
                processRouteObj = (DynamicObject)processRoutes.get(afterTechBill.getDynamicObject("processroute").getPkValue());
            }
            if (null == orderentryDyn || null == (orderEntry = OrderRestructureService.matchOrderEntry(srcOrderEntryId = Long.valueOf(orderentryDyn.getLong("id")), Arrays.asList(mftorderBillForPks)))) continue;
            DynamicObject orderRestructureOrderBill = OrderRestructureService.matchorderRestructureOrderBillByPAorderEntryId(orderEntry.getLong("sourceentryseq"), orderRestructureOrderBills);
            OrderRestructureService.repackageTechToEntryEntity(afterTechBill, orderRestructureOrderBill, orderEntry, processRouteObj);
        }
        SaveServiceHelper.save((DynamicObject[])afterTechBills);
    }

    public static DynamicObject matchOrderEntry(Long srcOrderEntryId, List<DynamicObject> orderBills) {
        DynamicObject result = null;
        block0: for (DynamicObject orderBill : orderBills) {
            DynamicObjectCollection orderEntrys = orderBill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject orderEntry : orderEntrys) {
                if (!srcOrderEntryId.equals(orderEntry.getLong("id"))) continue;
                result = orderEntry;
                continue block0;
            }
        }
        return result;
    }

    public static DynamicObject matchTechBill(Long srcOrderEntryId, List<DynamicObject> techBills) {
        DynamicObject result = null;
        for (DynamicObject techBill : techBills) {
            DynamicObject mftentryseq = techBill.getDynamicObject("mftentryseq");
            if (!srcOrderEntryId.equals(mftentryseq.getLong("id"))) continue;
            result = techBill;
            break;
        }
        return result;
    }

    public static DynamicObject matchStockProentry(String oprparent, DynamicObject techBill) {
        DynamicObject techEntry = null;
        if (null != techBill) {
            DynamicObjectCollection proentryentity = techBill.getDynamicObjectCollection("proentryentity");
            for (DynamicObject oprentry : proentryentity) {
                String processseq = oprentry.getString("processseq");
                if (!StringUtils.equals((String)processseq, (String)oprparent)) continue;
                techEntry = oprentry;
                break;
            }
        }
        return techEntry;
    }

    public static void genNewOrderBill(List<DynamicObject> orderRestructureBills, boolean isTempFlag) {
        List<DynamicObject> pushOrderBills = OrderRestructureService.restructureBillPushOrderBills(orderRestructureBills);
        for (DynamicObject orderBill : pushOrderBills) {
            OrderRestructureService.genOrderBillNo(orderBill, "pom_mftorder");
        }
        OperateOption orderSaveOperate = OperateOption.create();
        orderSaveOperate.setVariableValue("planInvokeOrderSave", "restructInvokeOrderSave");
        OperationResult orderSaveOperateResult = SaveServiceHelper.saveOperate((String)"pom_mftorder", (DynamicObject[])pushOrderBills.toArray(new DynamicObject[pushOrderBills.size()]), (OperateOption)orderSaveOperate);
        if (!orderSaveOperateResult.isSuccess()) {
            logger.info("restructInvokeOrderSave fail:" + OrderOpUtils.getErrDetail((OperationResult)orderSaveOperateResult));
            throw new KDBizException(new ErrorCode("OrderRestructureLoadInfoOp", String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff1a\u751f\u4ea7\u5de5\u5355\u4fdd\u5b58\u65f6%1$s", (String)"OrderRestructureService_6", (String)"mmc-pom-business", (Object[])new Object[0]), OrderOpUtils.getErrDetail((OperationResult)orderSaveOperateResult))), new Object[0]);
        }
    }

    public static void genOrderBillNo(DynamicObject orderBill, String entityId) {
        if (null != orderBill) {
            String billNo = CodeRuleServiceHelper.getNumber((String)entityId, (DynamicObject)orderBill, (String)orderBill.getDynamicObject("org").getPkValue().toString());
            orderBill.set("billno", (Object)(StringUtils.isBlank((String)billNo) ? UUID.randomUUID().toString().substring(0, 30) : billNo));
        }
    }

    public static BigDecimal getCanrestructurqty(DynamicObject srcOrderEntryDym, String restructurtype, DynamicObject orderBill, DynamicObject techBill) {
        BigDecimal pbcanrestructurqty = BigDecimal.valueOf(0L);
        if ("B".equals(restructurtype)) {
            DynamicObject transactiontype;
            boolean isprocedure = false;
            if (null != orderBill && null != (transactiontype = orderBill.getDynamicObject("transactiontype"))) {
                isprocedure = transactiontype.getBoolean("isprocedure");
            }
            DynamicObject material = srcOrderEntryDym.getDynamicObject("material").getDynamicObject("masterid");
            DynamicObject unit = srcOrderEntryDym.getDynamicObject("unit");
            DynamicObject baseunit = srcOrderEntryDym.getDynamicObject("baseunit");
            BigDecimal stockBaseQty = srcOrderEntryDym.getBigDecimal("stockqty");
            BigDecimal stockQty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)srcOrderEntryDym.getDynamicObject("material"), (DynamicObject)srcOrderEntryDym.getDynamicObject("baseunit"), (BigDecimal)stockBaseQty, (DynamicObject)srcOrderEntryDym.getDynamicObject("unit"));
            BigDecimal rptqty = srcOrderEntryDym.getBigDecimal("rptqty");
            BigDecimal rptbaseqty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)unit, (BigDecimal)rptqty, (DynamicObject)baseunit);
            if (isprocedure) {
                if (null != techBill) {
                    BigDecimal baseqtyInOrderEntry = srcOrderEntryDym.getBigDecimal("baseqty");
                    BigDecimal maxBaseQty = BigDecimal.ZERO.max(rptbaseqty).max(stockBaseQty);
                    DynamicObjectCollection oprentrys = techBill.getDynamicObjectCollection("oprentryentity");
                    for (DynamicObject oprentry : oprentrys) {
                        if (!OrderRestructureService.isNeedTechEntry(oprentry)) continue;
                        BigDecimal pushreportbaseqty = oprentry.getBigDecimal("pushreportbaseqty");
                        BigDecimal oprtotaloutbaseqty = oprentry.getBigDecimal("oprtotaloutbaseqty");
                        maxBaseQty = pushreportbaseqty.max(oprtotaloutbaseqty).max(maxBaseQty);
                    }
                    BigDecimal separablebaseqty = baseqtyInOrderEntry.subtract(maxBaseQty);
                    separablebaseqty = separablebaseqty.compareTo(BigDecimal.ZERO) > 0 ? separablebaseqty : BigDecimal.ZERO;
                    pbcanrestructurqty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)baseunit, (BigDecimal)separablebaseqty, (DynamicObject)unit);
                }
            } else {
                BigDecimal qty = srcOrderEntryDym.getBigDecimal("qty");
                pbcanrestructurqty = qty.subtract(stockQty).min(qty.subtract(srcOrderEntryDym.getBigDecimal("rptqty")));
            }
        } else if ("A".equals(restructurtype)) {
            BigDecimal baseQty = srcOrderEntryDym.getBigDecimal("quainwaqty").add(srcOrderEntryDym.getBigDecimal("unquainwaqty"));
            pbcanrestructurqty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)srcOrderEntryDym.getDynamicObject("material"), (DynamicObject)srcOrderEntryDym.getDynamicObject("baseunit"), (BigDecimal)baseQty, (DynamicObject)srcOrderEntryDym.getDynamicObject("unit"));
        }
        return pbcanrestructurqty;
    }

    public static void setSrcentryEntity2(DynamicObject restructBill, DynamicObject srcentry, DynamicObject techBill, DynamicObject oprentry, DynamicObject techOprparentEntry) {
        BigDecimal pbqty;
        BigDecimal pbrestructurqty = restructBill.getBigDecimal("pbrestructurqty");
        if (pbrestructurqty.compareTo(pbqty = restructBill.getBigDecimal("pbqty")) == 0) {
            if (Arrays.asList("A", "B", "C", "D").contains(oprentry.getString("oprstatus"))) {
                srcentry.set("srcchangetype", (Object)"A");
            } else if ("E".equals(oprentry.getString("oprstatus"))) {
                srcentry.set("srcchangetype", (Object)"B");
            }
        } else if (pbrestructurqty.compareTo(pbqty) < 0) {
            srcentry.set("srcchangetype", (Object)"B");
        }
        srcentry.set("srcoprno", oprentry.get("oprno"));
        srcentry.set("srcoproperation", oprentry.get("oproperation"));
        srcentry.set("srcoprdescription", oprentry.get("oprdescription"));
        srcentry.set("srcoprunit", oprentry.get("oprunit"));
        srcentry.set("srcoprqty", oprentry.get("oprqty"));
        srcentry.set("srcoprtotalreportqty", oprentry.get("oprtotalreportqty"));
        DynamicObject unit = restructBill.getDynamicObject("pbunit");
        DynamicObject material = restructBill.getDynamicObject("pbmaterial");
        if (null != unit && null != material) {
            BigDecimal restructurOprqty = UnitConvertHelper.calculateNewQty((BigDecimal)pbrestructurqty, (Long)((Long)oprentry.getDynamicObject("oprunit").getPkValue()), (Long)((Long)unit.getPkValue()), (Long)((Long)material.getPkValue()), (StringBuilder)new StringBuilder());
            BigDecimal qty = restructurOprqty.min(oprentry.getBigDecimal("oprqty").subtract(oprentry.getBigDecimal("pushreportqty")));
            srcentry.set("srcchangeqty", (Object)qty);
        }
        srcentry.set("srcoprstatus", oprentry.get("oprstatus"));
        srcentry.set("srcorderid", techBill.get("manufactureorderid"));
        srcentry.set("srcorderentryid", techBill.getDynamicObject("mftentryseq").getPkValue());
        srcentry.set("srcmftechnicsid", techBill.getPkValue());
        srcentry.set("srcmftechnicsentryid", oprentry.getPkValue());
        if (null != techOprparentEntry) {
            srcentry.set("srcoprparent", techOprparentEntry.get("processseq"));
            srcentry.set("srcprocessseqtype", techOprparentEntry.get("processseqtype"));
            srcentry.set("srcprocessseqname", techOprparentEntry.get("processseqname"));
        }
    }

    public static FormShowParameter importBom(String caption, IFormPlugin plugin, String action, String formId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.setCaption(caption);
        showParameter.setCloseCallBack(new CloseCallBack(plugin, action));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        return showParameter;
    }

    public static void addRetstockentry(IDataModel model, Map<String, DynamicObject> returnDataMap) {
        if (null != returnDataMap) {
            for (Map.Entry<String, DynamicObject> entryMap : returnDataMap.entrySet()) {
                int rowNumber = model.createNewEntryRow("retstockentry");
                OrderRestructureService.setRetStockEntry(model, rowNumber, entryMap.getValue());
            }
        }
    }

    private static void setRetStockEntry(IDataModel model, int rowNumber, DynamicObject returnDataMap) {
        if (null != returnDataMap) {
            model.setValue("retmftmaterial", returnDataMap.get("entrymaterial"), rowNumber);
            model.setValue("retmaterial", returnDataMap.get("entrymaterialid"), rowNumber);
            model.setValue("retqtynumerator", (Object)BigDecimal.ZERO, rowNumber);
            model.setValue("retqtydenominator", model.getValue("pbrestructurqty"), rowNumber);
            String qtytype = "A";
            model.setValue("retqtytype", (Object)qtytype, rowNumber);
            model.setValue("retmaterialunitid", returnDataMap.get("baseunit"), rowNumber);
            model.setValue("retoprparent", returnDataMap.get("entryprocessseq"), rowNumber);
            model.setValue("retoprno", returnDataMap.get("entryoperationnumber"), rowNumber);
            Object mrqsupplymode = returnDataMap.get("entryownertype");
            model.setValue("retsupplymode", mrqsupplymode, rowNumber);
            Object mrqsupplyorgid = returnDataMap.get("entrysupplyorg");
            model.setValue("retsupplyorgid", mrqsupplyorgid, rowNumber);
            Object mrqsupplierid = returnDataMap.get("entryowner");
            if (null == mrqsupplierid && null != mrqsupplymode && StringUtils.equals((String)"bos_org", (String)mrqsupplymode.toString())) {
                mrqsupplierid = OrderRestructureService.queryAccountingByInventory(null == mrqsupplyorgid ? null : (DynamicObject)mrqsupplyorgid);
            }
            model.setValue("retsupplierid", mrqsupplierid, rowNumber);
            model.setValue("retconfiguredcode", returnDataMap.get("entryconfiguredcode"), rowNumber);
            model.setValue("retauxpropertyid", returnDataMap.get("entryauxproperty"), rowNumber);
            model.setValue("retsourcetype", (Object)"B", rowNumber);
        }
    }

    public static void addScrapStockentry(IDataModel model, Map<String, DynamicObject> returnDataMap) {
        for (Map.Entry<String, DynamicObject> entryMap : returnDataMap.entrySet()) {
            int rowNumber = model.createNewEntryRow("scrapstockentry");
            OrderRestructureService.setScrapStockEntry(model, rowNumber, entryMap.getValue());
        }
    }

    private static void setScrapStockEntry(IDataModel model, int rowNumber, DynamicObject returnDataMap) {
        if (null != returnDataMap) {
            model.setValue("scrapmftmaterial", returnDataMap.get("entrymaterial"), rowNumber);
            model.setValue("scrapmaterial", returnDataMap.get("entrymaterialid"), rowNumber);
            model.setValue("scrapqtynumerator", (Object)BigDecimal.ZERO, rowNumber);
            model.setValue("scrapqtydenominator", model.getValue("pbrestructurqty"), rowNumber);
            String qtytype = "A";
            model.setValue("scrapqtytype", (Object)qtytype, rowNumber);
            model.setValue("scrapmaterialunit", returnDataMap.get("baseunit"), rowNumber);
            model.setValue("scrapoprparent", returnDataMap.get("entryprocessseq"), rowNumber);
            model.setValue("scrapoprno", returnDataMap.get("entryoperationnumber"), rowNumber);
            Object mrqsupplymode = returnDataMap.get("entryownertype");
            model.setValue("scrapsupplymode", mrqsupplymode, rowNumber);
            Object mrqsupplyorgid = returnDataMap.get("entrysupplyorg");
            model.setValue("scrapsupplyorgid", mrqsupplyorgid, rowNumber);
            Object mrqsupplierid = returnDataMap.get("entryowner");
            if (null == mrqsupplierid && null != mrqsupplymode && StringUtils.equals((String)"bos_org", (String)mrqsupplymode.toString())) {
                mrqsupplierid = OrderRestructureService.queryAccountingByInventory(null == mrqsupplyorgid ? null : (DynamicObject)mrqsupplyorgid);
            }
            model.setValue("scrapsupplierid", mrqsupplierid, rowNumber);
            model.setValue("scrapconfiguredcode", returnDataMap.get("entryconfiguredcode"), rowNumber);
            model.setValue("scrapauxpropertyid", returnDataMap.get("entryauxproperty"), rowNumber);
            model.setValue("scrapsourcetype", (Object)"B", rowNumber);
        }
    }

    public static void addMrpStockentry(IDataModel model, Map<String, DynamicObject> returnDataMap) {
        for (Map.Entry<String, DynamicObject> entryMap : returnDataMap.entrySet()) {
            int rowNumber = model.createNewEntryRow("mrqstockentry");
            OrderRestructureService.setMrqStockEntry(model, rowNumber, entryMap.getValue());
        }
    }

    private static void setMrqStockEntry(IDataModel model, int rowNumber, DynamicObject returnDataMap) {
        if (null != returnDataMap) {
            model.setValue("mrqmftmaterial", returnDataMap.get("entrymaterial"), rowNumber);
            model.setValue("mrqmaterial", returnDataMap.get("entrymaterialid"), rowNumber);
            model.setValue("mrqqtynumerator", returnDataMap.get("entryqtynumerator"), rowNumber);
            model.setValue("mrqqtydenominator", returnDataMap.get("entryqtydenominator"), rowNumber);
            String qtytype = "A";
            model.setValue("mrqqtytype", (Object)qtytype, rowNumber);
            model.setValue("mrqbaseunitid", returnDataMap.get("baseunit"), rowNumber);
            model.setValue("mrqfixscrap", returnDataMap.get("entryfixscrap"), rowNumber);
            model.setValue("mrqscraprate", returnDataMap.get("entryscraprate"), rowNumber);
            model.setValue("mrqprocessseq", returnDataMap.get("entryprocessseq"), rowNumber);
            model.setValue("mrqoprno", returnDataMap.get("entryoperationnumber"), rowNumber);
            Object mrqsupplymode = returnDataMap.get("entryownertype");
            model.setValue("mrqsupplymode", mrqsupplymode, rowNumber);
            Object mrqsupplyorgid = returnDataMap.get("entrysupplyorg");
            model.setValue("mrqsupplyorgid", mrqsupplyorgid, rowNumber);
            Object mrqsupplierid = returnDataMap.get("entryowner");
            if (null == mrqsupplierid && null != mrqsupplymode && StringUtils.equals((String)"bos_org", (String)mrqsupplymode.toString())) {
                mrqsupplierid = OrderRestructureService.queryAccountingByInventory(null == mrqsupplyorgid ? null : (DynamicObject)mrqsupplyorgid);
            }
            model.setValue("mrqsupplierid", mrqsupplierid, rowNumber);
            model.setValue("mrqconfiguredcode", returnDataMap.get("entryconfiguredcode"), rowNumber);
            model.setValue("mrqauxpropertyid", returnDataMap.get("entryauxproperty"), rowNumber);
            model.setValue("mrqsourcetype", (Object)"B", rowNumber);
        }
    }

    public static void addRetstockentryFromStock(IDataModel model, Map<String, DynamicObject> stockEntryMap) {
        if (null != stockEntryMap) {
            for (Map.Entry<String, DynamicObject> entryMap : stockEntryMap.entrySet()) {
                int rowNumber = model.createNewEntryRow("retstockentry");
                OrderRestructureService.setRetStockEntryFromStock(model, rowNumber, entryMap.getValue());
            }
        }
    }

    private static void setRetStockEntryFromStock(IDataModel model, int rowNumber, DynamicObject stockEntry) {
        if (null != stockEntry) {
            model.setValue("retmftmaterial", stockEntry.get("materialid"), rowNumber);
            model.setValue("retmaterial", stockEntry.get("materielmasterid"), rowNumber);
            model.setValue("retqtynumerator", (Object)BigDecimal.ZERO, rowNumber);
            model.setValue("retqtydenominator", model.getValue("pbrestructurqty"), rowNumber);
            model.setValue("retqtytype", stockEntry.get("qtytype"), rowNumber);
            model.setValue("retmaterialunitid", stockEntry.get("materialunitid"), rowNumber);
            model.setValue("retoprparent", stockEntry.get("processseq"), rowNumber);
            model.setValue("retoprno", stockEntry.get("oprno"), rowNumber);
            model.setValue("retsupplymode", stockEntry.get("supplymode"), rowNumber);
            model.setValue("retsupplierid", stockEntry.get("supplierid"), rowNumber);
            model.setValue("retsupplyorgid", stockEntry.get("supplyorgid"), rowNumber);
            model.setValue("retconfiguredcode", stockEntry.get("entryconfiguredcode"), rowNumber);
            model.setValue("retauxpropertyid", stockEntry.get("childauxpropertyid"), rowNumber);
            model.setValue("retsourcetype", (Object)"C", rowNumber);
            BigDecimal actissueqty = stockEntry.getBigDecimal("actissueqty");
            BigDecimal rejectedqty = stockEntry.getBigDecimal("rejectedqty");
            BigDecimal feedingqty = stockEntry.getBigDecimal("feedingqty");
            model.setValue("retreceivedbaseqty", (Object)actissueqty.subtract(rejectedqty).add(feedingqty), rowNumber);
        }
    }

    public static void addScrapStockentryFromStock(IDataModel model, Map<String, DynamicObject> stockEntryMap) {
        for (Map.Entry<String, DynamicObject> entryMap : stockEntryMap.entrySet()) {
            int rowNumber = model.createNewEntryRow("scrapstockentry");
            OrderRestructureService.setScrapStockEntryFromStock(model, rowNumber, entryMap.getValue());
        }
    }

    private static void setScrapStockEntryFromStock(IDataModel model, int rowNumber, DynamicObject stockEntry) {
        if (null != stockEntry) {
            model.setValue("scrapmftmaterial", stockEntry.get("materialid"), rowNumber);
            model.setValue("scrapmaterial", stockEntry.get("materielmasterid"), rowNumber);
            model.setValue("scrapqtynumerator", (Object)BigDecimal.ZERO, rowNumber);
            model.setValue("scrapqtydenominator", model.getValue("pbrestructurqty"), rowNumber);
            model.setValue("scrapqtytype", stockEntry.get("qtytype"), rowNumber);
            model.setValue("scrapmaterialunit", stockEntry.get("materialunitid"), rowNumber);
            model.setValue("scrapoprparent", stockEntry.get("processseq"), rowNumber);
            model.setValue("scrapoprno", stockEntry.get("oprno"), rowNumber);
            model.setValue("scrapsupplymode", stockEntry.get("supplymode"), rowNumber);
            model.setValue("scrapsupplierid", stockEntry.get("supplierid"), rowNumber);
            model.setValue("scrapsupplyorgid", stockEntry.get("supplyorgid"), rowNumber);
            model.setValue("scrapconfiguredcode", stockEntry.get("entryconfiguredcode"), rowNumber);
            model.setValue("scrapauxpropertyid", stockEntry.get("childauxpropertyid"), rowNumber);
            model.setValue("scrapsourcetype", (Object)"C", rowNumber);
            BigDecimal actissueqty = stockEntry.getBigDecimal("actissueqty");
            BigDecimal rejectedqty = stockEntry.getBigDecimal("rejectedqty");
            BigDecimal feedingqty = stockEntry.getBigDecimal("feedingqty");
            model.setValue("scrapreceivedbaseqty", (Object)actissueqty.subtract(rejectedqty).add(feedingqty), rowNumber);
        }
    }

    public static Set<String> getAllProperties(String entityKey) {
        HashSet<String> set = new HashSet<String>(16);
        Set<String> stockFields = OrderRestructureService.getAllFields(entityKey);
        for (String fields : stockFields) {
            set.add(fields);
        }
        return set;
    }

    public static Set<String> getAllFields(String entityKey) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityKey);
        Set<String> keySet = mainType.getFields().keySet();
        return keySet;
    }

    public static void updateSrcOrder(List<DynamicObject> orderBills, List<DynamicObject> orderRestructureOrderBills, Set<Long> srcOrderEntryIds) {
        DynamicObject[] manftechs;
        HashMap<Long, DynamicObject> orderEntryMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject orderBill : orderBills) {
            DynamicObjectCollection orderEntrys = orderBill.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject orderEntry : orderEntrys) {
                Long orderEntryId = orderEntry.getLong("id");
                orderEntryMap.put(orderEntryId, orderEntry);
                DynamicObject orderRestructureOrderBill = OrderRestructureService.matchorderRestructureOrderBill(orderEntryId, orderRestructureOrderBills);
                if (null == orderRestructureOrderBill) continue;
                DynamicObject material = orderEntry.getDynamicObject("material");
                if (null != material) {
                    material = material.getDynamicObject("masterid");
                }
                DynamicObject unit = orderEntry.getDynamicObject("unit");
                DynamicObject baseUnit = orderEntry.getDynamicObject("baseunit");
                BigDecimal pbrestructurqty = orderRestructureOrderBill.getBigDecimal("pbrestructurqty");
                BigDecimal pbrestructurBaseqty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)unit, (BigDecimal)pbrestructurqty, (DynamicObject)baseUnit);
                orderEntry.set("totalsplitqty", (Object)orderEntry.getBigDecimal("totalsplitqty").add(pbrestructurqty));
                orderEntry.set("totalsplitbaseqty", (Object)orderEntry.getBigDecimal("totalsplitbaseqty").add(pbrestructurBaseqty));
            }
        }
        QFilter filter = new QFilter("mftentryseq", "in", srcOrderEntryIds);
        String selectPro = OrderSplitTechnicsHelper.getAllProperties((String)"sfc_manftech", (String[])new String[]{"oprentryentity", "proentryentity", "ressubentryentity", "actsubentryentity", "repsubentryentity"});
        for (DynamicObject manftech : manftechs = BusinessDataServiceHelper.load((String)"sfc_manftech", (String)selectPro, (QFilter[])new QFilter[]{filter})) {
            DynamicObject mftentryseq = manftech.getDynamicObject("mftentryseq");
            if (null == mftentryseq) continue;
            Long orderEntryId = mftentryseq.getLong("id");
            DynamicObject orderRestructureOrderBill = OrderRestructureService.matchorderRestructureOrderBill(orderEntryId, orderRestructureOrderBills);
            DynamicObject orderEntry = (DynamicObject)orderEntryMap.get(orderEntryId);
            if (null == orderRestructureOrderBill || null == orderEntry) continue;
            DynamicObjectCollection manftechcols = manftech.getDynamicObjectCollection("oprentryentity");
            for (DynamicObject manftechcol : manftechcols) {
                BigDecimal totalsplitbaseqty = manftechcol.getBigDecimal("oprtotalsplitbaseqty");
                DynamicObject material = orderEntry.getDynamicObject("material");
                if (null != material) {
                    material = material.getDynamicObject("masterid");
                }
                DynamicObject unit = orderEntry.getDynamicObject("unit");
                DynamicObject baseUnit = orderEntry.getDynamicObject("baseunit");
                BigDecimal pbrestructurqty = orderRestructureOrderBill.getBigDecimal("pbrestructurqty");
                BigDecimal pbrestructurBaseqty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)unit, (BigDecimal)pbrestructurqty, (DynamicObject)baseUnit);
                totalsplitbaseqty = totalsplitbaseqty.add(pbrestructurBaseqty);
                manftechcol.set("oprtotalsplitbaseqty", (Object)totalsplitbaseqty);
                Map map = OprUnitHelper.getManftechMap((DynamicObject)manftech, (DynamicObject)manftechcol);
                manftechcol.set("oprtotalsplitqty", (Object)OprUnitHelper.getOprQty((Map)map, (BigDecimal)totalsplitbaseqty));
                String status = OrderRestructureService.setOprstatus(manftechcol);
                if (!StringUtils.isNotBlank((String)status)) continue;
                manftechcol.set("oprstatus", (Object)status);
            }
        }
        SaveServiceHelper.save((DynamicObject[])orderBills.toArray(new DynamicObject[0]));
        SaveServiceHelper.save((DynamicObject[])manftechs);
    }

    private static String setOprstatus(DynamicObject oprentry) {
        String oprstatus = "";
        if (null != oprentry) {
            BigDecimal oprtotalreportqty;
            BigDecimal oprqty = oprentry.getBigDecimal("oprqty");
            if (oprqty.compareTo(oprtotalreportqty = oprentry.getBigDecimal("oprtotalreportqty")) == 0) {
                oprstatus = "F";
            } else if (oprqty.compareTo(oprtotalreportqty) < 0 && oprtotalreportqty.compareTo(BigDecimal.ZERO) > 0) {
                oprstatus = "E";
            }
        }
        return oprstatus;
    }

    public static DynamicObject matchOrderByOrderEntryId(Long srcOrderEntryId, List<DynamicObject> orderList) {
        DynamicObject result = null;
        block0: for (DynamicObject order : orderList) {
            DynamicObjectCollection orderEntrys = order.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject orderEntry : orderEntrys) {
                if (!srcOrderEntryId.equals(orderEntry.getLong("id"))) continue;
                result = order;
                continue block0;
            }
        }
        return result;
    }

    public static boolean isNeedTechEntry(DynamicObject oprentry) {
        boolean result = false;
        if (null != oprentry) {
            result = !Arrays.asList("F", "G").contains(oprentry.getString("oprstatus")) && !oprentry.getBoolean("oprinvalid");
        }
        return result;
    }

    public static DynamicObject queryMftStockForReceivedBaseQty(Long orderEntryId) {
        DynamicObject stockBill = null;
        if (null != orderEntryId) {
            String stockEntityId = "pom_mftstock";
            String selectProperties = "stockentry.materialid,stockentry.processseq,stockentry.oprno,stockentry.actissueqty,stockentry.rejectedqty,stockentry.entryconfiguredcode,stockentry.feedingqty";
            stockBill = BusinessDataServiceHelper.loadSingleFromCache((String)stockEntityId, (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("orderentryid", "=", (Object)orderEntryId)});
        }
        return stockBill;
    }

    public static BigDecimal calPickedBaseQty(DynamicObject material, DynamicObject stockBill) {
        return BigDecimal.ZERO;
    }

    public static BigDecimal calReceivedBaseQty(Long mftMaterialId, String oprparent, String oprno, DynamicObject configureCode, DynamicObject stockBill) {
        BigDecimal receivedBaseQty = BigDecimal.ZERO;
        if (null != mftMaterialId && StringUtils.isNotBlank((String)oprparent) && StringUtils.isNotBlank((String)oprno) && null != stockBill) {
            DynamicObjectCollection stockBillEntrys = stockBill.getDynamicObjectCollection("stockentry");
            for (DynamicObject stockBillEntry : stockBillEntrys) {
                DynamicObject mftMaterialInStockEntry = stockBillEntry.getDynamicObject("materialid");
                String oprparentInStockEntry = stockBillEntry.getString("processseq");
                String oprnoInStockEntry = stockBillEntry.getString("oprno");
                BigDecimal actissueqty = stockBillEntry.getBigDecimal("actissueqty");
                BigDecimal rejectedqty = stockBillEntry.getBigDecimal("rejectedqty");
                BigDecimal feedingqty = stockBillEntry.getBigDecimal("feedingqty");
                DynamicObject entryconfiguredcode = stockBillEntry.getDynamicObject("entryconfiguredcode");
                if (null == mftMaterialInStockEntry || !mftMaterialId.equals(mftMaterialInStockEntry.getLong("id")) || !StringUtils.equals((String)oprparent, (String)oprparentInStockEntry) || !StringUtils.equals((String)oprno, (String)oprnoInStockEntry) || (null != entryconfiguredcode || null != configureCode) && (null == entryconfiguredcode || null == configureCode || !StringUtils.equals((String)entryconfiguredcode.getString("id"), (String)configureCode.getString("id")))) continue;
                receivedBaseQty = receivedBaseQty.add(actissueqty).subtract(rejectedqty).add(feedingqty);
            }
        }
        return receivedBaseQty;
    }

    public static boolean checkIsLoaded(DynamicObject restructBill) {
        boolean isLoadedFlag = false;
        if (null != restructBill) {
            DynamicObjectCollection mrqStockEntrys = restructBill.getDynamicObjectCollection("mrqstockentry");
            for (DynamicObject mrqStockEntry : mrqStockEntrys) {
                if (!StringUtils.equals((String)"E", (String)mrqStockEntry.getString("mrqsourcetype"))) continue;
                isLoadedFlag = true;
                break;
            }
            DynamicObjectCollection toTechEntrys = restructBill.getDynamicObjectCollection("toentryentity");
            for (DynamicObject toTechEntry : toTechEntrys) {
                if (!StringUtils.equals((String)"B", (String)toTechEntry.getString("tosourcetype"))) continue;
                isLoadedFlag = true;
                break;
            }
        }
        return isLoadedFlag;
    }

    public static List<DynamicObject> queryOrderBillsByRestructIds(Set<String> restructIds) {
        List<DynamicObject> orderBills = new ArrayList<DynamicObject>(16);
        if (null != restructIds && restructIds.size() > 0) {
            String selectPro = OrderSpliteService.getBillAllPropers((String)"pom_mftorder", (String[])new String[]{"treeentryentity"});
            QFilter qFilter = new QFilter("treeentryentity.sourceentryseq", "in", restructIds);
            DynamicObject[] mftorderBillForPks = BusinessDataServiceHelper.load((String)"pom_mftorder", (String)selectPro, (QFilter[])new QFilter[]{qFilter});
            orderBills = Arrays.asList(mftorderBillForPks);
        }
        return orderBills;
    }

    public static void clearOrderRestructInfo(List<DynamicObject> orderBills) {
        if (null != orderBills && orderBills.size() > 0) {
            for (DynamicObject orderBill : orderBills) {
                DynamicObjectCollection orderEntrys = orderBill.getDynamicObjectCollection("treeentryentity");
                for (DynamicObject orderEntry : orderEntrys) {
                    orderEntry.set("sourcebilltype", null);
                    orderEntry.set("sourcebillnumber", null);
                    orderEntry.set("sourceentryseq", null);
                }
            }
            SaveServiceHelper.update((DynamicObject[])orderBills.toArray(new DynamicObject[orderBills.size()]));
        }
    }

    public static List<Long> genLongIds(String entityId, int size) {
        ArrayList<Long> result = new ArrayList<Long>(10);
        if (StringUtils.isNotBlank((String)entityId) && size > 0) {
            long[] genLongIds;
            ORM orm = ORM.create();
            for (long id : genLongIds = orm.genLongIds(entityId, size)) {
                result.add(id);
            }
        }
        return result;
    }

    public static void deleteOrderPre(List<DynamicObject> restructBills) {
        HashSet<String> restructIds = new HashSet<String>(16);
        for (DynamicObject orderRestructureBill : restructBills) {
            restructIds.add(orderRestructureBill.getString("id"));
        }
        List<DynamicObject> orderBills = OrderRestructureService.queryOrderBillsByRestructIds(restructIds);
        OrderRestructureService.clearOrderRestructInfo(orderBills);
        HashSet<Long> orderIds = new HashSet<Long>(16);
        for (DynamicObject orderBill : orderBills) {
            orderIds.add(orderBill.getLong("id"));
        }
        OrderRestructureService.deleteTempOrder(orderIds);
    }

    public static void deleteXOrder(List<DynamicObject> restructBills) {
        HashSet<Long> xOrderIds = new HashSet<Long>(16);
        HashSet<Long> deleteOrderIds = new HashSet<Long>(16);
        HashSet<Long> unSubmitOrderIds = new HashSet<Long>(16);
        for (DynamicObject orderRestructureBill : restructBills) {
            xOrderIds.add(orderRestructureBill.getLong("pbxorderid"));
        }
        QFilter qf = new QFilter("id", "in", xOrderIds);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryPomXorder", (String)"pom_xmftorder", (String)"id,billstatus", (QFilter[])qf.toArray(), (String)"");
        for (Row row : dataSet) {
            if (StringUtils.equals((String)"B", (String)row.getString("billstatus"))) {
                unSubmitOrderIds.add(row.getLong("id"));
            }
            if (!StringUtils.equals((String)"A", (String)row.getString("billstatus"))) continue;
            deleteOrderIds.add(row.getLong("id"));
        }
        if (unSubmitOrderIds.size() > 0) {
            OrderRestructureService.submitXmftorderBills(unSubmitOrderIds, "unsubmit", ResManager.loadKDString((String)"\u64a4\u9500", (String)"OrderRestructureService_10", (String)"mmc-pom-business", (Object[])new Object[0]));
            deleteOrderIds.addAll(unSubmitOrderIds);
        }
        if (deleteOrderIds.size() > 0) {
            OrderRestructureService.submitXmftorderBills(deleteOrderIds, "delete", ResManager.loadKDString((String)"\u5220\u9664", (String)"OrderRestructureService_11", (String)"mmc-pom-business", (Object[])new Object[0]));
        }
    }

    public static void deleteStockEntrys(List<DynamicObject> orderRestructureBills) {
        HashSet<Long> srcOrderEntryIds = new HashSet<Long>(16);
        HashSet<Long> needDeleteStockEntryIds = new HashSet<Long>(16);
        for (DynamicObject orderRestructureBill : orderRestructureBills) {
            Object stockEntry2;
            DynamicObject pborderentryid = orderRestructureBill.getDynamicObject("pborderentryid");
            if (null != pborderentryid) {
                srcOrderEntryIds.add(pborderentryid.getLong("id"));
            }
            DynamicObjectCollection retstockentrys = orderRestructureBill.getDynamicObjectCollection("retstockentry");
            for (Object stockEntry2 : retstockentrys) {
                needDeleteStockEntryIds.add(stockEntry2.getLong("retstockentryid"));
            }
            DynamicObjectCollection scrapstockentrys = orderRestructureBill.getDynamicObjectCollection("scrapstockentry");
            stockEntry2 = scrapstockentrys.iterator();
            while (stockEntry2.hasNext()) {
                DynamicObject stockEntry3 = (DynamicObject)stockEntry2.next();
                needDeleteStockEntryIds.add(stockEntry3.getLong("scrapstockentryid"));
            }
            DynamicObjectCollection mrqstockentrys = orderRestructureBill.getDynamicObjectCollection("mrqstockentry");
            for (DynamicObject stockEntry4 : mrqstockentrys) {
                needDeleteStockEntryIds.add(stockEntry4.getLong("mrqbomentryid"));
            }
        }
        if (srcOrderEntryIds.size() > 0) {
            DynamicObject[] stockBills;
            for (DynamicObject stockBill : stockBills = BusinessDataServiceHelper.load((String)"pom_mftstock", (String)StockCulUtils.selectStockProperties((String)"pom_mftstock"), (QFilter[])new QFilter[]{new QFilter("orderentryid", "in", srcOrderEntryIds)})) {
                ArrayList<DynamicObject> needDeleteEntrys = new ArrayList<DynamicObject>(10);
                DynamicObjectCollection stockentrys = stockBill.getDynamicObjectCollection("stockentry");
                for (DynamicObject stockentry : stockentrys) {
                    if (!needDeleteStockEntryIds.contains(stockentry.getLong("id"))) continue;
                    needDeleteEntrys.add(stockentry);
                }
                stockentrys.removeAll(needDeleteEntrys);
            }
            SaveServiceHelper.update((DynamicObject[])stockBills);
        }
    }

    public static void restructOpRollBack(List<DynamicObject> restructBills) {
        if (null != restructBills && restructBills.size() > 0) {
            OrderRestructureService.deleteStockEntrys(restructBills);
            OrderRestructureService.deleteOrderPre(restructBills);
            OrderRestructureService.deleteXOrder(restructBills);
        }
    }

    public static void createRestructToEntity(List<DynamicObject> restructBills) {
        if (CollectionUtils.isNotEmpty(restructBills)) {
            HashSet<Long> processRouteIds = new HashSet<Long>(16);
            for (DynamicObject restructBill : restructBills) {
                DynamicObject paprocessroute = restructBill.getDynamicObject("paprocessroute");
                if (null == paprocessroute) continue;
                processRouteIds.add(paprocessroute.getLong("id"));
            }
            if (CollectionUtils.isNotEmpty(processRouteIds)) {
                QFilter filter = new QFilter("id", "in", processRouteIds);
                Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"pdm_route", (QFilter[])new QFilter[]{filter});
                for (DynamicObject restructureBill : restructBills) {
                    DynamicObject paprocessroute = restructureBill.getDynamicObject("paprocessroute");
                    if (null == paprocessroute) continue;
                    paprocessroute = (DynamicObject)objectDynamicObjectMap.get(paprocessroute.getPkValue());
                    int seq = restructureBill.getDynamicObjectCollection("toentryentity").size();
                    for (int i = 0; i < paprocessroute.getDynamicObjectCollection("processentry").size(); ++i) {
                        DynamicObject processRouteEntryObj = (DynamicObject)paprocessroute.getDynamicObjectCollection("processentry").get(i);
                        DynamicObject pdmRouteEntry = null;
                        DynamicObjectCollection pdmRouteEntrys = paprocessroute.getDynamicObjectCollection("entryentity");
                        for (DynamicObject routeEntry : pdmRouteEntrys) {
                            if (!StringUtils.equals((String)processRouteEntryObj.getString("parent"), (String)routeEntry.getString("processseq"))) continue;
                            pdmRouteEntry = routeEntry;
                            break;
                        }
                        DynamicObject newEntryObj = restructureBill.getDynamicObjectCollection("toentryentity").addNew();
                        ManuftechCreateBillUtil.setRestructureOprEntryEntityValue((DynamicObject)processRouteEntryObj, pdmRouteEntry, (DynamicObject)newEntryObj);
                        newEntryObj.set("seq", (Object)(++seq));
                    }
                }
            }
        }
    }

    public static DynamicObject queryAccountingByInventory(DynamicObject orgObj) {
        Long orgId;
        DynamicObject accountingOrg = null;
        if (null != orgObj && null == (accountingOrg = InvBillBotpHelper.getAccountByOrg((Long)(orgId = Long.valueOf(orgObj.getLong("id"))), (String)"05"))) {
            ArrayList<String> propertyNameList = new ArrayList<String>();
            propertyNameList.add("fisaccounting");
            Map orgProperty = OrgUnitServiceHelper.getOrgProperty((long)orgId, propertyNameList);
            Boolean fIsAccounting = (Boolean)orgProperty.get("fisaccounting");
            if (fIsAccounting.booleanValue()) {
                accountingOrg = orgObj;
            }
        }
        return accountingOrg;
    }
}

