/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.prop.opplugin.botp;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class PropOrderToInBillConvertPlugin
extends AbstractConvertPlugIn {
    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntitySet dataEntitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] byEntityKey = dataEntitySet.FindByEntityKey("billentry");
        if (byEntityKey == null || byEntityKey.length == 0) {
            return;
        }
        for (ExtendedDataEntity entity : byEntityKey) {
            DynamicObject billentry = entity.getDataEntity();
            DynamicObject material = billentry.getDynamicObject("material");
            if (material == null) continue;
            DynamicObject masterId = material.getDynamicObject("masterid");
            billentry.set("unit", (Object)material.getDynamicObject("inventoryunit"));
            if (masterId.getDynamicObject("auxptyunit") != null) {
                billentry.set("unit2nd", (Object)masterId.getDynamicObject("auxptyunit"));
            }
            DynamicObject unit = billentry.getDynamicObject("unit");
            DynamicObject baseunit = billentry.getDynamicObject("baseunit");
            BigDecimal baseqty = billentry.getBigDecimal("baseqty");
            billentry.set("qty", (Object)this.getQtyByUnit(masterId, baseunit, unit, baseqty));
            billentry.set("baseqty", (Object)this.processPrecision(baseqty, baseunit));
        }
    }

    private BigDecimal getQtyByUnit(DynamicObject masterid, DynamicObject baseunit, DynamicObject unit, BigDecimal baseqty) {
        if (unit == null || masterid == null || baseunit == null || baseqty == null) {
            return BigDecimal.ZERO;
        }
        DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)((Long)masterid.getPkValue()), (Long)((Long)baseunit.getPkValue()), (Long)((Long)unit.getPkValue()));
        if (muConv == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal numerator = muConv.getBigDecimal("numerator");
        BigDecimal denominator = muConv.getBigDecimal("denominator");
        int precision = unit.getInt("precision");
        return baseqty.multiply(numerator).divide(denominator, precision, this.getRoundType(unit));
    }

    private BigDecimal processPrecision(BigDecimal qty, DynamicObject unit) {
        int precision = unit.getInt("precision");
        return qty.setScale(precision, this.getRoundType(unit));
    }

    private int getRoundType(DynamicObject unit) {
        String precisionAccount = unit.getString("precisionaccount");
        int roundType = 0;
        switch (precisionAccount) {
            case "1": {
                roundType = 4;
                break;
            }
            case "2": {
                roundType = 1;
                break;
            }
            case "3": {
                roundType = 0;
                break;
            }
        }
        return roundType;
    }
}

