/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.prop.opplugin.botp;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.helper.DateChangeProHelper;
import kd.bd.mpdm.common.utils.DateUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mmc.prop.business.helper.PropMftOrderReportHelper;

public class PropOrderToOrderReportPlugin
extends AbstractConvertPlugIn {
    private static Log logger = LogFactory.getLog(PropOrderToOrderReportPlugin.class);

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        super.beforeBuildRowCondition(e);
        e.setCustFilterDesc(ResManager.loadKDString((String)"\uff08\u5206\u5f55\u63a7\u5236\u6c47\u62a5\u6570\u91cf \u7b49\u4e8e \u662f and \u5206\u5f55\uff08\u7d2f\u8ba1\uff09\u6c47\u62a5\u6570\u91cf \u5c0f\u4e8e \u6c47\u62a5\u4e0a\u9650\u6570\u91cf) or \u5206\u5f55\u63a7\u5236\u6c47\u62a5\u6570\u91cf \u7b49\u4e8e \u5426", (String)"OrderToOrderReportPlugin_0", (String)"mmc-prop-opplugin", (Object[])new Object[0]));
        e.setCustFilterExpression(" (treeentryentity.isconreportqty = true and treeentryentity.reportqty < treeentryentity.repmaxqty) or treeentryentity.isconreportqty = false");
        QFilter isconreportqtyTrue = new QFilter(" treeentryentity.isconreportqty", "=", (Object)true);
        QFilter lessRepmaxqty = new QFilter("treeentryentity.reportqty", "<", (Object)"treeentryentity.repmaxqty", true);
        QFilter isconreportqtyFalse = new QFilter(" treeentryentity.isconreportqty", "=", (Object)false);
        QFilter qFilter = isconreportqtyTrue.and(lessRepmaxqty).or(isconreportqtyFalse);
        e.getCustQFilters().add(qFilter);
    }

    public void afterConvert(AfterConvertEventArgs e) {
        Serializable reportDate;
        super.afterConvert(e);
        String tgtMainType = this.getTgtMainType().toString();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(tgtMainType);
        ArrayList<Long> mftOrderIdsList = new ArrayList<Long>(10);
        HashMap<String, Date> cacheBookDateMap = new HashMap<String, Date>(16);
        for (ExtendedDataEntity extendedDataEntity : billDataEntitys) {
            reportDate = extendedDataEntity.getDataEntity().getDate("reportdate");
            extendedDataEntity.setValue("bookdate", (Object)this.getBookDate((Date)reportDate, extendedDataEntity.getDataEntity().getDynamicObject("org").getLong("id"), cacheBookDateMap));
            DynamicObjectCollection sumentrys = (DynamicObjectCollection)extendedDataEntity.getValue("sumentry");
            for (DynamicObject row : sumentrys) {
                if (null == row || 0L == row.getLong("mftentryid")) continue;
                mftOrderIdsList.add(row.getLong("mftentryid"));
            }
        }
        if (!mftOrderIdsList.isEmpty()) {
            String selectPro = "treeentryentity.processroute,treeentryentity.id,treeentryentity.planbegintime,treeentryentity.planendtime,treeentryentity.routereplace,treeentryentity.programme";
            QFilter qf = new QFilter("treeentryentity.id", "in", mftOrderIdsList);
            HashMap<Long, Map<String, Object>> dsMap = new HashMap(16);
            DataSet mftOrderEntryDataSets = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"prop_mftorder", (String)selectPro, (QFilter[])qf.toArray(), null);
            reportDate = null;
            try {
                dsMap = this.convertDsToMap(mftOrderEntryDataSets);
            }
            catch (Throwable sumentrys) {
                reportDate = sumentrys;
                throw sumentrys;
            }
            finally {
                if (mftOrderEntryDataSets != null) {
                    if (reportDate != null) {
                        try {
                            mftOrderEntryDataSets.close();
                        }
                        catch (Throwable sumentrys) {
                            ((Throwable)reportDate).addSuppressed(sumentrys);
                        }
                    } else {
                        mftOrderEntryDataSets.close();
                    }
                }
            }
            Set<Long> routeIDSet = this.getIDSet(dsMap, "pdmRoute");
            Map<Object, DynamicObject> routeMap = this.getRouteMap(routeIDSet);
            Set<Long> programmeIdSet = this.getIDSet(dsMap, "programme");
            Map<Object, DynamicObject> programmeMap = this.getProgrammeMap(programmeIdSet);
            for (ExtendedDataEntity extendedDataEntity : billDataEntitys) {
                DynamicObject reportBill = extendedDataEntity.getDataEntity();
                Long orgId = 0L;
                if (null != reportBill && null != reportBill.getDynamicObject("org")) {
                    orgId = reportBill.getDynamicObject("org").getLong("id");
                }
                DynamicObjectCollection sumentrys = (DynamicObjectCollection)extendedDataEntity.getValue("sumentry");
                for (DynamicObject sumentry : sumentrys) {
                    DynamicObject programme;
                    Long mftOrderEntryId;
                    Map orderMap;
                    String matertype;
                    if (null == sumentry || !"C".equals(matertype = sumentry.getString("matertype")) || (orderMap = (Map)dsMap.get(mftOrderEntryId = Long.valueOf(sumentry.getLong("mftentryid")))) == null) continue;
                    Date planbegintime = null;
                    if (orderMap.get("planbegintime") != null) {
                        planbegintime = (Date)orderMap.get("planbegintime");
                    }
                    Date planendtime = null;
                    if (orderMap.get("planendtime") != null) {
                        planendtime = (Date)orderMap.get("planendtime");
                    }
                    Long programmeId = 0L;
                    if (orderMap.get("programme") == null || null == (programme = programmeMap.get(programmeId = Long.valueOf(Long.parseLong(orderMap.get("programme").toString()))))) continue;
                    this.autoCreateActEntrysByProgramme(planbegintime, planendtime, programme, sumentry, orgId);
                }
            }
        }
    }

    private Set<Long> filterByUseOrg(Set<Long> actIds, QFilter actQFilter, String baseDataName) {
        HashSet<Long> actSelectedIds = new HashSet<Long>(16);
        QFilter actQueryFilter = new QFilter("id", "in", actIds);
        if (null != actQFilter) {
            actQueryFilter.and(actQFilter);
        }
        Map actMap = BusinessDataServiceHelper.loadFromCache((String)baseDataName, (String)"id", (QFilter[])actQueryFilter.toArray());
        for (Map.Entry objectDynamicObjectEntry : actMap.entrySet()) {
            DynamicObject actObj = (DynamicObject)objectDynamicObjectEntry.getValue();
            if (null == actObj) continue;
            actSelectedIds.add(actObj.getLong("id"));
        }
        return actSelectedIds;
    }

    private Date getBookDate(Date reportDate, Long orgID, Map<String, Date> cacheBookDateMap) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date shortReportDate = DateUtils.getShortDate((Date)reportDate);
        String mapKeys = sdf.format(shortReportDate) + "_" + String.valueOf(orgID);
        Date bookDate = cacheBookDateMap.get(mapKeys);
        if (bookDate == null) {
            bookDate = DateChangeProHelper.getBookDate((Date)reportDate, (Long)orgID);
            cacheBookDateMap.put(mapKeys, bookDate);
        }
        return bookDate;
    }

    private Map<Long, Map<String, Object>> convertDsToMap(DataSet ds) {
        if (ds == null) {
            return Collections.emptyMap();
        }
        HashMap<Long, Map<String, Object>> returnMap = new HashMap<Long, Map<String, Object>>(16);
        while (ds.hasNext()) {
            Row mftOrderEntryDataSet = ds.next();
            long entryId = mftOrderEntryDataSet.getLong("treeentryentity.id");
            Date planbegintime = mftOrderEntryDataSet.getDate("treeentryentity.planbegintime");
            Date planendtime = mftOrderEntryDataSet.getDate("treeentryentity.planendtime");
            long pdmRoute = mftOrderEntryDataSet.getLong("treeentryentity.processroute");
            long programme = mftOrderEntryDataSet.getLong("treeentryentity.programme");
            HashMap<String, Comparable<Date>> paramMap = new HashMap<String, Comparable<Date>>(16);
            paramMap.put("planbegintime", planbegintime);
            paramMap.put("planendtime", planendtime);
            paramMap.put("pdmRoute", Long.valueOf(pdmRoute));
            paramMap.put("programme", Long.valueOf(programme));
            returnMap.put(entryId, paramMap);
        }
        return returnMap;
    }

    private Set<Long> getIDSet(Map<Long, Map<String, Object>> dsMap, String propKey) {
        if (dsMap == null || dsMap.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Long> rtIDSet = new HashSet<Long>(16);
        for (Map.Entry<Long, Map<String, Object>> paramMaps : dsMap.entrySet()) {
            Map<String, Object> paramMap = paramMaps.getValue();
            long pdmRoute = 0L;
            if (paramMap.get(propKey) != null) {
                pdmRoute = Long.parseLong(paramMap.get(propKey).toString());
            }
            if (0L == pdmRoute) continue;
            rtIDSet.add(pdmRoute);
        }
        return rtIDSet;
    }

    private Map<Object, DynamicObject> getRouteMap(Set<Long> rtIDSet) {
        QFilter qfilter = new QFilter("id", "in", rtIDSet);
        return BusinessDataServiceHelper.loadFromCache((String)"pdm_route", (String)"processentry,processentry.actentryentity,actentryentity.activity,actentryentity.baseqty,actentryentity.standardformula1,actentryentity.actresource,actentryentity.activity.creatorg", (QFilter[])new QFilter[]{qfilter});
    }

    private Map<Object, DynamicObject> getProgrammeMap(Set<Long> idSet) {
        QFilter qfilter = new QFilter("id", "in", idSet);
        return BusinessDataServiceHelper.loadFromCache((String)"fmm_programe", (String)"activenum,basicqty,activereportformula,resouce", (QFilter[])new QFilter[]{qfilter});
    }

    private void autoCreateActEntrysByProgramme(Date planbegintime, Date planendtime, DynamicObject Programme, DynamicObject sumentry, Long orgId) {
        int seq = 0;
        DynamicObjectCollection entryentity = Programme.getDynamicObjectCollection("entryentity");
        HashSet<Long> actIds = new HashSet<Long>(16);
        HashSet<Long> formulaIds = new HashSet<Long>(16);
        HashSet<Long> resourceIds = new HashSet<Long>(16);
        for (DynamicObject processRow : entryentity) {
            if (null == processRow) continue;
            DynamicObjectCollection activeentity = processRow.getDynamicObjectCollection("activeentity");
            for (DynamicObject activeRow : activeentity) {
                DynamicObject resouce;
                DynamicObject activereportformula;
                if (null == activeRow) continue;
                DynamicObject repactivity = activeRow.getDynamicObject("activenum");
                if (null != repactivity) {
                    actIds.add(repactivity.getLong("id"));
                }
                if (null != (activereportformula = activeRow.getDynamicObject("activereportformula"))) {
                    formulaIds.add(activereportformula.getLong("id"));
                }
                if (null == (resouce = activeRow.getDynamicObject("resouce"))) continue;
                resourceIds.add(resouce.getLong("id"));
            }
        }
        QFilter actQFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_processactivity", (Long)orgId);
        Set<Long> actSelectedIds = this.filterByUseOrg(actIds, actQFilter, "mpdm_processactivity");
        QFilter processformulaQFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_processformula", (Long)orgId);
        Set<Long> formulaSelectedIds = this.filterByUseOrg(formulaIds, processformulaQFilter, "mpdm_processformula");
        QFilter resourcesQFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_resources", (Long)orgId);
        Set<Long> resourceSelectedIds = this.filterByUseOrg(resourceIds, resourcesQFilter, "mpdm_resources");
        DynamicObjectCollection subRows = sumentry.getDynamicObjectCollection("subentryentity");
        subRows.clear();
        for (DynamicObject processRow : entryentity) {
            if (null == processRow) continue;
            DynamicObjectCollection activeentity = processRow.getDynamicObjectCollection("activeentity");
            for (DynamicObject actEntryRow : activeentity) {
                if (null == actEntryRow) continue;
                DynamicObject repactivity = actEntryRow.getDynamicObject("activenum");
                DynamicObject activereportformula = actEntryRow.getDynamicObject("activereportformula");
                DynamicObject resouce = actEntryRow.getDynamicObject("resouce");
                if (null != repactivity && !actSelectedIds.contains(repactivity.getLong("id")) || null != activereportformula && !formulaSelectedIds.contains(activereportformula.getLong("id")) || null != resouce && !resourceSelectedIds.contains(resouce.getLong("id"))) continue;
                DynamicObject subentryOrm = subRows.addNew();
                subentryOrm.set("seq", (Object)(++seq));
                subentryOrm.set("repactivity", (Object)repactivity);
                subentryOrm.set("repbaseqty", actEntryRow.get("basicqty"));
                subentryOrm.set("actstandardformula", actEntryRow.get("activereportformula"));
                subentryOrm.set("represources", actEntryRow.get("resouce"));
                subentryOrm.set("repactualbegintime", (Object)planbegintime);
                subentryOrm.set("repactualfinishtime", (Object)planendtime);
                BigDecimal repactualqty = new BigDecimal(0);
                try {
                    Object processactivityPk;
                    DynamicObject processactivity = actEntryRow.getDynamicObject("activity");
                    if (null != processactivity && null != (processactivityPk = processactivity.getPkValue())) {
                        processactivity = BusinessDataServiceHelper.loadSingleFromCache((Object)processactivityPk, (String)"mpdm_processactivity");
                        repactualqty = PropMftOrderReportHelper.runFormula((DynamicObject)subentryOrm, (DynamicObject)processactivity);
                    }
                }
                catch (Exception e) {
                    logger.info("\u516c\u5f0f\u6267\u884c\u51fa\u9519,\u8bf7\u68c0\u67e5\u516c\u5f0f\u8bed\u6cd5\u662f\u5426\u6b63\u786e", (Object)e);
                }
                subentryOrm.set("repactualqty", (Object)repactualqty);
            }
        }
    }
}

