/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.prop.opplugin.botp;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bd.mpdm.business.helper.CloseDateHelper;
import kd.bd.mpdm.business.helper.InvBillBotpHelper;
import kd.bd.mpdm.common.mftorder.helper.BillUnitAndQtytHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.UnitConvertHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class StockUnitBotpPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(StockUnitBotpPlugin.class);

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField("rework");
        e.addSrcField("orderid");
        e.addSrcField("considerminbatch");
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] entities = e.getTargetExtDataEntitySet().FindByEntityKey("billentry");
        if (entities == null || entities.length == 0) {
            return;
        }
        for (ExtendedDataEntity entity : entities) {
            DynamicObject masterId;
            DynamicObject dym = entity.getDataEntity();
            DynamicObject material = dym.getDynamicObject("material");
            if (material == null) continue;
            if (material.getDynamicObject("inventoryunit") != null) {
                entity.getDataEntity().set("unit", (Object)material.getDynamicObject("inventoryunit"));
            }
            if ((masterId = material.getDynamicObject("masterid")) == null) continue;
            if (masterId.getDynamicObject("baseunit") != null) {
                DynamicObject baseunit = masterId.getDynamicObject("baseunit");
                entity.getDataEntity().set("baseunit", (Object)baseunit);
            }
            if (masterId.getDynamicObject("auxptyunit") == null) continue;
            entity.getDataEntity().set("unit2nd", (Object)masterId.getDynamicObject("auxptyunit"));
        }
    }

    private void reCalBaseqty(DynamicObject masterId, DynamicObject dym) {
        String tgtMainType = this.getTgtMainType().toString();
        HashSet<String> billnames = new HashSet<String>();
        String field = "baseqty";
        String unit = "baseunit";
        billnames.add("im_mdc_mftomreqapplybill");
        billnames.add("im_mdc_mftproorder");
        billnames.add("im_mdc_mftfeedorder");
        if (!billnames.contains(tgtMainType)) {
            return;
        }
        Object masterIdPkValue = masterId.getPkValue();
        DynamicObject useUnit = dym.getDynamicObject(unit);
        int precision = useUnit.getInt("precision");
        int precisionaccount = useUnit.getInt("precisionaccount");
        QFilter materialInfoFiliter = new QFilter("masterid", "=", masterIdPkValue);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"query_bd_materialmftinfo", (String)"bd_materialmftinfo", (String)"minbatchnum,minbatchunit", (QFilter[])materialInfoFiliter.toArray(), null);){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                BigDecimal minBatch = next.getBigDecimal("minbatchnum") == null ? BigDecimal.ONE : next.getBigDecimal("minbatchnum");
                Long minBatchUnit = next.getLong("minbatchunit") == null ? (Long)dym.getDynamicObject("baseunit").getPkValue() : next.getLong("minbatchunit");
                DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)((Long)masterIdPkValue), (Long)minBatchUnit, (Long)((Long)useUnit.getPkValue()));
                if (muConv == null || muConv.getInt("numerator") == 0) continue;
                BigDecimal qty = dym.getBigDecimal(field);
                BigDecimal multy = qty.multiply(new BigDecimal(muConv.getInt("denominator"))).divide(minBatch.multiply(new BigDecimal(muConv.getInt("numerator"))), 0, 2);
                BigDecimal newBaseQty = multy.multiply(minBatch).multiply(new BigDecimal(muConv.getInt("numerator"))).divide(new BigDecimal(muConv.getInt("denominator")), precision, precisionaccount);
                dym.set(field, (Object)newBaseQty);
            }
        }
        if (dym.getDynamicObject("unit") != null && dym.getDynamicObject("baseunit") != null) {
            if (!dym.getDynamicObject("unit").getPkValue().equals(dym.getDynamicObject("baseunit").getPkValue())) {
                dym.set("qty", (Object)BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)masterId, (DynamicObject)dym.getDynamicObject("baseunit"), (BigDecimal)dym.getBigDecimal("baseqty"), (DynamicObject)dym.getDynamicObject("unit")));
            } else {
                dym.set("qty", (Object)dym.getBigDecimal("baseqty"));
            }
        }
        if ("im_mdc_mftomreqapplybill".equals(tgtMainType)) {
            dym.set("auditqty", (Object)dym.getBigDecimal("qty"));
            dym.set("auditbaseqty", (Object)dym.getBigDecimal("baseqty"));
            BigDecimal useoutqty = dym.getBigDecimal("useoutqty") == null ? BigDecimal.ZERO : dym.getBigDecimal("useoutqty");
            BigDecimal useoutbaseqty = dym.getBigDecimal("useoutbaseqty") == null ? BigDecimal.ZERO : dym.getBigDecimal("useoutbaseqty");
            dym.set("unpickqty", (Object)dym.getBigDecimal("auditqty").subtract(useoutqty));
            dym.set("unpickbaseqty", (Object)dym.getBigDecimal("auditbaseqty").subtract(useoutbaseqty));
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] entities = e.getTargetExtDataEntitySet().FindByEntityKey("billentry");
        Map fldProperties = e.getFldProperties();
        HashSet<Object> reworkEntrys = new HashSet<Object>(16);
        for (ExtendedDataEntity entity : entities) {
            boolean rework;
            DynamicObject masterId;
            DynamicObject wareOutEntry = entity.getDataEntity();
            DynamicObject material = wareOutEntry.getDynamicObject("material");
            if (material != null && (masterId = material.getDynamicObject("masterid")) != null) {
                boolean considerMinBatch;
                DynamicProperty dynamicProperty = (DynamicProperty)fldProperties.get("considerminbatch");
                DynamicProperty baseqtyProperty = (DynamicProperty)fldProperties.get("baseqty");
                List srcRows = (List)entity.getValue("ConvertSource");
                DynamicObject srcEntry = (DynamicObject)srcRows.get(0);
                if (dynamicProperty != null && (considerMinBatch = ((Boolean)dynamicProperty.getValue((Object)srcEntry)).booleanValue())) {
                    this.reCalBaseqty(masterId, wareOutEntry);
                }
                if (masterId.getDynamicObject("auxptyunit") != null) {
                    BigDecimal baseQty = wareOutEntry.getBigDecimal("baseqty");
                    long auxptyUnitId = masterId.getDynamicObject("auxptyunit").getLong("id");
                    long baseUnitId = masterId.getDynamicObject("baseunit").getLong("id");
                    long id = masterId.getLong("id");
                    wareOutEntry.set("qtyunit2nd", (Object)UnitConvertHelper.calculateNewQty((BigDecimal)baseQty, (Long)auxptyUnitId, (Long)baseUnitId, (Long)id, (StringBuilder)new StringBuilder()));
                }
            }
            DynamicProperty dynamicProperty = (DynamicProperty)fldProperties.get("rework");
            List srcRows = (List)entity.getValue("ConvertSource");
            DynamicObject srcEntry = (DynamicObject)srcRows.get(0);
            if (dynamicProperty == null || !(rework = ((Boolean)dynamicProperty.getValue((Object)srcEntry)).booleanValue())) continue;
            reworkEntrys.add(wareOutEntry.get("srcbillentryid"));
        }
        String tgtMainType = this.getTgtMainType().toString();
        ExtendedDataEntity[] entitys = e.getTargetExtDataEntitySet().FindByEntityKey(tgtMainType);
        DynamicProperty orderidPro = (DynamicProperty)fldProperties.get("orderid");
        HashSet<Long> orderIds = new HashSet<Long>(entitys.length);
        HashSet<Long> orgIds = new HashSet<Long>(entitys.length);
        HashSet<Long> invSchemeIds = new HashSet<Long>(entitys.length);
        for (int i = 0; i < entitys.length; ++i) {
            DynamicObject obj = entitys[i].getDataEntity();
            if (obj.getDynamicObject("org") != null) {
                orgIds.add(obj.getDynamicObject("org").getLong("id"));
            }
            if (obj.getDynamicObjectType().getProperties().containsKey((Object)"invscheme") && obj.getDynamicObject("invscheme") != null) {
                invSchemeIds.add(obj.getDynamicObject("invscheme").getLong("id"));
            }
            List srcRows = (List)entitys[i].getValue("ConvertSource");
            DynamicObject srcrow = (DynamicObject)srcRows.get(0);
            if (orderidPro == null || orderidPro.getValue((Object)srcrow) == null) continue;
            long orderid = Long.parseLong(orderidPro.getValue((Object)srcrow).toString());
            orderIds.add(orderid);
        }
        Map sourceBills = BFTrackerServiceHelper.findDirtSourceBills((String)"pom_mftorder", (Long[])orderIds.toArray(new Long[orderIds.size()]));
        HashMap currencyMap = new HashMap(128);
        if (CollectionUtils.isNotEmpty(orgIds)) {
            for (Long orgId : orgIds) {
                currencyMap.put(orgId, InvBillBotpHelper.getCurrencyAndExRateTable((Long)orgId).get("baseCurrencyID"));
            }
        }
        HashSet baseCurrencyIds = new HashSet(currencyMap.values());
        QFilter filter = new QFilter("id", "in", baseCurrencyIds);
        Map bdCurrency = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (QFilter[])new QFilter[]{filter});
        Map invSchemeMap = InvBillBotpHelper.getInvScheme(invSchemeIds);
        DynamicObject unqualifiedInvstatus = BusinessDataServiceHelper.loadSingleFromCache((Object)1536101894978546688L, (String)"bd_invstatus");
        for (int i = 0; i < entitys.length; ++i) {
            ExtendedDataEntity entity = entitys[i];
            DynamicObject obj = entity.getDataEntity();
            DynamicObject org = obj.getDynamicObject("org");
            if (org != null) {
                Long currencyId = (Long)currencyMap.get(org.getLong("id"));
                obj.set("settlecurrency", bdCurrency.get(currencyId));
            }
            if (obj.getDynamicObjectType().getProperties().containsKey((Object)"invscheme") && obj.getDynamicObject("invscheme") != null) {
                DynamicObjectCollection billEntry = obj.getDynamicObjectCollection("billentry");
                DynamicObject invScheme = (DynamicObject)invSchemeMap.get(obj.getDynamicObject("invscheme").getPkValue());
                obj.set("supplyownertype", invScheme.get("outownertype"));
                DynamicObjectCollection outInvTypeEntry = invScheme.getDynamicObjectCollection("outinvtypeentry");
                List outinvtypeisdefault = outInvTypeEntry.stream().filter(var -> var.getBoolean("outinvtypeisdefault")).collect(Collectors.toList());
                DynamicObjectCollection outInvStatusEntry = invScheme.getDynamicObjectCollection("outinvstatusentry");
                List outinvstatus = outInvStatusEntry.stream().map(var -> var.getDynamicObject("outinvstatus").getPkValue()).collect(Collectors.toList());
                List outinvstatusisdefault = outInvStatusEntry.stream().filter(var -> var.getBoolean("outinvstatusisdefault")).collect(Collectors.toList());
                for (DynamicObject dynamicObject : billEntry) {
                    dynamicObject.set("outownertype", invScheme.get("outownertype"));
                    boolean sourceOrderRework = this.isSourceOrderRework(entity, orderidPro, sourceBills);
                    Object entryPk = dynamicObject.get("srcbillentryid");
                    if (sourceOrderRework && reworkEntrys.contains(entryPk)) {
                        if (!outinvstatus.contains(1536101894978546688L)) {
                            throw new KDBizException(new ErrorCode("convert exception", String.format(ResManager.loadKDString((String)"\u8fd4\u5de5\u9886\u6599\u51fa\u5e93\u65f6\u5e93\u5b58\u4e8b\u52a1\u3010%1$s\u3011\u51fa\u5e93\u5e93\u5b58\u72b6\u6001\u65e0\u2018\u4e0d\u826f\u2019\u72b6\u6001\u503c", (String)"StockUnitBotpPlugin_0", (String)"mmc-pom-opplugin", (Object[])new Object[0]), invScheme.get("name"))), new Object[0]);
                        }
                        dynamicObject.set("outinvstatus", (Object)unqualifiedInvstatus);
                        continue;
                    }
                    if (!CollectionUtils.isNotEmpty(outinvstatusisdefault)) continue;
                    dynamicObject.set("outinvstatus", ((DynamicObject)outinvstatusisdefault.get(0)).get("outinvstatus"));
                }
            }
            CloseDateHelper.initBookDate((String)tgtMainType, (DynamicObject)obj, (BillEntityType)this.getSrcMainType());
        }
    }

    private boolean isSourceOrderRework(ExtendedDataEntity entity, DynamicProperty orderidPro, Map<Long, List<BFRow>> sourceBills) {
        if (sourceBills == null || sourceBills.size() < 1) {
            return false;
        }
        List srcRows = (List)entity.getValue("ConvertSource");
        DynamicObject srcrow = (DynamicObject)srcRows.get(0);
        long orderid = 0L;
        if (orderidPro != null && orderidPro.getValue((Object)srcrow) != null) {
            orderid = Long.parseLong(orderidPro.getValue((Object)srcrow).toString());
        }
        if (orderid != 0L) {
            List<BFRow> bfRows = sourceBills.get(orderid);
            if (bfRows == null || bfRows.size() < 1) {
                return false;
            }
            for (BFRow bfRow : bfRows) {
                BFRowId sId = bfRow.getSId();
                Long mainTableId = sId.getMainTableId();
                TableDefine tableDefine = ConvertMetaServiceHelper.loadTableDefine((Long)mainTableId);
                String entityNumber = tableDefine.getEntityNumber();
                if (!StringUtils.equals((CharSequence)"pom_mftorder", (CharSequence)entityNumber)) continue;
                return true;
            }
        }
        return false;
    }
}

