/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.prop.opplugin.mftreport.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class PropMftorderReptBillValidator
extends AbstractValidator {
    public void validate() {
        HashSet<Long> mftentryIdSet = new HashSet<Long>(16);
        String operate = this.getOperateKey();
        ArrayList<DynamicObject> mftEntryObjList = new ArrayList<DynamicObject>(16);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject dynObj = this.dataEntities[i].getDataEntity();
            DynamicObjectCollection sumentryColls = dynObj.getDynamicObjectCollection("sumentry");
            if (sumentryColls == null || sumentryColls.isEmpty()) continue;
            for (DynamicObject sumentryDyObj : sumentryColls) {
                DynamicObject mftEntryObj = null;
                if (sumentryDyObj.containsProperty("manufactureentryid")) {
                    mftEntryObj = sumentryDyObj.getDynamicObject("manufactureentryid");
                }
                if (null == mftEntryObj) {
                    Long mftentryId = sumentryDyObj.getLong("mftentryid");
                    mftentryIdSet.add(mftentryId);
                    continue;
                }
                mftEntryObjList.add(mftEntryObj);
            }
        }
        HashMap<Long, Map<String, Object>> mftordersMap = new HashMap(16);
        if ("save".equals(operate)) {
            mftordersMap = this.getMftorderMap(mftentryIdSet, mftEntryObjList);
        }
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject dynObj = this.dataEntities[i].getDataEntity();
            DynamicObjectCollection sumentryColls = dynObj.getDynamicObjectCollection("sumentry");
            if (sumentryColls == null || sumentryColls.isEmpty()) continue;
            if ("save".equals(operate)) {
                this.checkMftOrderEntry(i, sumentryColls, mftordersMap);
            }
            block13: for (int j = 0; j < sumentryColls.getRowCount(); ++j) {
                DynamicObject sumentry = (DynamicObject)sumentryColls.get(j);
                DynamicObjectCollection subentrys = null;
                int row = sumentry.getInt("seq");
                switch (operate) {
                    case "save": {
                        this.validateReportQty(i, row, sumentry);
                        subentrys = sumentry.getDynamicObjectCollection("subentryentity");
                        this.checkSubEntry(i, row, subentrys);
                        continue block13;
                    }
                    case "submit": {
                        this.validateReportQty(i, row, sumentry);
                        subentrys = sumentry.getDynamicObjectCollection("subentryentity");
                        this.checkSubEntry(i, row, subentrys);
                        continue block13;
                    }
                    case "audit": {
                        this.validateReportQty(i, row, sumentry);
                        continue block13;
                    }
                }
            }
        }
    }

    private void checkSubEntry(int i, int row, DynamicObjectCollection subentrys) {
        if (null != subentrys && !subentrys.isEmpty()) {
            for (int k = 0; k < subentrys.getRowCount(); ++k) {
                DynamicObject subentry = (DynamicObject)subentrys.get(k);
                int subRow = subentry.getInt("seq");
                this.checkRepactualTime(i, row, subRow, subentry);
            }
        }
    }

    private void checkRepactualTime(int i, int row, int subRow, DynamicObject subentryentity) {
        Date repactualbegintime = subentryentity.getDate("repactualbegintime");
        Date repactualfinishtime = subentryentity.getDate("repactualfinishtime");
        if (null != repactualbegintime && null != repactualfinishtime && repactualbegintime.after(repactualfinishtime)) {
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u6c47\u603b\u5206\u5f55\u7b2c%1$s\u884c\u6240\u5bf9\u5e94\u7684\u6d3b\u52a8\u7b2c%2$s\u884c\u4e0d\u6ee1\u8db3\u6761\u4ef6:\u5b9e\u9645\u5f00\u59cb\u65f6\u95f4\u5c0f\u4e8e\u7b49\u4e8e\u5b9e\u9645\u5b8c\u6210\u65f6\u95f4", (String)"PropMftorderReptBillValidator_16", (String)"mmc-prop-opplugin", (Object[])new Object[0]), row, subRow));
        }
    }

    private void validateReportQty(int i, int j, DynamicObject sumentryDyObj) {
        BigDecimal completqty = sumentryDyObj.getBigDecimal("completqty");
        BigDecimal qualifyqty = sumentryDyObj.getBigDecimal("qualifyqty");
        BigDecimal concesionqty = sumentryDyObj.getBigDecimal("concesionqty");
        BigDecimal scrappedqty = sumentryDyObj.getBigDecimal("scrappedqty");
        if (completqty.compareTo(qualifyqty.add(concesionqty).add(scrappedqty)) != 0) {
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u3010\u6c47\u62a5\u6570\u91cf\u3011\u9700\u6ee1\u8db3=\u3010\u5408\u683c\u6570\u91cf\u3011+\u3010\u8ba9\u6b65\u63a5\u6536\u6570\u91cf\u3011+\u3010\u62a5\u5e9f\u6570\u91cf\u3011", (String)"PropMftorderReptBillValidator_6", (String)"mmc-prop-opplugin", (Object[])new Object[0]), j));
        }
    }

    private void checkMftOrderEntry(int i, DynamicObjectCollection sumentryColls, Map<Long, Map<String, Object>> mftordersMap) {
        for (DynamicObject sumentryDyObj : sumentryColls) {
            Long mftentryId;
            Map<String, Object> orderMap;
            DynamicObject mftEntryObj = sumentryDyObj.getDynamicObject("manufactureentryid");
            if (null != mftEntryObj || null != (orderMap = mftordersMap.get(mftentryId = Long.valueOf(sumentryDyObj.getLong("mftentryid")))) && !orderMap.isEmpty()) continue;
            String info = String.format(ResManager.loadKDString((String)"\u5de5\u5355\u6c47\u62a5\u5355\u5bf9\u5e94\u7684\u751f\u4ea7\u5de5\u5355\u7b2c%s\u884c\u4e0d\u5b58\u5728\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"PropMftorderReptBillValidator_18", (String)"mmc-prop-opplugin", (Object[])new Object[0]), sumentryDyObj.getInt("manufacturerow")) + "\n";
            this.addErrorMessage(this.dataEntities[i], info);
            return;
        }
    }

    private Map<Long, Map<String, Object>> getMftorderMap(Set<Long> mftentryIDSet, List<DynamicObject> mftEntryObjList) {
        if (mftentryIDSet.isEmpty() && mftEntryObjList.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, Map<String, Object>> orderMap = new HashMap<Long, Map<String, Object>>(16);
        if (!mftEntryObjList.isEmpty()) {
            for (int i = 0; i < mftEntryObjList.size(); ++i) {
                DynamicObject dy = mftEntryObjList.get(i);
                HashMap<String, Object> dataMap = new HashMap<String, Object>(4);
                dataMap.put("taskstatus", dy.getString("taskstatus"));
                dataMap.put("bizstatus", dy.getString("bizstatus"));
                dataMap.put("entryid", dy.getLong("id"));
                orderMap.put(dy.getLong("id"), dataMap);
            }
        }
        if (!mftentryIDSet.isEmpty()) {
            QFilter qfilter = new QFilter("treeentryentity.id", "in", mftentryIDSet);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"mmc-propMftorderReptBillValidator-getMftorderMap", (String)"pom_mftorder", (String)"treeentryentity.taskstatus taskstatus ,treeentryentity.bizstatus bizstatus,treeentryentity.id mftEntryID", (QFilter[])new QFilter[]{qfilter}, (String)"");){
                while (ds.hasNext()) {
                    Row dsRow = ds.next();
                    HashMap<String, Object> dataMap = new HashMap<String, Object>(4);
                    dataMap.put("taskstatus", dsRow.getString("taskstatus"));
                    dataMap.put("bizstatus", dsRow.getString("bizstatus"));
                    dataMap.put("entryid", dsRow.getLong("mftEntryID"));
                    orderMap.put(dsRow.getLong("mftEntryID"), dataMap);
                }
            }
        }
        return orderMap;
    }
}

