/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.prop.opplugin.processreport.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.common.enums.OperateEnum;
import kd.bd.mpdm.common.utils.AcctOrgCloseDateUtil;
import kd.bd.mpdm.common.utils.CheckManuOrderUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.validate.AbstractValidator;
import kd.mmc.prop.common.mftorder.utils.QueryOrderUtil;
import kd.mmc.prop.common.utils.PropGetOpentryUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class ProcessReportValidator
extends AbstractValidator {
    public void validate() {
        String operate = this.getOption().getVariableValue("operatekey");
        HashSet<Long> oprEntryIds = new HashSet<Long>(16);
        HashSet<Long> orderEntryIds = new HashSet<Long>(16);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject dataEntity = this.dataEntities[i].getDataEntity();
            DynamicObjectCollection sumentitys = dataEntity.getDynamicObjectCollection("sumentry");
            for (DynamicObject obj : sumentitys) {
                oprEntryIds.add(PropGetOpentryUtils.getOprentryId((DynamicObject)obj));
                if (obj.getDynamicObject("manufactureentryid") == null) continue;
                orderEntryIds.add(obj.getDynamicObject("manufactureentryid").getLong("id"));
            }
        }
        HashMap<Long, Map<String, Object>> manftechByEntryId = new HashMap(16);
        if (CollectionUtils.isNotEmpty(orderEntryIds)) {
            manftechByEntryId = QueryOrderUtil.getManftechByEntryId(oprEntryIds);
        }
        HashMap<Long, Map<String, Object>> orderByEntryId = new HashMap(16);
        switch (operate) {
            case "submit": {
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    this.submitCheck(i, operate, manftechByEntryId);
                }
                break;
            }
            case "audit": {
                if (CollectionUtils.isNotEmpty(orderEntryIds)) {
                    orderByEntryId = QueryOrderUtil.getOrderByEntryId(orderEntryIds);
                }
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    this.auditCheck(i, manftechByEntryId, orderByEntryId);
                }
                break;
            }
            case "unaudit": {
                for (int i = 0; i < this.dataEntities.length; ++i) {
                    this.checkAcctOrgCloseDate(i, operate);
                    this.unauditCheck(i, manftechByEntryId);
                }
                break;
            }
        }
    }

    private void auditCheck(int i, Map<Long, Map<String, Object>> manftechByEntryId, Map<Long, Map<String, Object>> orderByEntryId) {
        DynamicObject obj = this.dataEntities[i].getDataEntity();
        for (DynamicObject sumentry : obj.getDynamicObjectCollection("sumentry")) {
            DynamicObject orderEntry;
            List<String> error;
            String entryPkvalue = PropGetOpentryUtils.getOprentryIdStr((DynamicObject)sumentry);
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)entryPkvalue)) continue;
            Map<String, Object> manftechEntry = manftechByEntryId.get(Long.valueOf(entryPkvalue));
            if (StringUtils.equals((CharSequence)"10070", (CharSequence)sumentry.getString("confirmoprstatus")) && MapUtils.isNotEmpty(manftechEntry)) {
                if (((BigDecimal)manftechEntry.get("oprentryentity.oprqty")).compareTo((BigDecimal)manftechEntry.get("oprentryentity.oprtotalqualifiedqty")) <= 0) {
                    error = ProcessReportValidator.checkEntryStatus("row_finish", manftechEntry, orderByEntryId);
                    for (String err : error) {
                        this.addWarningMessage(this.dataEntities[i], err);
                    }
                } else {
                    error = ProcessReportValidator.checkEntryStatus("row_start", manftechEntry, orderByEntryId);
                    for (String err : error) {
                        this.addWarningMessage(this.dataEntities[i], err);
                    }
                }
            } else if (StringUtils.equals((CharSequence)"10080", (CharSequence)sumentry.getString("confirmoprstatus")) && MapUtils.isNotEmpty(manftechEntry)) {
                error = ProcessReportValidator.checkEntryStatus("donothing_finish", manftechEntry, orderByEntryId);
                for (String err : error) {
                    this.addWarningMessage(this.dataEntities[i], err);
                }
            }
            if ((orderEntry = sumentry.getDynamicObject("manufactureentryid")) == null) continue;
            if (!"A".equals(orderEntry.getString("bizstatus"))) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355[%1$s]\u7b2c[%2$s]\u884c\u7684\u4e1a\u52a1\u72b6\u6001\u4e0d\u4e3a\u6b63\u5e38\uff0c\u4e0d\u5141\u8bb8%3$s\u3002", (String)"ProcessReportValidator_10", (String)"mmc-prop-opplugin", (Object[])new Object[0]), orderEntry.getString("headbillno"), orderEntry.get("entryseq"), OperateEnum.getValue((String)"audit")));
                continue;
            }
            if (orderEntry.getDate("startworktime") == null || manftechEntry == null || manftechEntry.get("oprentryentity.actualstarttime") == null || !((Date)manftechEntry.get("oprentryentity.actualstarttime")).before(orderEntry.getDate("startworktime"))) continue;
            this.addWarningMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u6b64\u5de5\u5e8f\u7684\u5f00\u5de5\u65f6\u95f4\u65e9\u4e8e\u5de5\u5355\u5f00\u5de5\u65f6\u95f4\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProcessReportValidator_15", (String)"mmc-prop-opplugin", (Object[])new Object[0]), new Object[0]));
        }
    }

    private void submitCheck(int i, String operate, Map<Long, Map<String, Object>> manftechByEntryId) {
        DynamicObject obj = this.dataEntities[i].getDataEntity();
        DynamicObjectCollection sumentrys = obj.getDynamicObjectCollection("sumentry");
        if (!obj.getBoolean("checkcoopation")) {
            BigDecimal sumQty;
            DynamicObjectCollection reportentrys;
            if ("qty".equals(obj.getString("staffreport"))) {
                for (DynamicObject sumentry : sumentrys) {
                    reportentrys = sumentry.getDynamicObjectCollection("childreportentity");
                    if (reportentrys == null || reportentrys.size() == 0 || (sumQty = reportentrys.stream().map(x -> x.getBigDecimal("qtyfield")).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(sumentry.getBigDecimal("completqty")) == 0) continue;
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5bf9\u5e94\u5de5\u5e8f\u7684\u6c47\u62a5\u6570\u91cf\u5e94\u7b49\u4e8e\u6c47\u62a5\u4eba\u5458\u6570\u91cf\u603b\u548c", (String)"ProcessReportValidator_0", (String)"mmc-prop-opplugin", (Object[])new Object[0]), new Object[0]));
                }
            } else if ("cooportion".equals(obj.getString("staffreport"))) {
                for (DynamicObject sumentry : sumentrys) {
                    reportentrys = sumentry.getDynamicObjectCollection("childreportentity");
                    if (reportentrys == null || reportentrys.size() == 0 || (sumQty = reportentrys.stream().map(x -> x.getBigDecimal("proportion")).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(new BigDecimal(100)) == 0) continue;
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5bf9\u5e94\u5de5\u5e8f\u7684\u6c47\u62a5\u6bd4\u4f8b\u4e4b\u548c\u5e94\u7b49\u4e8e\u767e\u5206\u4e4b\u767e", (String)"ProcessReportValidator_1", (String)"mmc-prop-opplugin", (Object[])new Object[0]), new Object[0]));
                }
            }
        }
        for (DynamicObject sumentry : sumentrys) {
            if ((sumentry.getBoolean("firstinspection") || !"1011".equals(sumentry.getString("inspectiontype"))) && sumentry.get("qualityorg") == null) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5f00\u542f\u9996\u68c0\u6216\u68c0\u9a8c\u65b9\u5f0f\u4e0d\u4e3a\u514d\u68c0\u65f6\uff0c\u8d28\u68c0\u7ec4\u7ec7\u5fc5\u5f55\u3002", (String)"ProcessReportValidator_9", (String)"mmc-prop-opplugin", (Object[])new Object[0]), new Object[0]));
            }
            if (sumentry.getDynamicObject("manufactureentryid") == null) continue;
            DynamicObject dynamicObject = sumentry.getDynamicObject("manufactureentryid");
            Map<String, Object> map = manftechByEntryId.get(PropGetOpentryUtils.getOprentryId((DynamicObject)sumentry));
            if (dynamicObject.getDate("startworktime") == null || map == null || map.get("oprentryentity.actualstarttime") == null || !((Date)map.get("oprentryentity.actualstarttime")).before(dynamicObject.getDate("startworktime"))) continue;
            this.addWarningMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u6b64\u5de5\u5e8f\u7684\u5f00\u5de5\u65f6\u95f4\u65e9\u4e8e\u5de5\u5355\u5f00\u5de5\u65f6\u95f4\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProcessReportValidator_15", (String)"mmc-prop-opplugin", (Object[])new Object[0]), new Object[0]));
        }
    }

    private void checkAcctOrgCloseDate(int i, String operate) {
        DynamicObject obj = this.dataEntities[i].getDataEntity();
        Date date = AcctOrgCloseDateUtil.getAcctOrgCloseDate((Long)obj.getDynamicObject("org").getLong("id"));
        Date reportDate = obj.getDate("bookdate");
        if (date != null && reportDate != null && date.compareTo(reportDate) >= 0) {
            String acctOrgName = AcctOrgCloseDateUtil.getAcctOrgName((Long)obj.getDynamicObject("org").getLong("id"));
            String operateKey = OperateEnum.getValue((String)operate);
            String format = ResManager.loadKDString((String)"\u6d41\u7a0b\u5de5\u5e8f\u6c47\u62a5\u5355\u751f\u4ea7\u7ec4\u7ec7\u5bf9\u5e94\u7684\u6838\u7b97\u7ec4\u7ec7(%1$s)\u5df2\u5173\u8d26\uff0c\u4e0d\u5141\u8bb8%2$s\u3002", (String)"ProcessReportValidator_2", (String)"mmc-prop-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(this.dataEntities[i], String.format(format, acctOrgName, operateKey));
        }
    }

    public static List<String> checkEntryStatus(String operateKey, Map<String, Object> manftechEntry, Map<Long, Map<String, Object>> orderByEntryId) {
        ArrayList<String> errors = new ArrayList<String>();
        if (!"C".equals(manftechEntry.get("billstatus"))) {
            errors.add(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u5de5\u5e8f\u8ba1\u5212[%s]\u672a\u5ba1\u6838\u3002", (String)"ProcessReportValidator_3", (String)"mmc-prop-opplugin", (Object[])new Object[0]), manftechEntry.get("billno")));
            return errors;
        }
        Map<String, Object> orderMap = orderByEntryId.get(manftechEntry.get("mftentryseq"));
        StringBuffer error = new StringBuffer();
        if (((Boolean)manftechEntry.get("oprentryentity.oprinvalid")).booleanValue()) {
            String format = String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u5de5\u5e8f\u8ba1\u5212[%1$s]\u5de5\u5e8f\u53f7[%2$s]\u5df2\u4f5c\u5e9f\u3002", (String)"ProcessReportValidator_4", (String)"mmc-prop-opplugin", (Object[])new Object[0]), manftechEntry.get("billno"), manftechEntry.get("oprentryentity.oprno"));
            errors.add(format);
        }
        switch (operateKey) {
            case "row_start": {
                error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkBizStatus", (String)((String)manftechEntry.get("billno")), (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u5f00\u5de5", (String)"ProcessReportValidator_5", (String)"mmc-prop-opplugin", (Object[])new Object[0]), orderMap, (String)ResManager.loadKDString((String)"\u6d41\u7a0b\u751f\u4ea7", (String)"ProcessReportValidator_13", (String)"mmc-prop-opplugin", (Object[])new Object[0]));
                break;
            }
            case "row_finish": {
                error = CheckManuOrderUtil.checkManuOrderEntryStatus((String)"checkBizStatus", (String)((String)manftechEntry.get("billno")), (String)ResManager.loadKDString((String)"\u6267\u884c\u81f3\u5b8c\u5de5", (String)"ProcessReportValidator_6", (String)"mmc-prop-opplugin", (Object[])new Object[0]), orderMap, (String)ResManager.loadKDString((String)"\u6d41\u7a0b\u751f\u4ea7", (String)"ProcessReportValidator_13", (String)"mmc-prop-opplugin", (Object[])new Object[0]));
                break;
            }
        }
        if (error.length() > 0) {
            errors.add(error.toString());
        }
        return errors;
    }

    private void unauditCheck(int i, Map<Long, Map<String, Object>> manftechByEntryId) {
        DynamicObject obj = this.dataEntities[i].getDataEntity();
        for (DynamicObject sumentry : obj.getDynamicObjectCollection("sumentry")) {
            DynamicObject orderEntry;
            BigDecimal qty;
            String entryPkvalue = PropGetOpentryUtils.getOprentryIdStr((DynamicObject)sumentry);
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)entryPkvalue)) continue;
            Map<String, Object> manftechEntry = manftechByEntryId.get(Long.valueOf(entryPkvalue));
            if (MapUtils.isNotEmpty(manftechByEntryId) && (qty = ((BigDecimal)manftechEntry.get("oprentryentity.oprtotalreworkqty")).subtract((BigDecimal)manftechEntry.get("oprentryentity.pushreworkreportqty"))).compareTo(sumentry.getBigDecimal("checkreworkqty")) < 0) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5206\u5f55\u884c\u7684\u8fd4\u5de5\u6570\u91cf\u5927\u4e8e\u5bf9\u5e94\u5de5\u5e8f\u4f5c\u4e1a\u8ba1\u5212\u3010\u8fd4\u5de5\u6570\u91cf-\u4e0b\u63a8\u8fd4\u5de5\u6c47\u62a5\u6570\u91cf\u3011\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838", (String)"ProcessReportValidator_7", (String)"mmc-prop-opplugin", (Object[])new Object[0]), new Object[0]));
            }
            if ((orderEntry = sumentry.getDynamicObject("manufactureentryid")) == null || "A".equals(orderEntry.getString("bizstatus"))) continue;
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u751f\u4ea7\u5de5\u5355[%1$s]\u7b2c[%2$s]\u884c\u7684\u4e1a\u52a1\u72b6\u6001\u4e0d\u4e3a\u6b63\u5e38\uff0c\u4e0d\u5141\u8bb8%3$s\u3002", (String)"ProcessReportValidator_10", (String)"mmc-prop-opplugin", (Object[])new Object[0]), orderEntry.getString("headbillno"), orderEntry.get("entryseq"), OperateEnum.getValue((String)"unaudit")));
        }
    }
}

