/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.prop.formplugin.manftech;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import kd.bd.mpdm.formplugin.manufacturemodel.TechnicsTplEditPlugin;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class PropTechnicsEditPlugin
extends TechnicsTplEditPlugin
implements RowClickEventListener {
    protected String getOrderBillType() {
        return "prop_mftorder";
    }

    protected String getOrderBillName() {
        return ResManager.loadKDString((String)"\u6d41\u7a0b\u751f\u4ea7\u5de5\u5355", (String)"PropTechnicsEditPlugin_0", (String)"mmc-prop-formplugin", (Object[])new Object[0]);
    }

    protected String getStockBillType() {
        return "prop_mftstock";
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setSkipNoField(true);
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (StringUtils.equals((CharSequence)"oprentryentity1", (CharSequence)entryGrid.getKey())) {
            int row = evt.getRow();
            if (this.getModel().getValue("isstage4", row) != null) {
                boolean isstage = (Boolean)this.getModel().getValue("isstage4", row);
                this.setTabVisble(isstage);
            }
        }
    }

    protected void showData(int selectRow) {
        super.showData(selectRow);
        if (this.getModel().getValue("isstage4", selectRow) != null) {
            boolean isstage = (Boolean)this.getModel().getValue("isstage4", selectRow);
            this.setTabVisble(isstage);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        Object isinitbill = this.getModel().getValue("isinitbill");
        if (isinitbill != null && Boolean.parseBoolean(isinitbill.toString())) {
            this.intiBillPropertyChanged(e);
        }
        String propertyName = e.getProperty().getName();
        ChangeData[] changeArr = e.getChangeSet();
        switch (propertyName) {
            case "isstage4": {
                this.isstageChange(changeArr);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"oprnoselect")) {
            Object returnValue = closedCallBackEvent.getReturnData();
            int row = this.getModel().getEntryCurrentRowIndex("oprentryentity1");
            this.getModel().setValue("parentprocessno4", returnValue, row);
            this.getModel().setValue("parentprocessno", returnValue, row);
        }
    }

    private void isstageChange(ChangeData[] changeArr) {
        for (int i = 0; i < changeArr.length; ++i) {
            ChangeData changedata = changeArr[i];
            int row = (Integer)this.getModel().getValue("row4", changedata.getRowIndex());
            if (row == -1) break;
            this.getModel().setValue("isstage", changedata.getNewValue(), row);
            if (changedata.getNewValue() == null) continue;
            boolean isstage = Boolean.parseBoolean(changedata.getNewValue() + "");
            this.setTabVisble(isstage);
            if (isstage) {
                this.getView().setEnable(Boolean.valueOf(true), row, new String[]{"parentprocessno4"});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"baritemap", "baritemap1", "baritemap2", "baritemap9", "baritemap10"});
                continue;
            }
            this.getView().setEnable(Boolean.valueOf(false), row, new String[]{"parentprocessno4"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"baritemap", "baritemap1", "baritemap2", "baritemap9", "baritemap10"});
            this.getModel().deleteEntryData("actsubentryentity");
            this.getModel().setValue("parentprocessno4", null, row);
            this.getModel().setValue("parentprocessno", null, row);
        }
    }

    private void setTabVisble(boolean isstage) {
        this.getView().setVisible(Boolean.valueOf(isstage), new String[]{"planpage", "reportpage", "detailpage"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit programme = (BasedataEdit)this.getView().getControl("programme");
        programme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit oproperation = (BasedataEdit)this.getView().getControl("oproperation4");
        oproperation.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit text = (TextEdit)this.getView().getControl("parentprocessno4");
        text.addClickListener((ClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("oprentryentity1");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"parentprocessno4")) {
            this.showOprnoselect();
        }
    }

    private void showOprnoselect() {
        ArrayList oprnoMaps = new ArrayList();
        DynamicObjectCollection oprentryentity = this.getModel().getEntryEntity("oprentryentity1");
        for (DynamicObject oprentry : oprentryentity) {
            if (oprentry.getBoolean("isstage4") || !StringUtils.isNotEmpty((CharSequence)oprentry.getString("oprno4"))) continue;
            HashMap<String, String> oprnoMap = new HashMap<String, String>(4);
            oprnoMap.put("oprno4", oprentry.getString("oprno4"));
            oprnoMap.put("oproperation4", oprentry.getString("oproperation4.name"));
            oprnoMap.put("oproperationname4", oprentry.getString("oproperation4.number"));
            oprnoMap.put("oprdescription4", oprentry.getString("oprdescription4"));
            oprnoMaps.add(oprnoMap);
        }
        if (oprnoMaps.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u9009\u62e9\u7684\u5de5\u5e8f", (String)"PropTechnicsEditPlugin_1", (String)"mmc-prop-formplugin", (Object[])new Object[0]));
        } else {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("prop_oprnoselect");
            parameter.setCustomParam("oprnoMaps", (Object)SerializationUtils.serializeToBase64(oprnoMaps));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "oprnoselect"));
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(parameter);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String source;
        super.beforeF7Select(evt);
        Control con = (Control)evt.getSource();
        switch (source = con.getKey()) {
            case "programme": {
                this.programmeBeforeF7(evt);
                break;
            }
            case "oproperation4": {
                this.oproperationBeforeF7(evt);
            }
        }
    }

    private void oproperationBeforeF7(BeforeF7SelectEvent evt) {
        Long productlineid = (Long)this.getModel().getValue("productline_id");
        HashSet<Long> stepsequenceIds = new HashSet<Long>();
        if (productlineid != 0L) {
            try (DataSet dataset = QueryServiceHelper.queryDataSet((String)"query_fmm_productline_opera", (String)"fmm_productline_opera", (String)"proseq_entryentity.step_sequence_num stepsequencenum", (QFilter[])new QFilter("product_line.id", "=", (Object)productlineid).toArray(), null);){
                for (Row row : dataset) {
                    stepsequenceIds.add(row.getLong("stepsequencenum"));
                }
            }
        }
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", stepsequenceIds));
    }

    private void programmeBeforeF7(BeforeF7SelectEvent evt) {
        Object masterObj = this.getModel().getValue("material");
        Object masterPaValue = null == masterObj ? Long.valueOf(-1L) : ((DynamicObject)masterObj).getPkValue();
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        QFilter qfilter = new QFilter("material", "=", masterPaValue);
        listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
    }

    private void intiBillPropertyChanged(PropertyChangedArgs e) {
        String name;
        IDataEntityProperty property = e.getProperty();
        switch (name = property.getName()) {
            case "oprtotalinqty1": 
            case "oprtotaloutqty1": 
            case "oprtotalqualifiedqty1": 
            case "oprtotalreceiveqty1": 
            case "oprtotalwasteqty1": 
            case "oprtotalmaterialqty1": 
            case "oprtotalreworkqty1": 
            case "oprrepairedqty1": {
                this.calculateQty();
                break;
            }
        }
    }

    private void calculateQty() {
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        IDataModel model = this.getModel();
        StringBuilder err = new StringBuilder();
        DynamicObject dataEntity = model.getDataEntity();
        boolean isinitbill = dataEntity.getBoolean("isinitbill");
        if (!isinitbill) {
            err.append(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5355\u636e\u4e3a\u975e\u521d\u59cb\u5316\u5355\u636e\uff0c\u4e0d\u5141\u8bb8\u5f15\u5165", (String)"OMTechnicsEditPlugin_1", (String)"mmc-om-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            ArrayList<String> errors = new ArrayList<String>(2);
            errors.add(err.toString());
            e.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), errors);
            return;
        }
    }
}

