/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.prop.formplugin.mftorder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.common.mftorder.helper.BillUnitAndQtytHelper;
import kd.bd.mpdm.common.mftorder.utils.CreateStockUtils;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bd.mpdm.common.query.helper.MaterialQueryHelper;
import kd.bd.mpdm.common.utils.AuxQtyAndUnitHelper;
import kd.bd.mpdm.common.utils.DynamicObjDataUtil;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.runtime.ConvertOpParameter;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mmc.prop.business.helper.PropBillHelper;
import kd.mmc.prop.common.mftorder.utils.MftOrderToProorderUtil;

public class PropMftOrderEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public static final String MASTERID = "masterid";
    private static Log logger = LogFactory.getLog(PropMftOrderEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit programme = (BasedataEdit)this.getView().getControl("programme");
        programme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        PropBillHelper.versionVisiable((Object)this.getModel().getValue("transactiontype"), (IFormView)this.getView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model;
        DynamicObject transactype;
        if (this.getPageCache().get("isIgnoreChangeListener") == "true") {
            return;
        }
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        ChangeData[] changeSet = e.getChangeSet();
        if ("bomid".equals(name) && (null == (transactype = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)(model = this.getModel()), (String)"transactiontype")) || !"A".equals(transactype.get("stockmaterials")) && !"B".equals(transactype.get("stockmaterials")))) {
            DynamicObjectCollection entryEntity = model.getEntryEntity("treeentryentity");
            for (DynamicObject entryRow : entryEntity) {
                entryRow.set("bomid", null);
                entryRow.set("versionid", null);
            }
            model.updateEntryCache(entryEntity);
            this.getView().updateView("treeentryentity");
        }
        block19: for (ChangeData changeData : changeSet) {
            switch (name) {
                case "transactiontype": {
                    this.transactypePropChange(changeData);
                    continue block19;
                }
                case "material": {
                    this.materialPropChange(changeData);
                    continue block19;
                }
                case "programme": {
                    this.programmePropChange(changeData);
                    continue block19;
                }
                case "expendbomtime": {
                    this.expendBomTimeChange(changeData);
                    continue block19;
                }
                case "bomid": {
                    this.versionChange(changeData);
                    continue block19;
                }
                case "qty": {
                    this.qtyPropChange(changeData);
                    continue block19;
                }
                case "productline": {
                    this.autoChangeCoproduct(changeData.getRowIndex(), name);
                    continue block19;
                }
            }
        }
    }

    private void versionChange(ChangeData changeData) {
        int rowIndex = changeData.getRowIndex();
        Object newValue = changeData.getNewValue();
        DynamicObject bom = (DynamicObject)newValue;
        Long versionId = null == bom ? 0L : bom.getLong("version.id");
        this.getModel().setValue("versionid_id", (Object)versionId, rowIndex);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String source;
        Control con = (Control)evt.getSource();
        switch (source = con.getKey()) {
            case "programme": {
                this.programmeBeforeF7(evt);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String operationKey = evt.getItemKey();
        if ("pushpick".equals(operationKey) || "pushreturn".equals(operationKey) || "pushapply".equals(operationKey)) {
            this.pushPick(operationKey);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if ("viewmftprooder".equals(key)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
            ArrayList<Object> idList = new ArrayList<Object>();
            if (entryGrid.getSelectRows().length == 0) {
                DynamicObject manuBill = this.getModel().getDataEntity();
                DynamicObjectCollection entryCol = manuBill.getDynamicObjectCollection("treeentryentity");
                for (int i = 0; i < entryCol.size(); ++i) {
                    DynamicObject[] entry = (DynamicObject[])entryCol.get(i);
                    idList.add(entry.getPkValue());
                }
            } else {
                for (int i = 0; i < entryGrid.getSelectRows().length; ++i) {
                    DynamicObject entry = this.getModel().getEntryRowEntity("treeentryentity", entryGrid.getSelectRows()[i]);
                    idList.add(entry.getPkValue());
                }
            }
            ArrayList<Object> stockids = new ArrayList<Object>();
            QFilter qFilterStock = new QFilter("orderentryid", "in", idList);
            DynamicObject[] stock = BusinessDataServiceHelper.load((String)"prop_mftstock", (String)"id", (QFilter[])qFilterStock.toArray());
            if (stock != null && stock.length > 0) {
                for (DynamicObject dynamicObject : stock) {
                    stockids.add(dynamicObject.getPkValue());
                }
                if (stockids.size() > 0) {
                    QFilter qmftProorder = new QFilter("billentry.mainbillid", "in", stockids);
                    DynamicObjectCollection query = QueryServiceHelper.query((String)"im_mdc_mftproorder", (String)"id,billtype.billformid", (QFilter[])qmftProorder.toArray());
                    HashSet<Long> prolinkids = new HashSet<Long>();
                    for (DynamicObject dym : query) {
                        String billformid = dym.getString("billtype.billformid");
                        if (!"im_mdc_mftproorder".equals(billformid)) continue;
                        prolinkids.add(dym.getLong("id"));
                    }
                    HashMap<String, HashSet<Long>> findTargetBills = new HashMap<String, HashSet<Long>>(16);
                    if (prolinkids.isEmpty()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4e0b\u6e38\u9886\u6599\u5355\u3002", (String)"MftOrderEdit_37", (String)"mmc-prop-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    findTargetBills.put("im_mdc_propproorder", prolinkids);
                    HashMap<String, String> para = new HashMap<String, String>();
                    para.put("formId", "prop_proorder");
                    FormShowParameter fsParameter = FormShowParameter.createFormShowParameter(para);
                    fsParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    fsParameter.setCustomParam("paramList", findTargetBills);
                    this.getView().showForm(fsParameter);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u751f\u4ea7\u7ec4\u4ef6\u6e05\u5355\u3002", (String)"MftOrderEdit_38", (String)"mmc-prop-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    private void pushPick(String type) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
        if (entryGrid.getSelectRows().length == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u5206\u5f55", (String)"MftOrderEdit_0", (String)"mmc-pom-formplugin", (Object[])new Object[0]));
            return;
        }
        IFormView view = this.getView();
        IBillView billView = (IBillView)view;
        ConvertOpParameter opParameter = MftOrderToProorderUtil.buildParameter(null, (IBillView)billView, (String)type);
        if (opParameter.getSelectedRows().size() == 0) {
            String billno = this.getModel().getValue("billno").toString();
            String format = String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u751f\u4ea7\u5de5\u5355%s\u5173\u8054\u7684\u6d41\u7a0b\u7528\u6599\u6e05\u5355\u4e0d\u5b58\u5728\u9700\u8981\u4e0b\u63a8\u7684\u6570\u636e\u3002", (String)"MftOrderEdit_8", (String)"mmc-prop-formplugin", (Object[])new Object[0]), billno);
            this.getView().showMessage(format);
            return;
        }
        String opParameterJson = SerializationUtils.toJsonString((Object)opParameter);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getCustomParams().put("opparam", opParameterJson);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u4e0b\u63a8", (String)"MftOrderEdit_9", (String)"mmc-prop-formplugin", (Object[])new Object[0]));
        showParameter.setFormId("mft_botp_convertop");
        this.getView().showForm(showParameter);
    }

    private void materialPropChange(ChangeData changeData) {
        logger.info("--materialPropChange in--");
        IDataModel model = this.getModel();
        DynamicObject transactype = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"transactiontype");
        if (null == transactype || !"D".equalsIgnoreCase(transactype.getString("stockmaterials"))) {
            return;
        }
        Object materialObj = changeData.getNewValue();
        int rowIndex = changeData.getRowIndex();
        DynamicObject masterObj = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"materielmasterid");
        QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"fmm_programe", (Long)DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"org").getLong("id"));
        if (materialObj instanceof DynamicObject && null != masterObj && null != filter) {
            filter.and("material", "=", masterObj.getPkValue()).and("status", "=", (Object)"C").and("enable", "=", (Object)"1");
            DynamicObjectCollection ids = QueryServiceHelper.query((String)"fmm_programe", (String)"id", (QFilter[])filter.toArray());
            if (!ids.isEmpty()) {
                model.setValue("programme", (Object)((DynamicObject)ids.get(0)).getLong("id"), rowIndex);
                return;
            }
        }
        model.setValue("programme", null, rowIndex);
    }

    private void programmeBeforeF7(BeforeF7SelectEvent evt) {
        int row;
        IDataModel model = this.getModel();
        DynamicObject masterObj = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"materielmasterid", (int)(row = evt.getRow()));
        if (null == masterObj) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u3002", (String)"PropMftOrderEdit_0", (String)"mmc-prop-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        QFilter qfilter = new QFilter("material", "=", masterObj.getPkValue());
        listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
    }

    private void programmePropChange(ChangeData changeData) {
        int rowIndex = changeData.getRowIndex();
        Object newValue = changeData.getNewValue();
        this.programmePropChange(rowIndex, newValue);
    }

    private void programmePropChange(int rowIndex, Object newValue) {
        IDataModel model = this.getModel();
        this.deleteRelEntryRow(rowIndex);
        HashMap<Integer, Map<String, Object>> propChangeMap = new HashMap<Integer, Map<String, Object>>(16);
        model.beginInit();
        if (newValue instanceof DynamicObject) {
            DynamicObject programe = (DynamicObject)newValue;
            DynamicObject proute = programe.getDynamicObject("proroute");
            Object workCenterPk = null == proute ? Long.valueOf(0L) : proute.getPkValue();
            model.setValue("productline", workCenterPk, rowIndex);
            Long versionId = programe.getLong("version.id");
            model.setValue("versionid_id", (Object)versionId, rowIndex);
            model.setValue("yieldrate", programe.get("yieldrate"), rowIndex);
            DynamicObjectCollection groupEntity = programe.getDynamicObjectCollection("groupentity");
            List<String> relproductList = Arrays.asList("A", "B");
            Date now = KDDateUtils.now();
            Set<DynamicObject> relProductSet = groupEntity.stream().filter(x -> relproductList.contains(x.getString("prodtype")) && null != x.get("entrymaterial") && now.after(x.getDate("entryvaliddate")) && now.before(x.getDate("entryinvaliddate"))).collect(Collectors.toSet());
            DynamicObject orgObj = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"org");
            if (!relProductSet.isEmpty() && null != orgObj) {
                this.relProductprogrammePropChange(rowIndex, model, propChangeMap, programe, workCenterPk, relProductSet, orgObj);
            }
        }
        model.endInit();
        propChangeMap.forEach((index, value) -> value.forEach((propKey, propvalue) -> model.setValue(propKey, propvalue, index.intValue())));
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getControl("treeentryentity");
        treeEntryGrid.expand(rowIndex);
        this.getView().updateView("treeentryentity");
    }

    private void relProductprogrammePropChange(int rowIndex, IDataModel model, Map<Integer, Map<String, Object>> propChangeMap, DynamicObject programe, Object workCenterPk, Set<DynamicObject> relProductSet, DynamicObject orgObj) {
        HashMap orgMaterialMftInfoMap = new HashMap(16);
        HashSet supplyOrgIdSet = new HashSet(16);
        Set materialIdSet = relProductSet.stream().map(x -> x.getDynamicObject("entrymaterial").getLong("id")).collect(Collectors.toSet());
        HashMap orgMasterMap = new HashMap(16);
        Long orgId = orgObj.getLong("id");
        orgMasterMap.put(orgId, materialIdSet);
        CreateStockUtils.getMaterialMftInfoByMaster((Long)orgId, orgMaterialMftInfoMap, orgMasterMap, supplyOrgIdSet);
        Map materialMftInfoMap = (Map)orgMaterialMftInfoMap.get(orgId);
        if (!materialMftInfoMap.isEmpty()) {
            for (DynamicObject relProduct : relProductSet) {
                Object masterId;
                Object mftmaterialObj;
                DynamicObject entryMaterial = relProduct.getDynamicObject("entrymaterial");
                if (null == entryMaterial || !((mftmaterialObj = materialMftInfoMap.get(masterId = entryMaterial.getPkValue())) instanceof DynamicObject)) continue;
                DynamicObject mftmaterial = (DynamicObject)mftmaterialObj;
                int insertRowIndex = model.insertEntryRow("treeentryentity", rowIndex);
                model.setValue("producttype", relProduct.get("prodtype"), insertRowIndex);
                model.setValue("material", (Object)mftmaterial, insertRowIndex);
                model.setValue("materielmasterid", masterId, insertRowIndex);
                model.setValue("versionid", relProduct.get("entryversion"), insertRowIndex);
                model.setValue("outputoperation", relProduct.get("prodstage"), insertRowIndex);
                DynamicObject unitDO = mftmaterial.getDynamicObject("mftunit");
                model.setValue("unit", (Object)unitDO, insertRowIndex);
                DynamicObject material = mftmaterial.getDynamicObject(MASTERID);
                material = MaterialQueryHelper.getDataCacheByID((Object)material.getPkValue());
                DynamicObject baseunitDO = material.getDynamicObject("baseunit");
                model.setValue("baseunit", (Object)baseunitDO, insertRowIndex);
                DynamicObject auxunitDO = material.getDynamicObject("auxptyunit");
                model.setValue("auxptyunit", (Object)auxunitDO, insertRowIndex);
                BigDecimal mainBaseQty = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)model, (String)"baseqty", (int)rowIndex);
                BigDecimal baseQty = mainBaseQty.multiply(relProduct.getBigDecimal("entryqtynumerator")).divide(relProduct.getBigDecimal("entryqtydenominator"), MPDMMftGenStocksUtils.getPrecision((DynamicObject)baseunitDO), MPDMMftGenStocksUtils.getRoundType((DynamicObject)baseunitDO));
                BigDecimal qty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)baseunitDO, (BigDecimal)baseQty, (DynamicObject)unitDO);
                this.addPropChangeValue(propChangeMap, insertRowIndex, "qty", qty);
                model.setValue("producedept", model.getValue("producedept", rowIndex), insertRowIndex);
                model.setValue("productline", workCenterPk, insertRowIndex);
                model.setValue("tracknumber", model.getValue("tracknumber", rowIndex), insertRowIndex);
                model.setValue("planbegintime", model.getValue("planbegintime", rowIndex), insertRowIndex);
                model.setValue("planpreparetime", model.getValue("planpreparetime", rowIndex), insertRowIndex);
                model.setValue("planendtime", model.getValue("planendtime", rowIndex), insertRowIndex);
                model.setValue("expendbomtime", model.getValue("expendbomtime", rowIndex), insertRowIndex);
                model.setValue("inwardept", model.getValue("inwardept", rowIndex), insertRowIndex);
                model.setValue("routereplace", model.getValue("routereplace", rowIndex), insertRowIndex);
                model.setValue("programme", (Object)programe, insertRowIndex);
                model.setValue("yieldrate", model.getValue("yieldrate", rowIndex), insertRowIndex);
            }
        }
    }

    private void deleteRelEntryRow(int rowIndex) {
        long rowid = (Long)this.getModel().getValue("treeentryentity.id", rowIndex);
        int rowCount = this.getModel().getEntryRowCount("treeentryentity");
        for (int i = rowCount - 1; i >= 0; --i) {
            long pid;
            String producttype = (String)this.getModel().getValue("producttype", i);
            if ("C".equals(producttype)) continue;
            long l = pid = null == this.getModel().getValue("pid", i) ? 0L : (Long)this.getModel().getValue("pid", i);
            if (rowid != pid) continue;
            this.getModel().deleteEntryRow("treeentryentity", i);
        }
    }

    private void qtyPropChange(ChangeData changeData) {
        int rowIndex;
        IDataModel model = this.getModel();
        String producttype = (String)model.getValue("producttype", rowIndex = changeData.getRowIndex());
        if (!"C".equals(producttype)) {
            return;
        }
        this.getModel().setValue("planqty", changeData.getNewValue(), rowIndex);
        int rowCount = model.getEntryRowCount("treeentryentity");
        DynamicObject mainProdutRow = model.getEntryRowEntity("treeentryentity", rowIndex);
        Object mainId = mainProdutRow.get("id");
        for (int i = rowCount - 1; i > rowIndex; --i) {
            DynamicObject entryentity = model.getEntryRowEntity("treeentryentity", i);
            DynamicObject programme = (DynamicObject)model.getValue("programme", rowIndex);
            DynamicObject copmaterial = (DynamicObject)model.getValue("materielmasterid", i);
            if (!entryentity.get("pid").equals(mainId) || copmaterial == null || programme == null) continue;
            QFilter qFilter = new QFilter("id", "=", (Object)programme.getLong("id"));
            qFilter.and(new QFilter("groupentity.entrymaterial", "=", copmaterial.getPkValue()));
            DynamicObjectCollection coproductCollection = QueryServiceHelper.query((String)"fmm_programe", (String)"groupentity.entryqtynumerator, groupentity.entryqtydenominator", (QFilter[])new QFilter[]{qFilter});
            if (coproductCollection == null || coproductCollection.isEmpty()) continue;
            DynamicObject mftmaterial = entryentity.getDynamicObject("material");
            DynamicObject material = mftmaterial.getDynamicObject(MASTERID);
            DynamicObject baseunitDO = entryentity.getDynamicObject("baseunit");
            DynamicObject unitDO = entryentity.getDynamicObject("unit");
            DynamicObject coproduct = (DynamicObject)coproductCollection.get(0);
            BigDecimal entryQtyNumerator = coproduct.getBigDecimal("groupentity.entryqtynumerator");
            BigDecimal entryQtyDenominator = coproduct.getBigDecimal("groupentity.entryqtydenominator");
            BigDecimal mainBaseQty = (BigDecimal)model.getValue("baseqty", rowIndex);
            if (entryQtyNumerator.compareTo(BigDecimal.ZERO) > 0 && entryQtyDenominator.compareTo(BigDecimal.ZERO) > 0) {
                mainBaseQty = mainBaseQty.multiply(entryQtyNumerator).divide(entryQtyDenominator, MPDMMftGenStocksUtils.getPrecision((DynamicObject)baseunitDO), MPDMMftGenStocksUtils.getRoundType((DynamicObject)baseunitDO));
            }
            model.setValue("baseqty", (Object)mainBaseQty, i);
            BigDecimal mainQty = BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)baseunitDO, (BigDecimal)mainBaseQty, (DynamicObject)unitDO);
            model.setValue("qty", (Object)mainQty, i);
            if (null != entryentity) {
                AuxQtyAndUnitHelper.changeUntAndQty((DynamicObject)entryentity, (DynamicObject)(null == entryentity.getDynamicObject("material") ? null : entryentity.getDynamicObject("material").getDynamicObject(MASTERID)), (DynamicObject)entryentity.getDynamicObject("auxptyunit"), (String)"baseqty", (String)"baseunit", (String)"auxptyqty");
                this.getView().updateView("auxptyqty", i);
            }
            model.setValue("planqty", (Object)mainQty, i);
        }
    }

    private void addPropChangeValue(Map<Integer, Map<String, Object>> propChangeMap, int rowIndex, String propKey, Object propValue) {
        Map<String, Object> propMap = propChangeMap.get(rowIndex);
        if (null == propMap) {
            propMap = new HashMap<String, Object>(16);
            propChangeMap.put(rowIndex, propMap);
        }
        propMap.put(propKey, propValue);
    }

    private void transactypePropChange(ChangeData changeData) {
        IDataModel model = this.getModel();
        Object newValue = changeData.getNewValue();
        PropBillHelper.versionVisiable((Object)newValue, (IFormView)this.getView());
        String stockMaterials = "";
        if (newValue instanceof DynamicObject) {
            DynamicObject transactype = (DynamicObject)newValue;
            stockMaterials = transactype.getString("stockmaterials");
        }
        int rowCount = this.getModel().getEntryRowCount("treeentryentity");
        for (int i = rowCount - 1; i >= 0; --i) {
            if ("A".equals(stockMaterials)) {
                model.setValue("programme", null, i);
                continue;
            }
            if ("D".equals(stockMaterials)) {
                model.setValue("bomid", null, i);
                continue;
            }
            model.setValue("programme", null, i);
            model.setValue("bomid", null, i);
        }
    }

    private void expendBomTimeChange(ChangeData changeData) {
        IDataModel model = this.getModel();
        DynamicObject transactype = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)model, (String)"transactiontype");
        if (null != transactype && "D".equalsIgnoreCase(transactype.getString("stockmaterials"))) {
            int rowIndex = changeData.getRowIndex();
            this.programmePropChange(rowIndex, model.getValue("programme", rowIndex));
        }
    }

    private void autoChangeCoproduct(int rowIndex, String changekey) {
        long rowid = (Long)this.getModel().getValue("treeentryentity.id", rowIndex);
        int rowCount = this.getModel().getEntryRowCount("treeentryentity");
        block6: for (int i = rowCount - 1; i >= 0; --i) {
            long pid;
            String producttype = (String)this.getModel().getValue("producttype", i);
            if ("C".equals(producttype)) continue;
            long l = pid = null == this.getModel().getValue("pid", i) ? 0L : (Long)this.getModel().getValue("pid", i);
            if (rowid != pid) continue;
            switch (changekey) {
                case "productline": {
                    Object workcenter = this.getModel().getValue("productline", rowIndex);
                    this.getModel().setValue("productline", workcenter, i);
                    continue block6;
                }
            }
        }
    }
}

