/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.prop.formplugin.mftstock;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bd.mpdm.common.mftorder.utils.StockCulUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;

public class PropManuftechStockEdit
extends AbstractFormPlugin
implements RowClickEventListener {
    protected static final Map<String, String> manuFieldMaps = new HashMap<String, String>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("stockentry");
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    private void showEntryDetial(DynamicObject entryentity) {
        this.getPageCache().put("isIgnoreChangeListener", "true");
        IDataModel model = this.getModel();
        if (entryentity != null && this.getSelectEntryRowIndex() != -1) {
            if (StringUtils.equals((CharSequence)this.getModel().getValue("billstatus").toString(), (CharSequence)"A") && !this.isJumpLevel(entryentity)) {
                this.setControlState(true);
            } else {
                this.setControlState(false);
            }
            model.setValue("workprocedurefield", entryentity.get("workprocedureid"));
            model.setValue("operationdescfield", entryentity.get("operationdesc"));
            model.setValue("oprnofield", entryentity.get("oprno"));
        } else {
            model.setValue("workprocedurefield", null);
            model.setValue("operationdescfield", null);
            model.setValue("oprnofield", null);
            this.setControlState(false);
        }
        this.getPageCache().put("isIgnoreChangeListener", "false");
    }

    public int getSelectEntryRowIndex() {
        int currentEntryIndex = -1;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("stockentry");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            currentEntryIndex = selectRows[0];
        }
        return currentEntryIndex;
    }

    private void setControlState(boolean flag) {
        this.getView().setEnable(Boolean.valueOf(flag), new String[]{"workprocedurefield", "oprnofield"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (StringUtils.equals((CharSequence)"stockentry", (CharSequence)entryGrid.getKey())) {
            DynamicObject entryentity = this.getModel().getEntryRowEntity("stockentry", this.getSelectEntryRowIndex());
            this.showEntryDetial(entryentity);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("true".equals(this.getPageCache().get("isIgnoreChangeListener"))) {
            return;
        }
        this.getPageCache().put("isIgnoreChangeListener", "true");
        int currentIndex = this.getSelectEntryRowIndex();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int changeIndex = e.getChangeSet()[0].getRowIndex();
        Object val = newValue;
        int currentSelectIndex = this.getSelectEntryRowIndex();
        if (currentSelectIndex > -1) {
            this.setEntryDownFieldValue(key, newValue, currentSelectIndex);
        } else {
            this.showEntryDetial(null);
            if (changeIndex == -1) {
                this.getPageCache().put("isIgnoreChangeListener", "false");
                return;
            }
        }
        if ("oprnofield".equals(key) && !StockCulUtils.isInteger((Object)newValue)) {
            if (StockCulUtils.isInteger((Object)oldValue)) {
                val = oldValue;
            } else if ("oprnofield".equals(key)) {
                val = "10";
            }
            if (val != newValue) {
                this.getModel().setValue(key, val);
            }
        }
        if (currentIndex > -1) {
            switch (key) {
                case "oprnofield": {
                    this.clearManuftechInfo(currentIndex);
                    break;
                }
            }
        }
        this.getPageCache().put("isIgnoreChangeListener", "false");
    }

    private void setEntryDownFieldValue(String key, Object newValue, int currentSelectIndex) {
        String entryFieldName = manuFieldMaps.get(key);
        if (StringUtils.isNotEmpty((CharSequence)entryFieldName) && currentSelectIndex >= 0) {
            this.getModel().setValue(entryFieldName, newValue, currentSelectIndex);
        }
    }

    private void clearManuftechInfo(int currentIndex) {
        this.getModel().setValue("workprocedurefield", null);
        this.getModel().setValue("operationdescfield", null);
        this.getModel().setValue("workprocedureid", null, currentIndex);
        this.getModel().setValue("operationdesc", null, currentIndex);
    }

    public boolean isJumpLevel(DynamicObject stockEntry) {
        return stockEntry.getBoolean("isjumplevel");
    }

    static {
        manuFieldMaps.put("oprnofield", "oprno");
        manuFieldMaps.put("workprocedurefield", "workprocedureid");
        manuFieldMaps.put("operationdescfield", "operationdesc");
    }
}

