/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.prop.formplugin.report;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mmc.prop.business.helper.PropMftOrderReportHelper;

public class PropReportMftOrderBillEdit
extends AbstractFormPlugin
implements RowClickEventListener,
BeforeF7SelectListener {
    private Boolean isIgnoreChangeListener = Boolean.FALSE;
    private static final Map<String, String> fieldMaps = new HashMap<String, String>();

    public static String getFieldName(String key) {
        return fieldMaps.get(key);
    }

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        BasedataEdit userno;
        BasedataEdit represources;
        BasedataEdit repactivity;
        EntryGrid entryActGrid;
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("sumentry");
        if (entryGrid != null) {
            entryGrid.addRowClickListener((RowClickEventListener)this);
        }
        if ((entryActGrid = (EntryGrid)this.getView().getControl("subentryentity")) != null) {
            entryActGrid.addRowClickListener((RowClickEventListener)this);
        }
        if ((repactivity = (BasedataEdit)this.getView().getControl("repactivity")) != null) {
            repactivity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((represources = (BasedataEdit)this.getView().getControl("represources")) != null) {
            represources.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((userno = (BasedataEdit)this.getView().getControl("userno")) != null) {
            userno.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (this.isIgnoreChangeListener.booleanValue()) {
            this.isIgnoreChangeListener = Boolean.FALSE;
            return;
        }
        String propertyName = e.getProperty().getName();
        Object newObj = e.getChangeSet()[0].getNewValue();
        int currentIndex = this.getSelectEntryRowIndex();
        ChangeData changeData = e.getChangeSet()[0];
        if (currentIndex > -1) {
            DynamicObject dataEntity = this.getModel().getEntryRowEntity("sumentry", currentIndex);
            this.entryToOther(dataEntity);
            String entryFieldName = PropReportMftOrderBillEdit.getFieldName(propertyName);
            if (StringUtils.isNotEmpty((CharSequence)entryFieldName) && currentIndex >= 0) {
                this.getModel().setValue(entryFieldName, newObj, currentIndex);
            }
        }
        this.copyEntryToDetail(propertyName, newObj);
        if (null == this.getPageCache().get("isIgnoreSubentryentityChangeListener") || StringUtils.equals((CharSequence)"false", (CharSequence)this.getPageCache().get("isIgnoreSubentryentityChangeListener"))) {
            HashSet set;
            if ("repactivity".equals(propertyName)) {
                this.propChangeRepactivity(changeData);
            }
            if ("repbaseqty".equals(propertyName)) {
                this.propChangeRepbaseqty(changeData);
            }
            if ("actstandardformula".equals(propertyName)) {
                this.propChangeRepActStandardformula(changeData);
            }
            if ((set = Sets.newHashSet((Object[])new String[]{"completqty", "qualifyqty", "concesionqty", "workwasteqty", "scrapqty", "scrappedqty", "repairqty", "reworkqty"})).contains(propertyName)) {
                this.properChangeCalRepActualQty();
            }
        }
    }

    private void properChangeCalRepActualQty() {
        DynamicObjectCollection subentryentitys = this.getModel().getEntryEntity("subentryentity");
        if (subentryentitys != null) {
            for (DynamicObject subentryentity : subentryentitys) {
                BigDecimal repactualqty = this.calRepactualqty(subentryentity);
                this.getModel().setValue("repactualqty", (Object)repactualqty, subentryentity.getInt("seq") - 1);
            }
        }
    }

    private void propChangeRepactivity(ChangeData changeData) {
        int rowIndex = changeData.getRowIndex();
        Object newValue = changeData.getNewValue();
        DynamicObject repactivity = (DynamicObject)newValue;
        this.getModel().setValue("repactivity", (Object)repactivity, rowIndex);
        if (null != repactivity) {
            repactivity = BusinessDataServiceHelper.loadSingleFromCache((Object)repactivity.getPkValue(), (String)"mpdm_processactivity", (String)"baseqty");
            BigDecimal repbaseqty = repactivity.getBigDecimal("baseqty");
            this.getModel().setValue("repbaseqty", (Object)repbaseqty, rowIndex);
        }
        DynamicObject subentryentity = this.getModel().getEntryRowEntity("subentryentity", rowIndex);
        BigDecimal repactualqty = this.calRepactualqty(subentryentity);
        this.getModel().setValue("repactualqty", (Object)repactualqty, rowIndex);
    }

    private void propChangeRepbaseqty(ChangeData changeData) {
        int rowIndex = changeData.getRowIndex();
        Object newValue = changeData.getNewValue();
        BigDecimal repbaseqty = (BigDecimal)newValue;
        this.getModel().setValue("repbaseqty", (Object)repbaseqty, rowIndex);
        DynamicObject subentryentity = this.getModel().getEntryRowEntity("subentryentity", rowIndex);
        BigDecimal repactualqty = this.calRepactualqty(subentryentity);
        this.getModel().setValue("repactualqty", (Object)repactualqty, rowIndex);
    }

    private void propChangeRepActStandardformula(ChangeData changeData) {
        int rowIndex = changeData.getRowIndex();
        this.getModel().setValue("actstandardformula", changeData.getNewValue(), rowIndex);
        DynamicObject subentryentity = this.getModel().getEntryRowEntity("subentryentity", rowIndex);
        BigDecimal repactualqty = this.calRepactualqty(subentryentity);
        this.getModel().setValue("repactualqty", (Object)repactualqty, rowIndex);
    }

    private void copyEntryToDetail(String filed, Object newObj) {
        switch (filed) {
            case "concesionbsqty": {
                this.getModel().setValue("entryconcesionbsqty", newObj);
                break;
            }
        }
    }

    public int getSelectEntryRowIndex() {
        int currentEntryIndex = -1;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("sumentry");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            currentEntryIndex = selectRows[0];
        }
        return currentEntryIndex;
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (StringUtils.equals((CharSequence)"sumentry", (CharSequence)entryGrid.getKey())) {
            DynamicObject entryentity = this.getModel().getEntryRowEntity("sumentry", evt.getRow());
            this.showEntryDetial(entryentity);
        }
    }

    private void showEntryDetial(DynamicObject entryentity) {
        this.isIgnoreChangeListener = Boolean.TRUE;
        if (entryentity != null) {
            IDataModel model = this.getModel();
            model.setValue("entryqualifywareqty", entryentity.get("qualifywareqty"));
            model.setValue("entryscrappedwareqty", entryentity.get("scrappedwareqty"));
            model.setValue("entrypushdownwareqty", entryentity.get("pushdownwareqty"));
            this.entryToOther(entryentity);
        }
        this.isIgnoreChangeListener = Boolean.FALSE;
    }

    private void entryToOther(DynamicObject entryentity) {
        IDataModel model = this.getModel();
        model.setValue("entrybaseunit", entryentity.get("baseunit"));
        model.setValue("entrycplbsqty", entryentity.get("completbsqty"));
        model.setValue("entryqualifybsqty", entryentity.get("qualifybsqty"));
        model.setValue("entrywstbsqty", entryentity.get("workwastebsqty"));
        model.setValue("entryscrapbsqty", entryentity.get("scrapbsqty"));
        model.setValue("entrysrpbsqty", entryentity.get("scrappedbsqty"));
        model.setValue("entryconcesionbsqty", entryentity.get("concesionbsqty"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key = e.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"previousentry") || StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"nextentry")) {
            DynamicObject entryentity = this.getModel().getEntryRowEntity("sumentry", this.getSelectEntryRowIndex());
            this.showEntryDetial(entryentity);
        } else if (StringUtils.equals((CharSequence)"newentryact", (CharSequence)key) || StringUtils.equals((CharSequence)"insertentryact", (CharSequence)key)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("sumentry");
            EntryGrid entryActGrid = (EntryGrid)this.getView().getControl("subentryentity");
            if (entryGrid.getSelectRows().length == 0) {
                return;
            }
            int rowIndex = entryGrid.getSelectRows()[0];
            int rowIndexAct = entryActGrid.getSelectRows()[0];
            DynamicObject entrySum = this.getModel().getEntryRowEntity("sumentry", rowIndex);
            Long mftentryid = entrySum.getLong("mftentryid");
            String selectPro = "treeentryentity.processroute,treeentryentity.id,treeentryentity.planbegintime,treeentryentity.planendtime,treeentryentity.routereplace";
            QFilter qf = new QFilter("treeentryentity.id", "=", (Object)mftentryid);
            Date planbegintime = null;
            Date planendtime = null;
            try (DataSet mftOrderEntryDataSets = QueryServiceHelper.queryDataSet((String)"mmc-POMReportMftOrderBillEdit", (String)"prop_mftorder", (String)selectPro, (QFilter[])qf.toArray(), null);){
                while (mftOrderEntryDataSets.hasNext()) {
                    Row mftOrderEntryDataSet = mftOrderEntryDataSets.next();
                    planbegintime = mftOrderEntryDataSet.getDate("treeentryentity.planbegintime");
                    planendtime = mftOrderEntryDataSet.getDate("treeentryentity.planendtime");
                }
            }
            if (null != planbegintime && planendtime != null) {
                this.getModel().setValue("repactualbegintime", (Object)planbegintime, rowIndexAct);
                this.getModel().setValue("repactualfinishtime", (Object)planendtime, rowIndexAct);
            }
        }
    }

    private BigDecimal calRepactualqty(DynamicObject subentryentity) {
        Object processactivityPk;
        BigDecimal repactualqty = new BigDecimal(0);
        DynamicObject processactivity = subentryentity.getDynamicObject("repactivity");
        if (null != processactivity && null != (processactivityPk = processactivity.getPkValue())) {
            processactivity = BusinessDataServiceHelper.loadSingleFromCache((Object)processactivityPk, (String)"mpdm_processactivity");
            int seq = subentryentity.getInt("seq");
            try {
                repactualqty = PropMftOrderReportHelper.runFormula((DynamicObject)subentryentity, (DynamicObject)processactivity);
            }
            catch (Exception e) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6d3b\u52a8\u7b2c%s\u884c\u6d3b\u52a8\u516c\u5f0f\u6267\u884c\u5931\u8d25,\u8bf7\u68c0\u67e5\u516c\u5f0f\u8bed\u6cd5\u662f\u5426\u6b63\u786e", (String)"POMReportMftOrderBillEdit_0", (String)"mmc-pom-formplugin", (Object[])new Object[0]), seq));
            }
        }
        return repactualqty;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("sumentry");
        int rowcount = this.getModel().getEntryRowCount("sumentry");
        if (entryGrid != null && rowcount > 0) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"docbilltype"});
            entryGrid.selectRows(0, true);
            DynamicObject entryentity = this.getModel().getEntryRowEntity("sumentry", 0);
            this.showEntryDetial(entryentity);
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"docbilltype"});
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (StringUtils.equals((CharSequence)billStatus, (CharSequence)"A")) {
            e.setCheckDataChange(true);
        } else {
            e.setCheckDataChange(false);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Control con = (Control)evt.getSource();
        String source = con.getKey();
        if ("repactivity".equals(source)) {
            this.filterRepactivity(evt);
        }
        if ("represources".equals(source)) {
            this.filterRepresources(evt);
        }
    }

    private void filterRepactivity(BeforeF7SelectEvent evt) {
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        listShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
        listShowParameter.setMultiSelect(false);
        DynamicObject mftOrderReportBill = this.getModel().getDataEntity();
        DynamicObject mftOrg = (DynamicObject)mftOrderReportBill.get("org");
        if (null == mftOrg) {
            return;
        }
        Long mftOrgId = mftOrg.getLong("masterid");
        if (null != mftOrgId) {
            QFilter qfilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_processactivity", (Long)mftOrgId);
            listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
        }
    }

    private void filterRepresources(BeforeF7SelectEvent evt) {
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        listShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
        listShowParameter.setMultiSelect(false);
        DynamicObject mftOrderReportBill = this.getModel().getDataEntity();
        DynamicObject mftOrg = (DynamicObject)mftOrderReportBill.get("org");
        if (null == mftOrg) {
            return;
        }
        QFilter qfilter = new QFilter("enable", "=", (Object)"1");
        qfilter.and(new QFilter("status", "=", (Object)"C"));
        Long mftOrgId = mftOrg.getLong("masterid");
        if (null != mftOrgId) {
            QFilter resourceOrgQFilter = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_resources", (Long)mftOrgId);
            qfilter.and(resourceOrgQFilter);
        }
        listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
    }

    static {
        fieldMaps.put("entrybegintime", "begintime");
        fieldMaps.put("entryendtime", "endtime");
        fieldMaps.put("entryqualifywareqty", "qualifywareqty");
        fieldMaps.put("entryunqualifywareqty", "unqualifywareqty");
        fieldMaps.put("entryscrappedwareqty", "scrappedwareqty");
    }
}

