/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.prop.common.mftorder.utils;

import java.math.BigDecimal;
import kd.bd.mpdm.common.utils.UnitPrecisionUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class UnitRateConvertUtil {
    private static final Log logger = LogFactory.getLog(UnitRateConvertUtil.class);

    public static BigDecimal getUnitRateConvert(Long materialId, Long srcUnitId, Long desUnitId) {
        String message = String.format(ResManager.loadKDString((String)"\u5355\u4f4d\u8f6c\u6362 ---\u5355\u4f4d\u6362\u7b97-\u53c2\u6570 \u6e90\u5355\u4f4did:%1$s \u76ee\u6807\u5355\u4f4did:%2$s \u7269\u6599id\uff1a%3$s", (String)"UnitRateConvertUtil_1", (String)"mmc-prop-common", (Object[])new Object[0]), srcUnitId, desUnitId, materialId);
        logger.info(message);
        BigDecimal unitRate = null;
        if (materialId == null || srcUnitId == null || desUnitId == null) {
            unitRate = BigDecimal.ZERO;
        } else if (srcUnitId.longValue() == desUnitId.longValue()) {
            unitRate = BigDecimal.ONE;
        } else {
            DynamicObject muConv = null;
            DynamicObject measureUnits = BusinessDataServiceHelper.loadSingleFromCache((Object)desUnitId, (String)"bd_measureunits");
            int type = UnitRateConvertUtil.getUnitPrecisionAccount(measureUnits.getString("precisionaccount"));
            try {
                muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
                if (muConv != null && muConv.getInt("denominator") != 0) {
                    unitRate = new BigDecimal(muConv.getInt("numerator")).divide(new BigDecimal(muConv.getInt("denominator")), measureUnits.getInt("precision"), type);
                }
            }
            catch (ArithmeticException arithmeticException) {
            }
            catch (Exception e) {
                throw new KDBizException(message);
            }
        }
        if (unitRate == null) {
            unitRate = BigDecimal.ZERO;
        }
        logger.error("\u5355\u4f4d\u6362\u7b97\u7387\u7ed3\u679c\u4e3a\uff1a" + unitRate);
        return unitRate;
    }

    public static int getUnitPrecisionAccount(String precisionAccount) {
        return UnitPrecisionUtils.getPrecisionDeal((String)precisionAccount);
    }
}

