/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class OutPurExectionRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static String[] repQueryFields = new String[]{"org", "purchaseorg", "planbegintime", "planfinishtime", "supplier", "oprno", "oprnumber", "manftechrowstatus", "order", "orderto", "manftechno", "material"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit t = (TextEdit)this.getControl("order");
        t.addClickListener((ClickListener)this);
        t = (TextEdit)this.getControl("orderto");
        t.addClickListener((ClickListener)this);
        BasedataEdit edit = (BasedataEdit)this.getControl("material");
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        edit = (BasedataEdit)this.getControl("oprno");
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        edit = (BasedataEdit)this.getControl("org");
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        edit = (BasedataEdit)this.getControl("supplier");
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        edit = (BasedataEdit)this.getControl("manftechno");
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fileName = evt.getProperty().getName();
        if ("org".equals(fileName)) {
            long userID = RequestContext.get().getCurrUserId();
            String appId = this.getView().getFormShowParameter().getAppId();
            HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userID, (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
            if (!result.hasAllOrgPerm()) {
                ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)result.getHasPermOrgs()));
                listShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
            }
        }
    }

    public void setSortAndFilter(List<SortAndFilterEvent> allColumns) {
        TreeSet<String> set = new TreeSet<String>(Arrays.asList("e_purchaseorg", "e_oproperation", "e_oprdescription", "e_org", "e_manftech", "e_material", "e_oprno", "e_supplier"));
        for (SortAndFilterEvent sort : allColumns) {
            if (!set.contains(sort.getColumnName())) continue;
            sort.setSort(true);
            sort.setFilter(true);
        }
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object isFromSFC = params.get("isfromSFC");
        if (isFromSFC != null && "true".equals(isFromSFC)) {
            Object org = showParameter.getCustomParam("org");
            Object purchaseOrg = showParameter.getCustomParam("purchaseorg");
            Object order = showParameter.getCustomParam("order");
            List oprNoList = (List)showParameter.getCustomParam("oprno");
            Object[] oprNo = new Object[]{};
            if (oprNoList != null && oprNoList.size() > 0) {
                oprNo = oprNoList.toArray();
            }
            Object oprNumber = showParameter.getCustomParam("oprnumber");
            Object manftechRowStatus = showParameter.getCustomParam("manftechrowstatus");
            List manftechNoList = (List)showParameter.getCustomParam("manftechno");
            Object[] manftechNo = new Object[]{};
            if (manftechNoList != null && manftechNoList.size() > 0) {
                manftechNo = manftechNoList.toArray();
            }
            List materialList = (List)showParameter.getCustomParam("material");
            Object[] material = new Object[]{};
            if (materialList != null && materialList.size() > 0) {
                material = materialList.toArray();
            }
            Object planBeginTime = showParameter.getCustomParam("planbegintime");
            Object planFinishTime = showParameter.getCustomParam("planfinishtime");
            model.setValue("org", org);
            model.setValue("purchaseorg", purchaseOrg);
            model.setValue("begintime", planBeginTime);
            model.setValue("endtime", planBeginTime);
            model.setValue("finishbegin", planFinishTime);
            model.setValue("finishend", planFinishTime);
            model.setValue("oprno", (Object)oprNo);
            model.setValue("oprnumber", oprNumber);
            model.setValue("manftechrowstatus", manftechRowStatus);
            model.setValue("order", order);
            model.setValue("orderto", order);
            model.setValue("manftechno", (Object)manftechNo);
            model.setValue("material", (Object)material);
            ReportFilter filter = (ReportFilter)this.getView().getControl("reportfilterap");
            this.getView().setEnable(Boolean.valueOf(false), repQueryFields);
            filter.search();
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        Control source = (Control)evt.getSource();
        String fieldKey = source.getKey();
        if ("order".equals(fieldKey) || "orderto".equals(fieldKey)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"OutPurExectionRptPlugin_0", (String)"mmc-sfc-report", (Object[])new Object[0]));
                return;
            }
            boolean isMultiSelect = true;
            if ("orderto".equals(fieldKey)) {
                isMultiSelect = false;
            }
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"pom_mftorder", (boolean)isMultiSelect);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldKey));
            Object orderNos = this.getModel().getValue(fieldKey);
            List<String> inputOrderNos = OutPurExectionRptPlugin.getInputOrderNos(orderNos);
            if (!inputOrderNos.isEmpty()) {
                QFilter[] qfs = new QFilter[]{new QFilter("billno", "in", inputOrderNos)};
                String orderEntity = this.getOrderEntity();
                String algoKey = "query-" + orderEntity;
                String sels = "id";
                HashSet<Object> billIds = new HashSet<Object>(16);
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)orderEntity, (String)sels, (QFilter[])qfs, null);){
                    while (dataSet.hasNext()) {
                        Row next = dataSet.next();
                        billIds.add(next.get("id"));
                    }
                }
                listShowParameter.setSelectedRows(billIds.toArray());
            }
            List filters = listShowParameter.getListFilterParameter().getQFilters();
            filters.add(new QFilter("billstatus", "=", (Object)"C"));
            filters.add(new QFilter("org", "=", org.getPkValue()));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        ListSelectedRowCollection list = (ListSelectedRowCollection)returnData;
        StringBuilder billNoStr = new StringBuilder();
        for (ListSelectedRow listSelectedRow : list) {
            String billNo = listSelectedRow.getBillNo();
            billNoStr.append(billNo).append(";");
        }
        this.getModel().setValue(actionId, (Object)billNoStr);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if ("order".equals(propertyName)) {
            ChangeData[] changeArr = e.getChangeSet();
            ChangeData changedata = changeArr[0];
            Object orderNoObj = changedata.getNewValue();
            List<String> inputOrderNos = OutPurExectionRptPlugin.getInputOrderNos(orderNoObj);
            if (inputOrderNos.size() > 1) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"orderto"});
                this.getModel().setValue("orderto", null);
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"orderto"});
                this.getModel().setValue("orderto", orderNoObj);
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        Object source = e.getSource();
        if (source instanceof FieldEdit) {
            String fieldEditKey;
            FieldEdit fieldEdit = (FieldEdit)source;
            switch (fieldEditKey = fieldEdit.getKey()) {
                case "order": 
                case "orderto": {
                    this.orderFieldPostBack(e);
                    break;
                }
            }
        }
    }

    private void orderFieldPostBack(BeforeFieldPostBackEvent e) {
        FieldEdit fieldEdit = (FieldEdit)e.getSource();
        String fieldEditKey = fieldEdit.getKey();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"OutPurExectionRptPlugin_0", (String)"mmc-sfc-report", (Object[])new Object[0]));
            this.getView().updateView(fieldEditKey);
            e.setCancel(true);
            return;
        }
        Object orderNoStrObj = e.getValue();
        List<String> inputOrderNos = OutPurExectionRptPlugin.getInputOrderNos(orderNoStrObj);
        if (inputOrderNos.isEmpty()) {
            return;
        }
        if ("orderto".equals(fieldEditKey) && inputOrderNos.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5de5\u5355\uff08\u81f3\uff09\u4e0d\u80fd\u591a\u9009", (String)"OutPurExectionRptPlugin_1", (String)"mmc-sfc-report", (Object[])new Object[0]));
            this.getView().updateView(fieldEditKey);
            e.setCancel(true);
            return;
        }
        QFilter orgQf = new QFilter("org", "=", org.getPkValue());
        QFilter statusQf = new QFilter("billstatus", "=", (Object)"C");
        QFilter inputOrderNosQf = new QFilter("billno", "in", inputOrderNos);
        QFilter[] qfs = new QFilter[]{orgQf, statusQf, inputOrderNosQf};
        String orderEntity = this.getOrderEntity();
        String algoKey = "query-" + orderEntity;
        String sels = "billno";
        ArrayList<String> billNos = new ArrayList<String>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)orderEntity, (String)sels, (QFilter[])qfs, null);){
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                billNos.add(next.getString("billno"));
            }
        }
        ArrayList<String> inLegOrders = new ArrayList<String>(16);
        StringBuilder errOrderStr = new StringBuilder();
        for (String orderNo : inputOrderNos) {
            if (billNos.contains(orderNo)) continue;
            inLegOrders.add(orderNo);
            errOrderStr.append(orderNo).append(";");
        }
        if (!inLegOrders.isEmpty()) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u5de5\u5355\u53f7[%1$s]\u4e0d\u5728\u53ef\u9009\u8303\u56f4\u5185", (String)"OutPurExectionRptPlugin_2", (String)"mmc-sfc-report", (Object[])new Object[0]), errOrderStr.toString());
            this.getView().showTipNotification(errMsg);
            this.getView().updateView(fieldEditKey);
            e.setCancel(true);
        }
    }

    private String getOrderEntity() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("order") != null) {
            return customParams.get("order").toString();
        }
        return "pom_mftorder";
    }

    public static List<String> getInputOrderNos(Object orderNoStrObj) {
        String[] orderNos;
        ArrayList<String> inputOrderNos = new ArrayList<String>(16);
        if (orderNoStrObj == null) {
            return inputOrderNos;
        }
        if (StringUtils.isEmpty((CharSequence)orderNoStrObj.toString())) {
            return inputOrderNos;
        }
        String orderNoStr = orderNoStrObj.toString();
        for (String orderNo : orderNos = orderNoStr.split(";|\uff1b|,|\uff0c| ")) {
            if (StringUtils.isEmpty((CharSequence)orderNo)) continue;
            inputOrderNos.add(orderNo);
        }
        return inputOrderNos;
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        return this.verifyQueryImp(queryParam);
    }

    private boolean verifyQueryImp(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        StringBuilder sb = new StringBuilder();
        if (filter.getValue("org") == null) {
            sb.append(ResManager.loadKDString((String)"\u201c\u751f\u4ea7\u7ec4\u7ec7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OutPurExectionRptPlugin_3", (String)"mmc-sfc-report", (Object[])new Object[0]));
            sb.append("\r\n");
        }
        boolean flag = true;
        if (filter.getValue("begintime") == null || filter.getValue("endtime") == null) {
            flag = false;
        }
        if (flag) {
            Date begintime = filter.getDate("begintime");
            Date endtime = filter.getDate("endtime");
            if (filter.getValue("finishbegin") != null || filter.getValue("finishend") != null) {
                Date finishbegin = filter.getDate("finishbegin");
                Date finishend = filter.getDate("finishend");
                if (finishbegin.before(begintime)) {
                    sb.append(ResManager.loadKDString((String)"\u6700\u65e9\u8ba1\u5212\u5b8c\u5de5\u65e5\u671f\u5e94\u665a\u4e8e\u7b49\u4e8e\u6700\u65e9\u8ba1\u5212\u5f00\u5de5\u65e5\u671f", (String)"OutPurExectionRptPlugin_4", (String)"mmc-sfc-report", (Object[])new Object[0]));
                    sb.append("\r\n");
                }
                if (finishend.before(endtime)) {
                    sb.append(ResManager.loadKDString((String)"\u6700\u665a\u8ba1\u5212\u5b8c\u5de5\u65e5\u671f\u5e94\u665a\u4e8e\u7b49\u4e8e\u6700\u665a\u8ba1\u5212\u5f00\u5de5\u65e5\u671f", (String)"OutPurExectionRptPlugin_5", (String)"mmc-sfc-report", (Object[])new Object[0]));
                    sb.append("\r\n");
                }
            }
        }
        if (sb.length() != 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u67e5\u8be2\u6761\u4ef6", (String)"OutPurExectionRptPlugin_6", (String)"mmc-sfc-report", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
            return false;
        }
        return true;
    }
}

