/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.CustomAggFunction;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.sfc.report.OutPurExectionRptPlugin;
import kd.mmc.sfc.report.StringAddAggFunction;

public class OutPurExectionRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static final ThreadLocal<Boolean> isOpenOrderDetails = new ThreadLocal();

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        List<QFilter> qfList = this.appendFilter();
        ArrayList<Long> manftechIds = new ArrayList<Long>(16);
        ArrayList<Long> manftechRowIds = new ArrayList<Long>(16);
        ArrayList<String> manftechRowStrIds = new ArrayList<String>(16);
        ArrayList<Long> materialIds = new ArrayList<Long>(16);
        String manSelectFields = this.getManSelectFields();
        DataSet sfcManftechTmpSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"sfc_manftech", (String)manSelectFields, (QFilter[])qfList.toArray(new QFilter[0]), null);
        GroupbyDataSet groupbyManftechDataSet = sfcManftechTmpSet.groupBy(this.getManSelectGroupFields());
        DataSet sfcManftechToInfoSet = groupbyManftechDataSet.sum("e_operationqty").sum("e_operationbaseqty").finish();
        DynamicObjectCollection sfcManftechTmp = QueryServiceHelper.query((String)"sfc_manftech", (String)"id, oprentryentity.id, material", (QFilter[])qfList.toArray(new QFilter[0]));
        for (DynamicObject manftechObj : sfcManftechTmp) {
            manftechIds.add(manftechObj.getLong("id"));
            manftechRowIds.add(manftechObj.getLong("oprentryentity.id"));
            manftechRowStrIds.add(manftechObj.get("oprentryentity.id").toString());
            materialIds.add(manftechObj.getLong("material"));
        }
        QFilter materialFilter = new QFilter("masterid", "in", materialIds);
        DataSet materialInfoSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_materialmftinfo", (String)"masterid, mftunit e_unit", (QFilter[])new QFilter[]{materialFilter}, null);
        FilterInfo filter = this.getQueryParam().getFilter();
        ArrayList<QFilter> purOrderQFilterList = new ArrayList<QFilter>();
        purOrderQFilterList.add(new QFilter("billentry.techid", "in", manftechIds));
        purOrderQFilterList.add(new QFilter("billentry.oprentryid", "in", manftechRowIds));
        purOrderQFilterList.add(new QFilter("billstatus", "=", (Object)"C"));
        this.appendPurOrgFilter(filter, purOrderQFilterList);
        this.appendSupplierFilter(filter, purOrderQFilterList);
        DataSet purOrderTmpSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_om_purorderbill", (String)"id purid,billentry.srcbillid,billentry.id,org e_purchaseorg, supplier e_supplier, billno e_outordernumber, billentry.techid, billentry.oprentryid, billentry.baseqty e_purbaseqty", (QFilter[])purOrderQFilterList.toArray(new QFilter[0]), null);
        HashSet<Long> supplierSet = new HashSet<Long>(16);
        DynamicObjectCollection purOrderSupply = QueryServiceHelper.query((String)"pm_om_purorderbill", (String)"supplier", (QFilter[])purOrderQFilterList.toArray(new QFilter[0]));
        for (DynamicObject dyn : purOrderSupply) {
            supplierSet.add(dyn.getLong("supplier"));
        }
        GroupbyDataSet groupbyPurOrderDataSet = purOrderTmpSet.groupBy(new String[]{"purid", "billentry.id", "billentry.oprentryid", "e_purchaseorg", "e_supplier", "billentry.srcbillid"});
        StringAddAggFunction outOrderInitNumber = new StringAddAggFunction("e_outordernumber", (DataType)DataType.StringType);
        DataSet purOrderSet = groupbyPurOrderDataSet.sum("e_purbaseqty").agg((CustomAggFunction)outOrderInitNumber, "e_outordernumber", "e_outordernumber").finish();
        QFilter purOrderRowFilter = new QFilter("sumentry.oprentryid", "in", manftechRowStrIds);
        purOrderRowFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        DataSet processRepTmpSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"sfc_processreportbill", (String)"sumentry.oprentryid, sumentry.completqty e_purreportbaseqty", (QFilter[])new QFilter[]{purOrderRowFilter}, null);
        processRepTmpSet = processRepTmpSet.select("cast(sumentry.oprentryid as Long) sumentry.oprentryid, e_purreportbaseqty");
        GroupbyDataSet groupbyProRepDataSet = processRepTmpSet.groupBy(new String[]{"sumentry.oprentryid"});
        DataSet processRepSet = groupbyProRepDataSet.sum("e_purreportbaseqty").finish();
        QFilter omCmpQFilter = new QFilter("billentry.techid", "in", manftechIds);
        omCmpQFilter.and(new QFilter("billentry.oprentryid", "in", manftechRowIds));
        omCmpQFilter.and(new QFilter("supplier", "in", supplierSet));
        omCmpQFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        DataSet omCmplinTmpSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_mdc_omcmplinbill", (String)"billentry.mainbillentryid,supplier,billentry.techid omtechid,billentry.oprentryid entryid, billentry.baseqty e_puraccptbaseqty", (QFilter[])new QFilter[]{omCmpQFilter}, null);
        GroupbyDataSet groupbyOmCmpDataSet = omCmplinTmpSet.groupBy(new String[]{"billentry.mainbillentryid", "entryid", "omtechid", "supplier"});
        DataSet omCmplinSet = groupbyOmCmpDataSet.sum("e_puraccptbaseqty").finish();
        QFilter outApplyFilter = new QFilter("billentry.workproplanid", "in", manftechIds);
        outApplyFilter.and(new QFilter("billentry.workproplannoid", "in", manftechRowIds));
        outApplyFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        DataSet outApplySet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_outapplybill", (String)"id outid, billno e_outapplynumber, billentry.workproplanid, billentry.workproplannoid", (QFilter[])new QFilter[]{outApplyFilter}, null);
        QFilter repAdjustFilter = new QFilter("sumentry.manftechentry", "in", manftechRowStrIds);
        repAdjustFilter.and(new QFilter("sumentry.manftechno", "in", manftechIds));
        repAdjustFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        DataSet reportAdjustTmpSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"sfc_reportresource_adjust", (String)"sumentry.manftechentry, sumentry.adjustbaseqty e_adjustbaseqty", (QFilter[])new QFilter[]{repAdjustFilter}, null);
        reportAdjustTmpSet = reportAdjustTmpSet.select("cast(sumentry.manftechentry as Long) sumentry.manftechentry, e_adjustbaseqty");
        GroupbyDataSet groupbyRepAdjDataSet = reportAdjustTmpSet.groupBy(new String[]{"sumentry.manftechentry"});
        DataSet reportAdjustSet = groupbyRepAdjDataSet.sum("e_adjustbaseqty").finish();
        QFilter outManftechFilter = new QFilter("entry.manftechid", "in", manftechIds);
        outManftechFilter.and(new QFilter("entry.manftechentry", "in", manftechRowIds));
        outManftechFilter.and(new QFilter("supplier", "in", supplierSet));
        outManftechFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        DataSet outManftechTmpSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"sfc_outmanftechissue", (String)"supplier outsupplier, entry.manftechentry manftechentry, entry.qty e_outmanftechqty, entry.baseqty e_outmanftechbaseqty", (QFilter[])new QFilter[]{outManftechFilter}, null);
        GroupbyDataSet groupByOutManftechDataSet = outManftechTmpSet.groupBy(new String[]{"outsupplier", "manftechentry"});
        DataSet outManftechSet = groupByOutManftechDataSet.sum("e_outmanftechqty").sum("e_outmanftechbaseqty").finish();
        DataSet sfcManftechSet = sfcManftechToInfoSet.leftJoin(materialInfoSet).on("e_material", "masterid").select(sfcManftechToInfoSet.getRowMeta().getFieldNames(), materialInfoSet.getRowMeta().getFieldNames()).finish();
        DataSet manFtechAndJoinTmpDataSet = sfcManftechSet.leftJoin(outApplySet).on("oprentryentity.id", "billentry.workproplannoid").select(sfcManftechSet.getRowMeta().getFieldNames(), outApplySet.getRowMeta().getFieldNames()).finish();
        DataSet manFtechAndJoinDataSet = manFtechAndJoinTmpDataSet.leftJoin(purOrderSet).on("oprentryentity.id", "billentry.oprentryid").on("outid", "billentry.srcbillid").select(manFtechAndJoinTmpDataSet.getRowMeta().getFieldNames(), purOrderSet.getRowMeta().getFieldNames()).finish();
        if (filter.getDynamicObject("purchaseorg") != null) {
            manFtechAndJoinDataSet = manFtechAndJoinDataSet.where("e_purchaseorg is not null");
        }
        if (filter.getDynamicObjectCollection("supplier") != null) {
            manFtechAndJoinDataSet = manFtechAndJoinDataSet.where("e_supplier is not null");
        }
        DataSet manFtechToPurDataSet = manFtechAndJoinDataSet.leftJoin(omCmplinSet).on("billentry.id", "billentry.mainbillentryid").select(manFtechAndJoinDataSet.getRowMeta().getFieldNames(), omCmplinSet.getRowMeta().getFieldNames()).finish();
        DataSet manFtechToProRepToPurDataSet = manFtechToPurDataSet.leftJoin(processRepSet).on("oprentryentity.id", "sumentry.oprentryid").select(manFtechToPurDataSet.getRowMeta().getFieldNames(), processRepSet.getRowMeta().getFieldNames()).finish();
        DataSet manFtechToRepAdjustDataSet = manFtechToProRepToPurDataSet.leftJoin(reportAdjustSet).on("oprentryentity.id", "sumentry.manftechentry").select(manFtechToProRepToPurDataSet.getRowMeta().getFieldNames(), reportAdjustSet.getRowMeta().getFieldNames()).finish();
        DataSet resDataSet = manFtechToRepAdjustDataSet.leftJoin(outManftechSet).on("oprentryentity.id", "manftechentry").on("e_supplier", "outsupplier").select(manFtechToRepAdjustDataSet.getRowMeta().getFieldNames(), outManftechSet.getRowMeta().getFieldNames()).finish();
        this.hideSwitch(reportQueryParam);
        String[] groupFieldsSet = this.getGroupFields();
        GroupbyDataSet groupbyDataSet = resDataSet.groupBy(groupFieldsSet);
        StringAddAggFunction outApplyNumber = new StringAddAggFunction("e_outapplynumber", (DataType)DataType.StringType);
        StringAddAggFunction outOrderNumber = new StringAddAggFunction("e_outordernumber", (DataType)DataType.StringType);
        DataSet midDataSet = groupbyDataSet.sum("e_purreportbaseqty").agg((CustomAggFunction)outApplyNumber, "e_outapplynumber", "e_outapplynumber").agg((CustomAggFunction)outOrderNumber, "e_outordernumber", "e_outordernumber").finish();
        String[] finalGroupFields = this.getFinalGroupFields();
        GroupbyDataSet groupbyFinalDataSet = midDataSet.groupBy(finalGroupFields);
        DataSet finishDataSet = groupbyFinalDataSet.sum("e_purbaseqty").sum("e_puraccptbaseqty").max("e_outmanftechqty").max("e_outmanftechbaseqty").sum("e_purreportbaseqty").agg((CustomAggFunction)outApplyNumber, "e_outapplynumber", "e_outapplynumber").agg((CustomAggFunction)outOrderNumber, "e_outordernumber", "e_outordernumber").finish().distinct();
        finishDataSet = finishDataSet.addField("case when e_puraccptbaseqty is NULL then e_outmanftechbaseqty when e_outmanftechbaseqty is null then (0 - e_puraccptbaseqty) else (e_outmanftechbaseqty - e_puraccptbaseqty) end", "e_sendnoreturnqty");
        ReportQueryParam queryParam = this.getQueryParam();
        List headFilters = queryParam.getFilter().getHeadFilters();
        String s = "";
        Boolean flag = false;
        if (!headFilters.isEmpty()) {
            for (QFilter qFilter2 : headFilters) {
                String partSql = "";
                String field = qFilter2.getProperty();
                if ("e_manftech".equals(field)) {
                    partSql = qFilter2.toString();
                } else if ("e_org".equals(field)) {
                    partSql = this.getBaseDataSql(qFilter2, "bos_org", "e_org", "name");
                } else if ("e_purchaseorg".equals(field)) {
                    partSql = this.getBaseDataSql(qFilter2, "bos_org", "e_purchaseorg", "name");
                } else if ("e_material".equals(field)) {
                    partSql = this.getBaseDataSql(qFilter2, "bd_material", "e_material", "number");
                } else if ("e_oprno".equals(field)) {
                    partSql = qFilter2.toString();
                } else if ("e_oproperation".equals(field)) {
                    partSql = this.getBaseDataSql(qFilter2, "mpdm_workprocedure", "e_oproperation", "number");
                } else if ("e_oprdescription".equals(field)) {
                    partSql = qFilter2.toString();
                } else if ("e_supplier".equals(field)) {
                    partSql = this.getBaseDataSql(qFilter2, "bd_supplier", "e_supplier", "number");
                }
                if ("".equals(partSql)) {
                    flag = true;
                    break;
                }
                if (!"".equals(s)) {
                    s = s + " AND " + partSql;
                    continue;
                }
                s = partSql;
            }
        }
        if (flag.booleanValue()) {
            finishDataSet = finishDataSet.filter("e_org = 0");
        } else if (!"".equals(s)) {
            finishDataSet = finishDataSet.filter(s);
        }
        if (queryParam.getSortInfo() != null) {
            return finishDataSet.orderBy(new String[]{queryParam.getSortInfo()});
        }
        return finishDataSet;
    }

    public String getBaseDataSql(QFilter qFilter, String entityName, String filed, String pro) {
        StringBuilder partSql = new StringBuilder(16);
        StringBuilder selectFiled = new StringBuilder(filed);
        if (qFilter.getCP().contains("is null")) {
            return selectFiled.append("= 0").toString();
        }
        if (qFilter.getCP().contains("not null")) {
            return selectFiled.append("> 0").toString();
        }
        qFilter.setProperty(pro);
        List nests = qFilter.getNests(true);
        if (nests != null) {
            qFilter.clearNests();
            for (QFilter.QFilterNest qFilterNest : nests) {
                QFilter filter = qFilterNest.getFilter();
                filter.setProperty(pro);
                qFilter.addFirstNest(filter, "and");
            }
        }
        DynamicObjectCollection dynamicObject = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])qFilter.toArray());
        Iterator iterator = dynamicObject.iterator();
        ArrayList<String> longs = new ArrayList<String>();
        while (iterator.hasNext()) {
            DynamicObject next = (DynamicObject)iterator.next();
            longs.add(next.getString("id"));
        }
        if (!longs.isEmpty()) {
            partSql = selectFiled.append(" in (");
            if (longs.size() == 1) {
                partSql.append((String)longs.get(0));
            } else {
                for (String aLong : longs) {
                    partSql.append(aLong).append(",");
                }
                partSql = new StringBuilder(partSql.substring(0, partSql.length() - 1));
            }
            partSql.append(")");
        }
        return partSql.toString();
    }

    private String[] getFinalGroupFields() {
        String[] manSelectGroupFields = this.getManSelectGroupFields();
        ArrayList<String> groupFieldsList = new ArrayList<String>(Arrays.asList(manSelectGroupFields));
        groupFieldsList.add("e_supplier");
        groupFieldsList.add("e_purchaseorg");
        groupFieldsList.add("e_unit");
        groupFieldsList.add("e_operationqty");
        groupFieldsList.add("e_operationbaseqty");
        String[] resFields = groupFieldsList.toArray(new String[groupFieldsList.size()]);
        return resFields;
    }

    private void hideSwitch(ReportQueryParam reportQueryParam) {
        List filterItems = reportQueryParam.getFilter().getFilterItems();
        for (FilterItemInfo filterItem : filterItems) {
            if ("isopenorderdetails".equals(filterItem.getPropName()) && filterItem.getValue().equals(false)) {
                isOpenOrderDetails.set(false);
            }
            if (!"isopenorderdetails".equals(filterItem.getPropName()) || !filterItem.getValue().equals(true)) continue;
            isOpenOrderDetails.set(true);
        }
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        if (isOpenOrderDetails.get().equals(false)) {
            this.isHideColumns(columns, true);
        } else {
            this.isHideColumns(columns, false);
        }
        isOpenOrderDetails.remove();
        return columns;
    }

    private void isHideColumns(List<AbstractReportColumn> columns, boolean isHide) {
        for (AbstractReportColumn reportColumn : columns) {
            if (reportColumn instanceof ReportColumn && "e_outapplynumber".equals(((ReportColumn)reportColumn).getFieldKey())) {
                ((ReportColumn)reportColumn).setHide(isHide);
            }
            if (!(reportColumn instanceof ReportColumn) || !"e_outordernumber".equals(((ReportColumn)reportColumn).getFieldKey())) continue;
            ((ReportColumn)reportColumn).setHide(isHide);
        }
    }

    private String getManSelectFields() {
        StringBuilder sql = new StringBuilder();
        sql.append("id").append(',');
        sql.append("oprentryentity.id").append(',');
        sql.append("org e_org").append(',');
        sql.append("billno e_manftech").append(',');
        sql.append("mftentryseq.entryseq e_mftentryseq").append(',');
        sql.append("mftentryseq.id e_mftentryseq1").append(',');
        sql.append("mftentryseq.headbillno e_manufactureorder").append(',');
        sql.append("oprentryentity.oprparent e_oprseq").append(',');
        sql.append("oprentryentity.oprno e_oprno").append(',');
        sql.append("oprentryentity.oproperation e_oproperation").append(',');
        sql.append("oprentryentity.oprdescription e_oprdescription").append(',');
        sql.append("material.name e_materialname").append(',');
        sql.append("material.id e_material").append(',');
        sql.append("material.modelnum e_model").append(',');
        sql.append("oprentryentity.oproperation.name e_oproperationname").append(',');
        sql.append("oprentryentity.oprplanbegintime e_proplanbegintime").append(',');
        sql.append("oprentryentity.oprplanfinishtime e_proplanendtime").append(',');
        sql.append("oprentryentity.oprunit e_oprunit").append(',');
        sql.append("baseunit e_baseunit").append(',');
        sql.append("oprentryentity.operationqty e_operationqty").append(',');
        sql.append("baseqty e_operationbaseqty");
        return sql.toString();
    }

    private String[] getManSelectGroupFields() {
        ArrayList<String> queryFields = new ArrayList<String>(16);
        queryFields.add("id");
        queryFields.add("oprentryentity.id");
        queryFields.add("e_org");
        queryFields.add("e_oprdescription");
        queryFields.add("e_manftech");
        queryFields.add("e_mftentryseq");
        queryFields.add("e_mftentryseq1");
        queryFields.add("e_manufactureorder");
        queryFields.add("e_oprseq");
        queryFields.add("e_oprno");
        queryFields.add("e_oproperation");
        queryFields.add("e_materialname");
        queryFields.add("e_material");
        queryFields.add("e_model");
        queryFields.add("e_oproperationname");
        queryFields.add("e_proplanbegintime");
        queryFields.add("e_proplanendtime");
        queryFields.add("e_oprunit");
        queryFields.add("e_baseunit");
        return queryFields.toArray(new String[queryFields.size()]);
    }

    public List<QFilter> appendFilter() {
        FilterInfo filter = this.getQueryParam().getFilter();
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        qfList.add(new QFilter("billstatus", "=", (Object)"C"));
        qfList.add(new QFilter("oprentryentity.machiningtype", "=", (Object)"1002"));
        this.appendOrgFilter(filter, qfList);
        this.appendStartTimeFilter(filter, qfList);
        this.appendFinishTimeFilter(filter, qfList);
        this.appendOprFilter(filter, qfList);
        this.appendOprNumberFilter(filter, qfList);
        this.appendManftechRowStatusFilter(filter, qfList);
        this.appendOrderFilter(filter, qfList);
        this.appendManftechNoFilter(filter, qfList);
        this.appendMaterialFilter(filter, qfList);
        return qfList;
    }

    private String[] getGroupFields() {
        String[] manSelectGroupFields = this.getManSelectGroupFields();
        ArrayList<String> groupFieldsList = new ArrayList<String>(Arrays.asList(manSelectGroupFields));
        groupFieldsList.add("e_supplier");
        groupFieldsList.add("e_purchaseorg");
        groupFieldsList.add("e_operationqty");
        groupFieldsList.add("e_operationbaseqty");
        groupFieldsList.add("e_unit");
        groupFieldsList.add("e_purbaseqty");
        groupFieldsList.add("e_puraccptbaseqty");
        groupFieldsList.add("e_outmanftechqty");
        groupFieldsList.add("e_outmanftechbaseqty");
        String[] resFields = groupFieldsList.toArray(new String[groupFieldsList.size()]);
        return resFields;
    }

    private void appendOrgFilter(FilterInfo filter, List<QFilter> qfList) {
        qfList.add(new QFilter("org", "=", filter.getDynamicObject("org").getPkValue()));
    }

    private void appendPurOrgFilter(FilterInfo filter, List<QFilter> qfList) {
        if (filter.getDynamicObject("purchaseorg") != null) {
            qfList.add(new QFilter("org", "=", filter.getDynamicObject("purchaseorg").getPkValue()));
        }
    }

    private void appendStartTimeFilter(FilterInfo filter, List<QFilter> qfList) {
        if (filter.getDate("begintime") != null && filter.getDate("endtime") != null) {
            Date beginDate = filter.getDate("begintime");
            Date endDate = filter.getDate("endtime");
            Calendar cal = Calendar.getInstance();
            cal.setTime(beginDate);
            cal.set(10, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            qfList.add(new QFilter("oprentryentity.oprplanbegintime", ">=", (Object)cal.getTime()));
            cal.setTime(endDate);
            cal.set(10, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.add(5, 1);
            qfList.add(new QFilter("oprentryentity.oprplanbegintime", "<", (Object)cal.getTime()));
        }
    }

    private void appendFinishTimeFilter(FilterInfo filter, List<QFilter> qfList) {
        if (filter.getDate("finishbegin") != null && filter.getDate("finishend") != null) {
            Date beginDate = filter.getDate("finishbegin");
            Date endDate = filter.getDate("finishend");
            Calendar cal = Calendar.getInstance();
            cal.setTime(beginDate);
            cal.set(10, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            qfList.add(new QFilter("oprentryentity.oprplanfinishtime", ">=", (Object)cal.getTime()));
            cal.setTime(endDate);
            cal.set(10, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.add(5, 1);
            qfList.add(new QFilter("oprentryentity.oprplanfinishtime", "<", (Object)cal.getTime()));
        }
    }

    private void appendSupplierFilter(FilterInfo filter, List<QFilter> qfList) {
        if (filter.getDynamicObjectCollection("supplier") != null) {
            HashSet idSet = new HashSet(filter.getDynamicObjectCollection("supplier").size());
            filter.getDynamicObjectCollection("supplier").forEach(obj -> idSet.add(obj.getPkValue()));
            qfList.add(new QFilter("supplier", "in", idSet));
        }
    }

    private void appendOprFilter(FilterInfo filter, List<QFilter> qfList) {
        if (filter.getDynamicObjectCollection("oprno") != null) {
            if (filter.getDynamicObjectCollection("oprno").size() == 1) {
                qfList.add(new QFilter("oprentryentity.oproperation", "=", ((DynamicObject)filter.getDynamicObjectCollection("oprno").get(0)).getPkValue()));
            } else {
                HashSet idSet = new HashSet(filter.getDynamicObjectCollection("oprno").size());
                filter.getDynamicObjectCollection("oprno").forEach(obj -> idSet.add(obj.getPkValue()));
                qfList.add(new QFilter("oprentryentity.oproperation", "in", idSet));
            }
        }
    }

    private void appendOprNumberFilter(FilterInfo filter, List<QFilter> qfList) {
        if (filter.getString("oprnumber") != null && !"".equals(filter.getString("oprnumber"))) {
            qfList.add(new QFilter("oprentryentity.oprno", "=", (Object)filter.getString("oprnumber")));
        }
    }

    private void appendManftechRowStatusFilter(FilterInfo filter, List<QFilter> qfList) {
        if (filter.getString("manftechrowstatus") != null) {
            qfList.add(new QFilter("oprentryentity.oprstatus", "in", (Object)filter.getString("manftechrowstatus").substring(1, filter.getString("manftechrowstatus").length() - 1).split(",")));
        }
    }

    private void appendOrderFilter(FilterInfo filter, List<QFilter> qfList) {
        String orderto;
        List<String> inputordertoNos;
        String orderStr = filter.getString("order");
        List<String> inputOrderNos = OutPurExectionRptPlugin.getInputOrderNos(orderStr);
        if (!inputOrderNos.isEmpty()) {
            if (inputOrderNos.size() == 1) {
                qfList.add(new QFilter("mftentryseq.headbillno", ">=", (Object)inputOrderNos.get(0)));
            } else {
                qfList.add(new QFilter("mftentryseq.headbillno", "in", inputOrderNos));
            }
        }
        if (!(inputordertoNos = OutPurExectionRptPlugin.getInputOrderNos(orderto = filter.getString("orderto"))).isEmpty()) {
            qfList.add(new QFilter("mftentryseq.headbillno", "<=", (Object)inputordertoNos.get(0)));
        }
    }

    private void appendManftechNoFilter(FilterInfo filter, List<QFilter> qfList) {
        if (filter.getDynamicObjectCollection("manftechno") != null) {
            if (filter.getDynamicObjectCollection("manftechno").size() == 1) {
                qfList.add(new QFilter("id", "=", ((DynamicObject)filter.getDynamicObjectCollection("manftechno").get(0)).getPkValue()));
            } else {
                HashSet idSet = new HashSet(filter.getDynamicObjectCollection("manftechno").size());
                filter.getDynamicObjectCollection("manftechno").forEach(obj -> idSet.add(obj.getPkValue()));
                qfList.add(new QFilter("id", "in", idSet));
            }
        }
    }

    private void appendMaterialFilter(FilterInfo filter, List<QFilter> qfList) {
        if (filter.getDynamicObjectCollection("material") != null) {
            if (filter.getDynamicObjectCollection("material").size() == 1) {
                qfList.add(new QFilter("material", "=", ((DynamicObject)filter.getDynamicObjectCollection("material").get(0)).getPkValue()));
            } else {
                HashSet idSet = new HashSet(filter.getDynamicObjectCollection("material").size());
                filter.getDynamicObjectCollection("material").forEach(obj -> idSet.add(obj.getPkValue()));
                qfList.add(new QFilter("material", "in", idSet));
            }
        }
    }
}

