/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.report.manuftech;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Locale;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class DailyPublicizeAllTabPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(DailyPublicizeAllTabPlugin.class);
    private static final String EntityNumber = "sfc_dailypublicize";
    private static final String EntityCount = "sfc_dailypublicize_rpt";

    public void afterCreateNewData(EventObject e) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        String appid = this.getAppId(EntityCount);
        Long org = RequestContext.get().getOrgId();
        if (PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)org, (String)appid, (String)EntityCount, (String)"47150e89000000ac") == 1) {
            this.getModel().setValue("org", (Object)org);
        } else {
            this.getModel().setValue("org", null);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, -1);
        calendar.set(5, calendar.getActualMinimum(5));
        this.getModel().setValue("startDate", (Object)sdf.format(calendar.getTime()));
        calendar.set(5, calendar.getActualMaximum(5));
        this.getModel().setValue("endDate", (Object)sdf.format(calendar.getTime()));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        if (this.getModel().getValue("org") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"DailyPublicizeAllTabPlugin_1", (String)"mmc-sfc-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObject org = filterInfo.getDynamicObject("org");
        this.getView().getPageCache().put("orgPKValue", String.valueOf(org.getPkValue()));
        this.getView().getPageCache().put("orgName", org.getString("name"));
        this.getView().getPageCache().put("orgId", org.getString("id"));
        this.getView().getPageCache().put("startDate", String.valueOf(filterInfo.getDate("startDate")));
        this.getView().getPageCache().put("endDate", String.valueOf(filterInfo.getDate("endDate")));
        this.getView().getPageCache().put("billstatus", filterInfo.getString("billstatus"));
        this.getView().getPageCache().put("meetingstatus", filterInfo.getString("meetingstatus"));
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        if ("meetingnumber".equals(e.getFieldName())) {
            String meetingType = e.getRowData().getString("meetingtypetext");
            String industry = e.getRowData().getString("industrytext");
            String org = this.getView().getPageCache().get("orgPKValue");
            String billstatus = this.getView().getPageCache().get("billstatus");
            String meetingstatus = this.getView().getPageCache().get("meetingstatus");
            QFilter qFilter = new QFilter("meetingtype.name", "=", (Object)meetingType);
            if (!"".equals(industry)) {
                qFilter.and(new QFilter("industry.name", "=", (Object)industry));
            } else {
                qFilter.and(new QFilter("industry.name", "=", null));
            }
            qFilter.and(new QFilter("org", "=", (Object)Long.parseLong(this.getView().getPageCache().get("orgPKValue"))));
            try {
                Date startDate = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US).parse(this.getView().getPageCache().get("startDate"));
                Date endDate = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US).parse(this.getView().getPageCache().get("endDate"));
                if (startDate != null && endDate != null) {
                    qFilter.and(new QFilter("meetingbegintime", ">=", (Object)startDate));
                    qFilter.and(new QFilter("meetingbegintime", "<=", (Object)endDate));
                }
            }
            catch (ParseException ex) {
                logger.error(ex.getMessage());
            }
            if (!"".equals(billstatus)) {
                qFilter.and(new QFilter("billstatus", "=", (Object)billstatus));
            }
            if (!"".equals(meetingstatus)) {
                qFilter.and(new QFilter("meetingstatus", "=", (Object)meetingstatus));
            }
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)EntityNumber, (String)"billno", (QFilter[])qFilter.toArray());
            Iterator iterator = dynamicObjectCollection.iterator();
            QFilter listQfilter = null;
            while (iterator.hasNext()) {
                DynamicObject dynamicObject = (DynamicObject)iterator.next();
                if (listQfilter == null) {
                    listQfilter = new QFilter("billno", "=", dynamicObject.get("billno"));
                    continue;
                }
                listQfilter.or(new QFilter("billno", "=", dynamicObject.get("billno")));
            }
            ListShowParameter showParams = ShowFormHelper.createShowListForm((String)"sfc_dailypublicize_lay", (boolean)true, (int)0, (boolean)false);
            ListFilterParameter params = showParams.getListFilterParameter();
            params.setFilter(listQfilter);
            long userId = Long.parseLong(RequestContext.get().getUserId());
            String appid = this.getAppId(EntityNumber);
            showParams.setCustomParam("filterOrg", (Object)this.getView().getPageCache().get("orgName"));
            if (PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)Long.parseLong(this.getView().getPageCache().get("orgId")), (String)appid, (String)EntityNumber, (String)"47150e89000000ac") != 1) {
                showParams.setLoadData(false);
                showParams.setCustomParam("isExistData", (Object)"false");
            } else {
                showParams.setCustomParam("isExistData", (Object)"true");
            }
            showParams.setListFilterParameter(params);
            this.getView().showForm((FormShowParameter)showParams);
        }
    }

    private String getAppId(String entityNumber) {
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String appNumber = this.getView().getFormShowParameter().getAppId();
        String appid = null;
        if (!StringUtils.isBlank((CharSequence)appNumber)) {
            try {
                appid = AppMetadataCache.getAppInfo((String)appNumber).getId();
            }
            catch (Exception var5) {
                appid = met.getAppId();
            }
        }
        return appid;
    }
}

