/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.formplugin.dailyplan;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class DailyPlanDetail
extends AbstractFormPlugin {
    private static final String ADD_NEW = "addnew";
    private static final String OK = "btnok";
    private static final String ID = "userid";
    private static final String PICTURE = "userpic";
    private static final String NAME = "username";
    private static final String NUMBER = "userno";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{ADD_NEW});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button ok = (Button)this.getControl(OK);
        ok.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String param = (String)this.getView().getFormShowParameter().getCustomParam("param");
        JSONObject jsonObject = JSON.parseObject((String)param);
        String title = jsonObject.getString("text");
        SimpleDateFormat dateFormat = new SimpleDateFormat(ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss", (String)"DailyPlanDetail_2", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
        String taskTime = dateFormat.format(new Date(jsonObject.getLong("taskTime")));
        this.getPageCache().put("text", title);
        this.getPageCache().put("taskId", jsonObject.getString("taskId"));
        this.getPageCache().put("taskTime", jsonObject.getString("taskTime"));
        this.getPageCache().put("persons", jsonObject.getString("persons"));
        this.changePersons(this.getPersonIds());
        this.getPageCache().put("originalPersons", this.getPageCache().get("persons"));
        String history = jsonObject.getString("history");
        if (Objects.nonNull(history)) {
            this.getPageCache().put("history", history);
        }
        this.getModel().setValue("title", (Object)title);
        this.getModel().setValue("tasktime", (Object)taskTime);
        this.loadTaskDetail();
        this.loadPersonCards();
    }

    private void loadTaskDetail() {
        long taskId = Long.parseLong(this.getPageCache().get("taskId"));
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"sfc_dailyplan", (String)"oprentryentity.orderno, oprentryentity.workcardtitle, oprentryentity.processgroup, oprentryentity.project", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskId)});
        DynamicObject taskStatus = QueryServiceHelper.queryOne((String)"sfc_dailyplan", (String)"taskstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskId)});
        String key = taskStatus == null ? "A" : taskStatus.getString("taskstatus");
        String taskState = "";
        switch (key) {
            case "A": {
                taskState = ResManager.loadKDString((String)"\u672a\u5f00\u5de5", (String)"DailyPlanDetail_5", (String)"mmc-sfc-formplugin", (Object[])new Object[0]);
                break;
            }
            case "B": {
                taskState = ResManager.loadKDString((String)"\u5f00\u5de5", (String)"DailyPlanDetail_6", (String)"mmc-sfc-formplugin", (Object[])new Object[0]);
                break;
            }
            case "C": {
                taskState = ResManager.loadKDString((String)"\u5b8c\u5de5", (String)"DailyPlanDetail_7", (String)"mmc-sfc-formplugin", (Object[])new Object[0]);
            }
        }
        this.getModel().setValue("taskstate", (Object)taskState);
        ArrayList<String> orderNos = new ArrayList<String>(10);
        for (DynamicObject object : objects) {
            orderNos.add(object.getString("oprentryentity.orderno"));
        }
        DynamicObjectCollection orders = QueryServiceHelper.query((String)"pom_mroorder", (String)"billno, treeentryentity.taskstatus", (QFilter[])new QFilter[]{new QFilter("billno", "in", orderNos)});
        HashMap<String, String> orderMap = new HashMap<String, String>(16);
        for (DynamicObject order : orders) {
            String orderState = "";
            switch (order.getString("treeentryentity.taskstatus")) {
                case "A": {
                    orderState = ResManager.loadKDString((String)"\u672a\u5f00\u5de5", (String)"DailyPlanDetail_5", (String)"mmc-sfc-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "B": {
                    orderState = ResManager.loadKDString((String)"\u5f00\u5de5", (String)"DailyPlanDetail_6", (String)"mmc-sfc-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "C": {
                    orderState = ResManager.loadKDString((String)"\u5b8c\u5de5", (String)"DailyPlanDetail_7", (String)"mmc-sfc-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "D": {
                    orderState = ResManager.loadKDString((String)"\u90e8\u5206\u5b8c\u5de5", (String)"DailyPlanDetail_8", (String)"mmc-sfc-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "E": {
                    orderState = ResManager.loadKDString((String)"\u53d6\u6d88", (String)"DailyPlanDetail_9", (String)"mmc-sfc-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "F": {
                    orderState = ResManager.loadKDString((String)"\u4fdd\u7559", (String)"DailyPlanDetail_10", (String)"mmc-sfc-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "G": {
                    orderState = ResManager.loadKDString((String)"\u91cd\u4e0b\u8fbe", (String)"DailyPlanDetail_11", (String)"mmc-sfc-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "H": {
                    orderState = ResManager.loadKDString((String)"\u6682\u505c", (String)"DailyPlanDetail_12", (String)"mmc-sfc-formplugin", (Object[])new Object[0]);
                    break;
                }
                case "J": {
                    orderState = ResManager.loadKDString((String)"\u5e9f\u5f03", (String)"DailyPlanDetail_13", (String)"mmc-sfc-formplugin", (Object[])new Object[0]);
                }
            }
            orderMap.put(order.getString("billno"), orderState);
        }
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        dataModel.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[]{"project", "workcardtitle", "processgroup", "orderno", "orderstate"});
        for (DynamicObject object : objects) {
            String orderNo = object.getString("oprentryentity.orderno");
            setter.addRow(new Object[]{object.getLong("oprentryentity.project"), object.getString("oprentryentity.workcardtitle"), object.getLong("oprentryentity.processgroup"), orderNo, orderMap.get(orderNo)});
        }
        dataModel.batchCreateNewEntryRow("entryentity", setter);
        dataModel.endInit();
    }

    private void loadPersonCards() {
        DynamicObjectCollection result = QueryServiceHelper.query((String)"mpdm_manuperson", (String)"id, user.name, user.number, user.picturefield", (QFilter[])new QFilter[]{new QFilter("id", "in", this.getPersonIds())});
        TableValueSetter cards = new TableValueSetter(new String[]{ID, PICTURE, NAME, NUMBER});
        for (DynamicObject person : result) {
            cards.addRow(new Object[]{person.get("id"), person.get("user.picturefield"), person.get("user.name"), person.get("user.number")});
        }
        this.getModel().beginInit();
        this.getModel().deleteEntryData("cardentryentity");
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("cardentryentity", cards);
        this.getModel().endInit();
        this.getView().updateView("cardentryentity");
    }

    private List<Long> getPersonIds() {
        List persons = JSON.parseArray((String)this.getPageCache().get("persons"), JSONObject.class);
        ArrayList<Long> personIds = new ArrayList<Long>(8);
        for (JSONObject person : persons) {
            personIds.add(Long.parseLong(person.getString("personId")));
        }
        return personIds;
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals(ADD_NEW)) {
            ListShowParameter personList = ShowFormHelper.createShowListForm((String)"sfc_dailyplanpersons", (boolean)true);
            personList.getOpenStyle().setShowType(ShowType.Modal);
            personList.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "add_new"));
            personList.setSelectedRows(this.getPersonIds().toArray());
            this.getView().showForm((FormShowParameter)personList);
        } else if (key.equals(OK)) {
            LinkedHashMap<String, Object> param = new LinkedHashMap<String, Object>();
            param.put("text", this.getPageCache().get("text"));
            param.put("taskId", this.getPageCache().get("taskId"));
            param.put("taskTime", this.getPageCache().get("taskTime"));
            param.put("persons", JSON.parseArray((String)this.getPageCache().get("persons"), JSONObject.class));
            this.getView().returnDataToParent((Object)JSON.toJSONString((Object)new JSONObject(param)));
            this.getPageCache().put("close", "");
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals("add_new")) {
            ListSelectedRowCollection returnDataCollection = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (Objects.isNull(returnDataCollection)) {
                return;
            }
            HashSet<Long> addIds = new HashSet<Long>(16);
            for (Object returnData : returnDataCollection) {
                addIds.add((Long)returnData.getPrimaryKeyValue());
            }
            DynamicObjectCollection queryIds = QueryServiceHelper.query((String)"sfc_dailyplanpersons", (String)"person.id", (QFilter[])new QFilter[]{new QFilter("id", "in", addIds)});
            addIds.clear();
            for (DynamicObject queryId : queryIds) {
                addIds.add(queryId.getLong("person.id"));
            }
            List<Long> personIds = this.getPersonIds();
            if (personIds.containsAll(addIds)) {
                return;
            }
            addIds.addAll(personIds);
            this.changePersons(addIds);
            this.loadPersonCards();
        }
    }

    private void changePersons(Collection<Long> ids) {
        DynamicObjectCollection results = QueryServiceHelper.query((String)"mpdm_manuperson", (String)"id, user.name", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        ArrayList<JSONObject> persons = new ArrayList<JSONObject>();
        for (DynamicObject result : results) {
            JSONObject person = new JSONObject();
            person.put("name", result.get("user.name"));
            person.put("personId", (Object)result.get("id").toString());
            person.put("personType", (Object)"AAA");
            persons.add(person);
        }
        this.getPageCache().put("persons", JSON.toJSONString(persons));
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        if (Objects.nonNull(this.getPageCache().get("history"))) {
            e.setCancel(true);
            return;
        }
        List persons = JSON.parseArray((String)this.getPageCache().get("persons"), JSONObject.class);
        CardEntry entry = (CardEntry)this.getView().getControl("cardentryentity");
        String id = (String)entry.getModel().getValue(ID, e.getRowIndexs()[0]);
        persons.removeIf(person -> person.getString("personId").equals(id));
        this.getPageCache().put("persons", JSON.toJSONString((Object)persons));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String originalPersons = this.getPageCache().get("originalPersons");
        String persons = this.getPageCache().get("persons");
        if (!originalPersons.equals(persons) && Objects.isNull(this.getPageCache().get("close"))) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"DailyPlanDetail_3", (String)"mmc-sfc-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u53d8\u66f4\u5b57\u6bb5\uff1a\u4efb\u52a1\u6210\u5458", (String)"DailyPlanDetail_4", (String)"mmc-sfc-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("confirm", (IFormPlugin)this));
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getCallBackId().equals("confirm") && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.getPageCache().put("close", "");
            this.getView().close();
        }
    }
}

