/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.formplugin.dailyplan;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bd.mpdm.common.utils.DateUtils;
import kd.bd.mpdm.common.utils.MulBaseDataUtils;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.botp.Push;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.mmc.sfc.business.dailyplan.DailyPlanBeanConvertHelper;
import kd.mmc.sfc.business.dailyplan.DailyPlanCustomControlHelper;
import kd.mmc.sfc.business.dailyplan.DailyPlanDataHelper;
import kd.mmc.sfc.business.dailyplan.DailyPlanHelper;
import kd.mmc.sfc.business.dailyplan.DailyPlanToCoorHelper;
import kd.mmc.sfc.common.dailyplan.bean.DailyPlanBean;
import kd.mmc.sfc.common.dailyplan.bean.DailyPlanEntryOfOprBean;
import kd.mmc.sfc.common.dailyplan.bean.DailyPlanEntryOfPlanBean;
import kd.mmc.sfc.common.dailyplan.bean.DailyPlanFilterBean;
import kd.mmc.sfc.common.dailyplan.bean.DailyPlanStatusEntity;
import kd.mmc.sfc.common.dailyplan.consts.DailyPlanCustomConsts;
import kd.mmc.sfc.common.dailyplan.utils.DailyPlanStatusUtils;
import kd.mmc.sfc.common.utils.SFCUtils;

public class DailyPlanEdit
extends AbstractFormPlugin
implements HyperLinkClickListener,
CellClickListener,
TabSelectListener {
    private int maxDays = 5;
    private String taskName = "";
    private Long rowTimeTmp = null;
    private static final String calendarDataCaheKey = "calendarData";
    private static final String calendarHistoryDataCaheKey = "calendarHistoryData";
    private static final String switchStatus = "switchStatus";
    private static final String calendarRightMenu = "calendarRightMenu";
    private static final String calendarHisRightMenu = "calendarHisRightMenu";
    private static final String queryStatus = "queryStatus";
    private static final String queryHistoryStatus = "queryHistoryStatus";
    private static final String currentDate = "currentDate";
    private static final String currentHistoryDate = "currentHistoryDate";
    private static final String eventArgs = "eventArgs";
    private static final String rowTime = "rowTime";
    private static final String tasks = "tasks";
    private static final String profession = "profession";
    private static final Log logger = LogFactory.getLog(DailyPlanEdit.class);

    private Date getStartDate() {
        String curDate = this.getPageCache().get(currentDate);
        if (curDate == null) {
            Date startDate = TimeServiceHelper.now();
            return DateUtils.getShortDate((Date)startDate);
        }
        long timeInMillis = Long.parseLong(curDate);
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(timeInMillis);
        return c.getTime();
    }

    private void setStartDate(Date startDate) {
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        long timeInMillis = c.getTimeInMillis();
        this.getPageCache().put(currentDate, String.valueOf(timeInMillis));
    }

    private Date getHistoryStartDate() {
        String curDate = this.getPageCache().get(currentHistoryDate);
        if (curDate == null) {
            Date startDate = TimeServiceHelper.now();
            return DateUtils.getShortDate((Date)startDate);
        }
        long timeInMillis = Long.parseLong(curDate);
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(timeInMillis);
        return c.getTime();
    }

    private void setHistoryStartDate(Date startDate) {
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        long timeInMillis = c.getTimeInMillis();
        this.getPageCache().put(currentHistoryDate, String.valueOf(timeInMillis));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar tbmain = (Toolbar)this.getView().getControl("tbmain");
        tbmain.addItemClickListener((ItemClickListener)this);
        EntryGrid entry = (EntryGrid)this.getControl("taskentryentity");
        entry.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid infoEntry = (EntryGrid)this.getControl("infoentryentity");
        infoEntry.addCellClickListener((CellClickListener)this);
        EntryGrid card = (EntryGrid)this.getControl("cardentryentity");
        card.addCellClickListener((CellClickListener)this);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void tabSelected(TabSelectEvent e) {
        DynamicObject[] entryData;
        String tabKey = e.getTabKey();
        if ("tabpageap4".equals(tabKey) && (entryData = ((EntryGrid)this.getControl("infoentryentity")).getEntryData().getDataEntitys()).length == 0) {
            DailyPlanHelper helper = new DailyPlanHelper();
            helper.setStartDate(this.getStartDate());
            helper.setMaxDays(this.maxDays);
            helper.setPlatView(this.getView());
            this.setMilestone(this.getCalendarCacheData());
            List infoShowData = helper.infoQueryForTab();
            this.getModel().deleteEntryData("infoentryentity");
            if (infoShowData != null && infoShowData.size() != 0) {
                this.bindAndShowInfoData(infoShowData);
            }
            this.getPageCache().put(queryStatus, "true");
        }
    }

    public void cellClick(CellClickEvent arg) {
        String fieldKey = arg.getFieldKey();
        int row = arg.getRow();
        if (StringUtils.equals((CharSequence)"prostatus", (CharSequence)fieldKey)) {
            EntryGrid infoEntry = (EntryGrid)this.getView().getControl("infoentryentity");
            EntryData dataEntry = infoEntry.getEntryData();
            DynamicObject[] data = dataEntry.getDataEntitys();
            Long infoDailyId = Long.parseLong(data[row].get("entryidcovered").toString());
            DynamicObject dynBill = BusinessDataServiceHelper.loadSingle((Object)infoDailyId, (String)"sfc_dailyplan");
            DynamicObjectCollection billEntry = dynBill.getDynamicObjectCollection("oprentryentity");
            for (int i = 0; i < billEntry.size(); ++i) {
                if (Long.parseLong(data[row].get("dailyentryid").toString()) != Long.parseLong(((DynamicObject)billEntry.get(i)).get("id").toString())) continue;
                if (Boolean.parseBoolean(data[row].get("prostatus").toString())) {
                    ((DynamicObject)billEntry.get(i)).set("handlestatus", (Object)0);
                    continue;
                }
                ((DynamicObject)billEntry.get(i)).set("handlestatus", (Object)1);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynBill});
            this.getView().updateView("infoentryentity");
        } else if (fieldKey.equals("tasklink")) {
            DailyPlanHelper dHelper = new DailyPlanHelper();
            DailyPlanFilterBean dBean = dHelper.buildFilterBean();
            if (Objects.isNull(dBean.getMulProjects()) || dBean.getMulProjects().isEmpty() || Objects.isNull(dBean.getProfession())) {
                return;
            }
            long projectId = (Long)this.getModel().getValue("planprojectid", row);
            long professionId = (Long)this.getModel().getValue("planprofessionid", row);
            String planType = (String)this.getModel().getValue("plantype", row);
            ListShowParameter showParameter = new ListShowParameter();
            String billId = "";
            switch (planType) {
                case "MASTERPLAN_S": {
                    billId = "pmts_task_masterplan";
                    break;
                }
                case "REGIONPLAN_S": {
                    billId = "pmts_task_regionplan";
                    break;
                }
                case "TREDEPLAN_S": {
                    billId = "pmts_task_industryplan";
                }
            }
            showParameter.setCustomParam("project", (Object)projectId);
            if (professionId != 0L) {
                showParameter.setCustomParam(profession, (Object)professionId);
            }
            showParameter.setBillFormId(billId);
            showParameter.setFormId("mpdm_gantt_list");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void cellDoubleClick(CellClickEvent arg) {
        if (StringUtils.equals((CharSequence)"prostatus", (CharSequence)arg.getFieldKey())) {
            this.cellClick(arg);
        }
    }

    public void itemClick(ItemClickEvent e) {
        String operationKey;
        super.itemClick(e);
        EntryGrid taskEntry = (EntryGrid)this.getView().getControl("taskentryentity");
        EntryGrid abnEntry = (EntryGrid)this.getView().getControl("abentryentity");
        int[] selectRows = taskEntry.getSelectRows();
        int[] selectAbnRows = abnEntry.getSelectRows();
        switch (operationKey = e.getOperationKey()) {
            case "combine": {
                if (selectRows.length <= 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u591a\u884c\u4efb\u52a1\u7ec4\u5408", (String)"DailyPlanEdit_4", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
                    return;
                }
                ConfirmCallBackListener combineConfirm = new ConfirmCallBackListener(operationKey);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u7ec4\u5408\u524d\u9700\u8981\u5148\u4fdd\u5b58\uff0c\u662f\u5426\u4fdd\u5b58", (String)"DailyPlanEdit_5", (String)"mmc-sfc-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, combineConfirm);
                break;
            }
            case "split": {
                if (selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u4efb\u52a1\u62c6\u5206", (String)"DailyPlanEdit_6", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
                    return;
                }
                ConfirmCallBackListener splitConfirm = new ConfirmCallBackListener(operationKey);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u62c6\u5206\u524d\u9700\u8981\u5148\u4fdd\u5b58\uff0c\u662f\u5426\u4fdd\u5b58", (String)"DailyPlanEdit_7", (String)"mmc-sfc-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, splitConfirm);
                break;
            }
            case "splittask": {
                if (selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u4efb\u52a1\u62c6\u5206", (String)"DailyPlanEdit_6", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
                    return;
                }
                ConfirmCallBackListener splitTaskConfirm = new ConfirmCallBackListener(operationKey);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u62c6\u5206\u524d\u9700\u8981\u5148\u4fdd\u5b58\uff0c\u662f\u5426\u4fdd\u5b58", (String)"DailyPlanEdit_7", (String)"mmc-sfc-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, splitTaskConfirm);
                break;
            }
            case "resourceready": {
                if (selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4efb\u52a1", (String)"DailyPlanEdit_12", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashSet<String> billNos = new HashSet<String>();
                HashSet<Long> projectIds = new HashSet<Long>();
                DynamicObjectCollection entity = this.getModel().getEntryEntity("taskentryentity");
                for (int selectRow : selectRows) {
                    DynamicObject row = (DynamicObject)entity.get(selectRow);
                    String order = row.getString("orderno");
                    DynamicObject project = row.getDynamicObject("project");
                    if (Objects.isNull(order) || Objects.isNull(project)) continue;
                    billNos.add(order);
                    projectIds.add((Long)project.getPkValue());
                }
                long dailyPlanId = (Long)this.getModel().getValue("dailyplanid", 0);
                DynamicObject organization = QueryServiceHelper.queryOne((String)"sfc_dailyplan", (String)"org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dailyPlanId)});
                long orgId = 0L;
                if (organization != null) {
                    orgId = organization.getLong("org");
                }
                this.changeResImg(orgId, new ArrayList<Long>(projectIds), new ArrayList<String>(billNos));
                break;
            }
            case "abnormal": {
                if (selectRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e", (String)"DailyPlanEdit_18", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection abnEntity = this.getModel().getEntryEntity("taskentryentity");
                DailyPlanHelper norHelp = new DailyPlanHelper();
                norHelp.normalCheck(operationKey, abnEntity, selectRows);
                this.getView().invokeOperation("refresh");
                break;
            }
            case "normal": {
                if (selectAbnRows.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e", (String)"DailyPlanEdit_18", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection norEntity = this.getModel().getEntryEntity("abentryentity");
                DailyPlanHelper abnorHelp = new DailyPlanHelper();
                abnorHelp.normalCheck(operationKey, norEntity, selectAbnRows);
                this.getView().invokeOperation("refresh");
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initCalendar();
        this.initHistoryCalendar(this.getStartDate());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String colName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        DailyPlanHelper helper = new DailyPlanHelper();
        switch (colName) {
            case "taskname": {
                Long dailyplanid = (Long)this.getModel().getValue("dailyplanid", changeSet[0].getRowIndex());
                helper.updateTaskName(dailyplanid, (String)newValue);
                break;
            }
            case "description": {
                Long cordailyplanid = (Long)this.getModel().getValue("cordailyplanid", changeSet[0].getRowIndex());
                helper.updateTaskName(cordailyplanid, (String)newValue);
                break;
            }
            case "note": {
                Long oprEntryid = (Long)this.getModel().getValue("oprentryid", changeSet[0].getRowIndex());
                helper.updateTaskNote(oprEntryid, (String)newValue);
                break;
            }
            case "teamno": {
                this.showPresortTeam();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        OperationResult operationResult = e.getOperationResult();
        boolean success = operationResult.isSuccess();
        if (!success) {
            return;
        }
        switch (operateKey = e.getOperateKey()) {
            case "query": {
                this.queryData(true);
                break;
            }
            case "showfilter": {
                this.showFilter();
                break;
            }
            case "showcofilter": {
                this.showCoFilter();
                break;
            }
            case "showhistoryfilter": {
                this.showHistoryFilter();
                break;
            }
            case "donothing_save": {
                this.saveDailyPlan();
                break;
            }
            case "refresh": {
                String slotId = this.getPageCache().get("slotId");
                if (StringUtils.isEmpty((CharSequence)slotId)) {
                    this.queryData(false);
                    break;
                }
                this.queryData(false, slotId);
                break;
            }
            case "transmit": {
                this.transmit();
                break;
            }
            case "staffneeds": {
                this.genStaffneedsBill();
                break;
            }
        }
    }

    private void queryData(boolean isCreate) {
        Map resMap;
        DailyPlanBean[] planBeans;
        this.clearData();
        DailyPlanHelper helper = new DailyPlanHelper();
        helper.setStartDate(this.getStartDate());
        helper.setMaxDays(this.maxDays);
        helper.setPlatView(this.getView());
        Tab tabap = (Tab)this.getView().getControl("tabap");
        String currentTab = tabap.getCurrentTab();
        DailyPlanToCoorHelper coHelper = new DailyPlanToCoorHelper();
        if ("tabpageap2".equals(currentTab)) {
            coHelper.setStartDate(this.getStartDate());
            coHelper.setMaxDays(this.maxDays);
            coHelper.setPlatView(this.getView());
        }
        if (isCreate) {
            helper.createDailyPlan();
        }
        if ((planBeans = helper.query()) != null) {
            this.bindAndShowData(planBeans);
        }
        if (isCreate && "tabpageap2".equals(currentTab)) {
            coHelper.createCoorDailyPlan();
            List coorShowData = coHelper.coorQuery();
            if (coorShowData != null && coorShowData.size() != 0) {
                this.bindAndShowCoorData(coorShowData);
            }
        }
        this.setMilestone(this.getCalendarCacheData());
        if (isCreate) {
            this.getModel().deleteEntryData("infoentryentity");
            List infoShowData = helper.infoQuery();
            if (infoShowData != null && infoShowData.size() != 0) {
                this.bindAndShowInfoData(infoShowData);
            }
        }
        if ((resMap = helper.queryMROOrder()) != null && resMap.get("mroOrderEntity") != null) {
            this.bindAndShowMROData((DynamicObjectCollection)resMap.get("mroOrderEntity"));
            this.getPageCache().put(profession, (String)resMap.get(profession));
        }
        this.getPageCache().put(queryStatus, "true");
    }

    private void queryData(boolean isCreate, String slotId) {
        Map resMap;
        DailyPlanBean[] planBeans;
        this.clearData();
        DailyPlanHelper helper = new DailyPlanHelper();
        helper.setStartDate(this.getStartDate());
        helper.setMaxDays(this.maxDays);
        helper.setPlatView(this.getView());
        Tab tabap = (Tab)this.getView().getControl("tabap");
        String currentTab = tabap.getCurrentTab();
        DailyPlanToCoorHelper coHelper = new DailyPlanToCoorHelper();
        if ("tabpageap2".equals(currentTab)) {
            coHelper.setStartDate(this.getStartDate());
            coHelper.setMaxDays(this.maxDays);
            coHelper.setPlatView(this.getView());
        }
        if (isCreate) {
            helper.createDailyPlan();
        }
        if ((planBeans = helper.query()) != null) {
            this.bindAndShowData(planBeans, slotId);
        }
        if (isCreate && "tabpageap2".equals(currentTab)) {
            coHelper.createCoorDailyPlan();
            List coorShowData = coHelper.coorQuery();
            if (coorShowData != null && coorShowData.size() != 0) {
                this.bindAndShowCoorData(coorShowData);
            }
        }
        if (isCreate) {
            this.getModel().deleteEntryData("infoentryentity");
            List infoShowData = helper.infoQuery();
            if (infoShowData != null) {
                this.bindAndShowInfoData(infoShowData);
            }
        }
        if ((resMap = helper.queryMROOrder()) != null && resMap.get("mroOrderEntity") != null) {
            this.bindAndShowMROData((DynamicObjectCollection)resMap.get("mroOrderEntity"));
            this.getPageCache().put(profession, (String)resMap.get(profession));
        }
        this.getPageCache().put(queryStatus, "true");
    }

    private void queryHistoryData(boolean isCreate, String slotId) {
        Long oldProfession = Long.valueOf(this.getPageCache().get("oldprofession"));
        String oldMulProStr = this.getPageCache().get("oldmulproject");
        String oldMulProjects = StringUtils.strip((String)oldMulProStr, (String)"[]");
        List<Long> oldMulProjectIds = Arrays.stream(oldMulProjects.split(",")).map(id -> Long.parseLong(id.trim())).collect(Collectors.toList());
        HashSet<QFilter> filters = new HashSet<QFilter>(8);
        filters.add(new QFilter("planentryentity.timeslotproid", "=", (Object)Long.valueOf(slotId)));
        String newProfessionStr = this.getPageCache().get("newprofession");
        Long newProfession = null;
        if (StringUtils.isNotEmpty((CharSequence)newProfessionStr)) {
            newProfession = Long.valueOf(newProfessionStr);
        }
        List<Long> newMulProjectIds = null;
        String newMulProjectIdsStr = this.getPageCache().get("newmulproject");
        if (StringUtils.isNotBlank((CharSequence)newMulProjectIdsStr)) {
            String newMulProjects = StringUtils.strip((String)newMulProjectIdsStr, (String)"[]");
            newMulProjectIds = Arrays.stream(newMulProjects.split(",")).map(id -> Long.parseLong(id.trim())).collect(Collectors.toList());
        }
        this.historyDailyPlanFilter(newProfession, filters, newMulProjectIds);
        DailyPlanHelper helper = new DailyPlanHelper();
        DailyPlanBean[] queryData = helper.query(filters);
        if (queryData.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5386\u53f2\u4efb\u52a1", (String)"DailyPlanEdit_38", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
        }
        this.setChangeTaskShowScheme(newMulProjectIds, oldMulProjectIds, queryData, slotId);
        this.getPageCache().put(queryHistoryStatus, "true");
    }

    private void setChangeTaskShowScheme(List<Long> newMulProjectIds, List<Long> oldMulProjectIds, DailyPlanBean[] queryData, String slotId) {
        if (newMulProjectIds == null || oldMulProjectIds == null || !Collections.disjoint(newMulProjectIds, oldMulProjectIds)) {
            Date today = DateUtils.getShortDate((Date)TimeServiceHelper.now());
            this.initHistoryCalendar(today);
            this.setHistoryStartDate(today);
            this.setCustomHistoryCalendar(queryData, slotId);
        } else if (queryData.length > 0) {
            this.bindDataByEariTime(queryData, slotId);
        } else {
            Date today = DateUtils.getShortDate((Date)TimeServiceHelper.now());
            this.initHistoryCalendar(today);
            this.setHistoryStartDate(today);
            this.setCustomHistoryCalendar(queryData, slotId);
        }
    }

    private void clearData() {
        this.getModel().deleteEntryData("taskentryentity");
        this.getModel().deleteEntryData("abentryentity");
        this.getModel().deleteEntryData("ohentryentity");
        this.getModel().deleteEntryData("coorentryentity");
    }

    private void showFilter() {
        this.getPageCache().remove("newprofession");
        this.getPageCache().remove("newmulproject");
        long currentUserId = UserServiceHelper.getCurrentUserId();
        QFilter filter = new QFilter("user", "=", (Object)currentUserId);
        DynamicObject dpFilter = BusinessDataServiceHelper.loadSingleFromCache((String)"sfc_dailyplan_filter", (String)"user,id", (QFilter[])filter.toArray());
        Tab tabap = (Tab)this.getView().getControl("tabap");
        String currentTab = tabap.getCurrentTab();
        BaseShowParameter bsp = new BaseShowParameter();
        if (currentTab.equals("tabpageap4")) {
            bsp.setFormId("sfc_dailyplan_filter_pc");
        } else {
            bsp.setFormId("sfc_dailyplan_filter");
        }
        bsp.setHasRight(true);
        bsp.getOpenStyle().setShowType(ShowType.Modal);
        bsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dailyplanfilter"));
        if (dpFilter != null) {
            bsp.setPkId(dpFilter.getPkValue());
        }
        this.getView().showForm((FormShowParameter)bsp);
    }

    private void showCoFilter() {
        long currentUserId = UserServiceHelper.getCurrentUserId();
        QFilter filter = new QFilter("couser", "=", (Object)currentUserId);
        DynamicObject dpFilter = BusinessDataServiceHelper.loadSingleFromCache((String)"sfc_dailycoor_filter", (String)"couser,id", (QFilter[])filter.toArray());
        BaseShowParameter bsp = new BaseShowParameter();
        bsp.setFormId("sfc_dailycoor_filter");
        bsp.setHasRight(true);
        bsp.getOpenStyle().setShowType(ShowType.Modal);
        bsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dailycoorfilter"));
        if (dpFilter != null) {
            bsp.setPkId(dpFilter.getPkValue());
        }
        this.getView().showForm((FormShowParameter)bsp);
    }

    private void showHistoryFilter() {
        String newProfession = this.getPageCache().get("newprofession");
        String newMulProject = this.getPageCache().get("newmulproject");
        if (StringUtils.isEmpty((CharSequence)newProfession) && StringUtils.isEmpty((CharSequence)newMulProject)) {
            long currentUserId = UserServiceHelper.getCurrentUserId();
            QFilter filter = new QFilter("user", "=", (Object)currentUserId);
            String selectProperties = "user,id,profession,mulproject";
            DynamicObject dpFilter = BusinessDataServiceHelper.loadSingleFromCache((String)"sfc_dailyplan_filter", (String)selectProperties, (QFilter[])filter.toArray());
            DynamicObject profession = (DynamicObject)dpFilter.get(profession);
            DynamicObjectCollection mulProjects = (DynamicObjectCollection)dpFilter.get("mulproject");
            List mulProObj = mulProjects.stream().map(proObj -> (DynamicObject)proObj.get("fbasedataid")).collect(Collectors.toList());
            List mulProIds = mulProObj.stream().map(proId -> (Long)proId.get("id")).collect(Collectors.toList());
            Long professionId = (Long)profession.get("id");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("sfc_dailyhispop");
            showParameter.setCaption(ResManager.loadKDString((String)"\u65e5\u8ba1\u5212", (String)"DailyPlanEdit_37", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "dailyplanhistoryfilter");
            showParameter.setCloseCallBack(closeCallBack);
            showParameter.setCustomParam(profession, (Object)professionId);
            showParameter.setCustomParam("mulproject", mulProIds);
            this.getView().showForm(showParameter);
            this.getPageCache().put("oldprofession", String.valueOf(professionId));
            this.getPageCache().put("oldmulproject", String.valueOf(mulProIds));
        } else {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("sfc_dailyhispop");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "dailyplanhistoryfilter");
            showParameter.setCloseCallBack(closeCallBack);
            if (StringUtils.isNotEmpty((CharSequence)newMulProject)) {
                String newMulProjects = StringUtils.strip((String)newMulProject, (String)"[]");
                List newMulProjectIds = Arrays.stream(newMulProjects.split(",")).map(id -> Long.parseLong(id.trim())).collect(Collectors.toList());
                showParameter.setCustomParam(profession, (Object)Long.parseLong(newProfession));
                showParameter.setCustomParam("mulproject", newMulProjectIds);
                this.getView().showForm(showParameter);
                this.getPageCache().put("newprofession", newProfession);
                this.getPageCache().put("newmulproject", String.valueOf(newMulProjectIds));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (e.getReturnData() != null && "dailyplanfilter".equals(actionId)) {
            this.getView().invokeOperation("query");
        }
        if (e.getReturnData() != null && "dailycoorfilter".equals(actionId)) {
            this.getView().invokeOperation("query");
        }
        if (e.getReturnData() != null && "dailyplanhistoryfilter".equals(actionId)) {
            returnData = (Map)e.getReturnData();
            DynamicObject newPro = (DynamicObject)returnData.get(profession);
            Long newProfession = (Long)newPro.get("id");
            DynamicObjectCollection newMulProjects = (DynamicObjectCollection)returnData.get("mulproject");
            List newMulPro = newMulProjects.stream().map(pro -> (DynamicObject)pro.get("fbasedataid")).collect(Collectors.toList());
            List<Long> newMulProjectIds = newMulPro.stream().map(proId -> (Long)proId.get("id")).collect(Collectors.toList());
            Long oldProfession = Long.valueOf(this.getPageCache().get("oldprofession"));
            String oldMulProStr = this.getPageCache().get("oldmulproject");
            String oldMulProjects = StringUtils.strip((String)oldMulProStr, (String)"[]");
            List<Long> oldMulProjectIds = Arrays.stream(oldMulProjects.split(",")).map(id -> Long.parseLong(id.trim())).collect(Collectors.toList());
            DailyPlanHelper helper = new DailyPlanHelper();
            HashSet<QFilter> filters = new HashSet<QFilter>(8);
            String slotId = this.getPageCache().get("initSlotId");
            if (StringUtils.isEmpty((CharSequence)slotId)) {
                return;
            }
            filters.add(new QFilter("planentryentity.timeslotproid", "=", (Object)Long.valueOf(slotId)));
            this.getPageCache().put("newprofession", String.valueOf(newProfession));
            this.getPageCache().put("newmulproject", String.valueOf(newMulProjectIds));
            this.historyDailyPlanFilter(newProfession, filters, newMulProjectIds);
            DailyPlanBean[] queryData = helper.query(filters);
            if (queryData != null && queryData.length > 0) {
                this.setTaskShowScheme(newMulProjectIds, oldMulProjectIds, queryData);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5386\u53f2\u4efb\u52a1", (String)"DailyPlanEdit_38", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
                this.setTaskShowScheme(newMulProjectIds, oldMulProjectIds, queryData);
            }
            this.getPageCache().put(queryHistoryStatus, "true");
        }
        if (e.getReturnData() != null && "taskname".equals(actionId)) {
            Map taskMap = (Map)e.getReturnData();
            String taskNumber = (String)taskMap.get("tasknumber");
            this.taskName = taskNumber + ":" + (String)taskMap.get("taskname");
            DynamicObject profession = (DynamicObject)taskMap.get(profession);
            Date planStartTime = (Date)taskMap.get("planstarttime");
            DailyPlanHelper helper = new DailyPlanHelper();
            helper.setPlatView(this.getView());
            HashMap<Long, Long> mroIdMap = new HashMap<Long, Long>(16);
            EntryGrid mroEntry = (EntryGrid)this.getView().getControl("ohentryentity");
            int[] selectRows = mroEntry.getSelectRows();
            for (int i = 0; i < selectRows.length; ++i) {
                int rowIndex = selectRows[i];
                Long mroId = (Long)this.getModel().getValue("mroid", rowIndex);
                Long mroEntryId = (Long)this.getModel().getValue("mroentryid", rowIndex);
                mroIdMap.put(mroEntryId, mroId);
            }
            ConvertOperationResult pushResult = helper.createDailyPlanFromMROOrder(mroIdMap);
            if (pushResult.isSuccess()) {
                Set targetBillIds = pushResult.getTargetBillIds();
                QFilter qFilter = new QFilter("id", "in", (Object)targetBillIds);
                String selectProperties = "taskname,oprentryentity.profession,planentryentity.planstarttime,planentryentity.planbizstatus,planentryentity.timeslotproid";
                DynamicObject dailyPlan = BusinessDataServiceHelper.loadSingle((String)"sfc_dailyplan", (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
                dailyPlan.set("taskname", (Object)this.taskName);
                DynamicObjectCollection planEntryEntity = dailyPlan.getDynamicObjectCollection("planentryentity");
                planEntryEntity.addNew();
                String slotId = this.getPageCache().get("slotId");
                for (int i = 0; i < planEntryEntity.size(); ++i) {
                    DynamicObject plan = (DynamicObject)planEntryEntity.get(i);
                    plan.set("planstarttime", (Object)planStartTime);
                    plan.set("planbizstatus", (Object)"A");
                    plan.set("timeslotproid", (Object)Long.valueOf(slotId));
                }
                DynamicObjectCollection oprEntryEntity = dailyPlan.getDynamicObjectCollection("oprentryentity");
                for (int i = 0; i < oprEntryEntity.size(); ++i) {
                    DynamicObject plan = (DynamicObject)oprEntryEntity.get(i);
                    plan.set(profession, (Object)profession);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dailyPlan});
                String eventArgs = this.getPageCache().get(eventArgs);
                Long dataIndex = Long.parseLong(eventArgs);
                Long rowTime = Long.valueOf(this.getPageCache().get(rowTime));
                JSONArray tasks = JSONArray.parseArray((String)this.getPageCache().get(tasks));
                if (dataIndex.compareTo(rowTime) == 0) {
                    JSONArray taskArray = this.addTaskToCalendar(dataIndex, tasks, pushResult);
                    for (int i = 0; i < taskArray.size(); ++i) {
                        JSONObject task = taskArray.getJSONObject(i);
                        this.updateTaskFromMRO(task);
                    }
                }
            }
        }
        if (e.getReturnData() != null && "showDetail".equals(actionId)) {
            returnData = e.getReturnData();
            JSONObject detailData = JSONObject.parseObject((String)returnData.toString());
            this.updateTaskDetail(detailData);
        }
        if (e.getReturnData() != null && "project_selected".equals(actionId)) {
            returnData = e.getReturnData();
            ListSelectedRowCollection list = (ListSelectedRowCollection)returnData;
            Long projectId = (Long)list.get(0).getPrimaryKeyValue();
            DynamicObject project = BusinessDataServiceHelper.loadSingleFromCache((Object)projectId, (String)"pmpd_project", (String)"id,number,name");
            this.getPageCache().put("project", SFCUtils.DynamicObjectToJSON((DynamicObject)project));
            this.showStaffneedsEditView();
        }
        if (e.getReturnData() != null && actionId.contains("message_")) {
            String[] param = actionId.substring(8).split("_");
            long taskId = Long.parseLong(param[0]);
            long taskTime = Long.parseLong(param[1]);
            DynamicObjectCollection tasks = QueryServiceHelper.query((String)"sfc_dailyplan", (String)"taskname, oprentryentity.materialmtc.name, oprentryentity.project.name, oprentryentity.profession.name, oprentryentity.orderno, planentryentity.planstarttime, planentryentity.planendtime", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskId).and(new QFilter("planentryentity.planstarttime", "=", (Object)new Date(taskTime)))});
            ListSelectedRowCollection returnData2 = (ListSelectedRowCollection)e.getReturnData();
            Object[] priValues = returnData2.getPrimaryKeyValues();
            DynamicObjectCollection users = QueryServiceHelper.query((String)"mpdm_manuperson", (String)"user.id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)priValues)});
            ArrayList<Long> userIds = new ArrayList<Long>(10);
            for (DynamicObject user : users) {
                userIds.add(user.getLong("user.id"));
            }
            MessageInfo message = new MessageInfo();
            message.setSenderId(Long.valueOf(UserServiceHelper.getCurrentUserId()));
            message.setTitle(ResManager.loadKDString((String)"\u65e5\u8ba1\u5212\u6d88\u606f\u63a8\u9001", (String)"DailyPlanEdit_39", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
            StringJoiner context = new StringJoiner("\n");
            SimpleDateFormat dateFormat = new SimpleDateFormat(ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5HH:mm:ss", (String)"DailyPlanEdit_40", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
            for (DynamicObject task : tasks) {
                Date endDate;
                Date startDate;
                StringJoiner content = new StringJoiner("\uff0c", "", "\u3002");
                String project = task.getString("oprentryentity.project.name");
                String material = task.getString("oprentryentity.materialmtc.name");
                String profession = task.getString("oprentryentity.profession.name");
                StringJoiner first = new StringJoiner(ResManager.loadKDString((String)"\u7684", (String)"DailyPlanEdit_41", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
                StringJoiner pro_mat = new StringJoiner("/");
                if (Objects.nonNull(project)) {
                    pro_mat.add(String.format(ResManager.loadKDString((String)"%s\u9879\u76ee", (String)"DailyPlanEdit_42", (String)"mmc-sfc-formplugin", (Object[])new Object[0]), project));
                }
                if (Objects.nonNull(material)) {
                    pro_mat.add(String.format(ResManager.loadKDString((String)"\u98de\u673a%s", (String)"DailyPlanEdit_43", (String)"mmc-sfc-formplugin", (Object[])new Object[0]), material));
                }
                if (pro_mat.length() > 0) {
                    first.add(pro_mat.toString());
                }
                if (Objects.nonNull(profession)) {
                    first.add(String.format(ResManager.loadKDString((String)"%s\u884c\u4e1a", (String)"DailyPlanEdit_44", (String)"mmc-sfc-formplugin", (Object[])new Object[0]), profession));
                }
                if (first.length() > 0) {
                    content.add(first.toString());
                }
                String taskName = task.getString("taskname");
                String order = task.getString("oprentryentity.orderno");
                StringJoiner second = new StringJoiner("-");
                if (Objects.nonNull(taskName)) {
                    second.add(String.format(ResManager.loadKDString((String)"\u4efb\u52a1%s", (String)"DailyPlanEdit_45", (String)"mmc-sfc-formplugin", (Object[])new Object[0]), taskName));
                }
                if (Objects.nonNull(order)) {
                    second.add(String.format(ResManager.loadKDString((String)"\u68c0\u4fee\u5de5\u5355\u7f16\u53f7%s", (String)"DailyPlanEdit_46", (String)"mmc-sfc-formplugin", (Object[])new Object[0]), order));
                }
                if (second.length() > 0) {
                    content.add(second.toString());
                }
                if (Objects.nonNull(startDate = task.getDate("planentryentity.planstarttime"))) {
                    content.add(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u4e3a%s", (String)"DailyPlanEdit_47", (String)"mmc-sfc-formplugin", (Object[])new Object[0]), dateFormat.format(startDate)));
                }
                if (Objects.nonNull(endDate = task.getDate("planentryentity.planendtime"))) {
                    content.add(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u7ed3\u675f\u65f6\u95f4\u4e3a%s", (String)"DailyPlanEdit_48", (String)"mmc-sfc-formplugin", (Object[])new Object[0]), dateFormat.format(endDate)));
                }
                context.add(content.toString());
            }
            message.setContent(context.toString());
            message.setType("message");
            message.setUserIds(userIds);
            MessageCenterServiceHelper.sendMessage((MessageInfo)message);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6d88\u606f\u63a8\u9001\u6210\u529f", (String)"DailyPlanEdit_49", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
        }
        if (e.getReturnData() != null && "infotext_information".equals(actionId)) {
            returnData = e.getReturnData();
            DailyPlanHelper dataHelper = new DailyPlanHelper();
            String planId = this.getView().getPageCache().get("dailyId");
            dataHelper.tranParameter(returnData, planId);
        }
    }

    private void setTaskShowScheme(List<Long> newMulProjectIds, List<Long> oldMulProjectIds, DailyPlanBean[] queryData) {
        if (!Collections.disjoint(newMulProjectIds, oldMulProjectIds)) {
            this.getPageCache().put("proFlag", "1");
            Date today = DateUtils.getShortDate((Date)TimeServiceHelper.now());
            this.initHistoryCalendar(today);
            this.setHistoryStartDate(today);
            this.setCustomHistoryCalendar(queryData);
        } else if (queryData.length > 0) {
            this.getPageCache().put("proFlag", "0");
            this.bindDataByEariTime(queryData);
        } else {
            this.getPageCache().put("proFlag", "1");
            Date today = DateUtils.getShortDate((Date)TimeServiceHelper.now());
            this.initHistoryCalendar(today);
            this.setHistoryStartDate(today);
            this.setCustomHistoryCalendar(queryData);
        }
    }

    private void bindDataByEariTime(DailyPlanBean[] queryData) {
        List<DailyPlanBean> queryDailyHis = Arrays.asList(queryData);
        List<DailyPlanBean> filterNullByStartTime = queryDailyHis.stream().filter(o -> o.getBeginTime() != null).collect(Collectors.toList());
        Stream<DailyPlanEntryOfPlanBean> dailyPlanEntry = Arrays.stream(((DailyPlanBean)filterNullByStartTime.get(0)).getPlanEntry());
        List startTimeOfPlan = dailyPlanEntry.map(startTime -> startTime.getPlanStartTime()).collect(Collectors.toList());
        this.getPageCache().put("autoIncreaseNum", "1");
        if (filterNullByStartTime.size() == 1) {
            Date date = DateUtils.getShortDate((Date)((Date)startTimeOfPlan.get(0)));
            this.initHistoryOtherCalendar(date);
            this.setHistoryStartDate(date);
            this.setCustomHistoryCalendar(queryData);
        } else {
            Date earliestStartTime = this.getEarliestStartTime(filterNullByStartTime);
            Date date = DateUtils.getShortDate((Date)earliestStartTime);
            this.initHistoryOtherCalendar(date);
            this.setHistoryStartDate(date);
            this.setCustomHistoryCalendar(queryData);
        }
    }

    private void bindDataByEariTime(DailyPlanBean[] queryData, String slotId) {
        List<DailyPlanBean> queryDailyHis = Arrays.asList(queryData);
        List<DailyPlanBean> filterNullByStartTime = queryDailyHis.stream().filter(o -> o.getBeginTime() != null).collect(Collectors.toList());
        Stream<DailyPlanEntryOfPlanBean> dailyPlanEntry = Arrays.stream(((DailyPlanBean)filterNullByStartTime.get(0)).getPlanEntry());
        List startTimeOfPlan = dailyPlanEntry.map(startTime -> startTime.getPlanStartTime()).collect(Collectors.toList());
        if (filterNullByStartTime.size() == 1) {
            Date date = DateUtils.getShortDate((Date)((Date)startTimeOfPlan.get(0)));
            this.initHistoryOtherCalendar(date);
            this.setHistoryStartDate(date);
            this.setCustomHistoryCalendar(queryData, slotId);
        } else {
            Date earliestStartTime = this.getEarliestStartTime(filterNullByStartTime);
            Date date = DateUtils.getShortDate((Date)earliestStartTime);
            this.initHistoryOtherCalendar(date);
            this.setHistoryStartDate(date);
            this.setCustomHistoryCalendar(queryData, slotId);
        }
    }

    private Date getEarliestStartTime(List<DailyPlanBean> filterNullByStartTime) {
        List sortedByStartTime = filterNullByStartTime.stream().map(dailyPlanEntry -> dailyPlanEntry.getPlanEntry()).collect(Collectors.toList());
        ArrayList<Date> startTimeList = new ArrayList<Date>(16);
        Iterator iterator = sortedByStartTime.iterator();
        while (iterator.hasNext()) {
            DailyPlanEntryOfPlanBean[] dailyPlanEntryOfPlanBeans;
            for (DailyPlanEntryOfPlanBean dailyPlanEntryOfPlanBean : dailyPlanEntryOfPlanBeans = (DailyPlanEntryOfPlanBean[])iterator.next()) {
                Date planStartTime = dailyPlanEntryOfPlanBean.getPlanStartTime();
                startTimeList.add(planStartTime);
            }
        }
        Date eariStartTime = (Date)startTimeList.stream().min(Date::compareTo).get();
        return eariStartTime;
    }

    private void bindAndShowData(DailyPlanBean[] dailyPlan) {
        for (DailyPlanBean headBean : dailyPlan) {
            DailyPlanEntryOfOprBean[] oprEntry;
            DynamicObject billType = headBean.getBillType();
            String strBillType = billType.getString("number");
            block7: for (DailyPlanEntryOfOprBean oprEntryBean : oprEntry = headBean.getOprEntry()) {
                switch (strBillType) {
                    case "sfc_dailyplan_tech_BT_S": {
                        if (!headBean.isException()) {
                            this.setTaskEntryData(headBean, oprEntryBean);
                            continue block7;
                        }
                        this.setAbnEntryData(headBean, oprEntryBean);
                        continue block7;
                    }
                }
            }
        }
        this.updateAllocationStatus();
        this.setCustomCalendar(dailyPlan);
        this.getTaskChangedNotify();
        this.initPersons();
        this.autoClickResReady();
    }

    private void bindAndShowData(DailyPlanBean[] dailyPlan, String slotId) {
        for (DailyPlanBean headBean : dailyPlan) {
            DailyPlanEntryOfOprBean[] oprEntry;
            DynamicObject billType = headBean.getBillType();
            String strBillType = billType.getString("number");
            block7: for (DailyPlanEntryOfOprBean oprEntryBean : oprEntry = headBean.getOprEntry()) {
                switch (strBillType) {
                    case "sfc_dailyplan_tech_BT_S": {
                        if (!headBean.isException()) {
                            this.setTaskEntryData(headBean, oprEntryBean);
                            continue block7;
                        }
                        this.setAbnEntryData(headBean, oprEntryBean);
                        continue block7;
                    }
                }
            }
        }
        this.updateAllocationStatus();
        this.setCustomCalendar(dailyPlan, slotId);
        this.getTaskChangedNotify();
        this.autoClickResReady();
    }

    private String taskTypeName(String type) {
        switch (type) {
            case "pom_coordination_FAC_S": {
                return "surface";
            }
            case "pom_coordination_HEA_S": {
                return "heat";
            }
            case "pom_coordination_INWORK_S": {
                return "innerwork";
            }
            case "pom_coordination_MAC_S": {
                return "machining";
            }
            case "pom_coordination_SPR_S": {
                return "printing";
            }
        }
        return "";
    }

    private void bindAndShowCoorData(List<Map<String, Object>> rows) {
        for (int c = 0; c < rows.size(); ++c) {
            int rowIndex = this.getModel().createNewEntryRow("coorentryentity");
            this.getModel().setValue("cordailyplanid", rows.get(c).get("fid"), rowIndex);
            this.getModel().setValue("tasktype", (Object)this.taskTypeName(rows.get(c).get("ftasktype").toString()), rowIndex);
            this.getModel().setValue("description", rows.get(c).get("ftaskname"), rowIndex);
            this.getModel().setValue("allocatestatus", rows.get(c).get("fallocationstatus"), rowIndex);
            this.getModel().setValue("coorbillno", rows.get(c).get("fbillno"), rowIndex);
        }
    }

    private void bindAndShowInfoData(List<Map<String, Object>> rows) {
        for (int c = 0; c < rows.size(); ++c) {
            QFilter filMat;
            DynamicObjectCollection planeNoFind;
            QFilter filPro;
            DynamicObjectCollection proName;
            List infoIds = (List)rows.get(c).get("fbasedataid");
            Object[] receiver = new Object[infoIds.size()];
            for (int r = 0; r < infoIds.size(); ++r) {
                receiver[r] = infoIds.get(r);
            }
            String project = "";
            String planeNo = "";
            Long proId = Long.parseLong(rows.get(c).get("fprojectid").toString());
            if (rows.get(c).get("fprojectid") != null && proId != 0L && (proName = QueryServiceHelper.query((String)"pmpd_project", (String)"name", (QFilter[])new QFilter[]{filPro = new QFilter("id", "=", (Object)proId)})) != null) {
                project = ((DynamicObject)proName.get(0)).getString("name");
            }
            Long matId = Long.parseLong(rows.get(c).get("fmaterialmtcid").toString());
            if (rows.get(c).get("fmaterialmtcid") != null && matId != 0L && (planeNoFind = QueryServiceHelper.query((String)"mpdm_materialmtcinfo", (String)"masterid", (QFilter[])new QFilter[]{filMat = new QFilter("id", "=", (Object)matId)})) != null) {
                planeNo = ((DynamicObject)planeNoFind.get(0)).getString("masterid");
            }
            String proPlaneNo = project + "-" + planeNo;
            int rowIndex = this.getModel().createNewEntryRow("infoentryentity");
            this.getModel().setValue("entryidcovered", rows.get(c).get("fid"), rowIndex);
            this.getModel().setValue("dailyentryid", rows.get(c).get("fentryid"), rowIndex);
            this.getModel().setValue("taskdescrip", rows.get(c).get("ftaskname"), rowIndex);
            String info = "";
            Object info_tag = rows.get(c).get("finformcontext_tag");
            if (info_tag != null && info_tag.toString().length() > 20) {
                info = info_tag.toString().substring(0, 15);
                this.getModel().setValue("information", (Object)info, rowIndex);
            } else {
                this.getModel().setValue("information", info_tag, rowIndex);
            }
            this.getModel().setValue("information_tag", info_tag, rowIndex);
            this.getModel().setValue("projectplaneno", (Object)proPlaneNo, rowIndex);
            this.getModel().setValue("senderpro", rows.get(c).get("fprofessionid"), rowIndex);
            this.getModel().setValue("receiverpro", (Object)receiver, rowIndex);
            this.getModel().setValue("prostatus", rows.get(c).get("fhandlestatus"), rowIndex);
        }
        this.getView().updateView("infoentryentity");
    }

    private void bindAndShowMROData(DynamicObjectCollection mroDynamicObjs) {
        Object dailyExpTypeNumber = null;
        Object dailyExpTypeName = null;
        String entryMaterielMTC = "";
        String projectName = "";
        for (DynamicObject mroEntry : mroDynamicObjs) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            Long id = (Long)mroEntry.get("id");
            Long entryId = (Long)mroEntry.get("treeentryentity.id");
            Long dailyExpTypeId = mroEntry.getLong("dailyexptype");
            QFilter dailyExpTypeQFilter = new QFilter("id", "=", (Object)dailyExpTypeId);
            DynamicObject dailyExpType = QueryServiceHelper.queryOne((String)"mpdm_dailyexptypedef", (String)"number,name", (QFilter[])new QFilter[]{dailyExpTypeQFilter});
            if (dailyExpType != null) {
                dailyExpTypeNumber = dailyExpType.get("number");
                dailyExpTypeName = dailyExpType.get("name");
            }
            Object billNo = mroEntry.get("billno");
            Long materielMTCId = mroEntry.getLong("treeentryentity.materielmtc");
            QFilter materielMTCQFilter = new QFilter("id", "=", (Object)materielMTCId);
            DynamicObject materielMTC = QueryServiceHelper.queryOne((String)"mpdm_materialmtcinfo", (String)"name", (QFilter[])new QFilter[]{materielMTCQFilter});
            if (materielMTC != null) {
                entryMaterielMTC = String.valueOf(materielMTC.get("name"));
            }
            Long projectId = mroEntry.getLong("treeentryentity.project");
            QFilter projectQFilter = new QFilter("id", "=", (Object)projectId);
            DynamicObject project = QueryServiceHelper.queryOne((String)"pmpd_project", (String)"name", (QFilter[])new QFilter[]{projectQFilter});
            if (project != null) {
                projectName = String.valueOf(project.get("name"));
            }
            String materAndPro = projectName + "/" + entryMaterielMTC;
            map.put("id", id);
            map.put("entryId", entryId);
            map.put("billNo", billNo);
            map.put("entryMaterielMTC", entryMaterielMTC);
            map.put("project", projectId);
            map.put("materAndPro", materAndPro);
            map.put("dailyExpTypeName", dailyExpTypeName);
            map.put("dailyExpTypeNumber", dailyExpTypeNumber);
            this.setMROEntryData(map);
        }
        this.getView().updateView("ohentryentity");
    }

    private void setMROEntryData(Map<String, Object> map) {
        Long id = (Long)map.get("id");
        Long entryId = (Long)map.get("entryId");
        Object billNo = map.get("billNo");
        String entryMaterielMTC = (String)map.get("entryMaterielMTC");
        Long project = (Long)map.get("project");
        Object dailyExpTypeName = map.get("dailyExpTypeName");
        String materAndPro = (String)map.get("materAndPro");
        Object dailyExpTypeNumber = map.get("dailyExpTypeNumber");
        int rowIdex = this.getModel().createNewEntryRow("ohentryentity");
        this.getModel().beginInit();
        this.getModel().setValue("mroid", (Object)id, rowIdex);
        this.getModel().setValue("mroentryid", (Object)entryId, rowIdex);
        this.getModel().setValue("workname", dailyExpTypeName, rowIdex);
        this.getModel().setValue("worknumber", dailyExpTypeNumber, rowIdex);
        this.getModel().setValue("mroorderid", billNo, rowIdex);
        this.getModel().setValue("projectid", (Object)project, rowIdex);
        this.getModel().setValue("materidfield", (Object)entryMaterielMTC, rowIdex);
        this.getModel().setValue("proandmaterid", (Object)materAndPro, rowIdex);
        this.getModel().endInit();
    }

    private void setTaskEntryData(DailyPlanBean headBean, DailyPlanEntryOfOprBean oprEntryBean) {
        int rowIndex = this.getModel().createNewEntryRow("taskentryentity");
        this.getModel().beginInit();
        this.getModel().setValue("dailyplanid", headBean.getPkValue(), rowIndex);
        this.getModel().setValue("oprentryid", oprEntryBean.getPkValue(), rowIndex);
        this.getModel().setValue("taskname", (Object)headBean.getTaskName(), rowIndex);
        this.getModel().setValue("workcardtitle", (Object)oprEntryBean.getWorkCardTitle(), rowIndex);
        this.getModel().setValue("orderno", (Object)oprEntryBean.getOrderNo(), rowIndex);
        this.getModel().setValue("processgroup", (Object)oprEntryBean.getProcessGroup(), rowIndex);
        this.getModel().setValue("project", (Object)oprEntryBean.getProject(), rowIndex);
        this.getModel().setValue("workunit", (Object)oprEntryBean.getOprWorkHourUnit(), rowIndex);
        this.getModel().setValue("stdworkhour", (Object)oprEntryBean.getWorkHour(), rowIndex);
        this.getModel().setValue("taskbegintime", (Object)headBean.getBeginTime(), rowIndex);
        this.getModel().setValue("taskendtime", (Object)headBean.getEndTime(), rowIndex);
        this.getModel().setValue("allocationstatus", (Object)"A", rowIndex);
        this.getModel().setValue("techno", (Object)oprEntryBean.getTechNo(), rowIndex);
        this.getModel().setValue("defaultworksort", (Object)oprEntryBean.getDefaultWorkSort(), rowIndex);
        this.getModel().setValue("dailyplanno", (Object)headBean.getBillno(), rowIndex);
        this.getModel().setValue("completionrate", (Object)oprEntryBean.getCompletionRate(), rowIndex);
        this.getModel().setValue("note", (Object)oprEntryBean.getNote(), rowIndex);
        this.getModel().endInit();
    }

    private void setAbnEntryData(DailyPlanBean headBean, DailyPlanEntryOfOprBean oprEntryBean) {
        int rowIndex = this.getModel().createNewEntryRow("abentryentity");
        this.getModel().beginInit();
        this.getModel().setValue("dailyplanidab", headBean.getPkValue(), rowIndex);
        this.getModel().setValue("oprentryidab", oprEntryBean.getPkValue(), rowIndex);
        this.getModel().setValue("tasknameab", (Object)headBean.getTaskName(), rowIndex);
        this.getModel().setValue("workcardtitleab", (Object)oprEntryBean.getWorkCardTitle(), rowIndex);
        this.getModel().setValue("ordernoab", (Object)oprEntryBean.getOrderNo(), rowIndex);
        this.getModel().setValue("processgroupab", (Object)oprEntryBean.getProcessGroup(), rowIndex);
        this.getModel().setValue("projectab", (Object)oprEntryBean.getProject(), rowIndex);
        this.getModel().setValue("workunitab", (Object)oprEntryBean.getOprWorkHourUnit(), rowIndex);
        this.getModel().setValue("stdworkhourab", (Object)oprEntryBean.getWorkHour(), rowIndex);
        this.getModel().setValue("taskbegintimeab", (Object)headBean.getBeginTime(), rowIndex);
        this.getModel().setValue("taskendtimeab", (Object)headBean.getEndTime(), rowIndex);
        this.getModel().setValue("allocationstatusab", (Object)"A", rowIndex);
        this.getModel().setValue("technoab", (Object)oprEntryBean.getTechNo(), rowIndex);
        this.getModel().setValue("defaultworksortab", (Object)oprEntryBean.getDefaultWorkSort(), rowIndex);
        this.getModel().setValue("dailyplannoab", (Object)headBean.getBillno(), rowIndex);
        this.getModel().endInit();
    }

    private void setCustomCalendar(DailyPlanBean[] dailyPlans) {
        DailyPlanCustomControlHelper cusHelper = new DailyPlanCustomControlHelper();
        JSONObject jsonData = this.getCalendarCacheData();
        String slotId = cusHelper.convertDailyPlanBeanToCustom(dailyPlans, jsonData);
        if (StringUtils.isEmpty((CharSequence)slotId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u884c\u4e1a\u672a\u6dfb\u52a0\u65f6\u95f4\u6bb5\u65b9\u6848", (String)"DailyPlanEdit_62", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put("slotId", slotId);
        this.getPageCache().put("initSlotId", slotId);
        String hisSlotId = this.getPageCache().get("slotId");
        if (StringUtils.isEmpty((CharSequence)this.getPageCache().get("hisSlotId"))) {
            this.getPageCache().put("hisSlotId", hisSlotId);
        }
        this.bindCustomControl(jsonData);
    }

    private void setCustomCalendar(DailyPlanBean[] dailyPlans, String slotId) {
        JSONObject jsonData = this.getCalendarCacheData();
        DailyPlanCustomControlHelper cusHelper = new DailyPlanCustomControlHelper();
        cusHelper.convertDailyPlanBeanToCustom(dailyPlans, jsonData, slotId);
        this.bindCustomControl(jsonData);
    }

    private void setCustomHistoryCalendar(DailyPlanBean[] dailyPlans) {
        JSONObject jsonData = this.getHisCalendarCacheData();
        DailyPlanCustomControlHelper cusHelper = new DailyPlanCustomControlHelper();
        String slotId = cusHelper.convertDailyPlanBeanToCustom(dailyPlans, jsonData);
        this.getPageCache().put("hisSlotId", slotId);
        this.bindHistoryCustomControl(jsonData);
    }

    private void setCustomHistoryCalendar(DailyPlanBean[] dailyPlans, String slotId) {
        JSONObject jsonData = this.getHisCalendarCacheData();
        DailyPlanCustomControlHelper cusHelper = new DailyPlanCustomControlHelper();
        cusHelper.convertDailyPlanHisBeanToCustom(dailyPlans, jsonData, slotId);
        this.bindHistoryCustomControl(jsonData);
    }

    private void saveDailyPlan() {
        this.getPageCache().put("isSaved", "1");
        JSONObject calendarCacheData = this.getCalendarCacheData();
        DailyPlanDataHelper saveHelper = new DailyPlanDataHelper();
        Object[] operationResult = saveHelper.saveDailyPlanData(calendarCacheData.toJSONString());
        if (operationResult != null && operationResult.length > 0) {
            if (operationResult[0].equals(1)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u884c\u4e1a\u672a\u7ed1\u5b9a\u65f6\u95f4\u6bb5\u65b9\u6848\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"DailyPlanEdit_63", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"DailyPlanEdit_9", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void updateAllocationStatus() {
        DynamicObjectCollection taskEntry = this.getModel().getEntryEntity("taskentryentity");
        for (Object taskRow : taskEntry) {
            Long dailyplanid = taskRow.getLong("dailyplanid");
            if (this.checkDailyPlanIDIsAllocate(dailyplanid.toString())) {
                taskRow.set("allocationstatus", (Object)"B");
                continue;
            }
            taskRow.set("allocationstatus", (Object)"A");
        }
        DynamicObjectCollection corTaskEntry = this.getModel().getEntryEntity("coorentryentity");
        for (DynamicObject taskRow : corTaskEntry) {
            Long dailyplanid = taskRow.getLong("cordailyplanid");
            if (this.checkDailyPlanIDIsAllocate(dailyplanid.toString())) {
                taskRow.set("allocatestatus", (Object)"B");
                continue;
            }
            taskRow.set("allocatestatus", (Object)"A");
        }
        DynamicObjectCollection abTaskEntry = this.getModel().getEntryEntity("abentryentity");
        for (DynamicObject taskRow : abTaskEntry) {
            Long dailyplanid = taskRow.getLong("dailyplanidab");
            if (this.checkDailyPlanIDIsAllocate(dailyplanid.toString())) {
                taskRow.set("allocationstatusab", (Object)"B");
                continue;
            }
            taskRow.set("allocationstatusab", (Object)"A");
        }
        this.getView().updateView("taskentryentity");
        this.getView().updateView("coorentryentity");
        this.getView().updateView("abentryentity");
    }

    private boolean checkDailyPlanIDIsAllocate(String dailyplanid) {
        JSONObject calendarCacheData = this.getCalendarCacheData();
        if (calendarCacheData != null) {
            JSONArray tableData = calendarCacheData.getJSONArray("tableData");
            for (int i = 0; i < tableData.size(); ++i) {
                JSONObject row = tableData.getJSONObject(i);
                for (int j = 1; j <= this.maxDays; ++j) {
                    String col = String.format("row_%1$s", j);
                    JSONObject colData = row.getJSONObject(col);
                    JSONArray tasks = colData.getJSONArray(tasks);
                    for (int index = 0; index < tasks.size(); ++index) {
                        JSONObject task = tasks.getJSONObject(index);
                        String taskID = task.getString("taskId");
                        if (!dailyplanid.equals(taskID)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void clearTask() {
        DailyPlanDataHelper heper = new DailyPlanDataHelper();
        heper.clearData();
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String slotId = this.getPageCache().get("slotId");
        MessageBoxResult result = e.getResult();
        if ("changeslot_confirm".equals(e.getCallBackId())) {
            if (MessageBoxResult.Yes.equals((Object)result)) {
                this.clearTask();
                this.currentCalenderOp(slotId, "changeTimeSlotName");
            } else {
                JSONObject jsonData = this.getCalendarCacheData();
                this.bindCustomControl(jsonData);
            }
        }
        if (("prevDay".equals(e.getCallBackId()) || "nextDay".equals(e.getCallBackId())) && MessageBoxResult.No.equals((Object)result)) {
            this.getPageCache().put("isSaved", "1");
            this.currentCalenderOp("", e.getCallBackId());
        }
        if (MessageBoxResult.Yes.equals((Object)result) && !"projectChoose".equals(e.getCallBackId())) {
            String callBackId;
            this.getView().invokeOperation("donothing_save");
            switch (callBackId = e.getCallBackId()) {
                case "combine": {
                    this.combine();
                    break;
                }
                case "split": {
                    this.split();
                    break;
                }
                case "splittask": {
                    this.splitTask();
                    break;
                }
                case "prevDay": {
                    this.currentCalenderOp("", e.getCallBackId());
                    break;
                }
                case "nextDay": {
                    this.currentCalenderOp("", e.getCallBackId());
                }
            }
        } else if (MessageBoxResult.Yes.equals((Object)result) && "projectChoose".equals(e.getCallBackId())) {
            this.projectChoose();
        }
    }

    private void combine() {
        DailyPlanHelper helper = new DailyPlanHelper();
        EntryGrid taskEntry = (EntryGrid)this.getView().getControl("taskentryentity");
        int[] selectRows = taskEntry.getSelectRows();
        if (selectRows.length > 0) {
            HashSet<Long> dailyPlanIDs = new HashSet<Long>(8);
            for (int i : selectRows) {
                Long dailyplanid = (Long)this.getModel().getValue("dailyplanid", i);
                dailyPlanIDs.add(dailyplanid);
            }
            helper.setPlatView(this.getView());
            helper.combineDailyPlan(dailyPlanIDs);
            this.getView().invokeOperation("refresh");
        }
    }

    private void split() {
        DailyPlanHelper helper = new DailyPlanHelper();
        helper.setPlatView(this.getView());
        EntryGrid taskEntry = (EntryGrid)this.getView().getControl("taskentryentity");
        int[] selectRows = taskEntry.getSelectRows();
        if (selectRows.length > 0) {
            HashSet<Long> dailyPlanIDs = new HashSet<Long>(8);
            for (int i : selectRows) {
                Long dailyplanid = (Long)this.getModel().getValue("oprentryid", i);
                dailyPlanIDs.add(dailyplanid);
            }
            helper.splitDailyPlan(dailyPlanIDs);
            this.getView().invokeOperation("refresh");
        }
    }

    private void splitTask() {
        DailyPlanHelper helper = new DailyPlanHelper();
        helper.setPlatView(this.getView());
        EntryGrid taskEntry = (EntryGrid)this.getView().getControl("taskentryentity");
        int[] selectRows = taskEntry.getSelectRows();
        if (selectRows.length > 0) {
            HashSet<Long> dailyPlanIDs = new HashSet<Long>(8);
            for (int i : selectRows) {
                Long dailyplanid = (Long)this.getModel().getValue("dailyplanid", i);
                dailyPlanIDs.add(dailyplanid);
            }
            HashSet<Long> oprEntryID = new HashSet<Long>(8);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("taskentryentity");
            for (DynamicObject row : entryEntity) {
                Long dailyID = row.getLong("dailyplanid");
                if (!dailyPlanIDs.contains(dailyID)) continue;
                oprEntryID.add(row.getLong("oprentryid"));
            }
            helper.splitDailyPlan(oprEntryID);
            this.getView().invokeOperation("refresh");
        }
    }

    private void transmit() {
        JSONObject calendarCacheData = this.getCalendarCacheData();
        HashSet<Long> dailyPlanIDs = new HashSet<Long>(16);
        JSONArray rows = calendarCacheData.getJSONArray("tableData");
        for (int i = 0; i < rows.size(); ++i) {
            JSONObject row = rows.getJSONObject(i);
            for (int j = 1; j <= this.maxDays; ++j) {
                String colName = String.format("row_%d", j);
                JSONObject col = row.getJSONObject(colName);
                JSONArray tasks = col.getJSONArray(tasks);
                for (int k = 0; k < tasks.size(); ++k) {
                    JSONObject task = tasks.getJSONObject(k);
                    Long taskId = Long.valueOf(task.getString("taskId"));
                    dailyPlanIDs.add(taskId);
                }
            }
        }
        if (dailyPlanIDs.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4e0b\u8fbe\u7684\u4efb\u52a1", (String)"DailyPlanEdit_36", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
            return;
        }
        this.saveDailyPlan();
        DailyPlanHelper helper = new DailyPlanHelper();
        helper.setPlatView(this.getView());
        helper.transmitDailyPlan(dailyPlanIDs);
    }

    private void initCalendar() {
        CustomControl calendar = (CustomControl)this.getControl("calendarcontrolap");
        if (calendar == null) {
            return;
        }
        DailyPlanCustomControlHelper cusHelper = new DailyPlanCustomControlHelper();
        cusHelper.setMaxDays(this.maxDays);
        JSONObject param = new JSONObject();
        param.put("startDate", (Object)this.getStartDate());
        JSONObject data = cusHelper.initCalendar(param);
        JSONArray customerRightMenu = DailyPlanCustomConsts.getCustomerRightMenu();
        this.getPageCache().put(calendarRightMenu, customerRightMenu.toJSONString());
        this.getPageCache().put(switchStatus, "false");
        this.bindCustomControl(data);
    }

    private void initHistoryCalendar(Date startDate) {
        CustomControl calendar = (CustomControl)this.getControl("calendarcontrolap1");
        if (calendar == null) {
            return;
        }
        DailyPlanCustomControlHelper cusHelper = new DailyPlanCustomControlHelper();
        cusHelper.setMaxDays(this.maxDays);
        JSONObject param = new JSONObject();
        param.put("startDate", (Object)startDate);
        JSONObject data = cusHelper.initCalendar(param);
        JSONArray customerRightMenu = DailyPlanCustomConsts.getCustomerHisRightMenu();
        this.getPageCache().put(calendarHisRightMenu, customerRightMenu.toJSONString());
        this.getPageCache().put(switchStatus, "false");
        this.bindHistoryCustomControl(data);
    }

    private void initHistoryOtherCalendar(Date startDate) {
        CustomControl calendar = (CustomControl)this.getControl("calendarcontrolap1");
        if (calendar == null) {
            return;
        }
        DailyPlanCustomControlHelper cusHelper = new DailyPlanCustomControlHelper();
        cusHelper.setMaxDays(this.maxDays);
        JSONObject param = new JSONObject();
        param.put("startDate", (Object)startDate);
        String autoIncreaseNum = this.getPageCache().get("autoIncreaseNum");
        JSONObject data = cusHelper.initHisCalendar(param, Integer.parseInt(autoIncreaseNum));
        JSONArray customerRightMenu = DailyPlanCustomConsts.getCustomerHisRightMenu();
        this.getPageCache().put(calendarHisRightMenu, customerRightMenu.toJSONString());
        this.getPageCache().put(switchStatus, "false");
        this.bindHistoryCustomControl(data);
    }

    private void bindCustomControl(JSONObject data) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(8);
        String strSwitchStatus = this.getPageCache().get(switchStatus);
        String rightMenu = this.getPageCache().get(calendarRightMenu);
        paramsMap.put("rightMenuData", JSONArray.parseArray((String)rightMenu));
        paramsMap.put("mySwitch", Boolean.parseBoolean(strSwitchStatus));
        paramsMap.put("isDraggable", "true");
        paramsMap.put("topBoxShow", "true");
        paramsMap.put("timeStamp", TimeServiceHelper.now());
        paramsMap.put("action", "init");
        paramsMap.put("returnData", data);
        CustomControl calendar = (CustomControl)this.getControl("calendarcontrolap");
        if (calendar == null) {
            return;
        }
        this.getPageCache().put(calendarDataCaheKey, data.toJSONString());
        calendar.setData(paramsMap);
    }

    private void bindHistoryCustomControl(JSONObject data) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(8);
        String strSwitchStatus = this.getPageCache().get(switchStatus);
        String rightMenu = this.getPageCache().get(calendarHisRightMenu);
        paramsMap.put("rightMenuData", JSONArray.parseArray((String)rightMenu));
        paramsMap.put("mySwitch", Boolean.parseBoolean(strSwitchStatus));
        paramsMap.put("action", "init");
        paramsMap.put("returnData", data);
        CustomControl calendar = (CustomControl)this.getControl("calendarcontrolap1");
        if (calendar == null) {
            return;
        }
        this.getPageCache().put(calendarHistoryDataCaheKey, data.toJSONString());
        calendar.setData(paramsMap);
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String eventArgs = e.getEventArgs();
        String eventName = e.getEventName();
        String key = e.getKey();
        if ("calendarcontrolap1".equals(key)) {
            if ("changeTimeSlotName".equals(eventName)) {
                this.getPageCache().put("autoIncreaseNum", "1");
                this.getPageCache().put("hisSlotId", eventArgs);
                this.historyCalenderOp(eventArgs, "changeTimeSlotName");
            } else {
                this.historyCalenderOp(eventArgs, eventName);
            }
        } else if ("changeTimeSlotName".equals(eventName)) {
            this.getPageCache().put("slotId", eventArgs);
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("changeslot_confirm", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u65f6\u95f4\u6bb5\u5c06\u5220\u9664\u5f53\u5929\u53ca\u4ee5\u540e\u7684\u6240\u6709\u8ba1\u5212\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u3002", (String)"DailyPlanEdit_57", (String)"mmc-sfc-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
        } else if (("prevDay".equals(eventName) || "nextDay".equals(eventName)) && "0".equals(this.getPageCache().get("isSaved"))) {
            if ("prevDay".equals(eventName)) {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("prevDay", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u65e5\u671f\u672a\u4fdd\u5b58\u5c06\u6e05\u7a7a\u4efb\u52a1\uff0c\u662f\u5426\u4fdd\u5b58\u4efb\u52a1\u3002", (String)"DailyPlanEdit_58", (String)"mmc-sfc-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNoCancel, confirmCallBackListener);
            } else {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("nextDay", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u65e5\u671f\u672a\u4fdd\u5b58\u5c06\u6e05\u7a7a\u4efb\u52a1\uff0c\u662f\u5426\u4fdd\u5b58\u4efb\u52a1\u3002", (String)"DailyPlanEdit_58", (String)"mmc-sfc-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNoCancel, confirmCallBackListener);
            }
        } else {
            this.currentCalenderOp(eventArgs, eventName);
        }
    }

    private void historyCalenderOp(String eventArgs, String eventName) {
        switch (eventName) {
            case "changemySwitch": {
                JSONObject cacheData = this.getHisCalendarCacheData();
                this.getPageCache().put(switchStatus, eventArgs);
                this.bindCustomControl(cacheData);
                break;
            }
            case "changeTimeSlotName": {
                this.queryHistoryData(false, eventArgs);
                break;
            }
            case "prevDay": {
                this.changeHistoryStartDate(-1);
                break;
            }
            case "nextDay": {
                this.changeHistoryStartDate(1);
                break;
            }
            case "checkInfo": {
                this.showHistoryTaskDetail(eventArgs);
                break;
            }
        }
    }

    private void currentCalenderOp(String eventArgs, String eventName) {
        switch (eventName) {
            case "changemySwitch": {
                JSONObject cacheData = this.getCalendarCacheData();
                this.getPageCache().put(switchStatus, eventArgs);
                this.bindCustomControl(cacheData);
                break;
            }
            case "prevDay": {
                this.changeStartDate(-1);
                break;
            }
            case "nextDay": {
                this.changeStartDate(1);
                break;
            }
            case "changeTimeSlotName": {
                this.queryData(false, eventArgs);
                break;
            }
            case "checkInfo": {
                this.showTaskDetail(eventArgs);
                break;
            }
            case "mronrcapply": {
                DailyPlanHelper nrcHelper = new DailyPlanHelper();
                Long nrcTaskId = nrcHelper.getTaskId(eventArgs);
                nrcHelper.nrcBillApply(nrcTaskId);
                PushArgs pushNrc = nrcHelper.nrcBillApply(nrcTaskId);
                this.nrcPush(pushNrc);
                break;
            }
            case "mroswsapply": {
                DailyPlanHelper swsHelper = new DailyPlanHelper();
                Long swsTaskId = swsHelper.getTaskId(eventArgs);
                PushArgs pushSws = swsHelper.swsBillApply(swsTaskId);
                this.swsPush(pushSws);
                break;
            }
            case "mftreqbillapply": {
                DailyPlanHelper reqHelper = new DailyPlanHelper();
                Long reqTaskId = reqHelper.getTaskId(eventArgs);
                reqHelper.setPlatView(this.getView());
                PushArgs pushArgs = reqHelper.reqBillApply(reqTaskId);
                this.reqPush(pushArgs);
                break;
            }
            case "coorbillapply": {
                DailyPlanHelper coorHelper = new DailyPlanHelper();
                Long coorTaskId = coorHelper.getTaskId(eventArgs);
                PushArgs pushCoor = coorHelper.coorBillApply(coorTaskId);
                this.coorPush(pushCoor);
                break;
            }
            case "staffneeds": {
                DailyPlanHelper staffHelper = new DailyPlanHelper();
                Long staffTaskId = staffHelper.getTaskId(eventArgs);
                PushArgs pushStaff = staffHelper.staffBill(staffTaskId);
                this.staffPush(pushStaff);
                break;
            }
            case "otherNeeds": {
                DailyPlanHelper otherHelper = new DailyPlanHelper();
                Long otherTaskId = otherHelper.getTaskId(eventArgs);
                PushArgs pushOther = otherHelper.otherNeedBill(otherTaskId);
                this.otherPush(pushOther);
                break;
            }
            case "workappoint": {
                DailyPlanHelper appointHelper = new DailyPlanHelper();
                Long appointTaskId = appointHelper.getTaskId(eventArgs);
                PushArgs pushAppoint = appointHelper.workAppointBill(appointTaskId);
                try {
                    this.appointPush(pushAppoint, eventArgs);
                }
                catch (ParseException e) {
                    logger.error(e.getMessage());
                }
                break;
            }
            case "informtask": {
                DailyPlanHelper infoHelper = new DailyPlanHelper();
                infoHelper.setPlatView(this.getView());
                this.getView().getPageCache().put("dailyId", infoHelper.getTaskId(eventArgs).toString());
                infoHelper.openDpForm((IFormPlugin)this, JSON.parseObject((String)eventArgs).get((Object)"text").toString());
                break;
            }
            case "sendmessage": {
                this.showPersons(eventArgs);
                break;
            }
            case "important": {
                this.setImportant(eventArgs, "1");
                break;
            }
            case "cancelimportant": {
                this.setImportant(eventArgs, "0");
                break;
            }
            default: {
                this.doTaskOperate(eventArgs, eventName);
            }
        }
    }

    private void appointPush(PushArgs pushAppoint, String eventArgs) throws ParseException {
        JSONObject req = JSON.parseObject((String)eventArgs);
        Long time = req.getLong("taskTime");
        Date date = new Date(time);
        SimpleDateFormat sDate = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sTime = new SimpleDateFormat("HH:mm:ss");
        String dateStr = sDate.format(date);
        String timeStr = sTime.format(date);
        ConvertOperationResult appointResult = ConvertServiceHelper.push((PushArgs)pushAppoint);
        if (appointResult.isSuccess() && !appointResult.getCachePageIds().isEmpty()) {
            MainEntityType swsTargetMainType = EntityMetadataCache.getDataEntityType((String)"pmtm_workappointment");
            List objs = appointResult.loadTargetDataObjects(BusinessDataReader::loadRefence, swsTargetMainType);
            List strs = appointResult.getCachePageIds();
            for (int i = 0; i < objs.size(); ++i) {
                ((DynamicObject)objs.get(i)).set("needdate", (Object)date);
                ((DynamicObject)objs.get(i)).set("needtime", (Object)date);
                ((DynamicObject)objs.get(i)).set("taskdetail", (Object)"aaa");
                appointResult.updateTargetDataObject((String)strs.get(i), (DynamicObject)objs.get(i));
            }
            if (objs.size() > 1) {
                Push.showMultiTargetBills((IFormView)this.getView(), (PushArgs)pushAppoint, (ConvertOperationResult)appointResult, (boolean)false);
            } else {
                Push.showTargetBill((IFormView)this.getView(), (PushArgs)pushAppoint, (ConvertOperationResult)appointResult, (boolean)false);
            }
        } else {
            Push.showReport((IFormView)this.getView(), (AbstractConvertServiceArgs)pushAppoint, (ConvertOperationResult)appointResult);
        }
    }

    private void otherPush(PushArgs pushOther) {
        ConvertOperationResult otherResult = ConvertServiceHelper.push((PushArgs)pushOther);
        if (otherResult.isSuccess() && !otherResult.getCachePageIds().isEmpty()) {
            MainEntityType swsTargetMainType = EntityMetadataCache.getDataEntityType((String)"msplan_otherneedplan");
            List swsTargetBillObjs = otherResult.loadTargetDataObjects(BusinessDataReader::loadRefence, swsTargetMainType);
            if (swsTargetBillObjs.size() > 1) {
                Push.showMultiTargetBills((IFormView)this.getView(), (PushArgs)pushOther, (ConvertOperationResult)otherResult, (boolean)false);
            } else {
                Push.showTargetBill((IFormView)this.getView(), (PushArgs)pushOther, (ConvertOperationResult)otherResult, (boolean)false);
            }
        } else {
            Push.showReport((IFormView)this.getView(), (AbstractConvertServiceArgs)pushOther, (ConvertOperationResult)otherResult);
        }
    }

    private void staffPush(PushArgs pushStaff) {
        ConvertOperationResult staffResult = ConvertServiceHelper.push((PushArgs)pushStaff);
        if (staffResult.isSuccess() && !staffResult.getCachePageIds().isEmpty()) {
            MainEntityType swsTargetMainType = EntityMetadataCache.getDataEntityType((String)"sfc_staffneeds");
            List swsTargetBillObjs = staffResult.loadTargetDataObjects(BusinessDataReader::loadRefence, swsTargetMainType);
            if (swsTargetBillObjs.size() > 1) {
                Push.showMultiTargetBills((IFormView)this.getView(), (PushArgs)pushStaff, (ConvertOperationResult)staffResult, (boolean)false);
            } else {
                Push.showTargetBill((IFormView)this.getView(), (PushArgs)pushStaff, (ConvertOperationResult)staffResult, (boolean)false);
            }
        } else {
            Push.showReport((IFormView)this.getView(), (AbstractConvertServiceArgs)pushStaff, (ConvertOperationResult)staffResult);
        }
    }

    private void coorPush(PushArgs pushCoor) {
        ConvertOperationResult coorResult = ConvertServiceHelper.push((PushArgs)pushCoor);
        if (coorResult.isSuccess() && !coorResult.getCachePageIds().isEmpty()) {
            MainEntityType swsTargetMainType = EntityMetadataCache.getDataEntityType((String)"pom_coordination");
            List swsTargetBillObjs = coorResult.loadTargetDataObjects(BusinessDataReader::loadRefence, swsTargetMainType);
            if (swsTargetBillObjs.size() > 1) {
                Push.showMultiTargetBills((IFormView)this.getView(), (PushArgs)pushCoor, (ConvertOperationResult)coorResult, (boolean)false);
            } else {
                Push.showTargetBill((IFormView)this.getView(), (PushArgs)pushCoor, (ConvertOperationResult)coorResult, (boolean)false);
            }
        } else {
            Push.showReport((IFormView)this.getView(), (AbstractConvertServiceArgs)pushCoor, (ConvertOperationResult)coorResult);
        }
    }

    private void nrcPush(PushArgs pushNrc) {
        ConvertOperationResult swsResult = ConvertServiceHelper.push((PushArgs)pushNrc);
        if (swsResult.isSuccess() && !swsResult.getCachePageIds().isEmpty()) {
            MainEntityType swsTargetMainType = EntityMetadataCache.getDataEntityType((String)"pom_mronrc");
            List swsTargetBillObjs = swsResult.loadTargetDataObjects(BusinessDataReader::loadRefence, swsTargetMainType);
            if (swsTargetBillObjs.size() > 1) {
                Push.showMultiTargetBills((IFormView)this.getView(), (PushArgs)pushNrc, (ConvertOperationResult)swsResult, (boolean)false);
            } else {
                Push.showTargetBill((IFormView)this.getView(), (PushArgs)pushNrc, (ConvertOperationResult)swsResult, (boolean)false);
            }
        } else {
            Push.showReport((IFormView)this.getView(), (AbstractConvertServiceArgs)pushNrc, (ConvertOperationResult)swsResult);
        }
    }

    private void swsPush(PushArgs pushSws) {
        ConvertOperationResult swsResult = ConvertServiceHelper.push((PushArgs)pushSws);
        if (swsResult.isSuccess() && !swsResult.getCachePageIds().isEmpty()) {
            MainEntityType swsTargetMainType = EntityMetadataCache.getDataEntityType((String)"pom_mrosws");
            List swsTargetBillObjs = swsResult.loadTargetDataObjects(BusinessDataReader::loadRefence, swsTargetMainType);
            if (swsTargetBillObjs.size() > 1) {
                Push.showMultiTargetBills((IFormView)this.getView(), (PushArgs)pushSws, (ConvertOperationResult)swsResult, (boolean)false);
            } else {
                Push.showTargetBill((IFormView)this.getView(), (PushArgs)pushSws, (ConvertOperationResult)swsResult, (boolean)false);
            }
        } else {
            Push.showReport((IFormView)this.getView(), (AbstractConvertServiceArgs)pushSws, (ConvertOperationResult)swsResult);
        }
    }

    private void reqPush(PushArgs pushReq) {
        ConvertOperationResult reqResult = ConvertServiceHelper.push((PushArgs)pushReq);
        if (reqResult.isSuccess() && !reqResult.getCachePageIds().isEmpty()) {
            MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"im_mdc_mftreqbill");
            List targetBillObjs = reqResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
            if (targetBillObjs.size() > 1) {
                Push.showMultiTargetBills((IFormView)this.getView(), (PushArgs)pushReq, (ConvertOperationResult)reqResult, (boolean)false);
            } else {
                Push.showTargetBill((IFormView)this.getView(), (PushArgs)pushReq, (ConvertOperationResult)reqResult, (boolean)false);
            }
        } else {
            Push.showReport((IFormView)this.getView(), (AbstractConvertServiceArgs)pushReq, (ConvertOperationResult)reqResult);
        }
    }

    private void changeStartDate(int diffDay) {
        JSONObject calendarCacheData = this.getCalendarCacheData();
        String slotId = this.getPageCache().get("slotId");
        if (StringUtils.isEmpty((CharSequence)slotId)) {
            return;
        }
        Date startDate = this.getStartDate();
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        c.add(5, diffDay);
        DailyPlanCustomControlHelper cusHelper = new DailyPlanCustomControlHelper();
        cusHelper.setMaxDays(this.maxDays);
        Boolean isQuery = Boolean.parseBoolean(this.getPageCache().get(queryStatus));
        JSONObject topJson = cusHelper.buildTop(c.getTime());
        calendarCacheData.put("top", (Object)topJson);
        JSONArray columnJson = cusHelper.buildColumn(c.getTime(), this.maxDays);
        calendarCacheData.put("columns", (Object)columnJson);
        HashSet<String> taskSlotIds = new HashSet<String>(16);
        if (isQuery.booleanValue()) {
            DailyPlanHelper helper = new DailyPlanHelper();
            helper.setStartDate(c.getTime());
            helper.setMaxDays(this.maxDays);
            DailyPlanBean[] dailyPlanBeans = helper.query();
            if (diffDay < 0) {
                for (DailyPlanBean dailyPlan : dailyPlanBeans) {
                    DailyPlanEntryOfPlanBean[] planEntry;
                    for (DailyPlanEntryOfPlanBean dailyPlanEntryOfPlanBean : planEntry = dailyPlan.getPlanEntry()) {
                        Date planStartTime = dailyPlanEntryOfPlanBean.getPlanStartTime();
                        if (planStartTime.compareTo(c.getTime()) < 0 || planStartTime.compareTo(startDate) >= 0) continue;
                        String timeSlotId = String.valueOf(dailyPlanEntryOfPlanBean.getTimeSlotId());
                        taskSlotIds.add(timeSlotId);
                    }
                }
                if (taskSlotIds.size() > 0 && !taskSlotIds.contains(slotId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u7684\u65f6\u95f4\u6bb5\u65b9\u6848\u4e0d\u4e00\u81f4\uff0c\u4e0d\u652f\u6301\u65f6\u95f4\u5f80\u524d\u79fb\u52a8", (String)"DailyPlanEdit_59", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            this.setStartDate(c.getTime());
            cusHelper.convertDailyPlanBeanToCustom(dailyPlanBeans, calendarCacheData, slotId);
            this.setMilestone(calendarCacheData);
        }
        this.bindCustomControl(calendarCacheData);
    }

    private void changeHistoryStartDate(int diffDay) {
        int num;
        String autoIncreaseNum;
        JSONObject calendarCacheData = this.getHisCalendarCacheData();
        String slotId = this.getPageCache().get("hisSlotId");
        if (StringUtils.isEmpty((CharSequence)slotId)) {
            slotId = this.getPageCache().get("slotId");
        }
        Date startDate = this.getHistoryStartDate();
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        c.add(5, diffDay);
        DailyPlanCustomControlHelper cusHelper = new DailyPlanCustomControlHelper();
        cusHelper.setMaxDays(this.maxDays);
        Boolean isQuery = Boolean.parseBoolean(this.getPageCache().get(queryHistoryStatus));
        JSONObject topJson = cusHelper.buildTop(c.getTime());
        calendarCacheData.put("top", (Object)topJson);
        JSONArray columnJson = new JSONArray(16);
        String proFlag = this.getPageCache().get("proFlag");
        if (StringUtils.isEmpty((CharSequence)proFlag)) {
            return;
        }
        if (Integer.parseInt(proFlag) == 1) {
            columnJson = cusHelper.buildColumn(c.getTime(), this.maxDays);
        } else if (diffDay > 0) {
            autoIncreaseNum = this.getPageCache().get("autoIncreaseNum");
            num = Integer.parseInt(autoIncreaseNum);
            columnJson = cusHelper.buildOtherHisColumn(c.getTime(), this.maxDays, num += this.maxDays);
            this.getPageCache().put("autoIncreaseNum", String.valueOf(num));
        } else {
            autoIncreaseNum = this.getPageCache().get("autoIncreaseNum");
            num = Integer.parseInt(autoIncreaseNum);
            if ((num -= this.maxDays) < 0) {
                return;
            }
            columnJson = cusHelper.buildOtherHisColumn(c.getTime(), this.maxDays, num);
            this.getPageCache().put("autoIncreaseNum", String.valueOf(num));
        }
        calendarCacheData.put("columns", (Object)columnJson);
        if (isQuery.booleanValue()) {
            DailyPlanHelper helper = new DailyPlanHelper();
            helper.setStartDate(c.getTime());
            helper.setMaxDays(this.maxDays);
            HashSet<QFilter> filters = new HashSet<QFilter>(8);
            if (this.getPageCache().get("newprofession") != null && this.getPageCache().get("newmulproject") != null) {
                String newProfession = this.getPageCache().get("newprofession");
                Long professionFilter = Long.valueOf(newProfession);
                String newMulProject = this.getPageCache().get("newmulproject");
                String newMulProjects = StringUtils.strip((String)newMulProject, (String)"[]");
                List<Long> mulProjectFilter = Arrays.stream(newMulProjects.split(",")).map(id -> Long.parseLong(id.trim())).collect(Collectors.toList());
                filters.add(new QFilter("planentryentity.timeslotproid", "=", (Object)Long.valueOf(slotId)));
                this.historyDailyPlanFilter(professionFilter, filters, mulProjectFilter);
            }
            DailyPlanBean[] queryData = helper.query(filters);
            this.setHistoryStartDate(c.getTime());
            cusHelper.convertDailyPlanBeanToCustom(queryData, calendarCacheData, slotId);
        }
        this.bindHistoryCustomControl(calendarCacheData);
    }

    private void historyDailyPlanFilter(Long professionFilter, Set<QFilter> filters, List<Long> mulProjectFilter) {
        if (professionFilter != null && !professionFilter.equals(0L)) {
            filters.add(new QFilter("oprentryentity.profession", "=", (Object)professionFilter));
        }
        if (mulProjectFilter != null && !mulProjectFilter.isEmpty()) {
            filters.add(new QFilter("oprentryentity.project", "in", mulProjectFilter));
        }
        filters.add(new QFilter("planentryentity", ">", (Object)0));
    }

    private JSONObject getCalendarCacheData() {
        String cache = this.getPageCache().get(calendarDataCaheKey);
        return JSONObject.parseObject((String)cache, (Feature[])new Feature[]{Feature.OrderedField});
    }

    private JSONObject getHisCalendarCacheData() {
        String cache = this.getPageCache().get(calendarHistoryDataCaheKey);
        return JSONObject.parseObject((String)cache, (Feature[])new Feature[]{Feature.OrderedField});
    }

    private void doTaskOperate(String eventArgs, String eventName) {
        JSONObject cacheData = this.getCalendarCacheData();
        JSONArray tableData = cacheData.getJSONArray("tableData");
        for (int i = 0; i < tableData.size(); ++i) {
            JSONObject row = tableData.getJSONObject(i);
            block13: for (int j = 1; j <= this.maxDays; ++j) {
                String col = String.format("row_%1$s", j);
                JSONObject colData = row.getJSONObject(col);
                Long rowTime = colData.getLong(rowTime);
                JSONArray tasks = colData.getJSONArray(tasks);
                switch (eventName) {
                    case "clickProject": {
                        this.clickProject(eventArgs, tasks);
                        continue block13;
                    }
                    case "deleteTask": {
                        this.deleteTask(eventArgs, tasks);
                        continue block13;
                    }
                    case "clickProjectBox": {
                        this.clickProjectBox(eventArgs, rowTime, tasks);
                        continue block13;
                    }
                    case "projectDrop": {
                        JSONObject jsonArg = JSONObject.parseObject((String)eventArgs);
                        Long endTimeSolt = jsonArg.getLong("endTimeSolt");
                        Long startTimeSolt = jsonArg.getLong("startTimeSolt");
                        if (startTimeSolt == null || endTimeSolt == null) {
                            return;
                        }
                        String taskId = jsonArg.getString("taskId");
                        if (rowTime.compareTo(startTimeSolt) != 0) continue block13;
                        if (this.checkRowTime(endTimeSolt)) {
                            return;
                        }
                        this.projectDrop(taskId, startTimeSolt, endTimeSolt, tasks, tableData);
                        continue block13;
                    }
                }
            }
        }
        this.getPageCache().put(calendarDataCaheKey, cacheData.toString());
        this.updateAllocationStatus();
        this.bindCustomControl(cacheData);
    }

    private void clickProjectBox(String eventArgs, Long rowTime, JSONArray tasks) {
        String currentTab;
        Tab tabap = (Tab)this.getView().getControl("tabap");
        switch (currentTab = tabap.getCurrentTab()) {
            case "tabpageap": {
                this.addTaskDataToCalendar(eventArgs, rowTime, tasks);
                break;
            }
            case "tabpageap1": {
                this.addPlanDataToCalendar(eventArgs, rowTime, tasks);
                break;
            }
            case "tabpageap2": {
                this.addCorDataToCalendar(eventArgs, rowTime, tasks);
                break;
            }
            case "tabpageap3": {
                this.addAbTaskDataToCalendar(eventArgs, rowTime, tasks);
                break;
            }
        }
    }

    private void addTaskDataToCalendar(String eventArgs, Long rowTime, JSONArray tasks) {
        Long dataIndex = Long.parseLong(eventArgs);
        if (dataIndex.compareTo(rowTime) == 0) {
            if (this.checkRowTime(rowTime)) {
                return;
            }
            this.addTaskData(dataIndex, tasks);
        }
    }

    private void addCorDataToCalendar(String eventArgs, Long rowTime, JSONArray tasks) {
        Long dataIndex = Long.parseLong(eventArgs);
        if (dataIndex.compareTo(rowTime) == 0) {
            if (this.checkRowTime(rowTime)) {
                return;
            }
            this.addCorTaskData(dataIndex, tasks);
        }
    }

    private void addAbTaskDataToCalendar(String eventArgs, Long rowTime, JSONArray tasks) {
        Long dataIndex = Long.parseLong(eventArgs);
        if (dataIndex.compareTo(rowTime) == 0) {
            if (this.checkRowTime(rowTime)) {
                return;
            }
            this.addAbTaskData(dataIndex, tasks);
        }
    }

    private void addPlanDataToCalendar(String eventTmpArgs, Long rowTmpTime, JSONArray tasksTmp) {
        Long dataIndex = Long.parseLong(eventTmpArgs);
        if (dataIndex.compareTo(rowTmpTime) == 0) {
            if (this.checkRowTime(rowTmpTime)) {
                return;
            }
            this.rowTimeTmp = rowTmpTime;
            String workName = (String)this.getModel().getValue("workname");
            String workNumber = (String)this.getModel().getValue("worknumber");
            EntryGrid mroEntry = (EntryGrid)this.getView().getControl("ohentryentity");
            int[] selectRows = mroEntry.getSelectRows();
            int rowCount = this.getModel().getEntryRowCount("ohentryentity");
            if (selectRows != null && selectRows.length > 0) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("sfc_dailypop");
                showParameter.setCaption(ResManager.loadKDString((String)"\u65e5\u8ba1\u5212", (String)"DailyPlanEdit_37", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskname");
                showParameter.setCloseCallBack(closeCallBack);
                showParameter.setCustomParam("workName", (Object)workName);
                showParameter.setCustomParam("workNumber", (Object)workNumber);
                String profession = this.getPageCache().get(profession) == null ? "0" : this.getPageCache().get(profession);
                showParameter.setCustomParam(profession, (Object)Long.parseLong(profession));
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String timeStr = sdf.format(this.rowTimeTmp);
                try {
                    Date startTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(timeStr);
                    showParameter.setCustomParam("planstarttime", (Object)startTime);
                }
                catch (ParseException e) {
                    throw new KDBizException(new ErrorCode("DailyPlanDataHelper", String.format("Date format conversion exception\uff1a%1$s", timeStr)), new Object[0]);
                }
                this.getView().showForm(showParameter);
                this.getPageCache().put(eventArgs, eventTmpArgs);
                this.getPageCache().put(rowTime, rowTmpTime.toString());
                this.getPageCache().put(tasks, tasksTmp.toString());
            }
        }
    }

    private boolean checkRowTime(Long rowTmpTime) {
        DailyPlanDataHelper helper = new DailyPlanDataHelper();
        Boolean flag = helper.isHistoryTime(rowTmpTime.toString());
        if (flag.booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5728\u8fc7\u53bb\u65f6\u95f4\u6bb5\u5185\u8fdb\u884c\u8be5\u64cd\u4f5c\u3002", (String)"DailyPlanEdit_60", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private JSONArray addTaskToCalendar(Long dataIndex, JSONArray tasks, ConvertOperationResult pushResult) {
        Set targetBillIds = pushResult.getTargetBillIds();
        HashSet<QFilter> filters = new HashSet<QFilter>(8);
        QFilter filter = new QFilter("id", "in", (Object)targetBillIds);
        filters.add(filter);
        DailyPlanBeanConvertHelper fieldHelper = new DailyPlanBeanConvertHelper();
        DynamicObject[] sfcDailyPlan = fieldHelper.getDataFromDB(filters);
        for (int i = 0; i < sfcDailyPlan.length; ++i) {
            String taskId = String.valueOf(sfcDailyPlan[i].get("id"));
            JSONObject taskJSON = this.buildMROTaskJSONObject(dataIndex, taskId, this.taskName);
            tasks.add((Object)taskJSON);
        }
        return tasks;
    }

    private void addTaskData(Long dataIndex, JSONArray tasks) {
        HashMap<String, JSONArray> mapTask = new HashMap<String, JSONArray>(8);
        EntryGrid taskEntry = (EntryGrid)this.getView().getControl("taskentryentity");
        int[] selectRows = taskEntry.getSelectRows();
        if (tasks == null) {
            tasks = new JSONArray(10);
        }
        if (tasks.isEmpty()) {
            if (selectRows.length > 0) {
                this.getPageCache().put("isSaved", "0");
            }
            for (int i = 0; i < selectRows.length; ++i) {
                int rowIndex = selectRows[i];
                String taskid = this.getModel().getValue("dailyplanid", rowIndex) == null ? "0" : this.getModel().getValue("dailyplanid", rowIndex).toString();
                String taskName = (String)this.getModel().getValue("taskname", rowIndex);
                JSONObject taskJSON = this.buildTaskJSONObject(dataIndex, taskid, taskName);
                if (mapTask.containsKey(taskid)) continue;
                mapTask.put(taskid, taskJSON.getJSONArray("persons"));
                tasks.add((Object)taskJSON);
            }
        } else {
            int i;
            for (i = 0; i < tasks.size(); ++i) {
                JSONObject taskI = tasks.getJSONObject(i);
                String taskID = taskI.getString("taskId");
                JSONArray persons = taskI.getJSONArray("persons");
                mapTask.put(taskID, persons);
            }
            for (i = 0; i < selectRows.length; ++i) {
                String taskid;
                int rowIndex = selectRows[i];
                String string = taskid = this.getModel().getValue("dailyplanid", rowIndex) == null ? "0" : this.getModel().getValue("dailyplanid", rowIndex).toString();
                if (mapTask.containsKey(taskid)) continue;
                String taskName = (String)this.getModel().getValue("taskname", rowIndex);
                JSONObject taskJSON = this.buildTaskJSONObject(dataIndex, taskid, taskName);
                tasks.add((Object)taskJSON);
            }
        }
    }

    private void addCorTaskData(Long dataIndex, JSONArray tasks) {
        HashMap<String, JSONArray> mapTask = new HashMap<String, JSONArray>(8);
        EntryGrid taskEntry = (EntryGrid)this.getView().getControl("coorentryentity");
        if (tasks == null) {
            tasks = new JSONArray(10);
        }
        int[] selectRows = taskEntry.getSelectRows();
        if (tasks.isEmpty()) {
            for (int i = 0; i < selectRows.length; ++i) {
                int rowIndex = selectRows[i];
                String taskid = this.getModel().getValue("cordailyplanid", rowIndex) == null ? "0" : this.getModel().getValue("cordailyplanid", rowIndex).toString();
                String taskName = (String)this.getModel().getValue("description", rowIndex);
                JSONObject taskJSON = this.buildTaskJSONObject(dataIndex, taskid, taskName);
                if (mapTask.containsKey(taskid)) continue;
                mapTask.put(taskid, taskJSON.getJSONArray("persons"));
                tasks.add((Object)taskJSON);
            }
        } else {
            int i;
            for (i = 0; i < tasks.size(); ++i) {
                JSONObject taskI = tasks.getJSONObject(i);
                String taskID = taskI.getString("taskId");
                JSONArray persons = taskI.getJSONArray("persons");
                mapTask.put(taskID, persons);
            }
            for (i = 0; i < selectRows.length; ++i) {
                String taskid;
                int rowIndex = selectRows[i];
                String string = taskid = this.getModel().getValue("cordailyplanid", rowIndex) == null ? "0" : this.getModel().getValue("cordailyplanid", rowIndex).toString();
                if (mapTask.containsKey(taskid)) continue;
                String taskName = (String)this.getModel().getValue("description", rowIndex);
                JSONObject taskJSON = this.buildTaskJSONObject(dataIndex, taskid, taskName);
                tasks.add((Object)taskJSON);
            }
        }
    }

    private void addAbTaskData(Long dataIndex, JSONArray tasks) {
        HashMap<String, JSONArray> mapTask = new HashMap<String, JSONArray>(8);
        if (tasks == null) {
            tasks = new JSONArray(10);
        }
        EntryGrid taskEntry = (EntryGrid)this.getView().getControl("abentryentity");
        int[] selectRows = taskEntry.getSelectRows();
        if (tasks.isEmpty()) {
            for (int i = 0; i < selectRows.length; ++i) {
                int rowIndex = selectRows[i];
                String taskid = this.getModel().getValue("dailyplanidab", rowIndex) == null ? "0" : this.getModel().getValue("dailyplanidab", rowIndex).toString();
                String taskName = (String)this.getModel().getValue("tasknameab", rowIndex);
                JSONObject taskJSON = this.buildTaskJSONObject(dataIndex, taskid, taskName);
                if (mapTask.containsKey(taskid)) continue;
                mapTask.put(taskid, taskJSON.getJSONArray("persons"));
                tasks.add((Object)taskJSON);
            }
        } else {
            int i;
            for (i = 0; i < tasks.size(); ++i) {
                JSONObject taskI = tasks.getJSONObject(i);
                String taskID = taskI.getString("taskId");
                JSONArray persons = taskI.getJSONArray("persons");
                mapTask.put(taskID, persons);
            }
            for (i = 0; i < selectRows.length; ++i) {
                String taskid;
                int rowIndex = selectRows[i];
                String string = taskid = this.getModel().getValue("dailyplanidab", rowIndex) == null ? "0" : this.getModel().getValue("dailyplanidab", rowIndex).toString();
                if (mapTask.containsKey(taskid)) continue;
                String taskName = (String)this.getModel().getValue("tasknameab", rowIndex);
                JSONObject taskJSON = this.buildTaskJSONObject(dataIndex, taskid, taskName);
                tasks.add((Object)taskJSON);
            }
        }
    }

    private JSONObject buildTaskJSONObject(Long dataIndex, String taskid, String taskName) {
        Long id;
        Map dailyPlanStatus;
        JSONObject taskJson = new JSONObject(true);
        taskJson.put("text", (Object)taskName);
        taskJson.put("taskId", (Object)taskid);
        String taskType = DailyPlanHelper.getTaskType((String)taskid, (Long)dataIndex);
        if (taskType != null) {
            taskJson.put("type", (Object)taskType);
        }
        if ((dailyPlanStatus = DailyPlanStatusUtils.getDailyPlanStatus((Set)Sets.newHashSet((Object[])new Object[]{id = Long.valueOf(taskid)}))) != null && !dailyPlanStatus.isEmpty()) {
            DailyPlanStatusEntity dailyPlanStatusEntity = (DailyPlanStatusEntity)dailyPlanStatus.get(id);
            String showStatus = dailyPlanStatusEntity.getShowstatus();
            DailyPlanCustomControlHelper controlHelper = new DailyPlanCustomControlHelper();
            String color = controlHelper.getColorByShowStatus(showStatus);
            taskJson.put("backgroundColor", (Object)color);
        }
        taskJson.put("taskTime", (Object)dataIndex);
        JSONArray persons = new JSONArray();
        this.buildUserData(persons);
        taskJson.put("persons", (Object)persons);
        return taskJson;
    }

    private JSONObject buildMROTaskJSONObject(Long dataIndex, String taskid, String taskName) {
        JSONObject taskJson = new JSONObject(true);
        taskJson.put("text", (Object)taskName);
        taskJson.put("taskId", (Object)taskid);
        Long id = Long.valueOf(taskid);
        Map dailyPlanStatus = DailyPlanStatusUtils.getDailyPlanStatus((Set)Sets.newHashSet((Object[])new Object[]{id}));
        if (dailyPlanStatus != null && !dailyPlanStatus.isEmpty()) {
            DailyPlanStatusEntity dailyPlanStatusEntity = (DailyPlanStatusEntity)dailyPlanStatus.get(id);
            String showStatus = dailyPlanStatusEntity.getShowstatus();
            DailyPlanCustomControlHelper controlHelper = new DailyPlanCustomControlHelper();
            String color = controlHelper.getColorByShowStatus(showStatus);
            taskJson.put("backgroundColor", (Object)color);
        }
        taskJson.put("taskTime", (Object)dataIndex);
        JSONArray persons = new JSONArray();
        this.buildUserData(persons);
        taskJson.put("persons", (Object)persons);
        return taskJson;
    }

    private void buildUserData(JSONArray persons) {
        EntryGrid engrGrid = (EntryGrid)this.getView().getControl("engineersentity");
        DynamicObjectCollection engrEntity = this.getModel().getEntryEntity("engineersentity");
        HashSet<String> personSet = new HashSet<String>(8);
        for (int i : engrGrid.getSelectRows()) {
            DynamicObject engrRow = (DynamicObject)engrEntity.get(i);
            JSONObject person = new JSONObject();
            person.put("personId", (Object)engrRow.get("engrid").toString());
            person.put("name", engrRow.get("engrname"));
            person.put("personType", (Object)"AAA");
            personSet.add(person.toJSONString());
        }
        EntryGrid teamGrid = (EntryGrid)this.getView().getControl("teamsentity");
        DynamicObjectCollection teamEntity = this.getModel().getEntryEntity("teamsentity");
        for (int i : teamGrid.getSelectRows()) {
            DynamicObject teamRow = (DynamicObject)teamEntity.get(i);
            JSONObject person = new JSONObject();
            person.put("personId", (Object)teamRow.get("memberid").toString());
            person.put("name", teamRow.get("membername"));
            person.put("personType", (Object)"AAA");
            personSet.add(person.toJSONString());
        }
        Object object = personSet.iterator();
        while (object.hasNext()) {
            String person = (String)object.next();
            persons.add((Object)JSONObject.parseObject((String)person));
        }
    }

    private void addUserData(JSONArray persons) {
        HashSet<String> personIDs = new HashSet<String>(8);
        for (int i = 0; i < persons.size(); ++i) {
            JSONObject personData = persons.getJSONObject(i);
            String personid = personData.getString("personId");
            personIDs.add(personid);
        }
        EntryGrid engrGrid = (EntryGrid)this.getView().getControl("engineersentity");
        DynamicObjectCollection engrEntity = this.getModel().getEntryEntity("engineersentity");
        HashSet<String> personSet = new HashSet<String>(8);
        for (int i : engrGrid.getSelectRows()) {
            DynamicObject engrRow = (DynamicObject)engrEntity.get(i);
            JSONObject person = new JSONObject();
            person.put("personId", (Object)engrRow.get("engrid").toString());
            person.put("name", engrRow.get("engrname"));
            person.put("personType", (Object)"AAA");
            personSet.add(person.toJSONString());
        }
        EntryGrid teamGrid = (EntryGrid)this.getView().getControl("teamsentity");
        DynamicObjectCollection teamEntity = this.getModel().getEntryEntity("teamsentity");
        for (int i : teamGrid.getSelectRows()) {
            DynamicObject teamRow = (DynamicObject)teamEntity.get(i);
            JSONObject person = new JSONObject();
            person.put("personId", (Object)teamRow.get("memberid").toString());
            person.put("name", teamRow.get("membername"));
            person.put("personType", (Object)"AAA");
            personSet.add(person.toJSONString());
        }
        Object object = personSet.iterator();
        while (object.hasNext()) {
            String person = (String)object.next();
            JSONObject personJson = JSONObject.parseObject((String)person);
            String userPK = personJson.getString("personId");
            if (personIDs.contains(userPK)) continue;
            persons.add((Object)JSONObject.parseObject((String)person));
        }
    }

    private void clickProject(String eventArgs, JSONArray tasks) {
        JSONObject param = JSONObject.parseObject((String)eventArgs);
        String taskid = param.getString("taskId");
        Long taskTime = param.getLong("taskTime");
        for (int k = 0; k < tasks.size(); ++k) {
            JSONObject taskJSON = tasks.getJSONObject(k);
            Long dataTaskTime = taskJSON.getLong("taskTime");
            String dataTaskID = taskJSON.getString("taskId");
            if (taskTime.compareTo(dataTaskTime) != 0 || !taskid.equals(dataTaskID)) continue;
            if (this.checkRowTime(dataTaskTime)) {
                return;
            }
            JSONArray personArray = taskJSON.getJSONArray("persons");
            this.addUserData(personArray);
        }
    }

    private void deleteTask(String eventArgs, JSONArray tasks) {
        JSONObject param = JSONObject.parseObject((String)eventArgs);
        String taskid = param.getString("taskId");
        Long taskTime = param.getLong("taskTime");
        DailyPlanDataHelper saveHelper = new DailyPlanDataHelper();
        DailyPlanHelper helper = new DailyPlanHelper();
        for (int i = 0; i < tasks.size(); ++i) {
            JSONObject taskData = tasks.getJSONObject(i);
            String dataTaskID = taskData.getString("taskId");
            Long dataTaskTime = taskData.getLong("taskTime");
            if (!taskid.equals(dataTaskID) || taskTime.compareTo(dataTaskTime) != 0) continue;
            if (this.checkRowTime(dataTaskTime)) {
                return;
            }
            boolean validateTransmitStatus = helper.validateTransmitStatus(Long.valueOf(Long.parseLong(dataTaskID)));
            if (validateTransmitStatus) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5df2\u5f00\u5de5\u3001\u5df2\u4e0b\u8fbe\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DailyPlanEdit_10", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean refleshFlag = saveHelper.deleteDailyPlanData(taskid, taskTime.toString(), true);
            if (refleshFlag) {
                this.removeTaskBillRow(dataTaskID);
            }
            tasks.remove((Object)taskData);
        }
    }

    private void removeTaskBillRow(String dataTaskID) {
        DynamicObjectCollection taskEntryEntity = this.getModel().getEntryEntity("taskentryentity");
        int seq = -1;
        for (DynamicObject taskEntry : taskEntryEntity) {
            String id = String.valueOf(taskEntry.getLong("dailyplanid"));
            if (!StringUtils.equals((CharSequence)dataTaskID, (CharSequence)id)) continue;
            seq = taskEntry.getInt("seq");
        }
        if (seq >= 1) {
            this.getModel().deleteEntryRow("taskentryentity", seq - 1);
            this.getView().updateView("taskentryentity");
        }
        DynamicObjectCollection abenEntryEntity = this.getModel().getEntryEntity("abentryentity");
        int seqAb = -1;
        for (DynamicObject abenEntry : abenEntryEntity) {
            String id = String.valueOf(abenEntry.getLong("dailyplanidab"));
            if (!StringUtils.equals((CharSequence)dataTaskID, (CharSequence)id)) continue;
            seqAb = abenEntry.getInt("seq");
        }
        if (seqAb >= 1) {
            this.getModel().deleteEntryRow("abentryentity", seqAb - 1);
            this.getView().updateView("abentryentity");
        }
    }

    private void changeResImg(long org, List<Long> projectIds, List<String> billNos) {
        Map resDetailSum;
        logger.info(String.format("projectIds:\n%1$s\nbillNos:\n%2$s\n", projectIds.toString(), billNos.toString()));
        try {
            resDetailSum = (Map)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pom", (String)"ResReadyDetaiService", (String)"queryResReadyDetailMroOrderNum", (Object[])new Object[]{org, projectIds, billNos, "0"});
        }
        catch (KDBizException e) {
            this.getView().showTipNotification(e.getMessage());
            return;
        }
        List resDetailResult = (List)resDetailSum.get("suminfo");
        logger.info(String.format("resDetailResult:\n%s\n", resDetailResult.toString()));
        try {
            resDetailSum = (Map)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pom", (String)"ResReadyDetaiService", (String)"queryResReadyDetailMroOrderNum", (Object[])new Object[]{org, projectIds, new ArrayList(), "0"});
        }
        catch (KDBizException e) {
            this.getView().showTipNotification(e.getMessage());
            return;
        }
        List equipments = (List)resDetailSum.get("equipmentsum");
        logger.info(String.format("equipments:\n%s\n", equipments.toString()));
        String equipment = "D";
        for (Object equipmentInfo : equipments) {
            if (!projectIds.contains((Long)equipmentInfo.get("projectnumber"))) continue;
            equipment = (String)equipmentInfo.get("equipmentstatussum");
            break;
        }
        if (resDetailResult.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d44\u6e90\u5c31\u7eea\u670d\u52a1\u8c03\u7528\u5931\u8d25", (String)"DailyPlanEdit_61", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap resource = new HashMap(6);
        for (Map result : resDetailResult) {
            String key = (String)result.get("checkebill") + result.get("projectnumber");
            HashMap<String, String> value = new HashMap<String, String>();
            value.put("material", (String)result.get("materialstatussum"));
            value.put("equipment", equipment);
            value.put("tool", (String)result.get("toolstatussum"));
            value.put("file", (String)result.get("filestatussum"));
            value.put("techsupport", (String)result.get("technicalstatussum"));
            value.put("workcard", (String)result.get("workcardstatussum"));
            resource.put(key, value);
        }
        EntryGrid taskEntry = (EntryGrid)this.getView().getControl("taskentryentity");
        DynamicObjectCollection entity = this.getModel().getEntryEntity("taskentryentity");
        for (int selectRow : taskEntry.getSelectRows()) {
            String key;
            Map status;
            DynamicObject row = (DynamicObject)entity.get(selectRow);
            String order = row.getString("orderno");
            DynamicObject project = row.getDynamicObject("project");
            if (Objects.isNull(order) || Objects.isNull(project) || (status = (Map)resource.get(key = order + project.getPkValue())) == null) continue;
            for (Map.Entry detail : status.entrySet()) {
                if (Objects.isNull(detail.getValue())) continue;
                String baseUrl = System.getProperty("domain.contextUrl");
                StringBuilder imgUrl = new StringBuilder(baseUrl);
                if (baseUrl.charAt(baseUrl.length() - 1) != '/') {
                    imgUrl.append("/");
                }
                switch ((String)detail.getValue()) {
                    case "A": {
                        imgUrl.append("icons/pc/state/hr_mistake_22_22.png");
                        break;
                    }
                    case "B": {
                        imgUrl.append("icons/pc/state/hr_tip_22_22.png");
                        break;
                    }
                    case "C": {
                        imgUrl.append("icons/pc/state/success_20_20.png");
                        break;
                    }
                    case "D": {
                        imgUrl.append("icons/pc/state/hr_ refresh_22_22.png");
                    }
                }
                row.set((String)detail.getKey(), (Object)imgUrl.toString());
            }
        }
        this.getView().updateView("taskentryentity");
    }

    private void projectDrop(String startTaskId, Long startTimeSolt, Long endTimeSolt, JSONArray startTasks, JSONArray tableData) {
        String strSwitchStatus = this.getPageCache().get(switchStatus);
        DailyPlanDataHelper saveHelper = new DailyPlanDataHelper();
        DailyPlanHelper helper = new DailyPlanHelper();
        boolean isCopy = Boolean.parseBoolean(strSwitchStatus);
        JSONObject needMoveData = new JSONObject();
        for (int i = 0; i < startTasks.size(); ++i) {
            JSONObject task = startTasks.getJSONObject(i);
            String taskID = task.getString("taskId");
            if (!startTaskId.equals(taskID)) continue;
            needMoveData = task.clone();
            if (isCopy) continue;
            boolean validateTransmitStatus = helper.validateTransmitStatus(Long.valueOf(Long.parseLong(taskID)));
            if (validateTransmitStatus) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5df2\u5f00\u5de5\u3001\u5df2\u4e0b\u8fbe\uff0c\u4e0d\u5141\u8bb8\u79fb\u52a8\u3002", (String)"DailyPlanEdit_11", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
                return;
            }
            String taskId = task.getString("taskId");
            String taskTime = task.getString("taskTime");
            saveHelper.deleteDailyPlanData(taskId, taskTime, false);
            startTasks.remove(i);
        }
        String moveTaskID = needMoveData.getString("taskId");
        if (moveTaskID == null) {
            return;
        }
        String taskType = DailyPlanHelper.getTaskType((String)moveTaskID, (Long)endTimeSolt);
        needMoveData.put("type", (Object)taskType);
        for (int i = 0; i < tableData.size(); ++i) {
            JSONObject row = tableData.getJSONObject(i);
            for (int j = 1; j <= this.maxDays; ++j) {
                String col = String.format("row_%1$s", j);
                JSONObject colData = row.getJSONObject(col);
                Long rowTime = colData.getLong(rowTime);
                JSONArray endTasks = colData.getJSONArray(tasks);
                if (rowTime.compareTo(endTimeSolt) != 0) continue;
                boolean isExists = false;
                for (int index = 0; index < endTasks.size(); ++index) {
                    JSONObject endTask = endTasks.getJSONObject(index);
                    String endTaskID = endTask.getString("taskId");
                    if (!startTaskId.equals(endTaskID)) continue;
                    isExists = true;
                    break;
                }
                if (isExists) continue;
                needMoveData.put("taskTime", (Object)endTimeSolt);
                endTasks.add((Object)needMoveData);
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldKey = hyperLinkClickEvent.getFieldName();
        List<String> keys = Arrays.asList("material", "equipment", "tool", "file", "techsupport", "workcard");
        if (keys.contains(fieldKey)) {
            long projectId = this.getModel().getValue("project", hyperLinkClickEvent.getRowIndex()) == null ? 0L : ((DynamicObject)this.getModel().getValue("project", hyperLinkClickEvent.getRowIndex())).getLong("id");
            String billNo = (String)this.getModel().getValue("orderno", hyperLinkClickEvent.getRowIndex());
            String type = "";
            switch (fieldKey) {
                case "material": {
                    type = "0";
                    break;
                }
                case "equipment": {
                    type = "1";
                    break;
                }
                case "tool": {
                    type = "2";
                    break;
                }
                case "file": {
                    type = "3";
                    break;
                }
                case "techsupport": {
                    type = "4";
                    break;
                }
                case "workcard": {
                    type = "5";
                }
            }
            ReportShowParameter report = new ReportShowParameter();
            report.setFormId("pom_resready");
            report.getOpenStyle().setShowType(ShowType.Modal);
            ReportQueryParam queryParam = new ReportQueryParam();
            FilterInfo filter = queryParam.getFilter();
            filter.addFilterItem("projectfilter", (Object)projectId);
            if (!type.equals("1")) {
                filter.addFilterItem("mroorderfilters", (Object)billNo);
            }
            filter.addFilterItem("restypefilter", (Object)type);
            if (!type.equals("1")) {
                filter.addFilterItem("dimenradiogroup", (Object)"0");
            } else {
                filter.addFilterItem("dimenradiogroup", (Object)"1");
            }
            report.setQueryParam(queryParam);
            this.getView().showForm((FormShowParameter)report);
        }
    }

    private void showTaskDetail(String eventArgs) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("sfc_dailyplandetail");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("param", (Object)eventArgs);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showDetail"));
        this.getView().showForm(fsp);
    }

    private void showHistoryTaskDetail(String eventArgs) {
        JSONObject jsonObject = JSONObject.parseObject((String)eventArgs);
        jsonObject.put("history", (Object)true);
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("sfc_dailyplandetail");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("param", (Object)jsonObject.toJSONString());
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showDetail"));
        this.getView().showForm(fsp);
    }

    private void updateTaskDetail(JSONObject detailData) {
        Long detailTaskTime = detailData.getLong("taskTime");
        String detailTaskID = detailData.getString("taskId");
        JSONObject cacheData = this.getCalendarCacheData();
        JSONArray tableData = cacheData.getJSONArray("tableData");
        for (int i = 0; i < tableData.size(); ++i) {
            JSONObject row = tableData.getJSONObject(i);
            for (int j = 1; j <= this.maxDays; ++j) {
                String col = String.format("row_%1$s", j);
                JSONObject colData = row.getJSONObject(col);
                Long rowTime = colData.getLong(rowTime);
                if (rowTime.compareTo(detailTaskTime) != 0) continue;
                JSONArray tasks = colData.getJSONArray(tasks);
                for (int k = 0; k < tasks.size(); ++k) {
                    JSONObject task = (JSONObject)tasks.get(k);
                    String taskID = task.getString("taskId");
                    if (!taskID.equals(detailTaskID)) continue;
                    task.put("persons", (Object)detailData.getJSONArray("persons"));
                }
            }
        }
        this.bindCustomControl(cacheData);
    }

    private void updateTaskFromMRO(JSONObject task) {
        Long detailTaskTime = task.getLong("taskTime");
        JSONObject cacheData = this.getCalendarCacheData();
        JSONArray tableData = cacheData.getJSONArray("tableData");
        for (int i = 0; i < tableData.size(); ++i) {
            JSONObject row = tableData.getJSONObject(i);
            for (int j = 1; j <= this.maxDays; ++j) {
                String col = String.format("row_%1$s", j);
                JSONObject colData = row.getJSONObject(col);
                Long rowTime = colData.getLong(rowTime);
                if (rowTime.compareTo(detailTaskTime) != 0) continue;
                JSONArray tasks = colData.getJSONArray(tasks);
                if (tasks.isEmpty()) {
                    tasks.add((Object)task);
                    continue;
                }
                if (tasks.contains((Object)task)) continue;
                tasks.add((Object)task);
            }
        }
        this.bindCustomControl(cacheData);
    }

    /*
     * WARNING - void declaration
     */
    private void initPersons() {
        void var21_27;
        DailyPlanHelper dHelper;
        DailyPlanFilterBean dBean;
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        if (dataModel.getEntryRowCount("engineersentity") != 0) {
            dataModel.deleteEntryData("engineersentity");
        }
        if (dataModel.getEntryRowCount("teamsentity") != 0) {
            dataModel.deleteEntryData("teamsentity");
        }
        if (Objects.isNull((dBean = (dHelper = new DailyPlanHelper()).buildFilterBean()).getMulProjects()) || dBean.getMulProjects().isEmpty() || Objects.isNull(dBean.getProfession())) {
            return;
        }
        ArrayList persons = new ArrayList(10);
        long professId = dBean.getProfession().getLong("id");
        List projectIds = MulBaseDataUtils.getPkValuesByMulData((DynamicObjectCollection)dBean.getMulProjects());
        for (Long projectId : projectIds) {
            Map<String, Object> result = this.getPresortData(projectId, professId);
            if (result == null || Objects.isNull(result.get("data"))) continue;
            persons.addAll(JSON.parseArray((String)JSON.toJSONString(result.get("data")), JSONObject.class));
        }
        if (persons.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u4eba\u5458\u9884\u6392\u6570\u636e", (String)"DailyPlanEdit_35", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> engineers = new HashSet<Long>(16);
        HashMap<Long, Map> teamGroups = new HashMap<Long, Map>(16);
        for (JSONObject person : persons) {
            if (person.containsKey((Object)"classGroup")) {
                Long classGroup = person.getLong("classGroup");
                HashMap<Long, Boolean> members = new HashMap<Long, Boolean>(16);
                members.put(person.getLong("user"), person.getBoolean("isLeader"));
                teamGroups.merge(classGroup, members, (oldMap, newMap) -> {
                    oldMap.putAll(newMap);
                    return oldMap;
                });
                continue;
            }
            engineers.add(person.getLong("user"));
        }
        QFilter qFilter = new QFilter("name", "!=", (Object)ResManager.loadKDString((String)"\u5de5\u7a0b\u5e08", (String)"DailyPlanEdit_24", (String)"mmc-sfc-formplugin", (Object[])new Object[0])).and(new QFilter("name", "!=", (Object)ResManager.loadKDString((String)"\u73ed\u7ec4", (String)"DailyPlanEdit_25", (String)"mmc-sfc-formplugin", (Object[])new Object[0])));
        DeleteServiceHelper.delete((String)"sfc_dailypersongroup", (QFilter[])new QFilter[]{qFilter});
        DeleteServiceHelper.delete((String)"sfc_dailyplanpersons", (QFilter[])new QFilter[0]);
        DynamicObject classGroup = BusinessDataServiceHelper.loadSingleFromCache((String)"sfc_dailypersongroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)ResManager.loadKDString((String)"\u73ed\u7ec4", (String)"DailyPlanEdit_25", (String)"mmc-sfc-formplugin", (Object[])new Object[0]))});
        Map teams = BusinessDataServiceHelper.loadFromCache((String)"mpdm_classgroup", (String)"id, number, name", (QFilter[])new QFilter[]{new QFilter("id", "in", teamGroups.keySet())});
        ArrayList<DynamicObject> addTeams = new ArrayList<DynamicObject>(10);
        for (Map.Entry entry : teams.entrySet()) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"sfc_dailypersongroup");
            dynamicObject.set("number", ((DynamicObject)entry.getValue()).get("number"));
            dynamicObject.set("name", ((DynamicObject)entry.getValue()).get("name"));
            dynamicObject.set("status", (Object)"C");
            dynamicObject.set("enable", (Object)"1");
            dynamicObject.set("parent", (Object)classGroup);
            dynamicObject.set("team", entry.getValue());
            addTeams.add(dynamicObject);
        }
        SaveServiceHelper.save((DynamicObject[])addTeams.toArray(new DynamicObject[0]));
        ArrayList<Long> users = new ArrayList<Long>(10);
        users.addAll(engineers);
        for (Map.Entry entry : teamGroups.entrySet()) {
            users.addAll(((Map)entry.getValue()).keySet());
        }
        Map map = BusinessDataServiceHelper.loadFromCache((String)"mpdm_manuperson", (String)"id, number, name", (QFilter[])new QFilter[]{new QFilter("id", "in", users)});
        DynamicObject[] dynamicObjectArray = BusinessDataServiceHelper.load((String)"sfc_dailypersongroup", (String)"team.id, team.number", (QFilter[])new QFilter[]{new QFilter("team.id", "in", teamGroups.keySet())});
        DynamicObject engr = BusinessDataServiceHelper.loadSingleFromCache((String)"sfc_dailypersongroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)ResManager.loadKDString((String)"\u5de5\u7a0b\u5e08", (String)"DailyPlanEdit_24", (String)"mmc-sfc-formplugin", (Object[])new Object[0]))});
        HashMap<Long, DynamicObject> groups = new HashMap<Long, DynamicObject>(16);
        DynamicObject[] dynamicObjectArray2 = dynamicObjectArray;
        int n = dynamicObjectArray2.length;
        boolean bl = false;
        while (var21_27 < n) {
            DynamicObject loadTeam = dynamicObjectArray2[var21_27];
            groups.put(loadTeam.getLong("team.id"), loadTeam);
            ++var21_27;
        }
        ArrayList<DynamicObject> addPerson = new ArrayList<DynamicObject>(10);
        for (Long l : engineers) {
            DynamicObject user = (DynamicObject)map.get(l);
            if (Objects.isNull(user)) continue;
            DynamicObject person = BusinessDataServiceHelper.newDynamicObject((String)"sfc_dailyplanpersons");
            person.set("number", (Object)String.format("engineer-%s", user.getString("number")));
            person.set("name", (Object)user.getString("name"));
            person.set("status", (Object)"C");
            person.set("enable", (Object)"1");
            person.set("person", (Object)user);
            person.set("group", (Object)engr);
            person.set("persontype", (Object)"engineer");
            addPerson.add(person);
        }
        for (Map.Entry entry : teamGroups.entrySet()) {
            DynamicObject group = (DynamicObject)groups.get(entry.getKey());
            if (Objects.isNull(group)) continue;
            for (Map.Entry personEntry : ((Map)entry.getValue()).entrySet()) {
                DynamicObject person = BusinessDataServiceHelper.newDynamicObject((String)"sfc_dailyplanpersons");
                DynamicObject user = (DynamicObject)map.get(personEntry.getKey());
                person.set("number", (Object)String.format("%1$s-%2$s", group.getString("team.number"), user.getString("number")));
                person.set("name", (Object)user.getString("name"));
                person.set("status", (Object)"C");
                person.set("enable", (Object)"1");
                person.set("person", (Object)user);
                person.set("group", (Object)group);
                person.set("isteamleader", (Object)((Boolean)personEntry.getValue() != false ? "1" : "0"));
                person.set("persontype", (Object)"team");
                addPerson.add(person);
            }
        }
        SaveServiceHelper.save((DynamicObject[])addPerson.toArray(new DynamicObject[0]));
        this.getPresorted();
    }

    private void getPresorted() {
        DynamicObjectCollection persons = QueryServiceHelper.query((String)"sfc_dailyplanpersons", (String)"group, person,person.name, person.user.number", (QFilter[])new QFilter[0]);
        HashMap<Long, List> personMap = new HashMap<Long, List>(16);
        for (DynamicObject person : persons) {
            final HashMap<String, String> personDetail = new HashMap<String, String>(2);
            personDetail.put("id", person.get("person").toString());
            personDetail.put("name", person.getString("person.name"));
            personDetail.put("number", person.getString("person.user.number"));
            personMap.merge(person.getLong("group"), new ArrayList<Map<String, String>>(){
                {
                    this.add(personDetail);
                }
            }, (oldData, newData) -> {
                oldData.addAll(newData);
                return oldData;
            });
        }
        DynamicObjectCollection teams = QueryServiceHelper.query((String)"sfc_dailypersongroup", (String)"id, team.name", (QFilter[])new QFilter[]{new QFilter("id", "in", personMap.keySet())});
        HashMap<Long, String> groupMap = new HashMap<Long, String>(16);
        for (Object team : teams) {
            groupMap.put(team.getLong("id"), team.getString("team.name"));
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        for (Map.Entry entry : groupMap.entrySet()) {
            if (!Objects.nonNull(entry.getValue())) continue;
            LocaleString localeString = new LocaleString();
            localeString.setLocaleValue_zh_CN((String)entry.getValue());
            comboItems.add(new ComboItem(localeString, Long.toString((Long)entry.getKey())));
        }
        if (!comboItems.isEmpty()) {
            ComboEdit combo = (ComboEdit)this.getControl("teamno");
            combo.setComboItems(comboItems);
            this.getModel().setValue("teamno", (Object)((ComboItem)comboItems.get(0)).getValue());
        }
        TableValueSetter engSetter = new TableValueSetter(new String[]{"engrname", "engrno", "engrid"});
        for (Map.Entry entry : personMap.entrySet()) {
            String groupName = (String)groupMap.get(entry.getKey());
            if (Objects.nonNull(groupName)) {
                this.getPageCache().put(String.valueOf(entry.getKey()), JSON.toJSONString(entry.getValue()));
                continue;
            }
            for (Map person : (List)entry.getValue()) {
                engSetter.addRow(new Object[]{person.get("name"), person.get("number"), person.get("id")});
            }
        }
        AbstractFormDataModel abstractFormDataModel = (AbstractFormDataModel)this.getModel();
        abstractFormDataModel.batchCreateNewEntryRow("engineersentity", engSetter);
        this.showPresortTeam();
    }

    private void showPresortTeam() {
        String teamDetail;
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        dataModel.beginInit();
        if (dataModel.getEntryRowCount("teamsentity") != 0) {
            dataModel.deleteEntryData("teamsentity");
        }
        if (Objects.nonNull(teamDetail = this.getPageCache().get((String)this.getModel().getValue("teamno")))) {
            TableValueSetter teamSetter = new TableValueSetter(new String[]{"membername", "memberno", "memberid"});
            List teamMembers = JSONArray.parseArray((String)teamDetail, JSONObject.class);
            for (JSONObject teamMember : teamMembers) {
                teamSetter.addRow(new Object[]{teamMember.getString("name"), teamMember.getString("number"), teamMember.getString("id")});
            }
            dataModel.batchCreateNewEntryRow("teamsentity", teamSetter);
        }
        dataModel.endInit();
        this.getView().updateView("teamsentity");
    }

    private Map<String, Object> getPresortData(long projectId, long professId) {
        QFilter manuPersonFilter = new QFilter("user", "=", (Object)13466739L);
        DynamicObject manuPerson = BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_manuperson", (String)"id", (QFilter[])manuPersonFilter.toArray());
        if (manuPerson == null) {
            return null;
        }
        String result = String.format("{\"data\":[{\"billNo\":\"sortest-02\",\"dispatchArea\":0,\"endTime\":1663233075000,\"id\":1510227407078957056,\"isLeader\":false,\"materialMtcInfo\":0,\"project\":[1485528408870904832],\"projectRole\":1507143586443956224,\"remark\":\"\",\"resourceplan\":0,\"startTime\":1663233075000,\"user\":%1$s,\"workGroup\":1510221445899232256,\"workPercent\":0,\"workRemark\":\"\",\"workType\":1494264426163872768}],\"success\":true,\"errInfo\":null}", manuPerson.getPkValue());
        return JSON.parseObject((String)result);
    }

    private void genStaffneedsBill() {
        long currentUserId = UserServiceHelper.getCurrentUserId();
        QFilter filter = new QFilter("user", "=", (Object)currentUserId);
        DynamicObject dpFilter = BusinessDataServiceHelper.loadSingleFromCache((String)"sfc_dailyplan_filter", (String)"user,id,profession,project,mulproject", (QFilter[])filter.toArray());
        DynamicObject profession = new DynamicObject();
        DynamicObjectCollection projects = null;
        if (dpFilter != null) {
            profession = dpFilter.getDynamicObject(profession);
            this.getPageCache().put("professionStaffNeed", SFCUtils.DynamicObjectToJSON((DynamicObject)profession));
            projects = dpFilter.getDynamicObjectCollection("mulproject");
        }
        if (profession == null || projects == null || projects.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u3010\u884c\u4e1a\u3011\u6216\u8005\u3010\u9879\u76ee\u3011\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8bbe\u7f6e\u67e5\u8be2\u6761\u4ef6\uff0c\u518d\u751f\u6210\u3010\u4eba\u5458\u9700\u6c42\u3011", (String)"DailyPlanEdit_31", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> projectIDs = new HashSet<Long>(16);
        if (projects != null && projects.size() > 1) {
            for (DynamicObject projectDb : projects) {
                DynamicObject projectDObj = projectDb == null ? null : (DynamicObject)projectDb.get("FBasedataId");
                if (projectDObj == null) continue;
                projectIDs.add((Long)projectDObj.getPkValue());
            }
            this.getPageCache().put("projectIDs", ((Object)projectIDs).toString());
            ConfirmCallBackListener staffneedsConfirm = new ConfirmCallBackListener("projectChoose");
            this.getView().showConfirm(ResManager.loadKDString((String)"\u67e5\u8be2\u6761\u4ef6\u8bbe\u7f6e\u4e86\u591a\u4e2a\u3010\u9879\u76ee\u3011\uff0c\u8bf7\u9009\u62e9\u5176\u4e2d\u7684\u4e00\u4e2a\u751f\u6210\u3010\u4eba\u5458\u9700\u6c42\u3011\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"DailyPlanEdit_32", (String)"mmc-sfc-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, staffneedsConfirm);
            return;
        }
        if (projects != null && projects.size() == 1) {
            DynamicObject projectDObj;
            DynamicObject project = (DynamicObject)projects.get(0);
            DynamicObject dynamicObject = projectDObj = projects.get(0) == null ? null : (DynamicObject)project.get("FBasedataId");
            if (projectDObj != null) {
                this.getPageCache().put("project", SFCUtils.DynamicObjectToJSON((DynamicObject)projectDObj));
            } else {
                this.getPageCache().put("project", null);
            }
            this.showStaffneedsEditView();
        }
    }

    private void showStaffneedsEditView() {
        String projectStr;
        DynamicObject projectDObj;
        DynamicObject professionDObj;
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("sfc_staffneeds_simple");
        billShowParameter.setCaption(ResManager.loadKDString((String)"\u4eba\u5458\u9700\u6c42", (String)"DailyPlanEdit_33", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        String professionStr = this.getPageCache().get("professionStaffNeed");
        DynamicObject dynamicObject = professionDObj = StringUtils.isEmpty((CharSequence)professionStr) ? null : SFCUtils.JSONToDynamicObject((String)professionStr, (String)"mpdm_professiona");
        if (professionDObj != null) {
            billShowParameter.setCustomParam(profession, (Object)professionDObj);
        }
        DynamicObject dynamicObject2 = projectDObj = StringUtils.isEmpty((CharSequence)(projectStr = this.getPageCache().get("project"))) ? null : SFCUtils.JSONToDynamicObject((String)projectStr, (String)"pmpd_project");
        if (projectDObj != null) {
            billShowParameter.setCustomParam("project", (Object)projectDObj);
        }
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private void projectChoose() {
        String projectIDStr = this.getPageCache().get("projectIDs");
        if (projectIDStr != null && projectIDStr.length() > 2) {
            String projectIDSub = projectIDStr.substring(1, projectIDStr.length() - 1);
            String[] projectIDStrs = projectIDSub.split(",");
            HashSet<Long> projectIDs = new HashSet<Long>(16);
            for (String projectID : projectIDStrs) {
                Long projectIDL = Long.valueOf(projectID.trim());
                projectIDs.add(projectIDL);
            }
            QFilter projectfilter = new QFilter("id", "in", projectIDs);
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setFormId("pmpd_project_f7");
            listShowParameter.setBillFormId("pmpd_project");
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u9879\u76ee\u5217\u8868", (String)"DailyPlanEdit_34", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
            listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss inlineStyleCss = new StyleCss();
            inlineStyleCss.setHeight("580");
            inlineStyleCss.setWidth("960");
            listShowParameter.getOpenStyle().setInlineStyleCss(inlineStyleCss);
            listShowParameter.setLookUp(true);
            listShowParameter.setMultiSelect(false);
            listShowParameter.getListFilterParameter().getQFilters().add(projectfilter);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "project_selected"));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    private void showPersons(String eventArgs) {
        JSONObject event = JSON.parseObject((String)eventArgs);
        StringJoiner joiner = new StringJoiner("_", "message_", "");
        joiner.add(event.getString("taskId")).add(event.getString("taskTime"));
        String callBackId = joiner.toString();
        ListShowParameter personList = ShowFormHelper.createShowListForm((String)"mpdm_manuperson", (boolean)true);
        personList.getOpenStyle().setShowType(ShowType.Modal);
        personList.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBackId));
        this.getView().showForm((FormShowParameter)personList);
    }

    private void setMilestone(JSONObject data) {
        JSONArray columns = data.getJSONArray("columns");
        for (Object column : columns) {
            ((JSONObject)column).remove((Object)"milepost");
        }
        HashSet<Long> projectIds = new HashSet<Long>(16);
        Long mainPlanType = 1437660575319473152L;
        DailyPlanHelper dHelper = new DailyPlanHelper();
        DailyPlanFilterBean dBean = dHelper.buildFilterBean();
        if (Objects.isNull(dBean.getMulProjects()) || dBean.getMulProjects().isEmpty() || Objects.isNull(dBean.getProfession())) {
            return;
        }
        DynamicObjectCollection multiplyProject = dBean.getMulProjects();
        for (DynamicObject project : multiplyProject) {
            projectIds.add((Long)project.get("fbasedataid_id"));
        }
        QFilter qFilter = new QFilter("projectnum.id", "in", projectIds).and(new QFilter("scheduletype", "=", (Object)"3")).and(new QFilter("plantype.id", "=", (Object)mainPlanType));
        DynamicObjectCollection result = QueryServiceHelper.query((String)"pmts_task", (String)"name, projectnum.name, planstartdate", (QFilter[])new QFilter[]{qFilter});
        if (result.size() != 0) {
            HashMap<String, List> milestones = new HashMap<String, List>(16);
            Calendar calendar = Calendar.getInstance();
            for (DynamicObject mile : result) {
                final HashMap<String, String> milestone = new HashMap<String, String>(2);
                Date startDate = mile.getDate("planstartdate");
                if (Objects.isNull(startDate)) continue;
                calendar.setTime(startDate);
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                String planDate = String.valueOf(calendar.getTime().getTime());
                String projectName = mile.getString("projectnum.name");
                String milepostName = mile.getString("name");
                if (Objects.nonNull(projectName)) {
                    milestone.put("projectName", projectName);
                }
                if (Objects.nonNull(milepostName)) {
                    milestone.put("milepostName", milepostName);
                }
                if (milestone.size() <= 0) continue;
                milestones.merge(planDate, new ArrayList<Map<String, String>>(){
                    {
                        this.add(milestone);
                    }
                }, (oldList, newList) -> {
                    if (oldList.size() < 3) {
                        oldList.addAll(newList);
                    }
                    return oldList;
                });
            }
            for (Map.Entry milestoneEntry : milestones.entrySet()) {
                for (int i = 0; i < columns.size(); ++i) {
                    JSONObject column = columns.getJSONObject(i);
                    if (!column.getString("dataIndex").equals(milestoneEntry.getKey())) continue;
                    column.put("milepost", (Object)JSON.parseArray((String)JSON.toJSONString(milestoneEntry.getValue())));
                }
            }
        }
        this.bindCustomControl(data);
    }

    private void setImportant(String eventArgs, String isImportant) {
        JSONObject event = JSON.parseObject((String)eventArgs);
        String taskID = event.getString("taskId");
        String sql = String.format("update t_sfc_dailyplan_new set fisimportant='%1$s' where fid=%2$s", isImportant, taskID);
        DB.execute((DBRoute)DBRoute.of((String)"SCM"), (String)sql);
        this.saveDailyPlan();
        this.getView().invokeOperation("refresh");
    }

    private void getTaskChangedNotify() {
        DailyPlanHelper dHelper = new DailyPlanHelper();
        DailyPlanFilterBean dBean = dHelper.buildFilterBean();
        if (Objects.isNull(dBean.getMulProjects()) || dBean.getMulProjects().isEmpty() || Objects.isNull(dBean.getProfession())) {
            return;
        }
        long professionId = dBean.getProfession().getLong("id");
        DynamicObjectCollection multiplyProject = dBean.getMulProjects();
        long[] projectIds = new long[multiplyProject.size()];
        for (int i = 0; i < multiplyProject.size(); ++i) {
            projectIds[i] = (Long)((DynamicObject)multiplyProject.get(i)).get("fbasedataid_id");
        }
        QFilter qFilter = new QFilter("project.id", "in", (Object)projectIds).and(new QFilter(profession, "=", (Object)0).or(new QFilter(profession, "=", (Object)professionId)));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"sfc_daily_notification", (String)"tasktype.number, project.id, profession.id, time, message", (QFilter[])qFilter.toArray());
        List notifications = query.stream().sorted(Comparator.comparingLong(n -> n.getDate("time").getTime()).reversed()).collect(Collectors.toList());
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        dataModel.deleteEntryData("cardentryentity");
        TableValueSetter setter = new TableValueSetter(new String[]{"planprojectid", "planprofessionid", "plantype", "message"});
        for (DynamicObject notification : notifications) {
            setter.addRow(new Object[]{notification.getLong("project.id"), notification.getLong("profession.id"), notification.getString("tasktype.number"), notification.getString("message")});
        }
        dataModel.batchCreateNewEntryRow("cardentryentity", setter);
    }

    private void autoClickResReady() {
        HashSet<String> billNos = new HashSet<String>();
        HashSet<Long> projectIds = new HashSet<Long>();
        DynamicObjectCollection entity = this.getModel().getEntryEntity("taskentryentity");
        int[] rows = new int[entity.size()];
        int i = 0;
        for (DynamicObject row : entity) {
            rows[i] = i;
            ++i;
            String order = row.getString("orderno");
            DynamicObject project = row.getDynamicObject("project");
            if (Objects.isNull(order) || Objects.isNull(project)) continue;
            billNos.add(order);
            projectIds.add((Long)project.getPkValue());
        }
        EntryGrid taskEntry = (EntryGrid)this.getView().getControl("taskentryentity");
        taskEntry.selectRows(rows, 0);
        long userDefaultOrgID = RequestContext.get().getOrgId();
        this.changeResImg(userDefaultOrgID, new ArrayList<Long>(projectIds), new ArrayList<String>(billNos));
        taskEntry.clearEntryState();
    }
}

