/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.formplugin.dailyplan;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import org.apache.commons.lang3.StringUtils;

public class DailyPlanPopPlugIn
extends AbstractFormPlugin {
    private static final String KEY_OK = "btnok";
    private static final String KEY_CANCEL = "btncancel";
    private static final String KEY_TASK_NAME = "taskname";
    private static final String KEY_TASK_NUMBER = "tasknumber";
    private static final String KEY_PROFESSION = "profession";
    private static final String KEY_PLANSTARTTIME = "planstarttime";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_OK, KEY_CANCEL});
        BasedataEdit projectEdit = (BasedataEdit)this.getControl(KEY_PROFESSION);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)KEY_OK)) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(16);
            hashMap.put(KEY_TASK_NAME, String.valueOf(this.getModel().getValue(KEY_TASK_NAME)));
            hashMap.put(KEY_TASK_NUMBER, String.valueOf(this.getModel().getValue(KEY_TASK_NUMBER)));
            hashMap.put(KEY_PROFESSION, this.getModel().getValue(KEY_PROFESSION));
            hashMap.put(KEY_PLANSTARTTIME, this.getModel().getValue(KEY_PLANSTARTTIME));
            this.getView().returnDataToParent(hashMap);
            this.getView().close();
        } else if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)KEY_CANCEL)) {
            this.getView().returnDataToParent(null);
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object professionObj = showParameter.getCustomParam(KEY_PROFESSION);
        Long profession = 0L;
        if (professionObj instanceof Integer) {
            profession = ((Integer)professionObj).longValue();
        } else if (professionObj instanceof Long) {
            profession = (Long)professionObj;
        }
        String workName = (String)showParameter.getCustomParam("workName");
        String workNumber = (String)showParameter.getCustomParam("workNumber");
        String planStartTime = (String)showParameter.getCustomParam(KEY_PLANSTARTTIME);
        Date startTime = null;
        try {
            startTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(planStartTime);
        }
        catch (ParseException ex) {
            throw new KDBizException(new ErrorCode("DailyPlanPopPlugIn", String.format("Date format conversion exception\uff1a%1$s", planStartTime)), new Object[0]);
        }
        this.getModel().setValue(KEY_TASK_NAME, (Object)workName);
        this.getModel().setValue(KEY_TASK_NUMBER, (Object)workNumber);
        this.getModel().setItemValueByID(KEY_PROFESSION, (Object)profession);
        this.getModel().setValue(KEY_PLANSTARTTIME, (Object)startTime);
    }
}

