/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.formplugin.dailyplan;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class StaffNeedsEditPlugin
extends AbstractBillPlugIn {
    private static final Log logger = LogFactory.getLog(StaffNeedsEditPlugin.class);
    public static final String ENTRYENTITY = "entryentity";
    public static final String CATEGORY = "category";
    public static final String STAFFPOOLNUM = "staffpoolamount";
    public static final String NEWUSERENTRY = "newuserentry";
    public static final String ORG = "org";
    public static final String PROFESSIONA = "professiona";
    public static final String PROJECT = "project";
    public static final String WORKHOURS = "workhours";

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propname = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        switch (propname) {
            case "professiona": {
                this.setStaffpoolnumByProfessiona(changeSet, org);
                this.setWorkHoursByProjectAndProfessiona(changeSet, org, PROFESSIONA);
                break;
            }
            case "category": {
                this.setStaffpoolnumByCategory(changeSet, org);
                break;
            }
            case "project": {
                this.setWorkHoursByProjectAndProfessiona(changeSet, org, PROJECT);
                break;
            }
        }
    }

    private void setWorkHoursByProjectAndProfessiona(ChangeData[] changeSet, DynamicObject org, String changKey) {
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"StaffNeedsEditPlugin_0", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
            return;
        }
        ChangeData cd = changeSet[0];
        Object newValue = cd.getNewValue();
        DynamicObject changeDObj = (DynamicObject)newValue;
        if (changeDObj == null) {
            return;
        }
        if (PROFESSIONA.equals(changKey)) {
            DynamicObject project = (DynamicObject)this.getModel().getValue(PROJECT);
            if (project == null) {
                return;
            }
            this.setWorkHours(org, changeDObj, project);
        } else if (PROJECT.equals(changKey)) {
            DynamicObject professiona = (DynamicObject)this.getModel().getValue(PROFESSIONA);
            if (professiona == null) {
                return;
            }
            this.setWorkHours(org, professiona, changeDObj);
        }
    }

    private void setWorkHours(DynamicObject org, DynamicObject professiona, DynamicObject project) {
        if (professiona != null && project != null) {
            QFilter qFilter = new QFilter("oprentryentity.profession.id", "=", professiona.getPkValue());
            qFilter.and("oprentryentity.project.id", "=", project.getPkValue());
            qFilter.and(new QFilter("taskstatus", "!=", (Object)"C"));
            qFilter.and(new QFilter("createorg.id", "=", org.getPkValue()));
            String selectFields = "id,billno,org,billstatus,taskstatus,oprentryentity,oprentryentity.workhour,planentryentity,planentryentity.planstarttime,planentryentity.planendtime";
            DynamicObject[] dailyplans = BusinessDataServiceHelper.load((String)"sfc_dailyplan", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
            BigDecimal allPlanHours = BigDecimal.valueOf(0.0);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            for (DynamicObject dailyplan : dailyplans) {
                BigDecimal onePlanHours = BigDecimal.valueOf(0.0);
                String billNO = dailyplan.getString("billno");
                DynamicObjectCollection oprentryentityCols = dailyplan.getDynamicObjectCollection("oprentryentity");
                BigDecimal oneWorkhours = BigDecimal.valueOf(0.0);
                for (DynamicObject oprentryentityCol : oprentryentityCols) {
                    BigDecimal workhour = oprentryentityCol.getBigDecimal("workhour");
                    if (BigDecimal.ZERO.compareTo(workhour) == 0) continue;
                    oneWorkhours = oneWorkhours.add(workhour);
                }
                DynamicObjectCollection planentryentityCols = dailyplan.getDynamicObjectCollection("planentryentity");
                HashSet<String> dateRange = new HashSet<String>(16);
                for (DynamicObject planentryentityCol : planentryentityCols) {
                    Date planstarttime = planentryentityCol.getDate("planstarttime");
                    Date planendtime = planentryentityCol.getDate("planendtime");
                    if (planstarttime == null || planendtime == null) continue;
                    Date flag = planstarttime;
                    Calendar cal = Calendar.getInstance();
                    while (flag.compareTo(planendtime) <= 0) {
                        cal.clear();
                        cal.setTime(flag);
                        Date flagDate = cal.getTime();
                        String flagDateStr = sdf.format(flagDate);
                        if (dateRange.add(flagDateStr)) {
                            dateRange.add(flagDateStr);
                        }
                        cal.add(5, 1);
                        flag = cal.getTime();
                    }
                }
                if (oneWorkhours.compareTo(BigDecimal.ZERO) > 0 && dateRange.size() > 0) {
                    BigDecimal dayCount;
                    int days = dateRange.size();
                    if (days != 0 && (dayCount = BigDecimal.valueOf(days)).compareTo(BigDecimal.ZERO) > 0) {
                        onePlanHours = oneWorkhours.divide(dayCount, 2, 4);
                    }
                } else {
                    onePlanHours = oneWorkhours;
                }
                allPlanHours = allPlanHours.add(onePlanHours);
            }
            if (allPlanHours.compareTo(BigDecimal.ZERO) > 0) {
                this.getModel().setValue(WORKHOURS, (Object)allPlanHours);
            } else {
                this.getModel().setValue(WORKHOURS, null);
            }
        }
    }

    private void setStaffpoolnumByProfessiona(ChangeData[] changeSet, DynamicObject org) {
        ChangeData cd = changeSet[0];
        Object newValue = cd.getNewValue();
        DynamicObject professiona = (DynamicObject)newValue;
        if (professiona != null) {
            DynamicObjectCollection userEntrys = this.getModel().getEntryEntity(ENTRYENTITY);
            for (int i = 0; i < userEntrys.size(); ++i) {
                DynamicObject category = ((DynamicObject)userEntrys.get(i)).getDynamicObject(CATEGORY);
                if (category == null) continue;
                this.setStaffpoolnum(org, professiona, category, i);
            }
        }
    }

    private void setStaffpoolnumByCategory(ChangeData[] changeSet, DynamicObject org) {
        ChangeData cd = changeSet[0];
        Object newValue = cd.getNewValue();
        DynamicObject category = (DynamicObject)newValue;
        DynamicObject professiona = (DynamicObject)this.getModel().getValue(PROFESSIONA);
        EntryGrid userEntryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        DynamicObjectCollection userEntry = this.getModel().getEntryEntity(ENTRYENTITY);
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"StaffNeedsEditPlugin_0", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
            return;
        }
        int[] selectRows = userEntryGrid.getSelectRows();
        if (professiona != null && category != null) {
            for (int i = 0; i < selectRows.length; ++i) {
                int index = selectRows[i];
                category = ((DynamicObject)userEntry.get(index)).getDynamicObject(CATEGORY);
                this.setStaffpoolnum(org, professiona, category, index);
            }
        }
    }

    private void setStaffpoolnum(DynamicObject org, DynamicObject professiona, DynamicObject category, int index) {
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"StaffNeedsEditPlugin_0", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
            return;
        }
        if (professiona != null && category != null) {
            QFilter qFilter0 = new QFilter("professiona.id", "=", professiona.getPkValue());
            String proNumber = (String)professiona.get("longnumber");
            StringBuilder longnumberSb = new StringBuilder();
            if (proNumber != null && !StringUtils.isBlank((CharSequence)proNumber)) {
                longnumberSb.append(proNumber).append(".%");
            }
            QFilter qFilter1 = new QFilter("professiona.longnumber", "like", (Object)longnumberSb.toString());
            QFilter qFilterPro = qFilter0.or(qFilter1);
            QFilter qFilter = new QFilter(CATEGORY, "=", category.getPkValue());
            qFilter.and(new QFilter("status", "=", (Object)"C"));
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            qFilter.and(qFilterPro);
            Map cbreakers = BusinessDataServiceHelper.loadFromCache((String)"mpdm_manuperson", (String)"id,user,status,enable,professiona,category", (QFilter[])new QFilter[]{qFilter});
            if (cbreakers != null && cbreakers.size() > 0) {
                this.getModel().setValue(STAFFPOOLNUM, (Object)cbreakers.size(), index);
            } else {
                this.getModel().setValue(STAFFPOOLNUM, (Object)0, index);
            }
        } else {
            this.getModel().setValue(STAFFPOOLNUM, (Object)0, index);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs adoea) {
        OperationResult or = adoea.getOperationResult();
        String opKey = adoea.getOperateKey();
        if (NEWUSERENTRY.equalsIgnoreCase(opKey)) {
            if (!or.isSuccess()) {
                return;
            }
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"mpdm_category", (boolean)false);
            listShowParameter.setMultiSelect(true);
            listShowParameter.setCaption(ResManager.loadKDString((String)"\u4eba\u5458\u7c7b\u578b\u5217\u8868", (String)"StaffNeedsEditPlugin_1", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, opKey));
            listShowParameter.setFormId("bos_listf7");
            List filters = listShowParameter.getListFilterParameter().getQFilters();
            filters.add(new QFilter("status", "=", (Object)"C"));
            filters.add(new QFilter("enable", "=", (Object)"1"));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent ccb) {
        super.closedCallBack(ccb);
        String actID = ccb.getActionId();
        Object returnData = ccb.getReturnData();
        if (returnData == null) {
            return;
        }
        DynamicObject professiona = (DynamicObject)this.getModel().getValue(PROFESSIONA);
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        if (NEWUSERENTRY.equalsIgnoreCase(actID)) {
            ListSelectedRowCollection listSelected = (ListSelectedRowCollection)returnData;
            for (ListSelectedRow category : listSelected) {
                if (category == null) continue;
                int index = this.getModel().createNewEntryRow(ENTRYENTITY);
                this.getModel().setValue(CATEGORY, category.getPrimaryKeyValue(), index);
                DynamicObject categoryDo = (DynamicObject)this.getModel().getValue(CATEGORY, index);
                this.setStaffpoolnum(org, professiona, categoryDo, index);
            }
        }
    }
}

