/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.formplugin.manftech;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.sfc.common.utils.SFCUtils;

public class DailyPublicizeEntryPlugin
extends AbstractFormPlugin {
    protected String getEntryName() {
        IFormView fv = this.getView();
        FormShowParameter fsp = fv.getFormShowParameter();
        String formID = fsp.getFormId();
        String entryName = "sfc_dailypublicize_mc".equalsIgnoreCase(formID) ? "mcentry" : ("sfc_dailypublicize_moc".equalsIgnoreCase(formID) ? "mocentry" : null);
        return entryName;
    }

    protected List<Map<String, String>> getEntryData(String entryName, DynamicObjectCollection docEntry) {
        IFormView fv = this.getView();
        IPageCache pc = fv.getPageCache();
        String mmcID = pc.get("MeetingModConfigID");
        String mmcEntryID = pc.get("MeetingModConfigEntryID");
        long lMMCID = StringUtils.isEmpty((CharSequence)mmcID) ? 0L : Long.parseLong(mmcID);
        long lMMCEntryID = StringUtils.isEmpty((CharSequence)mmcEntryID) ? 0L : Long.parseLong(mmcEntryID);
        ArrayList<Map<String, String>> lEntryData = new ArrayList<Map<String, String>>();
        if (lMMCID <= 0L) {
            return lEntryData;
        }
        for (DynamicObject doEntry : docEntry) {
            Object objMMCID = doEntry.get(entryName + "mmc");
            Object objMMCEntryID = doEntry.get(entryName + "mmcentryid");
            long lTmpMMCID = objMMCID instanceof Long ? (Long)objMMCID : 0L;
            long lTmpMMCEntryID = objMMCEntryID instanceof Long ? (Long)objMMCEntryID : 0L;
            long lPK = doEntry.getLong(entryName + "id");
            if (lTmpMMCID <= 0L) {
                DynamicObject doMMC = doEntry.getDynamicObject(entryName + "mmc");
                lTmpMMCID = SFCUtils.getDynamicObjectLongPK((DynamicObject)doMMC);
            }
            if (lTmpMMCID <= 0L || lPK <= 0L || Long.compare(lTmpMMCID, lMMCID) != 0 || Long.compare(lTmpMMCEntryID, lMMCEntryID) != 0) continue;
            HashMap<String, String> mEntryRowData = new HashMap<String, String>();
            mEntryRowData.put(entryName + "id", String.valueOf(lPK));
            String content = doEntry.getString(entryName + "content");
            mEntryRowData.put(entryName + "content", content);
            if ("mocentry".equalsIgnoreCase(entryName)) {
                String otherDesc = doEntry.getString(entryName + "otherdesc");
                mEntryRowData.put(entryName + "otherdesc", otherDesc);
            }
            boolean isChecked = doEntry.getBoolean(entryName + "ischecked");
            mEntryRowData.put(entryName + "ischecked", isChecked ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
            lEntryData.add(mEntryRowData);
        }
        return lEntryData;
    }

    public void afterCreateNewData(EventObject eo) {
        super.afterCreateNewData(eo);
        RequestContext rc = RequestContext.get();
        long curUserID = rc.getCurrUserId();
        IFormView fv = this.getView();
        IPageCache pc = fv.getPageCache();
        IDataModel dm = this.getModel();
        FormShowParameter fsp = fv.getFormShowParameter();
        String formID = fsp.getFormId();
        String parentPageID = fsp.getParentPageId();
        String entryName = this.getEntryName();
        if (StringUtils.isEmpty((CharSequence)entryName)) {
            return;
        }
        IFormView fvParent = fv.getView(parentPageID);
        IDataModel dmParent = fvParent.getModel();
        Map mCustParam = fsp.getCustomParams();
        Boolean bIsCreateNew = SFCUtils.getMapBooleanValue((Map)mCustParam, (Object)"IsCreateNew");
        Boolean bIsPreview = SFCUtils.getMapBooleanValue((Map)mCustParam, (Object)"IsPreview");
        List<Map<String, String>> lEntryData = SFCUtils.getMapListValue((Map)mCustParam, (Object)"EntryData");
        long lMMCID = SFCUtils.getMapLongValue((Map)mCustParam, (Object)"MeetingModConfigID");
        long lMMCEntryID = SFCUtils.getMapLongValue((Map)mCustParam, (Object)"MeetingModConfigEntryID");
        String billStatus = SFCUtils.getMapStringValue((Map)mCustParam, (Object)"BillStatus");
        Boolean isEnableEntryContent = "B".equalsIgnoreCase(billStatus) || "C".equalsIgnoreCase(billStatus) ? Boolean.FALSE : Boolean.TRUE;
        pc.put("MeetingModConfigID", String.valueOf(lMMCID));
        pc.put("MeetingModConfigEntryID", String.valueOf(lMMCEntryID));
        DynamicObject doOriginator = SFCUtils.getDataModelDynamicObjectValue((IDataModel)dmParent, (String)"originator", (int)-1);
        long originatorID = SFCUtils.getDynamicObjectLongPK((DynamicObject)doOriginator);
        DynamicObjectCollection docPersEntry = dmParent.getEntryEntity("persentry");
        boolean isCurUserInPersEntry = false;
        for (DynamicObject doPersEntry : docPersEntry) {
            DynamicObject doPersEntryPer = doPersEntry.getDynamicObject("persentryper");
            long persEntryPerID = SFCUtils.getDynamicObjectLongPK((DynamicObject)doPersEntryPer);
            if (persEntryPerID <= 0L || Long.compare(curUserID, persEntryPerID) != 0) continue;
            isCurUserInPersEntry = true;
            break;
        }
        Boolean isShowChecked = "C".equalsIgnoreCase(billStatus) && (Long.compare(curUserID, originatorID) == 0 || isCurUserInPersEntry);
        fv.setVisible(isShowChecked, new String[]{entryName + "ischecked"});
        DynamicObject doMMC = BusinessDataServiceHelper.loadSingleFromCache((Object)lMMCID, (String)"sfc_meetmodconfig", (String)"number,name,resource,isallowedmodify,ismeetcontent,childitem,description,datasrc");
        boolean isAllowEditContent = doMMC == null ? false : doMMC.getBoolean("isallowedmodify");
        pc.put("isAllowEditContent", Boolean.toString(isAllowEditContent));
        if (SFCUtils.isEmptyList((List)lEntryData)) {
            DynamicObjectCollection docParentEntry = dmParent.getEntryEntity(entryName);
            lEntryData = this.getEntryData(entryName, docParentEntry);
        }
        if (!SFCUtils.isEmptyList((List)lEntryData)) {
            dm.beginInit();
            dmParent.beginInit();
            for (Map<String, String> mEntryData : lEntryData) {
                String pk = SFCUtils.getMapStringValue(mEntryData, (Object)(entryName + "id"));
                long lPK = StringUtils.isEmpty((CharSequence)pk) ? 0L : Long.parseLong(pk);
                String content = SFCUtils.getMapStringValue(mEntryData, (Object)(entryName + "content"));
                String otherDesc = SFCUtils.getMapStringValue(mEntryData, (Object)(entryName + "otherdesc"));
                String isChecked = SFCUtils.getMapStringValue(mEntryData, (Object)(entryName + "ischecked"));
                if (lMMCID <= 0L || lPK <= 0L) continue;
                int newEntryRowIndex = dm.createNewEntryRow(entryName);
                dm.setValue(entryName + "id", (Object)lPK, newEntryRowIndex);
                dm.setValue(entryName + "mmc", (Object)lMMCID, newEntryRowIndex);
                dm.setValue(entryName + "mmcentryid", (Object)lMMCEntryID, newEntryRowIndex);
                dm.setValue(entryName + "content", (Object)content, newEntryRowIndex);
                dm.setValue(entryName + "ischecked", (Object)Boolean.parseBoolean(isChecked), newEntryRowIndex);
                if ("mocentry".equalsIgnoreCase(entryName)) {
                    dm.setValue(entryName + "otherdesc", (Object)otherDesc, newEntryRowIndex);
                    fv.setEnable(isEnableEntryContent, newEntryRowIndex, new String[]{entryName + "otherdesc"});
                }
                if (bIsCreateNew.booleanValue()) {
                    int newParentEntryRowIndex = dmParent.createNewEntryRow(entryName);
                    dmParent.setValue(entryName + "id", (Object)lPK, newParentEntryRowIndex);
                    dmParent.setValue(entryName + "content", (Object)content, newParentEntryRowIndex);
                    dmParent.setValue(entryName + "mmc", (Object)lMMCID, newParentEntryRowIndex);
                    dmParent.setValue(entryName + "mmcentryid", (Object)lMMCEntryID, newParentEntryRowIndex);
                    if ("mocentry".equalsIgnoreCase(entryName)) {
                        dmParent.setValue(entryName + "otherdesc", (Object)otherDesc, newParentEntryRowIndex);
                    }
                }
                fv.setEnable(Boolean.valueOf(isAllowEditContent && isEnableEntryContent != false), newEntryRowIndex, new String[]{entryName + "content"});
            }
            dm.endInit();
            dmParent.endInit();
            if (bIsCreateNew.booleanValue()) {
                fv.sendFormAction(fvParent);
            }
        }
        if (bIsPreview.booleanValue()) {
            fv.setEnable(Boolean.FALSE, new String[]{entryName});
        }
    }

    public void propertyChanged(PropertyChangedArgs pca) {
        super.propertyChanged(pca);
        IFormView fv = this.getView();
        FormShowParameter fsp = fv.getFormShowParameter();
        String parentPageID = fsp.getParentPageId();
        String entryName = this.getEntryName();
        if (StringUtils.isEmpty((CharSequence)entryName)) {
            return;
        }
        IFormView fvParent = fv.getView(parentPageID);
        IDataModel dmParent = fvParent.getModel();
        int parentEntryRowCount = dmParent.getEntryRowCount(entryName);
        IDataModel dm = this.getModel();
        IDataEntityProperty idep = pca.getProperty();
        String pName = idep.getName();
        if (pName.equalsIgnoreCase(entryName + "id")) {
            return;
        }
        ChangeData[] cdArray = pca.getChangeSet();
        boolean isUpdateParent = false;
        block0: for (ChangeData cd : cdArray) {
            String newValue;
            int rowIndex = cd.getRowIndex();
            Object objNewValue = cd.getNewValue();
            String string = newValue = objNewValue == null ? null : objNewValue.toString();
            Long lNewValue = objNewValue == null ? 0L : (objNewValue instanceof Long ? (Long)objNewValue : 0L);
            Long lPK = SFCUtils.getDataModelLongValue((IDataModel)dm, (String)(entryName + "id"), (int)rowIndex);
            if (lPK <= 0L) continue;
            for (int parentEntryRowIndex = 0; parentEntryRowIndex < parentEntryRowCount; ++parentEntryRowIndex) {
                Long lParentPK = SFCUtils.getDataModelLongValue((IDataModel)dmParent, (String)(entryName + "id"), (int)parentEntryRowIndex);
                if (lPK.compareTo(lParentPK) != 0) continue;
                dmParent.setValue(pName, (Object)newValue, parentEntryRowIndex);
                isUpdateParent = true;
                continue block0;
            }
        }
        if (isUpdateParent) {
            fv.sendFormAction(fvParent);
        }
    }
}

