/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.formplugin.manftech;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import kd.bd.mpdm.common.manuftech.utils.MftOrderReportTplUtils;
import kd.bd.mpdm.formplugin.manufacturemodel.TechnicsTplEditPlugin;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.report.ReportShowParameter;
import kd.mmc.sfc.business.manuftech.SfcTechnicsHelper;
import kd.mmc.sfc.common.utils.SfcBigDecimaUtil;

public class SFCMftTechnicsEditPlugin
extends TechnicsTplEditPlugin {
    private static final Log logger = LogFactory.getLog(SFCMftTechnicsEditPlugin.class);

    protected String getOrderBillType() {
        return "pom_mftorder";
    }

    protected String getStockBillType() {
        return "pom_mftstock";
    }

    public void afterDoOperation(AfterDoOperationEventArgs arg0) {
        super.afterDoOperation(arg0);
        String operateKey = arg0.getOperateKey();
        if ("beginworkbfop".equals(operateKey)) {
            ArrayList<String> billnos = new ArrayList<String>(1);
            billnos.add(this.getModel().getValue("billno").toString());
            BillShowParameter showParameter = MftOrderReportTplUtils.createAddNewBillShowParam(billnos, (Object)((DynamicObject)this.getModel().getValue("org")).getPkValue());
            this.getView().showForm((FormShowParameter)showParameter);
        } else if ("outpurex".equals(operateKey)) {
            EntryGrid oprEntryEntityGrid = (EntryGrid)this.getView().getControl("oprentryentity1");
            Object rowNo = this.getModel().getValue("row10");
            if (rowNo == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f3a\u5c11\u5de5\u5e8f\u5217\u8868\u5206\u5f55\u884c\u3002", (String)"SFCMftTechnicsEditPlugin_0", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
                return;
            }
            int[] selectRows = new int[]{(Integer)rowNo};
            ArrayList<Long> supplier = new ArrayList<Long>(16);
            ArrayList<Long> oprOperation = new ArrayList<Long>(16);
            Object oprStatus = null;
            Object oprPlanBeginTime = null;
            Object oprPlanFinishTime = null;
            Object oprNo = null;
            Object purchaseOrg = null;
            IDataModel model = this.getModel();
            DynamicObject orgObj = (DynamicObject)model.getValue("org");
            Long org = orgObj.getLong("id");
            DynamicObject mftEntrySeq = (DynamicObject)model.getValue("mftentryseq");
            Object baseDataManufactureOrder = mftEntrySeq.get("headbillno");
            ArrayList<Long> billNo = new ArrayList<Long>(16);
            billNo.add((Long)model.getValue("id"));
            ArrayList<Long> material = new ArrayList<Long>(16);
            DynamicObject materialObj = (DynamicObject)model.getValue("material");
            material.add(materialObj.getLong("id"));
            DynamicObjectCollection oprEntryEntity = model.getEntryEntity("oprentryentity");
            for (int selectRow : selectRows) {
                DynamicObject oprOperationObj;
                DynamicObject oprObj = (DynamicObject)oprEntryEntity.get(selectRow);
                oprPlanBeginTime = oprObj.get("oprplanbegintime");
                oprPlanFinishTime = oprObj.get("oprplanfinishtime");
                DynamicObject supplierObj = (DynamicObject)oprObj.get("supplier");
                if (supplierObj != null) {
                    supplier.add(supplierObj.getLong("id"));
                }
                if ((oprOperationObj = (DynamicObject)oprObj.get("oproperation")) != null) {
                    oprOperation.add(oprOperationObj.getLong("id"));
                }
                oprNo = oprObj.get("oprno");
                oprStatus = oprObj.get("oprstatus");
            }
            ReportShowParameter report = new ReportShowParameter();
            report.setFormId("sfc_outpurex");
            report.getOpenStyle().setShowType(ShowType.Modal);
            report.setCustomParam("org", (Object)org);
            report.setCustomParam("planbegintime", oprPlanBeginTime);
            report.setCustomParam("planfinishtime", oprPlanFinishTime);
            report.setCustomParam("supplier", supplier);
            report.setCustomParam("oprno", oprOperation);
            report.setCustomParam("oprnumber", oprNo);
            report.setCustomParam("manftechrowstatus", oprStatus);
            report.setCustomParam("order", baseDataManufactureOrder);
            report.setCustomParam("manftechno", billNo);
            report.setCustomParam("material", material);
            report.setCustomParam("isfromSFC", (Object)"true");
            this.getView().showForm((FormShowParameter)report);
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        IDataModel model = this.getModel();
        String entityKey = model.getDataEntityType().getName();
        StringBuilder err = new StringBuilder();
        DynamicObject dataEntity = model.getDataEntity();
        boolean isinitbill = dataEntity.getBoolean("isinitbill");
        if (!isinitbill) {
            err.append(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5bfc\u5165\u201c\u521d\u59cb\u5316\u201d\u4e3a\u201c\u5426\u201d\u7684\u5355\u636e\u3002", (String)"SFCMftTechnicsEditPlugin_1", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            ArrayList<String> errors = new ArrayList<String>(2);
            errors.add(err.toString());
            e.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), errors);
            return;
        }
        DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection("oprentryentity");
        for (DynamicObject entry : entryColl) {
            this.calculateQtyAfterImport(entry);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        Object isinitbill = this.getModel().getValue("isinitbill");
        if (isinitbill != null && Boolean.parseBoolean(isinitbill.toString())) {
            this.intiBillPropertyChanged(e);
        }
    }

    private void intiBillPropertyChanged(PropertyChangedArgs e) {
        String name;
        IDataEntityProperty property = e.getProperty();
        switch (name = property.getName()) {
            case "oprtotalinqty1": 
            case "oprtotaloutqty1": 
            case "oprtotalqualifiedqty1": 
            case "oprtotalreceiveqty1": 
            case "oprtotalwasteqty1": 
            case "oprtotalmaterialqty1": 
            case "oprtotalreworkqty1": 
            case "oprrepairedqty1": {
                this.calculateQty();
                break;
            }
        }
    }

    private void calculateQty() {
        int entryIndex = (Integer)this.getModel().getValue("row2");
        if (entryIndex < 0) {
            return;
        }
        if ("1".equals(this.getPageCache().get("flag"))) {
            return;
        }
        BigDecimal oprtotalinqty1 = SfcBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("oprtotalinqty1"));
        BigDecimal oprtotaloutqty1 = SfcBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("oprtotaloutqty1"));
        BigDecimal oprtotalqualifiedqty1 = SfcBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("oprtotalqualifiedqty1"));
        BigDecimal oprtotalreceiveqty1 = SfcBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("oprtotalreceiveqty1"));
        BigDecimal oprtotalwasteqty1 = SfcBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("oprtotalwasteqty1"));
        BigDecimal oprtotalmaterialqty1 = SfcBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("oprtotalmaterialqty1"));
        BigDecimal oprtotalreworkqty1 = SfcBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("oprtotalreworkqty1"));
        BigDecimal oprrepairedqty1 = SfcBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("oprrepairedqty1"));
        BigDecimal pushreworkreportqty1 = SfcBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("pushreworkreportqty1"));
        BigDecimal reworkreportqty1 = SfcBigDecimaUtil.toBigDecimal((Object)this.getModel().getValue("reworkreportqty1"));
        this.getPageCache().put("flag", "1");
        BigDecimal pushreportqty1 = oprtotalqualifiedqty1.add(oprtotalreceiveqty1).add(oprtotalwasteqty1).add(oprtotalmaterialqty1).add(oprtotalreworkqty1).add(oprrepairedqty1);
        this.getModel().setValue("pushreportqty1", (Object)pushreportqty1);
        BigDecimal oprtotalreportqty1 = oprtotalqualifiedqty1.add(oprtotalreceiveqty1).add(oprtotalwasteqty1).add(oprtotalmaterialqty1).add(oprtotalreworkqty1).add(oprrepairedqty1);
        this.getModel().setValue("oprtotalreportqty1", (Object)oprtotalreportqty1);
        BigDecimal oprtotaljunkqty1 = oprtotalmaterialqty1.add(oprtotalwasteqty1);
        this.getModel().setValue("oprtotaljunkqty1", (Object)oprtotaljunkqty1);
        this.getModel().setValue("oprtotalinqty", (Object)oprtotalinqty1, entryIndex);
        this.getModel().setValue("oprtotaloutqty", (Object)oprtotaloutqty1, entryIndex);
        this.getModel().setValue("oprtotalqualifiedqty", (Object)oprtotalqualifiedqty1, entryIndex);
        this.getModel().setValue("oprtotalreceiveqty", (Object)oprtotalreceiveqty1, entryIndex);
        this.getModel().setValue("oprtotalwasteqty", (Object)oprtotalwasteqty1, entryIndex);
        this.getModel().setValue("oprtotalmaterialqty", (Object)oprtotalmaterialqty1, entryIndex);
        this.getModel().setValue("oprtotalreworkqty", (Object)oprtotalreworkqty1, entryIndex);
        this.getModel().setValue("oprrepairedqty", (Object)oprrepairedqty1, entryIndex);
        this.getModel().setValue("pushreportqty", (Object)pushreportqty1, entryIndex);
        this.getModel().setValue("oprtotalreportqty", (Object)oprtotalreportqty1, entryIndex);
        this.getModel().setValue("oprtotaljunkqty", (Object)oprtotaljunkqty1, entryIndex);
        DynamicObject manTechicsInfo = this.getModel().getDataEntity();
        DynamicObject techisInfo = this.getModel().getEntryRowEntity("oprentryentity", entryIndex);
        Map manftechMap = SfcTechnicsHelper.getManftechMap((DynamicObject)manTechicsInfo, (DynamicObject)techisInfo);
        BigDecimal oprtotalinbaseqty1 = SfcTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotalinqty1);
        this.getModel().setValue("oprtotalinbaseqty1", (Object)oprtotalinbaseqty1);
        this.getModel().setValue("oprtotalinbaseqty", (Object)oprtotalinbaseqty1, entryIndex);
        BigDecimal oprtotaloutbaseqty1 = SfcTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotaloutqty1);
        this.getModel().setValue("oprtotaloutbaseqty1", (Object)oprtotaloutbaseqty1);
        this.getModel().setValue("oprtotaloutbaseqty", (Object)oprtotaloutbaseqty1, entryIndex);
        BigDecimal pushreportbaseqty1 = SfcTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)pushreportqty1);
        this.getModel().setValue("pushreportbaseqty1", (Object)pushreportbaseqty1);
        this.getModel().setValue("pushreportbaseqty", (Object)pushreportbaseqty1, entryIndex);
        BigDecimal pushreworkreportbaseqty1 = SfcTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)pushreworkreportqty1);
        this.getModel().setValue("pushreworkreportbaseqty1", (Object)pushreworkreportbaseqty1);
        this.getModel().setValue("pushreworkreportbaseqty", (Object)pushreworkreportbaseqty1, entryIndex);
        BigDecimal oprtotalreportbaseqty1 = SfcTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotalreportqty1);
        this.getModel().setValue("oprtotalreportbaseqty1", (Object)oprtotalreportbaseqty1);
        this.getModel().setValue("oprtotalreportbaseqty", (Object)oprtotalreportbaseqty1, entryIndex);
        BigDecimal reworkreportbaseqty1 = SfcTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)reworkreportqty1);
        this.getModel().setValue("reworkreportbaseqty1", (Object)reworkreportbaseqty1);
        this.getModel().setValue("reworkreportbaseqty", (Object)reworkreportbaseqty1, entryIndex);
        BigDecimal oprtotalqualifiedbaseqty1 = SfcTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotalqualifiedqty1);
        this.getModel().setValue("oprtotalqualifiedbaseqty1", (Object)oprtotalqualifiedbaseqty1);
        this.getModel().setValue("oprtotalqualifiedbaseqty", (Object)oprtotalqualifiedbaseqty1, entryIndex);
        BigDecimal oprtotalreceivebaseqty1 = SfcTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotalreceiveqty1);
        this.getModel().setValue("oprtotalreceivebaseqty1", (Object)oprtotalreceivebaseqty1);
        this.getModel().setValue("oprtotalreceivebaseqty", (Object)oprtotalreceivebaseqty1, entryIndex);
        BigDecimal oprtotalwastebaseqty1 = SfcTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotalwasteqty1);
        this.getModel().setValue("oprtotalwastebaseqty1", (Object)oprtotalwastebaseqty1);
        this.getModel().setValue("oprtotalwastebaseqty", (Object)oprtotalwastebaseqty1, entryIndex);
        BigDecimal oprtotalmaterialbaseqty1 = SfcTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotalmaterialqty1);
        this.getModel().setValue("oprtotalmaterialbaseqty1", (Object)oprtotalmaterialbaseqty1);
        this.getModel().setValue("oprtotalmaterialbaseqty", (Object)oprtotalmaterialbaseqty1, entryIndex);
        BigDecimal oprtotaljunkbaseqty1 = SfcTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotaljunkqty1);
        this.getModel().setValue("oprtotaljunkbaseqty1", (Object)oprtotaljunkbaseqty1);
        this.getModel().setValue("oprtotaljunkbaseqty", (Object)oprtotaljunkbaseqty1, entryIndex);
        BigDecimal oprtotalreworkbaseqty1 = SfcTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotalreworkqty1);
        this.getModel().setValue("oprtotalreworkbaseqty1", (Object)oprtotalreworkbaseqty1);
        this.getModel().setValue("oprtotalreworkbaseqty", (Object)oprtotalreworkbaseqty1, entryIndex);
        this.getPageCache().put("flag", "0");
    }

    private void calculateQtyAfterImport(DynamicObject entry) {
        if ("1".equals(this.getPageCache().get("flag"))) {
            return;
        }
        BigDecimal oprtotalinqty = SfcBigDecimaUtil.toBigDecimal((Object)entry.getBigDecimal("oprtotalinqty"));
        BigDecimal oprtotaloutqty = SfcBigDecimaUtil.toBigDecimal((Object)entry.getBigDecimal("oprtotaloutqty"));
        BigDecimal oprtotalqualifiedqty = SfcBigDecimaUtil.toBigDecimal((Object)entry.getBigDecimal("oprtotalqualifiedqty"));
        BigDecimal oprtotalreceiveqty = SfcBigDecimaUtil.toBigDecimal((Object)entry.getBigDecimal("oprtotalreceiveqty"));
        BigDecimal oprtotalwasteqty = SfcBigDecimaUtil.toBigDecimal((Object)entry.getBigDecimal("oprtotalwasteqty"));
        BigDecimal oprtotalmaterialqty = SfcBigDecimaUtil.toBigDecimal((Object)entry.getBigDecimal("oprtotalmaterialqty"));
        BigDecimal oprtotalreworkqty = SfcBigDecimaUtil.toBigDecimal((Object)entry.getBigDecimal("oprtotalreworkqty"));
        BigDecimal oprrepairedqty = SfcBigDecimaUtil.toBigDecimal((Object)entry.getBigDecimal("oprrepairedqty"));
        BigDecimal pushreworkreportqty = SfcBigDecimaUtil.toBigDecimal((Object)entry.getBigDecimal("pushreworkreportqty"));
        BigDecimal reworkreportqty = SfcBigDecimaUtil.toBigDecimal((Object)entry.getBigDecimal("reworkreportqty"));
        this.getPageCache().put("flag", "1");
        BigDecimal pushreportqty = oprtotalqualifiedqty.add(oprtotalreceiveqty).add(oprtotalwasteqty).add(oprtotalmaterialqty).add(oprtotalreworkqty).add(oprrepairedqty);
        entry.set("pushreportqty", (Object)pushreportqty);
        BigDecimal oprtotalreportqty = oprtotalqualifiedqty.add(oprtotalreceiveqty).add(oprtotalwasteqty).add(oprtotalmaterialqty).add(oprtotalreworkqty).add(oprrepairedqty);
        entry.set("oprtotalreportqty", (Object)oprtotalreportqty);
        BigDecimal oprtotaljunkqty = oprtotalmaterialqty.add(oprtotalwasteqty);
        entry.set("oprtotaljunkqty", (Object)oprtotaljunkqty);
        DynamicObject manTechicsInfo = this.getModel().getDataEntity();
        Map manftechMap = SfcTechnicsHelper.getManftechMap((DynamicObject)manTechicsInfo, (DynamicObject)entry);
        BigDecimal oprtotalinbaseqty = SfcTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotalinqty);
        entry.set("oprtotalinbaseqty", (Object)oprtotalinbaseqty);
        BigDecimal oprtotaloutbaseqty = SfcTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotaloutqty);
        entry.set("oprtotaloutbaseqty", (Object)oprtotaloutbaseqty);
        BigDecimal pushreportbaseqty = SfcTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)pushreportqty);
        entry.set("pushreportbaseqty", (Object)pushreportbaseqty);
        BigDecimal pushreworkreportbaseqty = SfcTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)pushreworkreportqty);
        entry.set("pushreworkreportbaseqty", (Object)pushreworkreportbaseqty);
        BigDecimal oprtotalreportbaseqty = SfcTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotalreportqty);
        entry.set("oprtotalreportbaseqty", (Object)oprtotalreportbaseqty);
        BigDecimal reworkreportbaseqty = SfcTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)reworkreportqty);
        entry.set("reworkreportbaseqty", (Object)reworkreportbaseqty);
        BigDecimal oprtotalqualifiedbaseqty = SfcTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotalqualifiedqty);
        entry.set("oprtotalqualifiedbaseqty", (Object)oprtotalqualifiedbaseqty);
        BigDecimal oprtotalreceivebaseqty = SfcTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotalreceiveqty);
        entry.set("oprtotalreceivebaseqty", (Object)oprtotalreceivebaseqty);
        BigDecimal oprtotalwastebaseqty = SfcTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotalwasteqty);
        entry.set("oprtotalwastebaseqty", (Object)oprtotalwastebaseqty);
        BigDecimal oprtotalmaterialbaseqty = SfcTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotalmaterialqty);
        entry.set("oprtotalmaterialbaseqty", (Object)oprtotalmaterialbaseqty);
        BigDecimal oprtotaljunkbaseqty = SfcTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotaljunkqty);
        entry.set("oprtotaljunkbaseqty", (Object)oprtotaljunkbaseqty);
        BigDecimal oprtotalreworkbaseqty = SfcTechnicsHelper.getBaseQty((Map)manftechMap, (BigDecimal)oprtotalreworkqty);
        entry.set("oprtotalreworkbaseqty", (Object)oprtotalreworkbaseqty);
        this.getPageCache().put("flag", "0");
    }
}

