/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.formplugin.mydailyplan;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.sfc.common.dailyplan.utils.MydailyPlanUtil;
import kd.mmc.sfc.common.mydailyplan.MydailyPlanUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class MydailyPlanDisListPlugin
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"tbmain"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("distribute".equals(operateKey)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selects = billList.getSelectedRows();
            HashSet<Object> billIds = new HashSet<Object>(16);
            for (ListSelectedRow select : selects) {
                billIds.add(select.getPrimaryKeyValue());
            }
            if (billIds.size() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u6d3e\u4eba\u5458\u53ea\u80fd\u9009\u4e00\u6761\u4efb\u52a1\u3002", (String)"MydailyPlanDisListPlugin_1", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
                args.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs ade) {
        super.afterDoOperation(ade);
        String operateKey = ade.getOperateKey();
        if ("distribute".equals(operateKey) && ade.getOperationResult().isSuccess()) {
            long userId = RequestContext.get().getCurrUserId();
            DynamicObject mydailyPlanGroup = MydailyPlanUtil.getMydailyPlanGroup((long)userId);
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selects = billList.getSelectedRows();
            Object pkvalue = selects.get(0).getPrimaryKeyValue();
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setCustomParam("pkid", (Object)pkvalue.toString());
            showParameter.setCustomParam("groupid", (Object)(mydailyPlanGroup == null ? "0" : String.valueOf(mydailyPlanGroup.getPkValue())));
            showParameter.setFormId("sfc_dailyplan_dialog");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "distributecallback"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        HashMap returnData;
        String actionId = e.getActionId();
        if ("distributecallback".equals(actionId) && (returnData = (HashMap)e.getReturnData()) != null) {
            String pkid = (String)returnData.get("pkid");
            String groupid = (String)returnData.get("groupid");
            Map hashMap = (Map)returnData.get("entryid");
            this.updatePersion(pkid, hashMap, groupid);
            this.getView().invokeOperation("refresh");
        }
        super.closedCallBack(e);
    }

    private void updatePersion(String pkid, Map<String, Map<String, Set<Long>>> hashMap, String groupid) {
        DynamicObject currentUser = MydailyPlanUtils.getCurrentUser();
        String sql = "planstarttime,planendtime,userincharge,rolenumber,studystatus,classgroup,jobsrctype,issure,handoveruser";
        DynamicObject dailyplan = BusinessDataServiceHelper.loadSingle((Object)NumberUtils.toLong((String)pkid), (String)"sfc_dailyplan_user", (String)sql);
        if (dailyplan != null) {
            DynamicObjectCollection planentryentity = dailyplan.getDynamicObjectCollection("planentryentity");
            for (DynamicObject pentity : planentryentity) {
                DynamicObjectCollection allocsubentryentity = pentity.getDynamicObjectCollection("allocsubentryentity");
                String rowid = String.valueOf(pentity.getPkValue());
                Map<String, Set<Long>> opMap = hashMap.get(rowid);
                if (opMap == null) continue;
                if (opMap.get("deleteid") != null) {
                    ArrayList<DynamicObject> deleteList = new ArrayList<DynamicObject>(allocsubentryentity.size());
                    Set<Long> dset = opMap.get("deleteid");
                    for (DynamicObject row : allocsubentryentity) {
                        Long pkValue = (Long)row.getDynamicObject("userincharge").getPkValue();
                        if (!dset.contains(pkValue)) continue;
                        deleteList.add(row);
                    }
                    allocsubentryentity.removeAll(deleteList);
                }
                if (opMap.get("addid") == null) continue;
                Set<Long> addset = opMap.get("addid");
                for (Long userid : addset) {
                    DynamicObject addNew = allocsubentryentity.addNew();
                    addNew.set("userincharge", (Object)userid);
                    addNew.set("classgroup", (Object)NumberUtils.toLong((String)groupid));
                    addNew.set("jobsrctype", (Object)"B");
                    addNew.set("issure", (Object)"B");
                    addNew.set("handoveruser", (Object)currentUser);
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dailyplan});
            DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)dailyplan.getPkValue(), (String)"sfc_dailyplan", (String)MydailyPlanUtils.getSelectPro());
            MydailyPlanUtils.updatePlanTimeAndUser((DynamicObject)loadSingle);
            MydailyPlanUtils.updateCheckUser((DynamicObject[])new DynamicObject[]{loadSingle});
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{loadSingle});
        }
    }
}

