/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.formplugin.mydailyplan;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.mmc.sfc.common.mydailyplan.MydailyPlanUtils;

public class MydailyPlanPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final Log logger = LogFactory.getLog(MydailyPlanPlugin.class);
    private static final String KEY_SFC_DAILYPLAN_USER = "sfc_dailyplan_user";
    private static final String KEY_TAB_USER = "tab_user";
    private static final String KEY_TAB_CLASSGROUP = "tab_classgroup";
    private static final String KEY_TAB_PROFESSION = "tab_profession";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.showBillList(KEY_SFC_DAILYPLAN_USER, "flex_user", KEY_TAB_USER);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map checkParams = this.getView().getFormShowParameter().getCustomParams();
        Object type = checkParams.get("apptype");
        if (type != null && "mcenter".equals(type)) {
            Tab tab = (Tab)this.getControl("tab_view");
            tab.activeTab(KEY_TAB_PROFESSION);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl("tab_view");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    private void showBillList(String entityid, String flexKey, String tabKey) {
        Map params;
        Object type;
        Date now = TimeServiceHelper.now();
        Date endTime = new Date(now.getTime() - 604800000L);
        Long startdate = System.currentTimeMillis();
        logger.info("\u5de5\u4f5c\u6e05\u5355\u67e5\u8be2\u6700\u8fd1\u4e00\u5468\u7684\u6570\u636e");
        QFilter qFilter = new QFilter("createtime", ">=", (Object)endTime);
        qFilter.and("org", "=", (Object)MydailyPlanUtils.getCurrentUserOrgId());
        DynamicObject[] mydailyPlans = BusinessDataServiceHelper.load((String)"sfc_dailyplan", (String)MydailyPlanUtils.getSelectProRes(), (QFilter[])new QFilter[]{qFilter});
        Long enddate = System.currentTimeMillis() - startdate;
        logger.info("\u5de5\u4f5c\u6e05\u5355\u67e5\u8be2\u6700\u8fd1\u4e00\u5468\u7684\u6570\u636e,\u8017\u65f6" + enddate);
        if (mydailyPlans.length > 0) {
            Long startdate1 = System.currentTimeMillis();
            logger.info("\u5de5\u4f5c\u6e05\u5355\u8d44\u6e90\u5c31\u7eea\u72b6\u6001\u67e5\u8be2\u5f00\u59cb" + mydailyPlans.length);
            MydailyPlanUtils.updateResStatus((DynamicObject[])mydailyPlans);
            Long enddate1 = System.currentTimeMillis() - startdate1;
            logger.info("\u5de5\u4f5c\u6e05\u5355\u8d44\u6e90\u5c31\u7eea\u72b6\u6001\u67e5\u8be2\u7ed3\u675f,\u8017\u65f6" + enddate1);
        }
        ListShowParameter showParam = new ListShowParameter();
        showParam.setBillFormId(entityid);
        showParam.getOpenStyle().setShowType(ShowType.InContainer);
        showParam.getOpenStyle().setTargetKey(flexKey);
        this.getPageCache().put("childpageid", showParam.getPageId());
        this.getPageCache().put(tabKey, "1");
        if ("sfc_dailyplan_profession".equals(entityid) && (type = (params = this.getView().getFormShowParameter().getCustomParams()).get("apptype")) != null && "mcenter".equals(type)) {
            Long id = Long.parseLong(params.get("param1").toString());
            QFilter fil = new QFilter("id", "=", (Object)id);
            showParam.getListFilterParameter().setFilter(fil);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, entityid);
        showParam.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParam);
    }

    public void tabSelected(TabSelectEvent e) {
        String tabKey = e.getTabKey();
        String tabstatus = this.getPageCache().get(tabKey);
        if (tabstatus == null || !"1".equals(tabstatus)) {
            if (KEY_TAB_USER.equals(tabKey)) {
                this.showBillList(KEY_SFC_DAILYPLAN_USER, "flex_user", KEY_TAB_USER);
            } else if (KEY_TAB_CLASSGROUP.equals(tabKey)) {
                this.showBillList("sfc_dailyplan_classgroup", "flex_classgroup", KEY_TAB_CLASSGROUP);
            } else if (KEY_TAB_PROFESSION.equals(tabKey)) {
                this.showBillList("sfc_dailyplan_profession", "flex_profession", KEY_TAB_PROFESSION);
            } else if ("tab_notice".equals(tabKey)) {
                this.showBillList("sfc_dailyplan_notice", "flex_notice", "tab_notice");
            }
        }
    }
}

