/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.formplugin.mydailyplan;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.common.mftorder.utils.MPDMMftGenStocksUtils;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.sfc.common.mydailyplan.MydailyPlanUtils;

public class ProjectTaskEdit
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        this.addClickListeners(new String[]{"btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject currentUser = MydailyPlanUtils.getCurrentUser();
        DynamicObject industry = MydailyPlanUtils.getIndustry((DynamicObject)currentUser);
        this.getModel().setValue("profession", (Object)industry);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("btnok".equals(control.getKey())) {
            IFormView view = this.getView();
            String entityId = view.getEntityId();
            String srcEntityId = ((IListView)this.getView().getParentView()).getBillFormId();
            if ("sfc_dailyplan_project".equals(entityId)) {
                Set mydailyPlanIdSet = MydailyPlanUtils.getMydailyPlanIdSet((IFormView)this.getView(), (boolean)false, (boolean)true);
                if (!mydailyPlanIdSet.isEmpty()) {
                    MydailyPlanUtils.checkPermission((String)"projecttask", (String)srcEntityId, (Long)mydailyPlanIdSet.toArray(new Long[0])[0]);
                }
                this.projectBill();
            } else if ("sfc_dailyplan_company".equals(entityId)) {
                Set mydailyPlanIdSet = MydailyPlanUtils.getMydailyPlanIdSet((IFormView)this.getView(), (boolean)false, (boolean)true);
                if (!mydailyPlanIdSet.isEmpty()) {
                    MydailyPlanUtils.checkPermission((String)"companytask", (String)srcEntityId, (Long)mydailyPlanIdSet.toArray(new Long[0])[0]);
                }
                this.companyBill();
            }
        }
    }

    private void companyBill() {
        IDataModel model = this.getModel();
        DynamicObject profession = (DynamicObject)model.getValue("profession");
        DynamicObject dailyexptype = (DynamicObject)model.getValue("dailyexptype");
        String taskname = (String)model.getValue("taskname");
        DynamicObject dailyplan = BusinessDataServiceHelper.newDynamicObject((String)"sfc_dailyplan");
        DynamicObjectCollection oprentryentity = dailyplan.getDynamicObjectCollection("oprentryentity");
        DynamicObject oprentry = oprentryentity.addNew();
        oprentry.set("dailyexptype", (Object)dailyexptype);
        oprentry.set("profession", (Object)profession);
        oprentry.set("status", (Object)"A");
        MydailyPlanUtils.setPlanAndUser((DynamicObject)dailyplan);
        dailyplan.set("taskname", (Object)taskname);
        Long orgId = MydailyPlanUtils.getCurrentUserOrgId();
        dailyplan.set("org", (Object)orgId);
        this.setDefault(dailyplan);
        dailyplan.set("tasksrctype", (Object)"C");
        String[] numbers = CodeRuleServiceHelper.getBatchNumber((String)"sfc_dailyplan", (DynamicObject)dailyplan, (String)orgId.toString(), (int)1);
        if (!"".equals(numbers[0])) {
            dailyplan.set("billno", (Object)numbers[0]);
        } else {
            IDataEntityType type = dailyplan.getDataEntityType();
            DBRoute rt = new DBRoute(type.getDBRouteKey());
            SequenceReader seqReader = new SequenceReader(rt);
            seqReader.autoSetPrimaryKey((Object[])new DynamicObject[]{dailyplan}, type);
            dailyplan.set("billno", (Object)numbers[0]);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dailyplan});
        this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"ProjectTaskEdit_1", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
        this.getView().close();
    }

    private void setDefault(DynamicObject dailyplan) {
        dailyplan.set("taskstatus", (Object)"A");
        dailyplan.set("dispatchstatus", (Object)"B");
        dailyplan.set("bizstatus", (Object)"B");
        dailyplan.set("allocationstatus", (Object)"B");
        dailyplan.set("billstatus", (Object)"A");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void projectBill() {
        Long orgId = MydailyPlanUtils.getCurrentUserOrgId();
        String taskname = (String)this.getModel().getValue("taskname");
        DynamicObject profession = (DynamicObject)this.getModel().getValue("profession");
        HashSet<Long> orderEntrySet = new HashSet<Long>(16);
        HashMap<Long, Long> idEntryIdMap = new HashMap<Long, Long>(16);
        IDataModel model = this.getModel();
        DynamicObject project = (DynamicObject)model.getValue("project");
        DynamicObject dailyexptype = (DynamicObject)model.getValue("dailyexptype");
        QFilter q = new QFilter("dailyexptype", "=", dailyexptype.getPkValue());
        q.and(new QFilter("billstatus", "=", (Object)"C"));
        q.and(new QFilter("treeentryentity.project", "=", project.getPkValue()));
        q.and("treeentryentity.taskstatus", "in", (Object)new String[]{"A", "B", "D", "G"});
        q.and("treeentryentity.bizstatus", "=", (Object)"A");
        DynamicObjectCollection querys = QueryServiceHelper.query((String)"pom_mroorder", (String)"billno,id,treeentryentity.id", (QFilter[])new QFilter[]{q});
        for (DynamicObject query : querys) {
            orderEntrySet.add(query.getLong("treeentryentity.id"));
            idEntryIdMap.put(query.getLong("id"), query.getLong("treeentryentity.id"));
        }
        if (!orderEntrySet.isEmpty()) {
            PushArgs pushArgs = new PushArgs();
            pushArgs.setTargetEntityNumber("sfc_dailyplan");
            pushArgs.setHasRight(true);
            pushArgs.setRuleId("1495515643217205248");
            pushArgs.setBuildConvReport(true);
            ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(16);
            pushArgs.setSourceEntityNumber("pom_mroorder");
            for (Map.Entry m : idEntryIdMap.entrySet()) {
                ListSelectedRow srcBill = new ListSelectedRow(m.getKey());
                srcBill.setEntryEntityKey("treeentryentity");
                srcBill.setEntryPrimaryKeyValue(m.getValue());
                needPushRows.add(srcBill);
            }
            pushArgs.setSelectedRows(needPushRows);
            ConvertOperationResult result = ConvertServiceHelper.push((PushArgs)pushArgs);
            if (!result.isSuccess() || result.getCachePageIds().isEmpty()) throw new KDBizException(new ErrorCode("StockAutoGenerateStock", MPDMMftGenStocksUtils.getErrByRes((ConvertOperationResult)result)), new Object[0]);
            MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)"sfc_dailyplan");
            List targetBillObjs = result.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
            if (!targetBillObjs.isEmpty()) {
                for (DynamicObject targetBillObj : targetBillObjs) {
                    targetBillObj.set("taskname", (Object)taskname);
                    targetBillObj.set("tasksrctype", (Object)"B");
                    this.setDefault(targetBillObj);
                    MydailyPlanUtils.setPlanAndUser((DynamicObject)targetBillObj);
                    ((DynamicObject)targetBillObj.getDynamicObjectCollection("oprentryentity").get(0)).set("profession", (Object)profession);
                    targetBillObj.set("billno", (Object)targetBillObj.getPkValue().toString());
                }
                String[] numbers = CodeRuleServiceHelper.getBatchNumber((String)"sfc_dailyplan", (DynamicObject)((DynamicObject)targetBillObjs.get(0)), (String)orgId.toString(), (int)targetBillObjs.size());
                for (int i = 0; i < targetBillObjs.size(); ++i) {
                    DynamicObject targetBillObj = (DynamicObject)targetBillObjs.get(i);
                    if (numbers == null || numbers.length < i + 1 || numbers[i] == null) {
                        targetBillObj.set("billno", (Object)targetBillObj.getPkValue().toString());
                        continue;
                    }
                    targetBillObj.set("billno", (Object)numbers[i]);
                }
                SaveServiceHelper.save((DynamicObject[])targetBillObjs.toArray(new DynamicObject[0]));
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"ProjectTaskEdit_1", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
            }
            this.getView().close();
            return;
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u68c0\u4fee\u5de5\u5355\u3002", (String)"ProjectTaskEdit_0", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
        }
    }
}

