/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.formplugin.processreport;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bd.mpdm.business.manuftech.OprUnitHelper;
import kd.bd.mpdm.business.mftorder.OrderQualityOrgService;
import kd.bd.mpdm.business.mftorder.SerialNumberHelper;
import kd.bd.mpdm.common.manuftech.utils.SFCCustFormulaFuntions;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.formula.platform.api.IFormulaFunctions;
import kd.bos.formula.platform.engine.FormulaEngine;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.mmc.sfc.common.helper.WarehouseHelper;
import kd.mmc.sfc.common.utils.QueryOrderUtil;
import kd.mmc.sfc.common.utils.UnitRateConvertUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Sets;
import org.apache.commons.lang3.math.NumberUtils;

public class SFCProcessReportBillEdit
extends AbstractFormPlugin
implements RowClickEventListener,
BeforeF7SelectListener {
    protected Boolean isIgnoreChangeListener = Boolean.FALSE;
    private static final Log logger = LogFactory.getLog(SFCProcessReportBillEdit.class);

    public void initialize() {
        super.initialize();
    }

    public void itemClick(ItemClickEvent evt) {
        String operationKey;
        super.itemClick(evt);
        switch (operationKey = evt.getItemKey()) {
            case "checksnnumber": 
            case "entersnnumber": 
            case "importsnnumber": {
                SerialNumberHelper.handleSNNumber((AbstractFormPlugin)this, (ItemClickEvent)evt);
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit qualityOrg;
        BasedataEdit warehouse3;
        BasedataEdit warehouse2;
        BasedataEdit position2;
        BasedataEdit position3;
        BasedataEdit inwarehouseorg2;
        BasedataEdit inwarehouseorg3;
        BasedataEdit inwarconsigner2;
        BasedataEdit inwarconsigner3;
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("sumentry");
        if (entryGrid != null) {
            entryGrid.addRowClickListener((RowClickEventListener)this);
        }
        if ((inwarconsigner3 = (BasedataEdit)this.getView().getControl("inwarconsigner3")) != null) {
            inwarconsigner3.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((inwarconsigner2 = (BasedataEdit)this.getView().getControl("inwarconsigner2")) != null) {
            inwarconsigner2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((inwarehouseorg3 = (BasedataEdit)this.getView().getControl("inwarehouseorg3")) != null) {
            inwarehouseorg3.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((inwarehouseorg2 = (BasedataEdit)this.getView().getControl("inwarehouseorg2")) != null) {
            inwarehouseorg2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((position3 = (BasedataEdit)this.getView().getControl("position3")) != null) {
            position3.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((position2 = (BasedataEdit)this.getView().getControl("position2")) != null) {
            position2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((warehouse2 = (BasedataEdit)this.getView().getControl("warehouse2")) != null) {
            warehouse2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((warehouse3 = (BasedataEdit)this.getView().getControl("warehouse3")) != null) {
            warehouse3.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((qualityOrg = (BasedataEdit)this.getView().getControl("qualityorg")) != null) {
            qualityOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        HashSet fileds;
        String entryFieldName;
        if (this.isIgnoreChangeListener.booleanValue()) {
            return;
        }
        String key = e.getProperty().getName();
        Object oldObj = e.getChangeSet()[0].getOldValue();
        Object newObj = e.getChangeSet()[0].getNewValue();
        int currentIndex = this.getSelectEntryRowIndex();
        switch (key) {
            case "warehouse2": {
                if (newObj != null && ((DynamicObject)newObj).getBoolean("isopenlocation")) {
                    this.getView().setEnable(Boolean.TRUE, e.getChangeSet()[0].getRowIndex(), new String[]{"position2"});
                    break;
                }
                if (e.getChangeSet()[0].getRowIndex() < 0) {
                    this.getView().setEnable(Boolean.FALSE, 0, new String[]{"position2"});
                    break;
                }
                this.getView().setEnable(Boolean.FALSE, e.getChangeSet()[0].getRowIndex(), new String[]{"position2"});
                this.getModel().setValue("position2", null, e.getChangeSet()[0].getRowIndex());
                break;
            }
            case "warehouse3": {
                if (newObj != null && ((DynamicObject)newObj).getBoolean("isopenlocation")) {
                    this.getView().setEnable(Boolean.TRUE, e.getChangeSet()[0].getRowIndex(), new String[]{"position3"});
                    break;
                }
                if (e.getChangeSet()[0].getRowIndex() < 0) {
                    this.getView().setEnable(Boolean.FALSE, 0, new String[]{"position3"});
                    break;
                }
                this.getView().setEnable(Boolean.FALSE, e.getChangeSet()[0].getRowIndex(), new String[]{"position3"});
                this.getModel().setValue("position3", null, e.getChangeSet()[0].getRowIndex());
                break;
            }
            case "inwarehouseorg3": {
                if (newObj == null || oldObj == null || ((DynamicObject)oldObj).getPkValue().toString().equals(((DynamicObject)newObj).getPkValue().toString())) break;
                this.getModel().setValue("warehouse3", null, e.getChangeSet()[0].getRowIndex());
                break;
            }
            case "isreworkreport": {
                if (newObj == null || !((Boolean)newObj).booleanValue()) break;
                String oprentryid = (String)this.getModel().getValue("oprentryid", e.getChangeSet()[0].getRowIndex());
                Boolean firstinspection = (Boolean)this.getModel().getValue("firstinspection", e.getChangeSet()[0].getRowIndex());
                String inspectiontype = (String)this.getModel().getValue("inspectiontype", e.getChangeSet()[0].getRowIndex());
                DynamicObject manuftech = BusinessDataServiceHelper.loadSingle((String)"sfc_manftech", (String)"id,oprentryentity.oprtotalreworkqty,oprentryentity.pushreworkreportqty", (QFilter[])new QFilter[]{new QFilter("oprentryentity.id", "=", (Object)Long.valueOf(oprentryid))});
                if (manuftech == null) break;
                DynamicObjectCollection oprentryentitys = manuftech.getDynamicObjectCollection("oprentryentity");
                for (DynamicObject oprentry : oprentryentitys) {
                    if (!oprentryid.equals(oprentry.getPkValue().toString())) continue;
                    DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("sumentry");
                    String currententryPK = ((DynamicObject)entryEntity.get(e.getChangeSet()[0].getRowIndex())).getPkValue().toString();
                    BigDecimal qty = this.getReworkqty(currententryPK, oprentry);
                    this.getModel().setValue("completqty", (Object)qty, e.getChangeSet()[0].getRowIndex());
                    if (firstinspection.booleanValue() || !"1011".equals(inspectiontype)) continue;
                    this.getModel().setValue("qualifyqty", (Object)qty, e.getChangeSet()[0].getRowIndex());
                }
                break;
            }
            case "completqty": {
                if (!(newObj instanceof BigDecimal)) break;
                String oprentryId = (String)this.getModel().getValue("oprentryid", e.getChangeSet()[0].getRowIndex());
                BigDecimal value = this.calBaseQty(oprentryId, (BigDecimal)newObj);
                this.getModel().beginInit();
                this.getModel().setValue("completbaseqty", (Object)value, e.getChangeSet()[0].getRowIndex());
                this.getModel().endInit();
                this.getModel().setValue("entrycompletbaseqty", (Object)value);
                break;
            }
            case "qualifyqty": {
                if (!(newObj instanceof BigDecimal)) break;
                String oprentryId = (String)this.getModel().getValue("oprentryid", e.getChangeSet()[0].getRowIndex());
                BigDecimal value = this.calBaseQty(oprentryId, (BigDecimal)newObj);
                this.getModel().beginInit();
                this.getModel().setValue("qualifybaseqty", (Object)value, e.getChangeSet()[0].getRowIndex());
                this.getModel().endInit();
                this.getModel().setValue("entryqualifybaseqty", (Object)value);
                break;
            }
            case "receiveqty": {
                if (!(newObj instanceof BigDecimal)) break;
                String oprentryId = (String)this.getModel().getValue("oprentryid", e.getChangeSet()[0].getRowIndex());
                BigDecimal value = this.calBaseQty(oprentryId, (BigDecimal)newObj);
                this.getModel().beginInit();
                this.getModel().setValue("receivebaseqty", (Object)value, e.getChangeSet()[0].getRowIndex());
                this.getModel().endInit();
                this.getModel().setValue("entryreceivebaseqty", (Object)value);
                break;
            }
            case "workwasteqty": {
                if (!(newObj instanceof BigDecimal)) break;
                String oprentryId = (String)this.getModel().getValue("oprentryid", e.getChangeSet()[0].getRowIndex());
                BigDecimal value = this.calBaseQty(oprentryId, (BigDecimal)newObj);
                this.getModel().beginInit();
                this.getModel().setValue("workwastebaseqty", (Object)value, e.getChangeSet()[0].getRowIndex());
                this.getModel().endInit();
                this.getModel().setValue("entryworkwastebaseqty", (Object)value);
                break;
            }
            case "scrapqty": {
                if (!(newObj instanceof BigDecimal)) break;
                String oprentryId = (String)this.getModel().getValue("oprentryid", e.getChangeSet()[0].getRowIndex());
                BigDecimal value = this.calBaseQty(oprentryId, (BigDecimal)newObj);
                this.getModel().beginInit();
                this.getModel().setValue("scrapbaseqty", (Object)value, e.getChangeSet()[0].getRowIndex());
                this.getModel().endInit();
                this.getModel().setValue("entryscrapbaseqty", (Object)value);
                break;
            }
            case "junkqty": {
                if (!(newObj instanceof BigDecimal)) break;
                String oprentryId = (String)this.getModel().getValue("oprentryid", e.getChangeSet()[0].getRowIndex());
                BigDecimal value = this.calBaseQty(oprentryId, (BigDecimal)newObj);
                this.getModel().beginInit();
                this.getModel().setValue("junkbaseqty", (Object)value, e.getChangeSet()[0].getRowIndex());
                this.getModel().endInit();
                this.getModel().setValue("entryjunkbaseqty", (Object)value);
                break;
            }
            case "repairqty": {
                if (!(newObj instanceof BigDecimal)) break;
                String oprentryId = (String)this.getModel().getValue("oprentryid", e.getChangeSet()[0].getRowIndex());
                BigDecimal value = this.calBaseQty(oprentryId, (BigDecimal)newObj);
                this.getModel().beginInit();
                this.getModel().setValue("repairbaseqty", (Object)value, e.getChangeSet()[0].getRowIndex());
                this.getModel().endInit();
                this.getModel().setValue("entryrepairbaseqty", (Object)value);
                break;
            }
            case "checkreworkqty": {
                if (!(newObj instanceof BigDecimal)) break;
                String oprentryId = (String)this.getModel().getValue("oprentryid", e.getChangeSet()[0].getRowIndex());
                BigDecimal value = this.calBaseQty(oprentryId, (BigDecimal)newObj);
                this.getModel().beginInit();
                this.getModel().setValue("checkreworkbaseqty", (Object)value, e.getChangeSet()[0].getRowIndex());
                this.getModel().endInit();
                this.getModel().setValue("entrycheckreworkbaseqty", (Object)value);
                break;
            }
            case "starttime": {
                DynamicObject repWorkUnit1 = (DynamicObject)this.getModel().getValue("repworkunit", e.getChangeSet()[0].getRowIndex());
                Date closeTime = (Date)this.getModel().getValue("closetime", e.getChangeSet()[0].getRowIndex());
                if (closeTime == null || newObj == null || repWorkUnit1 == null) break;
                this.getModel().setValue("actconsumedhours", (Object)this.calDate((Date)newObj, closeTime, repWorkUnit1), e.getChangeSet()[0].getRowIndex());
                break;
            }
            case "closetime": {
                DynamicObject repWorkUnit2 = (DynamicObject)this.getModel().getValue("repworkunit", e.getChangeSet()[0].getRowIndex());
                Date startTime = (Date)this.getModel().getValue("starttime", e.getChangeSet()[0].getRowIndex());
                if (startTime == null || newObj == null || repWorkUnit2 == null) break;
                this.getModel().setValue("actconsumedhours", (Object)this.calDate(startTime, (Date)newObj, repWorkUnit2), e.getChangeSet()[0].getRowIndex());
                break;
            }
            case "actconsumedhours": {
                this.calHours(e);
                this.calTime(this.getModel().getEntryEntity("repsubentryentity"));
                break;
            }
            case "opactivity": {
                this.calHours(e);
                this.calTime(this.getModel().getEntryEntity("repsubentryentity"));
                break;
            }
            case "operator": {
                break;
            }
        }
        if (currentIndex > -1 && StringUtils.isNotEmpty((CharSequence)(entryFieldName = this.getFiledMaps().get(key))) && currentIndex >= 0) {
            if (newObj instanceof LocaleDynamicObjectCollection) {
                LocaleDynamicObjectCollection locales = (LocaleDynamicObjectCollection)newObj;
                String str = locales.size() > 0 ? ((DynamicObject)locales.get(0)).getString(key) : "";
                this.getModel().setValue(entryFieldName, (Object)str, currentIndex);
            } else {
                this.getModel().setValue(entryFieldName, newObj, currentIndex);
            }
        }
        if ((fileds = Sets.newHashSet((Object[])new String[]{"checkreworkqty", "repairqty", "junkqty", "scrapqty", "workwasteqty", "receiveqty", "qualifyqty", "completqty"})).contains(key)) {
            this.calRepActualQty(currentIndex);
        }
    }

    private void calRepActualQty(int currentIndex) {
        DynamicObjectCollection entryEntity1 = this.getModel().getEntryEntity("repsubentryentity");
        if (entryEntity1 != null) {
            this.isIgnoreChangeListener = Boolean.TRUE;
            DynamicObjectCollection repsubentrys = this.getModel().getEntryEntity("repsubentryentity");
            String processseq = this.getModel().getValue("processseq", currentIndex) + "";
            String oprno = this.getModel().getValue("oprno", currentIndex) + "";
            if (repsubentrys != null && repsubentrys.size() > 0) {
                for (DynamicObject repentry : repsubentrys) {
                    if (this.runFormula(repentry)) continue;
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u6d3b\u52a8\u5206\u5f55\u7b2c%1$s\u884c\u6d3b\u52a8\u516c\u5f0f\u6267\u884c\u5931\u8d25,\u8bf7\u68c0\u67e5\u516c\u5f0f\u8bed\u6cd5\u662f\u5426\u6b63\u786e\uff08\u5de5\u5e8f\u5e8f\u5217\uff1a%2$s\uff1b\u5de5\u5e8f\u53f7\uff1a%3$s\uff09\u3002", (String)"SFCProcessReportBillEdit_8", (String)"mmc-sfc-formplugin", (Object[])new Object[0]), repentry.getLong("seq"), processseq, oprno));
                }
                this.getView().updateView("repsubentryentity");
            }
            this.isIgnoreChangeListener = Boolean.FALSE;
        }
    }

    private BigDecimal calBaseQty(String oprentryId, BigDecimal newvalue) {
        Map manftechByEntryId = QueryOrderUtil.getManftechByEntryId(Sets.newHashSet((Object[])new String[]{oprentryId}).stream().map(NumberUtils::toLong).filter(v -> v > 0L).collect(Collectors.toSet()));
        Map map = (Map)manftechByEntryId.get(NumberUtils.toLong((String)oprentryId));
        BigDecimal value = OprUnitHelper.getBaseQty((Map)map, (BigDecimal)newvalue);
        return value;
    }

    private BigDecimal calDate(Date startTime, Date closeTime, DynamicObject repWorkUnit) {
        Duration between = Duration.between(startTime.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime(), closeTime.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
        BigDecimal seconds = new BigDecimal(between.getSeconds() + "");
        BigDecimal hours = seconds.divide(new BigDecimal("3600"), repWorkUnit.getInt("precision"), UnitRateConvertUtil.getUnitPrecisionAccount((String)repWorkUnit.getString("precisionaccount")));
        return hours;
    }

    private void calHours(PropertyChangedArgs e) {
        DynamicObjectCollection entity = this.getModel().getEntryEntity("childreportentity");
        BigDecimal reduce1 = entity.stream().filter(x -> "A".equals(x.getString("opactivity"))).map(x -> x.getBigDecimal("actconsumedhours")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal reduce2 = entity.stream().filter(x -> "B".equals(x.getString("opactivity"))).map(x -> x.getBigDecimal("actconsumedhours")).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.getModel().setValue("totalconsumedhours", (Object)reduce1, e.getChangeSet()[0].getParentRowIndex());
        this.getModel().setValue("totalinspectionhours", (Object)reduce2, e.getChangeSet()[0].getParentRowIndex());
    }

    private void calTime(DynamicObjectCollection entryEntity) {
        BigDecimal decimal = new BigDecimal("1");
        DynamicObjectCollection entity = this.getModel().getEntryEntity("childreportentity");
        BigDecimal reduce1 = entity.stream().filter(x -> "A".equals(x.getString("opactivity"))).map(x -> x.getBigDecimal("actconsumedhours")).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal reduce2 = entity.stream().filter(x -> "B".equals(x.getString("opactivity"))).map(x -> x.getBigDecimal("actconsumedhours")).reduce(BigDecimal.ZERO, BigDecimal::add);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject repActivity = ((DynamicObject)entryEntity.get(i)).getDynamicObject("repactivity");
            if (repActivity == null || repActivity.getDynamicObject("unit") == null) continue;
            DynamicObject unit = repActivity.getDynamicObject("unit");
            if ("minute".equals(unit.getString("number"))) {
                decimal = new BigDecimal("60");
            } else if ("second".equals(unit.getString("number"))) {
                decimal = new BigDecimal("3600");
            }
            this.getModel().setValue("actchours", (Object)reduce1.multiply(decimal), i);
            this.getModel().setValue("actihours", (Object)reduce2.multiply(decimal), i);
        }
    }

    private BigDecimal getReworkqty(String currententryPK, DynamicObject oprentry) {
        BigDecimal qty = oprentry.getBigDecimal("oprtotalreworkqty").subtract(oprentry.getBigDecimal("pushreworkreportqty"));
        boolean exists = QueryServiceHelper.exists((String)"sfc_processreportbill", (Object)this.getModel().getDataEntity().getPkValue());
        if (exists) {
            DynamicObject reportbill = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getDataEntity().getPkValue(), (String)"sfc_processreportbill");
            DynamicObjectCollection sumentrys = reportbill.getDynamicObjectCollection("sumentry");
            for (DynamicObject sumentry : sumentrys) {
                if (!sumentry.getPkValue().toString().equals(currententryPK) || !sumentry.getBoolean("isreworkreport")) continue;
                qty = qty.add(sumentry.getBigDecimal("completqty"));
                break;
            }
        }
        return qty;
    }

    private boolean runFormula(DynamicObject repentry) {
        boolean success = false;
        DynamicObject actstandardformula = repentry.getDynamicObject("actstandardformula");
        if (actstandardformula != null) {
            String formulaStr = actstandardformula.getString("formula");
            if (StringUtils.isBlank((CharSequence)formulaStr)) {
                return false;
            }
            HashMap<String, DynamicObject> varValues = new HashMap<String, DynamicObject>();
            DynamicObjectCollection repentrys = new DynamicObjectCollection();
            DynamicObject sumentry = (DynamicObject)OrmUtils.clone((IDataEntityBase)((DynamicObject)repentry.getParent()), (boolean)false, (boolean)true);
            repentrys.add((Object)((DynamicObject)OrmUtils.clone((IDataEntityBase)repentry, (boolean)false, (boolean)true)));
            sumentry.set("repsubentryentity", (Object)repentrys);
            DynamicObject cloneProcessReport = (DynamicObject)OrmUtils.clone((IDataEntityBase)((IDataEntityBase)((DynamicObject)repentry.getParent()).getParent()), (boolean)false, (boolean)true);
            DynamicObjectCollection dynamicObjectCollection = cloneProcessReport.getDynamicObjectCollection("sumentry");
            dynamicObjectCollection.clear();
            dynamicObjectCollection.add((Object)sumentry);
            varValues.put("sfc_processreportbill", cloneProcessReport);
            try {
                FormulaEngine.registerFunctions((IFormulaFunctions)new SFCCustFormulaFuntions());
                Object result = FormulaEngine.runFormula((String)formulaStr, varValues);
                repentry.set("repactualqty", result);
                success = true;
            }
            catch (Exception exp) {
                logger.error(String.format("\u516c\u5f0f\u8ba1\u7b97\u65f6\u51fa\u73b0\u5f02\u5e38 - \u53c2\u65701 %s  \u53c2\u65702 %s ", formulaStr, ((Object)varValues).toString()), (Throwable)exp);
            }
        }
        return success;
    }

    public int getSelectEntryRowIndex() {
        int currentEntryIndex = -1;
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("sumentry");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows != null && selectRows.length > 0) {
            currentEntryIndex = selectRows[0];
        }
        return currentEntryIndex;
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (StringUtils.equals((CharSequence)"sumentry", (CharSequence)entryGrid.getKey())) {
            DynamicObject entryentity = this.getModel().getEntryRowEntity("sumentry", evt.getRow());
            this.showEntryDetial(entryentity);
            this.setEntryEnable();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        this.setEntryEnable();
    }

    protected void showEntryDetial(DynamicObject entryentity) {
        this.isIgnoreChangeListener = Boolean.TRUE;
        IDataModel model = this.getModel();
        if (entryentity != null) {
            Map<String, String> filedMaps = this.getFiledMaps();
            for (Map.Entry<String, String> key : filedMaps.entrySet()) {
                model.setValue(key.getKey(), entryentity.get(key.getValue()));
            }
            if (StringUtils.equals((CharSequence)this.getModel().getValue("billstatus").toString(), (CharSequence)"A")) {
                this.setControlState(Boolean.TRUE);
            } else {
                this.setControlState(Boolean.FALSE);
            }
        } else {
            Map<String, String> fieldMaps = this.getFiledMaps();
            for (String key : fieldMaps.keySet()) {
                model.setValue(key, null);
            }
        }
        this.isIgnoreChangeListener = Boolean.FALSE;
    }

    protected void setControlState(Boolean flag) {
        this.getView().setEnable(flag, new String[]{"entryreporttype", "entryremark"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"previousentry") || StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"nextentry")) {
            DynamicObject entryentity = this.getModel().getEntryRowEntity("sumentry", this.getSelectEntryRowIndex());
            this.showEntryDetial(entryentity);
        } else if ("deleteentryuser".equals(key)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("childreportentity");
            BigDecimal reduce1 = entryEntity.stream().filter(x -> "A".equals(x.getString("opactivity"))).map(x -> x.getBigDecimal("actconsumedhours")).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal reduce2 = entryEntity.stream().filter(x -> "B".equals(x.getString("opactivity"))).map(x -> x.getBigDecimal("actconsumedhours")).reduce(BigDecimal.ZERO, BigDecimal::add);
            DynamicObject parent = (DynamicObject)entryEntity.getParent();
            parent.set("totalconsumedhours", (Object)reduce1);
            parent.set("totalinspectionhours", (Object)reduce2);
            this.calTime(this.getModel().getEntryEntity("repsubentryentity"));
            this.getView().updateView("sumentry");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "save": {
                for (DynamicObject sumentry : this.getModel().getEntryEntity("sumentry")) {
                    for (DynamicObject subentry : sumentry.getDynamicObjectCollection("subentryentity1")) {
                        if (subentry.getDynamicObject("material3") == null || !subentry.getDynamicObject("material3").getDynamicObject("masterid").getBoolean("enablelot") || subentry.get("batchno3") != null) continue;
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5de5\u5e8f\u6c47\u62a5\u5355\uff08\u7f16\u53f7\uff1a%1$s\uff09\u6c47\u603b\u660e\u7ec6\u7b2c%2$s\u884c\u7684\u5b8c\u5de5\u5165\u5e93\u5217\u8868\u7b2c%3$s\u884c\uff0c\u8bf7\u586b\u5199\u201c\u6279\u53f7\u201d\u3002", (String)"SFCProcessReportBillEdit_1", (String)"mmc-sfc-formplugin", (Object[])new Object[0]), this.getModel().getValue("billno").toString(), sumentry.getString("seq"), subentry.getString("seq")));
                    }
                }
                break;
            }
            case "audit": {
                FormOperate source = (FormOperate)args.getSource();
                source.getOption().setVariableValue("processreportaudit", "true");
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String source;
        Control con = (Control)beforeF7SelectEvent.getSource();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        switch (source = con.getKey()) {
            case "inwarconsigner3": {
                listShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
                listShowParameter.setMultiSelect(false);
                this.setListShowParameter(beforeF7SelectEvent);
                Object ownertype = this.getModel().getValue("ownertype3");
                if (ownertype == null || !"bos_org".equals(ownertype.toString()) || this.getModel().getValue("inwarehouseorg3") == null) break;
                DynamicObject inwarehouseorg3 = (DynamicObject)this.getModel().getValue("inwarehouseorg3");
                List idList = OrgUnitServiceHelper.getFromOrgs((String)"05", (Long)inwarehouseorg3.getLong("id"), (String)"10");
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)idList));
                listShowParameter.setCaption(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"SFCProcessReportBillEdit_5", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
                break;
            }
            case "inwarconsigner2": {
                listShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
                listShowParameter.setMultiSelect(false);
                Object ownertype2 = this.getModel().getValue("ownertype2");
                if (ownertype2 == null || !"bos_org".equals(ownertype2.toString()) || this.getModel().getValue("inwarehouseorg2") == null) break;
                DynamicObject inwarehouseorg2 = (DynamicObject)this.getModel().getValue("inwarehouseorg2");
                List idList = OrgUnitServiceHelper.getFromOrgs((String)"05", (Long)inwarehouseorg2.getLong("id"), (String)"10");
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)idList));
                break;
            }
            case "inwarehouseorg3": {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (org != null) {
                    listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", this.getInwareOrgFilter((Long)org.getPkValue())));
                }
            }
            case "inwarehouseorg2": {
                DynamicObject org1 = (DynamicObject)this.getModel().getValue("org");
                if (org1 == null) break;
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", this.getInwareOrgFilter((Long)org1.getPkValue())));
                break;
            }
            case "warehouse2": {
                ListShowParameter parameter;
                DynamicObject inOrg2 = (DynamicObject)this.getModel().getValue("inwarehouseorg2");
                if (inOrg2 == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u5165\u5e93\u7ec4\u7ec7\u201d\u7684\u503c\u3002", (String)"SFCProcessReportBillEdit_6", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                Long[] warehouseIds = WarehouseHelper.getAllWarehouseIDs((Long)NumberUtils.toLong((String)inOrg2.getPkValue().toString()));
                ArrayList<Long> ids = new ArrayList<Long>();
                for (Long id : warehouseIds) {
                    if (id == null) continue;
                    ids.add(id);
                }
                if (CollectionUtils.isNotEmpty(ids)) {
                    parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    QFilter qfilter = new QFilter("id", "in", ids);
                    parameter.getListFilterParameter().getQFilters().add(qfilter);
                } else {
                    parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    QFilter qfilter = new QFilter("id", "=", (Object)0L);
                    parameter.getListFilterParameter().getQFilters().add(qfilter);
                }
                this.setListShowParameter(beforeF7SelectEvent);
                break;
            }
            case "warehouse3": {
                ListShowParameter parameter;
                DynamicObject inOrg3 = (DynamicObject)this.getModel().getValue("inwarehouseorg3");
                if (inOrg3 == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u5165\u5e93\u7ec4\u7ec7\u201d\u7684\u503c\u3002", (String)"SFCProcessReportBillEdit_6", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                Long[] warehouseId = WarehouseHelper.getAllWarehouseIDs((Long)NumberUtils.toLong((String)inOrg3.getPkValue().toString()));
                ArrayList<Long> idList = new ArrayList<Long>();
                for (Long id : warehouseId) {
                    if (id == null) continue;
                    idList.add(id);
                }
                if (CollectionUtils.isNotEmpty(idList)) {
                    parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    QFilter qfilter = new QFilter("id", "in", idList);
                    parameter.getListFilterParameter().getQFilters().add(qfilter);
                } else {
                    parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                    QFilter qfilter = new QFilter("id", "=", (Object)0L);
                    parameter.getListFilterParameter().getQFilters().add(qfilter);
                }
                this.setListShowParameter(beforeF7SelectEvent);
                break;
            }
            case "position2": {
                listShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
                listShowParameter.setMultiSelect(false);
                DynamicObject warehouse2 = (DynamicObject)this.getModel().getValue("warehouse2");
                this.positionFilter(listShowParameter, warehouse2, beforeF7SelectEvent);
                break;
            }
            case "position3": {
                listShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
                listShowParameter.setMultiSelect(false);
                DynamicObject warehouse3 = (DynamicObject)this.getModel().getValue("warehouse3");
                this.positionFilter(listShowParameter, warehouse3, beforeF7SelectEvent);
                break;
            }
            case "qualityorg": {
                this.filterQualityOrg(beforeF7SelectEvent);
            }
        }
    }

    private void filterQualityOrg(BeforeF7SelectEvent evt) {
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        listShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
        listShowParameter.setMultiSelect(false);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("sumentry");
        if (entryGrid.getSelectRows().length == 0) {
            return;
        }
        DynamicObject mftOrderReportBill = this.getModel().getDataEntity();
        DynamicObject mftOrg = (DynamicObject)mftOrderReportBill.get("org");
        if (null == mftOrg) {
            return;
        }
        Long mftOrgId = mftOrg.getLong("id");
        List rangeList = OrderQualityOrgService.queryFisqcRangeList((Long)mftOrgId, (String)"fisqc", (String)"06");
        if (CollectionUtils.isNotEmpty((Collection)rangeList)) {
            QFilter qfilter = new QFilter("id", "in", (Object)rangeList);
            listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
        }
    }

    private void positionFilter(ListShowParameter listShowParameter, DynamicObject warehouse3, BeforeF7SelectEvent event) {
        if (warehouse3 != null && warehouse3.getBoolean("isopenlocation")) {
            DynamicObjectCollection entryentity = warehouse3.getDynamicObjectCollection("entryentity");
            List id = entryentity.stream().map(x -> x.getDynamicObject("location").getPkValue()).collect(Collectors.toList());
            if (!id.isEmpty()) {
                listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", id));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed3\u5e93\u4e3a\u7a7a\uff0c\u6216\u6b64\u4ed3\u5e93\u672a\u542f\u7528\u4ed3\u4f4d\u3002", (String)"SFCProcessReportBillEdit_7", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
        }
    }

    private void setListShowParameter(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        listShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
        listShowParameter.setMultiSelect(false);
    }

    private void setEntryEnable() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObjectCollection subentryentity1 = model.getEntryEntity("subentryentity1");
        if (subentryentity1 == null) {
            return;
        }
        for (int i = 0; i < subentryentity1.size(); ++i) {
            Object masterid;
            Object object = masterid = ((DynamicObject)subentryentity1.get(i)).getDynamicObject("material3") == null ? null : ((DynamicObject)subentryentity1.get(i)).getDynamicObject("material3").getDynamicObject("masterid").getPkValue();
            if (masterid == null) continue;
            DynamicObject bd_materialinventoryinfo = BusinessDataServiceHelper.loadSingle((String)"bd_materialinventoryinfo", (String)"id,enablelot", (QFilter[])new QFilter[]{new QFilter("id", "=", masterid)});
            if (bd_materialinventoryinfo != null && bd_materialinventoryinfo.getBoolean("enablelot")) {
                view.setEnable(Boolean.valueOf(true), i, new String[]{"batchno3"});
                continue;
            }
            view.setEnable(Boolean.valueOf(false), i, new String[]{"batchno3"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("sumentry");
        int rowcount = this.getModel().getEntryRowCount("sumentry");
        if (entryGrid != null && rowcount > 0) {
            entryGrid.selectRows(0, true);
            DynamicObject entryentity = this.getModel().getEntryRowEntity("sumentry", 0);
            this.showEntryDetial(entryentity);
        }
        this.setEntryEnable();
        Object isOmSfc = null;
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null && parentView.getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter formShowParameter = (ListShowParameter)parentView.getFormShowParameter();
            isOmSfc = formShowParameter.getCustomParam("isOmSfc");
        }
        if ("true".equals(isOmSfc)) {
            this.getView().setFormTitle(new LocaleString(ResManager.loadKDString((String)"\u5de5\u5e8f\u59d4\u5916\u6c47\u62a5\u5355", (String)"SFCProcessReportBillEdit_9", (String)"mmc-sfc-formplugin", (Object[])new Object[0])));
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        this.setEntryEnable();
        String entityName = e.getEntryProp().getName();
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_manuperson", (String)"id", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId())});
        if ("childreportentity".equals(entityName)) {
            this.getModel().setValue("repworkunit", this.getModel().getValue("workunit", e.getParentRow()), e.getRowDataEntities()[0].getRowIndex());
            this.getModel().setValue("operator", (Object)object, e.getRowDataEntities()[0].getRowIndex());
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    private List<Long> getInwareOrgFilter(Long mftOrg) {
        ArrayList<Long> filterList = new ArrayList<Long>();
        List fromOrgs = OrgUnitServiceHelper.getFromOrgs((String)"04", (Long)mftOrg, (String)"10");
        if (fromOrgs.isEmpty()) {
            Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)mftOrg, (Boolean)false, (Boolean)true);
            Integer fromOrg = map == null || map.isEmpty() ? Integer.valueOf(0) : map.get("id");
            Long longFromOrg = (Long)((Object)fromOrg);
            List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)longFromOrg, (boolean)true);
            if (!allToOrg.isEmpty()) {
                filterList.addAll(allToOrg);
            }
        } else {
            Long fromOrg = (Long)fromOrgs.get(0);
            List allToOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"05", (Long)fromOrg, (boolean)true);
            if (!allToOrg.isEmpty()) {
                filterList.addAll(allToOrg);
            }
        }
        return filterList;
    }

    public void afterCreateNewData(EventObject e) {
        ListShowParameter formShowParameter;
        String billFormId;
        super.afterCreateNewData(e);
        if (this.getView().getParentView() != null && this.getView().getParentView().getFormShowParameter() instanceof ListShowParameter && "sfc_mroprocessreport".equals(billFormId = (String)(formShowParameter = (ListShowParameter)this.getView().getParentView().getFormShowParameter()).getCustomParam("billFormId"))) {
            this.getModel().setValue("staffreport", (Object)"hours");
        }
    }

    private Map<String, String> getFiledMaps() {
        HashMap<String, String> fieldMaps = new HashMap<String, String>(256);
        fieldMaps.put("entrymanufacturenun", "manufacturenun");
        fieldMaps.put("entrymanufacturerow", "manufacturerow");
        fieldMaps.put("entrymanufacturenun1", "manufacturenun");
        fieldMaps.put("entrymanufacturerow1", "manufacturerow");
        fieldMaps.put("entryauxproperty", "auxproperty");
        fieldMaps.put("entryreporttype", "reporttype");
        fieldMaps.put("entryremark", "remarks");
        fieldMaps.put("entrybatchno", "batchno");
        fieldMaps.put("entrylot", "lot");
        fieldMaps.put("entryresource", "resource");
        fieldMaps.put("entrymfttechnics", "mfttechnics");
        fieldMaps.put("entryprocessseq", "processseq");
        fieldMaps.put("entryoprno", "oprno");
        fieldMaps.put("entryopra", "opra");
        fieldMaps.put("entryconfirmoprstatus", "confirmoprstatus");
        fieldMaps.put("entryseqreportctrl", "seqreportctrl");
        fieldMaps.put("productid", "material");
        fieldMaps.put("entrybaseunit", "baseunit");
        fieldMaps.put("entryphinspectionbaseqty", "pushinspectionbaseqty");
        fieldMaps.put("entryinspectionbaseqty", "inspectionbaseqty");
        fieldMaps.put("entrycompletbaseqty", "completbaseqty");
        fieldMaps.put("entryqualifybaseqty", "qualifybaseqty");
        fieldMaps.put("entryreceivebaseqty", "receivebaseqty");
        fieldMaps.put("entryworkwastebaseqty", "workwastebaseqty");
        fieldMaps.put("entryscrapbaseqty", "scrapbaseqty");
        fieldMaps.put("entryjunkbaseqty", "junkbaseqty");
        fieldMaps.put("entryrepairbaseqty", "repairbaseqty");
        fieldMaps.put("entrycheckreworkbaseqty", "checkreworkbaseqty");
        fieldMaps.put("entrytotalcompletqty", "totalcompletqty");
        fieldMaps.put("entrytotalqualifyqty", "totalqualifyqty");
        fieldMaps.put("entrytotalworkwasteqty", "totalworkwasteqty");
        fieldMaps.put("entrytotalscrapqty", "totalscrapqty");
        fieldMaps.put("entryreworkmethod", "reworkmethod");
        fieldMaps.put("entrymanufacturenun2", "manufacturenun");
        fieldMaps.put("entrymanufacturerow2", "manufacturerow");
        fieldMaps.put("entrymfttechnics2", "mfttechnics");
        fieldMaps.put("entryprocessseq2", "processseq");
        fieldMaps.put("entryoprno2", "oprno");
        fieldMaps.put("entryopra2", "opra");
        return fieldMaps;
    }
}

