/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.formplugin.protransfer;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bd.mpdm.business.manuftech.OprUnitHelper;
import kd.bd.mpdm.business.mftorder.OrderQualityOrgService;
import kd.bd.mpdm.common.consts.ProtransferBillConsts;
import kd.bd.mpdm.common.enums.ProtransferBiztypeEnum;
import kd.bd.mpdm.common.manuftech.utils.MftOrderReportTplUtils;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.UnitConvertHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ProtransferBillEdit
extends AbstractBillPlugIn
implements RowClickEventListener,
BeforeF7SelectListener {
    protected Boolean isIgnoreChangeListener = Boolean.FALSE;

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (StringUtils.equals((CharSequence)"outentryentity", (CharSequence)entryGrid.getKey())) {
            DynamicObject entryentity = this.getModel().getEntryRowEntity("outentryentity", evt.getRow());
            this.showEntryDetial(entryentity);
            this.showPropertyByTransfertype(evt.getRow());
        }
        if (StringUtils.equals((CharSequence)"inentryentity", (CharSequence)entryGrid.getKey())) {
            this.selectOutEntryRow(evt.getRow());
        }
    }

    private void selectOutEntryRow(int index) {
        Integer outrow = -1;
        EntryGrid outentry = (EntryGrid)this.getView().getControl("outentryentity");
        if (index >= 0) {
            outrow = this.getOutEntryRow(index);
        }
        outentry.selectRows(outrow.intValue());
        DynamicObject entryentity = this.getModel().getEntryRowEntity("outentryentity", outrow.intValue());
        this.showEntryDetial(entryentity);
        this.showPropertyByTransfertype(outrow);
    }

    protected void showEntryDetial(DynamicObject entryentity) {
        this.isIgnoreChangeListener = Boolean.TRUE;
        IDataModel model = this.getModel();
        if (entryentity != null) {
            Map<String, String> fieldMaps = this.getFiledMaps();
            for (Map.Entry<String, String> key : fieldMaps.entrySet()) {
                model.setValue(key.getKey(), entryentity.get(key.getValue()));
            }
        } else {
            Map<String, String> fieldMaps = this.getFiledMaps();
            for (String key : fieldMaps.keySet()) {
                model.setValue(key, null);
            }
        }
        this.isIgnoreChangeListener = Boolean.FALSE;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"inprocess"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("outentryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        EntryGrid inentryGrid = (EntryGrid)this.getView().getControl("inentryentity");
        inentryGrid.addRowClickListener((RowClickEventListener)this);
        BasedataEdit qualityOrg = (BasedataEdit)this.getView().getControl("qualityorg1");
        if (qualityOrg != null) {
            qualityOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        this.isIgnoreChangeListener = Boolean.TRUE;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("outentryentity");
        int rowcount = this.getModel().getEntryRowCount("outentryentity");
        if (entryGrid != null && rowcount > 0) {
            entryGrid.selectRows(0, true);
            DynamicObject entryentity = this.getModel().getEntryRowEntity("outentryentity", 0);
            this.showEntryDetial(entryentity);
            this.showPropertyByTransfertype(0);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"inspectiontype1", "qualityorg1", "pushinspectionbaseqty1", "inspectionbaseqty1"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"tabpageap3"});
        }
    }

    private void showPropertyByTransfertype(int i) {
        if (i >= 0) {
            Boolean isshow = Boolean.FALSE;
            Boolean iswhpoint = Boolean.FALSE;
            String transfertype = (String)this.getModel().getValue("transfertype", i);
            String biztype = (String)this.getModel().getValue("biztype", i);
            if (ProtransferBiztypeEnum.SEQUENCE.getValue().equals(biztype) && ProtransferBillConsts.OUT_TRANSFERTYPE.contains(transfertype)) {
                isshow = Boolean.TRUE;
                iswhpoint = (Boolean)this.getModel().getValue("warehousepoint", i);
            }
            this.getView().setVisible(isshow, new String[]{"inspectiontype1", "qualityorg1", "pushinspectionbaseqty1", "inspectionbaseqty1"});
            this.getView().setVisible(iswhpoint, new String[]{"tabpageap3"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        BigDecimal baseQty;
        int currentIndex;
        String key = e.getProperty().getName();
        if (this.isIgnoreChangeListener.booleanValue()) {
            return;
        }
        if ("transferqty1".equals(key)) {
            currentIndex = this.getModel().getEntryCurrentRowIndex("outentryentity");
            baseQty = this.calBaseQty(currentIndex, "transferqty");
            this.getModel().setValue("transferbaseqty1", (Object)baseQty);
            this.getModel().setValue("transferbaseqty", (Object)baseQty, currentIndex);
        }
        if ("qualifyqty".equals(key)) {
            currentIndex = this.getModel().getEntryCurrentRowIndex("outentryentity");
            baseQty = this.calBaseQty(currentIndex, "outqualifyqty");
            this.getModel().setValue("qualifybaseqty", (Object)baseQty);
            this.getModel().setValue("outqualifybaseqty", (Object)baseQty, currentIndex);
            this.writeInstorage(currentIndex, "qualifyqty");
        }
        if ("receiveqty".equals(key)) {
            currentIndex = this.getModel().getEntryCurrentRowIndex("outentryentity");
            baseQty = this.calBaseQty(currentIndex, "outreceiveqty");
            this.getModel().setValue("receivebaseqty", (Object)baseQty);
            this.getModel().setValue("outreceivebaseqty", (Object)baseQty, currentIndex);
            this.writeInstorage(currentIndex, "receiveqty");
        }
        if ("workwasteqty".equals(key)) {
            currentIndex = this.getModel().getEntryCurrentRowIndex("outentryentity");
            baseQty = this.calBaseQty(currentIndex, "outworkwasteqty");
            this.getModel().setValue("workwastebaseqty", (Object)baseQty);
            this.getModel().setValue("outworkwastebaseqty", (Object)baseQty, currentIndex);
            this.writeInstorage(currentIndex, "workwasteqty");
        }
        if ("scrapqty".equals(key)) {
            currentIndex = this.getModel().getEntryCurrentRowIndex("outentryentity");
            baseQty = this.calBaseQty(currentIndex, "outscrapqty");
            this.getModel().setValue("scrapbaseqty", (Object)baseQty);
            this.getModel().setValue("outscrapbaseqty", (Object)baseQty, currentIndex);
            this.writeInstorage(currentIndex, "scrapqty");
        }
        if ("reworkqty".equals(key)) {
            currentIndex = this.getModel().getEntryCurrentRowIndex("outentryentity");
            baseQty = this.calBaseQty(currentIndex, "outreworkqty");
            this.getModel().setValue("reworkbaseqty", (Object)baseQty);
            this.getModel().setValue("outreworkbaseqty", (Object)baseQty, currentIndex);
            this.writeInstorage(currentIndex, "reworkqty");
        }
        if ("qualityorg1".equals(key)) {
            currentIndex = this.getModel().getEntryCurrentRowIndex("outentryentity");
            this.getModel().setValue("qualityorg", e.getChangeSet()[0].getNewValue(), currentIndex);
        }
    }

    private void writeInstorage(int currentIndex, String key) {
        String transfertype = (String)this.getModel().getValue("transfertype", currentIndex);
        Boolean warehousepoint = (Boolean)this.getModel().getValue("warehousepoint", currentIndex);
        if (ProtransferBillConsts.OUT_TRANSFERTYPE.contains(transfertype) && warehousepoint.booleanValue()) {
            DynamicObject processplan = (DynamicObject)this.getModel().getValue("outprocessplan", currentIndex);
            DynamicObject baseunit = (DynamicObject)this.getModel().getValue("insbaseunit", currentIndex);
            DynamicObject unit = (DynamicObject)this.getModel().getValue("outproductunit", currentIndex);
            if (null != processplan && null != baseunit && null != unit) {
                long material = (Long)processplan.getDynamicObject("material").get("masterid");
                long id = baseunit.getLong("id");
                long unitId = unit.getLong("id");
                if ("qualifyqty".equals(key) || "receiveqty".equals(key)) {
                    BigDecimal conformitybaseqty = ((BigDecimal)this.getModel().getValue("outqualifybaseqty", currentIndex)).add((BigDecimal)this.getModel().getValue("outreceivebaseqty", currentIndex));
                    this.getModel().setValue("conformitybaseqty", (Object)conformitybaseqty, currentIndex);
                    this.getModel().setValue("conformitybaseqty1", (Object)conformitybaseqty);
                    BigDecimal conformityqty = UnitConvertHelper.calculateNewQty((BigDecimal)conformitybaseqty, (Long)unitId, (Long)id, (Long)material, (StringBuilder)new StringBuilder());
                    this.getModel().setValue("conformityqty", (Object)conformityqty, currentIndex);
                    this.getModel().setValue("conformityqty1", (Object)conformityqty);
                }
                if ("workwasteqty".equals(key) || "scrapqty".equals(key)) {
                    BigDecimal discardbaseqty = ((BigDecimal)this.getModel().getValue("outworkwastebaseqty", currentIndex)).add((BigDecimal)this.getModel().getValue("outscrapbaseqty", currentIndex));
                    this.getModel().setValue("discardbaseqty", (Object)discardbaseqty, currentIndex);
                    this.getModel().setValue("discardbaseqty1", (Object)discardbaseqty);
                    BigDecimal discardqty = UnitConvertHelper.calculateNewQty((BigDecimal)discardbaseqty, (Long)unitId, (Long)id, (Long)material, (StringBuilder)new StringBuilder());
                    this.getModel().setValue("discardqty", (Object)discardqty, currentIndex);
                    this.getModel().setValue("discardqty1", (Object)discardqty);
                }
                if ("reworkqty".equals(key)) {
                    BigDecimal badconformitybaseqty = (BigDecimal)this.getModel().getValue("outreworkbaseqty", currentIndex);
                    this.getModel().setValue("badconformitybaseqty", (Object)badconformitybaseqty, currentIndex);
                    this.getModel().setValue("badconformitybaseqty1", (Object)badconformitybaseqty);
                    BigDecimal badconformityqty = UnitConvertHelper.calculateNewQty((BigDecimal)badconformitybaseqty, (Long)unitId, (Long)id, (Long)material, (StringBuilder)new StringBuilder());
                    this.getModel().setValue("badconformityqty", (Object)badconformityqty, currentIndex);
                    this.getModel().setValue("badconformityqty1", (Object)badconformityqty);
                }
            }
        }
    }

    private BigDecimal calBaseQty(int currentIndex, String propertyName) {
        DynamicObject processplan = (DynamicObject)this.getModel().getValue("outprocessplan", currentIndex);
        DynamicObject outprocess = (DynamicObject)this.getModel().getValue("outprocessid", currentIndex);
        BigDecimal qty = (BigDecimal)this.getModel().getValue(propertyName, currentIndex);
        if (null != processplan && null != outprocess) {
            Map map = OprUnitHelper.getManftechMap((DynamicObject)processplan, (DynamicObject)outprocess);
            return OprUnitHelper.getBaseQty((Map)map, (BigDecimal)qty);
        }
        return BigDecimal.ZERO;
    }

    protected Integer getOutEntryRow(int index) {
        String outentryid = this.getModel().getValue("outentryentityid", index).toString();
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("outentryentity");
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String outentryentityid = dynamicObject.getString("id");
            if (!outentryid.equals(outentryentityid)) continue;
            return dynamicObject.getInt("seq") - 1;
        }
        return null;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Control con = (Control)beforeF7SelectEvent.getSource();
        String source = con.getKey();
        if (source.equals("qualityorg1")) {
            this.filterQualityOrg(beforeF7SelectEvent);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate formOperate = (FormOperate)e.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("unbackflush".equals(operateKey)) {
            IFormView view = this.getView();
            EntryGrid grid = (EntryGrid)view.getControl("outentryentity");
            int[] selectRows = grid.getSelectRows();
            if (selectRows.length <= 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ProtransferBillEdit_3", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            ArrayList<Long> entryPks = new ArrayList<Long>(16);
            for (int row : selectRows) {
                entryPks.add((Long)this.getModel().getValue("outentryentity.id", row));
            }
            String entryPksJsonString = SerializationUtils.toJsonString(entryPks);
            formOperate.getOption().setVariableValue("unBackFlushEntryPks", entryPksJsonString);
        }
        if ("backflushout".equals(operateKey)) {
            ArrayList<String> billnos = new ArrayList<String>(1);
            billnos.add(this.getModel().getValue("billno").toString());
            BillShowParameter showParameter = MftOrderReportTplUtils.createAddNewBillShowParam(billnos, (Object)((DynamicObject)this.getModel().getValue("org")).getPkValue());
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        FormOperate formOperate = (FormOperate)e.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("audit".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void filterQualityOrg(BeforeF7SelectEvent evt) {
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        listShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
        listShowParameter.setMultiSelect(false);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("outentryentity");
        if (entryGrid.getSelectRows().length == 0) {
            return;
        }
        DynamicObject protransferBill = this.getModel().getDataEntity();
        DynamicObject mftOrg = (DynamicObject)protransferBill.get("org");
        if (null == mftOrg) {
            return;
        }
        Long mftOrgId = mftOrg.getLong("id");
        List rangeList = OrderQualityOrgService.queryFisqcRangeList((Long)mftOrgId, (String)"fisqc", (String)"06");
        if (CollectionUtils.isNotEmpty((Collection)rangeList)) {
            QFilter qfilter = new QFilter("id", "in", (Object)rangeList);
            listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
        }
    }

    private Map<String, String> getFiledMaps() {
        HashMap<String, String> fieldMaps = new HashMap<String, String>(256);
        fieldMaps.put("inspectiontype1", "inspectiontype");
        fieldMaps.put("qualityorg1", "qualityorg");
        fieldMaps.put("pushinspectionbaseqty1", "pushinspectionbaseqty");
        fieldMaps.put("inspectionbaseqty1", "inspectionbaseqty");
        fieldMaps.put("conformityqty1", "conformityqty");
        fieldMaps.put("badconformityqty1", "badconformityqty");
        fieldMaps.put("discardqty1", "discardqty");
        fieldMaps.put("outproductunit1", "outproductunit");
        fieldMaps.put("insbaseunit1", "insbaseunit");
        fieldMaps.put("conformitybaseqty1", "conformitybaseqty");
        fieldMaps.put("badconformitybaseqty1", "badconformitybaseqty");
        fieldMaps.put("discardbaseqty1", "discardbaseqty");
        fieldMaps.put("pushwarehousebaseqty1", "pushwarehousebaseqty");
        fieldMaps.put("qualifiedinbaseqty1", "qualifiedinbaseqty");
        fieldMaps.put("badqualifiedinbaseqty1", "badqualifiedinbaseqty");
        fieldMaps.put("scrapinbaseqty1", "scrapinbaseqty");
        return fieldMaps;
    }
}

