/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.formplugin.protransfer;

import java.util.ArrayList;
import java.util.HashSet;
import kd.bd.mpdm.common.manuftech.utils.MftOrderReportTplUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ProtransferBillList
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        ListShowParameter showParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String billtype = (String)showParameter.getCustomParam("billtype");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (billtype != null && "protransfer".equals(billtype)) {
            qFilters.add(new QFilter("outentryentity.transfertype", "=", (Object)"11"));
            e.setBasedataCoreQFilters(qFilters);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate formOperate = (FormOperate)e.getSource();
        String key = formOperate.getOperateKey();
        if ("unbackflush".equals(key)) {
            ArrayList<Long> entryPks = new ArrayList<Long>(16);
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selects = billList.getSelectedRows();
            for (ListSelectedRow listSelectedRow : selects) {
                if (listSelectedRow.getEntryPrimaryKeyValue() == null) continue;
                entryPks.add(Long.parseLong(listSelectedRow.getEntryPrimaryKeyValue().toString()));
            }
            String entryPksJsonString = SerializationUtils.toJsonString(entryPks);
            formOperate.getOption().setVariableValue("unBackFlushEntryPks", entryPksJsonString);
        } else if ("backflushout".equals(key)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selects = billList.getSelectedRows();
            Object[] entryPrimaryKeyValues = selects.getPrimaryKeyValues();
            QFilter[] qFilter = new QFilter[]{new QFilter("id", "in", (Object)entryPrimaryKeyValues)};
            String algoKey = "queryProtransfer";
            String select = "billno,billstatus,org";
            ArrayList<String> billnos = new ArrayList<String>(16);
            HashSet<Long> proOrgSet = new HashSet<Long>(4);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sfc_protransferbill", (String)select, (QFilter[])qFilter, null);){
                while (dataSet.hasNext()) {
                    Row next = dataSet.next();
                    billnos.add(next.getString("billno"));
                    proOrgSet.add(next.getLong("org"));
                }
            }
            if (proOrgSet.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u4e0d\u540c\u65f6\uff0c\u4e0d\u652f\u6301\u6279\u91cf\u6267\u884c\u5012\u51b2\u9886\u6599\u3002", (String)"ProtransferBillList_0", (String)"mmc-sfc-formplugin", (Object[])new Object[0]));
                e.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            if (billnos.size() > 0 && proOrgSet.size() == 1) {
                BillShowParameter showParameter = MftOrderReportTplUtils.createAddNewBillShowParam(billnos, (Object)proOrgSet.toArray()[0]);
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }
}

