/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.formplugin.resourceadjust;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bd.mpdm.business.manuftech.OprUnitHelper;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.mmc.sfc.common.utils.QueryOrderUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ResourcesAdjustEdit
extends AbstractBillPlugIn
implements TabSelectListener,
BeforeF7SelectListener,
RowClickEventListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit manufactureorderText = (BasedataEdit)this.getView().getControl("manftechno");
        manufactureorderText.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit edit = (BasedataEdit)this.getControl("ecostcenter");
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fileName = beforeF7SelectEvent.getProperty().getName();
        if ("ecostcenter".equals(fileName)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setMultiSelect(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        ChangeData[] changeArr = e.getChangeSet();
        switch (propertyName) {
            case "manftechno": {
                break;
            }
            case "repactivity": {
                for (int i = 0; i < changeArr.length; ++i) {
                    ChangeData changedata = changeArr[i];
                    DynamicObject newValue = (DynamicObject)changedata.getNewValue();
                    if (newValue == null) continue;
                    DynamicObject unit = newValue.getDynamicObject("unit");
                    model.setValue("unit", (Object)unit, changedata.getRowIndex());
                }
                break;
            }
            case "adjustqty": {
                this.adjustQtyChange(changeArr, model);
                break;
            }
        }
    }

    private void manftechnoChange(ChangeData[] changeArr, IDataModel model) {
    }

    private void adjustQtyChange(ChangeData[] changeArr, IDataModel model) {
        for (int i = 0; i < changeArr.length; ++i) {
            ChangeData changedata = changeArr[i];
            int rowIndex = changedata.getRowIndex();
            BigDecimal newValue = (BigDecimal)changedata.getNewValue();
            String oprEntryId = (String)model.getValue("manftechentry", rowIndex);
            long id = NumberUtils.toLong((String)oprEntryId);
            Map manftechByEntryId = QueryOrderUtil.getManftechByEntryId((Set)Sets.newHashSet((Object[])new Long[]{id}));
            Map map = (Map)manftechByEntryId.get(id);
            if (newValue != null) {
                model.setValue("adjustbaseqty", (Object)OprUnitHelper.getBaseQty((Map)map, (BigDecimal)newValue), rowIndex);
                continue;
            }
            model.setValue("adjustbaseqty", null, rowIndex);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": {
                this.checkManftechEntry(e);
                break;
            }
            case "submit": {
                this.checkManftechEntry(e);
                break;
            }
        }
    }

    private void checkManftechEntry(BeforeDoOperationEventArgs e) {
        IDataModel bill = this.getModel();
        if (bill != null) {
            int rowCount = this.getModel().getEntryRowCount("sumentry");
            ArrayList<String> collect = new ArrayList<String>(10);
            for (int i = 0; i < rowCount; ++i) {
                collect.add((String)this.getModel().getValue("manftechentry", i));
            }
            HashMap<String, Integer> map = new HashMap<String, Integer>(16);
            for (String string : collect) {
                Integer i = 1;
                if (map.get(string) != null) {
                    i = (Integer)map.get(string) + 1;
                }
                map.put(string, i);
            }
            for (Map.Entry entry : map.entrySet()) {
                if ((Integer)entry.getValue() <= 1) continue;
                for (int j = 0; j < rowCount; ++j) {
                    if (!StringUtils.equals((CharSequence)((CharSequence)entry.getKey()), (CharSequence)((String)this.getModel().getValue("manftechentry", j)))) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u5de5\u5e8f\u5206\u5f55\u91cd\u590d\uff0c\u8bf7\u5220\u9664\u3002", (String)"ResourcesAdjustEdit_1", (String)"mmc-sfc-formplugin", (Object[])new Object[0]), j + 1));
                }
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        int rowcount = this.getModel().getEntryRowCount("sumentry");
        if (rowcount > 0) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"docbilltype"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"docbilltype"});
        }
    }
}

