/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.opplugin.dailyplan;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.sfc.common.dailyplan.utils.DailyPlanToReportUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class DailyPlanToReportOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(DailyPlanToReportOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("billentry.billentryid");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        HashSet<Long> dailyEntryIds = new HashSet<Long>(16);
        for (DynamicObject mydailyFinishWork : dataEntities = e.getDataEntities()) {
            DynamicObjectCollection billentrys = mydailyFinishWork.getDynamicObjectCollection("billentry");
            for (DynamicObject billentry : billentrys) {
                dailyEntryIds.add(billentry.getLong("billentryid"));
            }
        }
        if (CollectionUtils.isNotEmpty(dailyEntryIds)) {
            QFilter qFilter = new QFilter("oprentryentity.id", "in", dailyEntryIds);
            String selectPro = "tasksrctype,oprentryentity.srcbillid,oprentryentity.srcbillentryid,oprentryentity.workhour,oprentryentity.profession,oprentryentity.dailyexptype,repsubentryentity.id,repsubentryentity.person,repsubentryentity.reportbegintime,repsubentryentity.reportendtime,repsubentryentity.workhourunit,repsubentryentity.actualhour,repsubentryentity.worktype,repsubentryentity.isreported";
            DynamicObject[] dailyplanUserBills = BusinessDataServiceHelper.load((String)"sfc_dailyplan", (String)selectPro, (QFilter[])new QFilter[]{qFilter});
            if (null != dailyplanUserBills) {
                Date now = new Date();
                Map reportMap = DailyPlanToReportUtils.dailyPlanToReport((DynamicObject[])dailyplanUserBills, (Date)now);
                String errorInfo = (String)reportMap.get("errorInfo");
                this.getOption().setVariableValue("pushReportErrorInfo", errorInfo);
                HashSet<Long> successEntryIdSet = new HashSet<Long>(16);
                Set successEntrys = (Set)reportMap.get("successEntrys");
                for (DynamicObject successEntry : successEntrys) {
                    successEntryIdSet.add(successEntry.getLong("id"));
                }
                String successEntryId = StringUtils.join(successEntryIdSet, (String)",");
                this.getOption().setVariableValue("pushReportSuccessEntryId", successEntryId);
                SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String pushReportTime = sf.format(now);
                this.getOption().setVariableValue("pushReportTime", pushReportTime);
            }
        }
    }
}

