/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.opplugin.dailyplan;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.sfc.common.utils.SFCUtils;

public class ShiftHandoverSaveSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs ppea) {
        super.onPreparePropertys(ppea);
        List lFieldKey = ppea.getFieldKeys();
        lFieldKey.add("contentry.contentrynotice");
        lFieldKey.add("spntcentry.spntcentrycontent");
        lFieldKey.add("spntcentry.spntcentrytype");
        lFieldKey.add("billno");
        lFieldKey.add("industry");
        lFieldKey.add("handoverstatus");
        lFieldKey.add("isspntcentryupd");
        lFieldKey.add("iscontentryupd");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs boa) {
        super.beforeExecuteOperationTransaction(boa);
        DynamicObject[] doDatas = boa.getDataEntities();
        String oprKey = boa.getOperationKey();
        if (!"submit".equalsIgnoreCase(oprKey)) {
            return;
        }
        OperationResult or = this.getOperationResult();
        if (!or.isSuccess()) {
            return;
        }
        for (DynamicObject doData : doDatas) {
            doData.set("handoverstatus", (Object)"");
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs aoa) {
        super.afterExecuteOperationTransaction(aoa);
        DynamicObject[] doDatas = aoa.getDataEntities();
        String oprKey = aoa.getOperationKey();
        if (!"submit".equalsIgnoreCase(oprKey)) {
            return;
        }
        OperationResult or = this.getOperationResult();
        if (!or.isSuccess()) {
            return;
        }
        RequestContext rcCur = RequestContext.get();
        long curUserID = rcCur.getCurrUserId();
        long curOrgID = rcCur.getOrgId();
        DynamicObject doCurUser = curUserID > 0L ? BusinessDataServiceHelper.loadSingleFromCache((Object)curUserID, (String)"bos_user", (String)"number,name") : null;
        DynamicObject doCurOrg = curOrgID > 0L ? BusinessDataServiceHelper.loadSingleFromCache((Object)curOrgID, (String)"bos_org", (String)"number,name") : null;
        ORM orm = ORM.create();
        ArrayList<DynamicObject> lUpdNotice = new ArrayList<DynamicObject>();
        HashSet<String> sNotice = new HashSet<String>();
        for (DynamicObject doData : doDatas) {
            Object objIndustryPK;
            String billNO = doData.getString("billno");
            if (StringUtils.isEmpty((CharSequence)billNO)) {
                billNO = "";
            }
            boolean isPNTCEntryUpd = doData.getBoolean("isspntcentryupd");
            boolean isContEntryUpd = doData.getBoolean("iscontentryupd");
            if (!isPNTCEntryUpd && !isContEntryUpd) continue;
            DynamicObject doIndustry = doData.getDynamicObject("industry");
            Object object = objIndustryPK = doIndustry == null ? null : doIndustry.getPkValue();
            Long lIndustryPK = objIndustryPK == null ? -1L : (objIndustryPK instanceof Long ? (Long)objIndustryPK : -1L);
            if (lIndustryPK <= 0L || !isPNTCEntryUpd) continue;
            DynamicObjectCollection docSPTNCEntry = doData.getDynamicObjectCollection("spntcentry");
            for (DynamicObject doSPTNCEntry : docSPTNCEntry) {
                String noticeKey;
                DynamicObject doNotice;
                String content = doSPTNCEntry.getString("spntcentrycontent");
                String type = doSPTNCEntry.getString("spntcentrytype");
                if (StringUtils.isEmpty((CharSequence)content) || StringUtils.isEmpty((CharSequence)type) || !"T".equalsIgnoreCase(type) && !"Z".equalsIgnoreCase(type) || (doNotice = BusinessDataServiceHelper.loadSingleFromCache((String)"sfc_precautions", (String)"number,name,contents", (QFilter[])new QFilter[]{new QFilter("type", "=", (Object)type).and(new QFilter("professiona", "=", (Object)lIndustryPK).and(new QFilter("contents", "=", (Object)content)))})) != null || !sNotice.add(noticeKey = type + " " + lIndustryPK + " " + content)) continue;
                DynamicObject doNewNotice = BusinessDataServiceHelper.newDynamicObject((String)"sfc_precautions");
                doNewNotice.set("number", (Object)billNO);
                doNewNotice.set("name", (Object)billNO);
                doNewNotice.set("type", (Object)type);
                doNewNotice.set("contents", (Object)content);
                doNewNotice.set("professiona", (Object)doIndustry);
                doNewNotice.set("status", (Object)"C");
                doNewNotice.set("creator", (Object)doCurUser);
                doNewNotice.set("enable", (Object)"1");
                doNewNotice.set("createorg", (Object)doCurOrg);
                doNewNotice.set("org", (Object)doCurOrg);
                doNewNotice.set("useorg", (Object)doCurOrg);
                doNewNotice.set("ctrlstrategy", (Object)"5");
                String newNoticeNumbers = CodeRuleServiceHelper.getNumber((String)"sfc_precautions", (DynamicObject)doNewNotice, (String)String.valueOf(curOrgID));
                if (StringUtils.isEmpty((CharSequence)newNoticeNumbers)) {
                    doNewNotice.set("number", (Object)billNO);
                    doNewNotice.set("name", (Object)billNO);
                } else {
                    doNewNotice.set("number", (Object)newNoticeNumbers);
                    doNewNotice.set("name", (Object)newNoticeNumbers);
                }
                lUpdNotice.add(doNewNotice);
            }
        }
        if (!SFCUtils.isEmptyList(lUpdNotice)) {
            SaveServiceHelper.save((DynamicObject[])lUpdNotice.toArray(new DynamicObject[0]));
            for (DynamicObject doNewNotice : lUpdNotice) {
                doNewNotice.set("masterid", doNewNotice.getPkValue());
            }
            SaveServiceHelper.save((DynamicObject[])lUpdNotice.toArray(new DynamicObject[0]));
        }
    }
}

