/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.opplugin.event;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.business.manuftech.OprUnitHelper;
import kd.bd.mpdm.common.manuftech.bean.ManuFetchEntryBean;
import kd.bd.mpdm.common.manuftech.bean.ManuFetchEntryBeanUtils;
import kd.bd.mpdm.common.manuftech.utils.ChangeEntryStartOrCompletionTimeUtil;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.sfc.common.manuftech.utils.ChangeTechnicsBillEntryStatus;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class InspResultAuditWbReportPlugin
implements IEventServicePlugin {
    private static Log logger = LogFactory.getLog(InspResultAuditWbReportPlugin.class);

    public Object handleEvent(KDBizEvent e) {
        Object jParamObject = JSONObject.parse((String)e.getSource());
        if (jParamObject == null) {
            return e.getEventId();
        }
        JSONObject param = new JSONObject();
        if (jParamObject instanceof JSONArray) {
            param = ((JSONArray)jParamObject).getJSONObject(0);
        } else if (jParamObject instanceof JSONObject) {
            param = (JSONObject)jParamObject;
        }
        this.updateSumEntry(param);
        return e.getEventId();
    }

    private void updateSumEntry(JSONObject param) {
        QFilter filter;
        HashSet<Long> entryIds = new HashSet<Long>();
        HashSet<Long> updateEntryIds = new HashSet<Long>();
        HashBasedTable data = HashBasedTable.create();
        JSONArray array = param.getJSONArray("srcbills");
        for (int i = 0; i < array.size(); ++i) {
            if (array.getJSONObject(i).getLong("srcbillentryid") != null) {
                entryIds.add(array.getJSONObject(i).getLong("srcbillentryid"));
            }
            if (!"960042738642880512".equals(param.getString("biztype")) || !StringUtils.isNotBlank((CharSequence)array.getJSONObject(i).getString("samplingresult"))) continue;
            updateEntryIds.add(array.getJSONObject(i).getLong("srcbillentryid"));
            data.put((Object)array.getJSONObject(i).getLong("result_entryid"), (Object)array.getJSONObject(i).getString("samplingresult"), (Object)array.getJSONObject(i).getLong("srcbillentryid"));
        }
        String entity = param.getString("ck_srcentitynumber");
        HashSet<Long> oprEntryIds = new HashSet<Long>(16);
        DynamicObject[] objects = new DynamicObject[]{};
        if ("sfc_processreportbill".equals(entity)) {
            filter = new QFilter("sumentry.id", "in", entryIds);
            for (DynamicObject object : objects = BusinessDataServiceHelper.load((String)entity, (String)"reportdate,oprentryid,warehousepoint,qualifyqty,qualifybaseqty,receiveqty,receivebaseqty,confirmoprstatus,workwasteqty,workwastebaseqty,scrapqty,scrapbaseqty,junkqty,junkbaseqty,repairqty,repairbaseqty,checkreworkqty,checkreworkbaseqty,subentryentity1.conformityqty3,subentryentity1.qualifyqty3,subentryentity1.scrapqty3,subentryentity1.badqualifyqty3,subentryentity1.discardqty3,subentryentity1.badconformityqty3,subentryentity1.matertype3,repsubentryentity.repactualbegintime,repsubentryentity.repactualfinishtime", (QFilter[])new QFilter[]{filter})) {
                DynamicObjectCollection collection = object.getDynamicObjectCollection("sumentry");
                for (DynamicObject dynamicObject : collection) {
                    oprEntryIds.add(dynamicObject.getLong("oprentryid"));
                }
            }
        } else if ("sfc_protransferbill".equals(entity)) {
            filter = new QFilter("outentryentity.id", "in", entryIds);
            for (DynamicObject object : objects = BusinessDataServiceHelper.load((String)entity, (String)"outprocessid,outqualifyqty,outreceiveqty,outworkwasteqty,outscrapqty,outjunkqty,outreworkqty,outqualifybaseqty,outreceivebaseqty,outworkwastebaseqty,outscrapbaseqty,outreworkbaseqty,outjunkbaseqty,conformityqty,badconformityqty,discardqty", (QFilter[])new QFilter[]{filter})) {
                DynamicObjectCollection collection = object.getDynamicObjectCollection("outentryentity");
                for (DynamicObject dynamicObject : collection) {
                    if (dynamicObject.getDynamicObject("outprocessid") == null) continue;
                    oprEntryIds.add(dynamicObject.getDynamicObject("outprocessid").getLong("id"));
                }
            }
        }
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)"sfc_manftech", (String)"baseunit,material,operationqty,headqty,headunit,oprunit,firstinspectionstatus,oprtotalqualifiedqty,oprtotalqualifiedbaseqty,oprtotalreceiveqty,receivebaseqty,oprtotalreceivebaseqty,oprtotalwasteqty,oprtotalwastebaseqty,oprtotalmaterialqty,floorqty,oprtotalmaterialbaseqty,oprtotaljunkqty,oprtotaljunkbaseqty,oprtotalreworkqty,oprtotalreworkbaseqty,oprrepairedqty,oprrepairedbaseqty,actualstarttime,actualcompletiontime,transactiontype,mftentryseq,modifier,modifytime,machiningtype,oprstatus", (QFilter[])new QFilter[]{new QFilter("oprentryentity.id", "in", oprEntryIds)});
        if ("sfc_processreportbill".equals(entity)) {
            this.updateProcessReport(objects, datas, (Table<Long, String, Long>)data, param, updateEntryIds);
        } else if ("sfc_protransferbill".equals(entity)) {
            this.updateProTransfer(objects, datas);
        }
    }

    private void updateProcessReport(DynamicObject[] objects, DynamicObject[] datas, Table<Long, String, Long> data, JSONObject param, Set<Long> updateEntryIds) {
        Map column2;
        Map column1;
        Map column;
        HashBasedTable manftechParam = HashBasedTable.create();
        ArrayList<ManuFetchEntryBean> list = new ArrayList<ManuFetchEntryBean>(10);
        for (DynamicObject object : objects) {
            DynamicObjectCollection collection = object.getDynamicObjectCollection("sumentry");
            for (DynamicObject obj : collection) {
                if (!StringUtils.isNotBlank((CharSequence)obj.getString("oprentryid"))) continue;
                DynamicObjectCollection dynamicObjectCollection = obj.getDynamicObjectCollection("repsubentryentity");
                Optional<DynamicObject> min = dynamicObjectCollection.stream().min(Comparator.comparing(x -> x.getDate("repactualbegintime")));
                DynamicObject[] max = dynamicObjectCollection.stream().max(Comparator.comparing(x -> x.getDate("repactualfinishtime")));
                list.add(ManuFetchEntryBeanUtils.buildBean((Long)obj.getLong("oprentryid"), min, (Optional)max, (Date)object.getDate("reportdate")));
            }
        }
        Map<Long, List<ManuFetchEntryBean>> beanListMap = list.stream().collect(Collectors.groupingBy(ManuFetchEntryBean::getOprEntry));
        HashMap dateMap = new HashMap(16);
        beanListMap.forEach((k, v) -> {
            ManuFetchEntryBean max = v.stream().max(Comparator.comparing(ManuFetchEntryBean::getMax)).orElseGet(() -> new ManuFetchEntryBean());
            ManuFetchEntryBean min = v.stream().min(Comparator.comparing(ManuFetchEntryBean::getMin)).orElseGet(() -> new ManuFetchEntryBean());
            ManuFetchEntryBean bean = new ManuFetchEntryBean();
            bean.setOprEntry(k);
            bean.setMin(min.getMin());
            bean.setMax(max.getMax());
            dateMap.put(k, bean);
        });
        for (DynamicObject object : objects) {
            DynamicObjectCollection collection = object.getDynamicObjectCollection("sumentry");
            for (DynamicObject dynamicObject : collection) {
                for (DynamicObject manFtech : datas) {
                    DynamicObjectCollection dynamicObjectCollection = manFtech.getDynamicObjectCollection("oprentryentity");
                    for (DynamicObject oprObject : dynamicObjectCollection) {
                        if (!dynamicObject.getString("oprentryid").equals(oprObject.getPkValue().toString())) continue;
                        Map map = OprUnitHelper.getManftechMap((DynamicObject)manFtech, (DynamicObject)oprObject);
                        ManuFetchEntryBean manuFetchEntryBean = (ManuFetchEntryBean)dateMap.get(dynamicObject.getLong("oprentryid"));
                        this.updateProcessReportQty(dynamicObject, map);
                        this.updateManftechQty(oprObject, map);
                        if (updateEntryIds.contains(dynamicObject.getLong("id"))) {
                            if ("audit".equals(param.getString("operate"))) {
                                oprObject.set("firstinspectionstatus", (Object)(data.column((Object)"Y").values().contains(dynamicObject.getLong("id")) ? "C" : "N"));
                            } else if ("unaudit".equals(param.getString("operate"))) {
                                oprObject.set("firstinspectionstatus", (Object)"A");
                            }
                        }
                        if ("audit".equals(param.getString("operate"))) {
                            if (StringUtils.equals((CharSequence)"10070", (CharSequence)dynamicObject.getString("confirmoprstatus"))) {
                                if (oprObject.getBigDecimal("floorqty").compareTo(oprObject.getBigDecimal("oprtotalqualifiedqty").add(oprObject.getBigDecimal("oprtotalreceiveqty"))) <= 0) {
                                    manftechParam.put((Object)oprObject.getLong("id"), (Object)"row_finish", (Object)"F");
                                    ChangeEntryStartOrCompletionTimeUtil.changeEntryStartOrCompletionTimeToFinish((DynamicObject)oprObject, (Date)manuFetchEntryBean.getMin(), (Date)manuFetchEntryBean.getMax());
                                    continue;
                                }
                                manftechParam.put((Object)oprObject.getLong("id"), (Object)"row_start", (Object)"E");
                                ChangeEntryStartOrCompletionTimeUtil.changeEntryStartOrCompletionTimeToStart((DynamicObject)oprObject, (Date)manuFetchEntryBean.getMin());
                                continue;
                            }
                            if (!StringUtils.equals((CharSequence)"10080", (CharSequence)dynamicObject.getString("confirmoprstatus"))) continue;
                            manftechParam.put((Object)oprObject.getLong("id"), (Object)"row_finish", (Object)"F");
                            ChangeEntryStartOrCompletionTimeUtil.changeEntryStartOrCompletionTimeToFinish((DynamicObject)oprObject, (Date)manuFetchEntryBean.getMin(), (Date)manuFetchEntryBean.getMax());
                            continue;
                        }
                        if (!"unaudit".equals(param.getString("operate")) || oprObject.getBigDecimal("floorqty").compareTo(oprObject.getBigDecimal("oprtotalqualifiedqty").add(oprObject.getBigDecimal("oprtotalreceiveqty"))) <= 0) continue;
                        manftechParam.put((Object)oprObject.getLong("id"), (Object)"row_unstart", (Object)"E");
                        oprObject.set("actualcompletiontime", null);
                    }
                }
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("subentryentity1");
                if (!dynamicObject.getBoolean("warehousepoint") || !CollectionUtils.isNotEmpty((Collection)dynamicObjectCollection)) continue;
                for (DynamicObject dyObject : dynamicObjectCollection) {
                    if (!"C".equals(dyObject.getString("matertype3"))) continue;
                    dyObject.set("qualifyqty3", (Object)dynamicObject.getBigDecimal("qualifybaseqty").add(dynamicObject.getBigDecimal("receivebaseqty")));
                    dyObject.set("scrapqty3", (Object)dynamicObject.getBigDecimal("junkbaseqty"));
                    dyObject.set("badqualifyqty3", (Object)dynamicObject.getBigDecimal("repairbaseqty").add(dynamicObject.getBigDecimal("checkreworkbaseqty")));
                    dyObject.set("conformityqty3", (Object)dynamicObject.getBigDecimal("qualifyqty").add(dynamicObject.getBigDecimal("receiveqty")));
                    dyObject.set("discardqty3", (Object)dynamicObject.getBigDecimal("junkqty"));
                    dyObject.set("badconformityqty3", (Object)dynamicObject.getBigDecimal("repairqty").add(dynamicObject.getBigDecimal("checkreworkqty")));
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])objects);
        if (manftechParam.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])datas);
        }
        if (CollectionUtils.isNotEmpty((column = manftechParam.column((Object)"row_unstart")).keySet())) {
            ChangeTechnicsBillEntryStatus.changeEntryStatus2((String)"E", (boolean)false, (String)"row_unstart", column.keySet(), (DynamicObject[])datas);
        }
        if (CollectionUtils.isNotEmpty((column1 = manftechParam.column((Object)"row_finish")).keySet())) {
            ChangeTechnicsBillEntryStatus.changeEntryStatus2((String)"F", (boolean)false, (String)"row_finish", column1.keySet(), (DynamicObject[])datas);
        }
        if (CollectionUtils.isNotEmpty((column2 = manftechParam.column((Object)"row_start")).keySet())) {
            ChangeTechnicsBillEntryStatus.changeEntryStatus2((String)"E", (boolean)false, (String)"row_start", column2.keySet(), (DynamicObject[])datas);
        }
    }

    private void updateProTransfer(DynamicObject[] objects, DynamicObject[] datas) {
        for (DynamicObject object : objects) {
            DynamicObjectCollection collection = object.getDynamicObjectCollection("outentryentity");
            for (DynamicObject dynamicObject : collection) {
                for (DynamicObject manFtech : datas) {
                    DynamicObjectCollection dynamicObjectCollection = manFtech.getDynamicObjectCollection("oprentryentity");
                    for (DynamicObject oprObject : dynamicObjectCollection) {
                        if (!Objects.equals(oprObject.getPkValue(), dynamicObject.getDynamicObject("outprocessid").getPkValue())) continue;
                        Map map = OprUnitHelper.getManftechMap((DynamicObject)manFtech, (DynamicObject)oprObject);
                        this.updateProTransferQty(dynamicObject, map);
                        this.updateManftechQty(oprObject, map);
                    }
                }
            }
        }
        SaveServiceHelper.save((DynamicObject[])objects);
        SaveServiceHelper.save((DynamicObject[])datas);
    }

    private void updateProcessReportQty(DynamicObject dynamicObject, Map<String, Object> map) {
        dynamicObject.set("qualifyqty", (Object)OprUnitHelper.getOprQty(map, (BigDecimal)dynamicObject.getBigDecimal("qualifybaseqty")));
        dynamicObject.set("receiveqty", (Object)OprUnitHelper.getOprQty(map, (BigDecimal)dynamicObject.getBigDecimal("receivebaseqty")));
        dynamicObject.set("workwasteqty", (Object)OprUnitHelper.getOprQty(map, (BigDecimal)dynamicObject.getBigDecimal("workwastebaseqty")));
        dynamicObject.set("scrapqty", (Object)OprUnitHelper.getOprQty(map, (BigDecimal)dynamicObject.getBigDecimal("scrapbaseqty")));
        dynamicObject.set("junkqty", (Object)OprUnitHelper.getOprQty(map, (BigDecimal)dynamicObject.getBigDecimal("junkbaseqty")));
        dynamicObject.set("repairqty", (Object)OprUnitHelper.getOprQty(map, (BigDecimal)dynamicObject.getBigDecimal("repairbaseqty")));
        dynamicObject.set("checkreworkqty", (Object)OprUnitHelper.getOprQty(map, (BigDecimal)dynamicObject.getBigDecimal("checkreworkbaseqty")));
    }

    private void updateProTransferQty(DynamicObject dynamicObject, Map<String, Object> map) {
        dynamicObject.set("outqualifyqty", (Object)OprUnitHelper.getOprQty(map, (BigDecimal)dynamicObject.getBigDecimal("outqualifybaseqty")));
        dynamicObject.set("outreceiveqty", (Object)OprUnitHelper.getOprQty(map, (BigDecimal)dynamicObject.getBigDecimal("outreceivebaseqty")));
        dynamicObject.set("outworkwasteqty", (Object)OprUnitHelper.getOprQty(map, (BigDecimal)dynamicObject.getBigDecimal("outworkwastebaseqty")));
        dynamicObject.set("outscrapqty", (Object)OprUnitHelper.getOprQty(map, (BigDecimal)dynamicObject.getBigDecimal("outscrapbaseqty")));
        dynamicObject.set("outjunkqty", (Object)OprUnitHelper.getOprQty(map, (BigDecimal)dynamicObject.getBigDecimal("outjunkbaseqty")));
        dynamicObject.set("outreworkqty", (Object)OprUnitHelper.getOprQty(map, (BigDecimal)dynamicObject.getBigDecimal("outreworkbaseqty")));
        dynamicObject.set("conformityqty", (Object)dynamicObject.getBigDecimal("outqualifyqty").add(dynamicObject.getBigDecimal("outreceiveqty")));
        dynamicObject.set("badconformityqty", (Object)dynamicObject.getBigDecimal("outreworkqty"));
        dynamicObject.set("discardqty", (Object)dynamicObject.getBigDecimal("outworkwasteqty").add(dynamicObject.getBigDecimal("outscrapqty")));
    }

    private void updateManftechQty(DynamicObject oprObject, Map<String, Object> map) {
        oprObject.set("oprtotalqualifiedqty", (Object)OprUnitHelper.getOprQty(map, (BigDecimal)oprObject.getBigDecimal("oprtotalqualifiedbaseqty")));
        oprObject.set("oprtotalreceiveqty", (Object)OprUnitHelper.getOprQty(map, (BigDecimal)oprObject.getBigDecimal("oprtotalreceivebaseqty")));
        oprObject.set("oprtotalwasteqty", (Object)OprUnitHelper.getOprQty(map, (BigDecimal)oprObject.getBigDecimal("oprtotalwastebaseqty")));
        oprObject.set("oprtotalmaterialqty", (Object)OprUnitHelper.getOprQty(map, (BigDecimal)oprObject.getBigDecimal("oprtotalmaterialbaseqty")));
        oprObject.set("oprtotaljunkqty", (Object)OprUnitHelper.getOprQty(map, (BigDecimal)oprObject.getBigDecimal("oprtotaljunkbaseqty")));
        oprObject.set("oprtotalreworkqty", (Object)OprUnitHelper.getOprQty(map, (BigDecimal)oprObject.getBigDecimal("oprtotalreworkbaseqty")));
        oprObject.set("oprrepairedqty", (Object)OprUnitHelper.getOprQty(map, (BigDecimal)oprObject.getBigDecimal("oprrepairedbaseqty")));
    }
}

