/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.opplugin.event;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class InspResultGenMftmanuinbill
implements IEventServicePlugin {
    private static Log logger = LogFactory.getLog(InspResultGenMftmanuinbill.class);
    private static final String POM_MFTORDERREPORT = "pom_mftorderreport";
    private static final String SFC_PROCESSREPORTBILL = "sfc_processreportbill";
    private static final String IM_MDC_MFTMANUINBILL = "im_mdc_mftmanuinbill";
    public static final String KEY_QUALIFYBSQTY = "qualifybsqty";
    public static final String KEY_UNQUALIFYBSQTY = "unqualifybsqty";
    public static final String KEY_SCRAPPEDBSQTY = "scrappedbsqty";

    public Object handleEvent(KDBizEvent e) {
        Object jParamObject = JSONObject.parse((String)e.getSource());
        if (jParamObject == null) {
            return e.getEventId();
        }
        JSONObject param = new JSONObject();
        if (jParamObject instanceof JSONArray) {
            param = ((JSONArray)jParamObject).getJSONObject(0);
        } else if (jParamObject instanceof JSONObject) {
            param = (JSONObject)jParamObject;
        }
        this.genMftmanuinbil(param);
        return e.getEventId();
    }

    private void genMftmanuinbil(JSONObject param) {
        String entity = param.getString("ck_srcentitynumber");
        logger.info("entity:" + entity);
        if ("unaudit".equalsIgnoreCase(param.getString("operate"))) {
            return;
        }
        HashSet<Long> entryIds = new HashSet<Long>();
        JSONArray array = param.getJSONArray("srcbills");
        for (int i = 0; i < array.size(); ++i) {
            if (array.getJSONObject(i).getLong("srcbillentryid") == null) continue;
            entryIds.add(array.getJSONObject(i).getLong("srcbillentryid"));
        }
        logger.info("entryIds:" + entryIds);
        HashMap entryidAndId = Maps.newHashMapWithExpectedSize((int)entryIds.size());
        HashMap entryidAndMftEntryId = Maps.newHashMapWithExpectedSize((int)entryIds.size());
        String ruleId = "";
        Map<Object, Object> customParams = new HashMap();
        if (SFC_PROCESSREPORTBILL.equals(entity)) {
            this.getProcessReportBill(entryidAndId, entryIds, entryidAndMftEntryId);
            ruleId = "1194036655955331072";
            customParams = this.getProcessReportCustomParams(array, entryidAndMftEntryId);
        } else if (POM_MFTORDERREPORT.equals(entity)) {
            this.getMftorderReportBill(entryidAndId, entryIds);
            ruleId = "1114515031602500608";
            customParams = this.getMftorderReportCustomParams(array);
        }
        if (!entryidAndId.isEmpty() && (SFC_PROCESSREPORTBILL.equals(entity) || POM_MFTORDERREPORT.equals(entity))) {
            logger.info("entryidAndId:" + entryidAndId);
            PushArgs pushArgs = new PushArgs();
            pushArgs.setSourceEntityNumber(entity);
            pushArgs.setTargetEntityNumber(IM_MDC_MFTMANUINBILL);
            pushArgs.setHasRight(false);
            pushArgs.setCustomParams(customParams);
            pushArgs.setRuleId(ruleId);
            pushArgs.setBuildConvReport(true);
            ArrayList<ListSelectedRow> needPushRows = new ArrayList<ListSelectedRow>(10);
            for (Map.Entry entry : entryidAndId.entrySet()) {
                ListSelectedRow srcBill = new ListSelectedRow(entry.getValue());
                srcBill.setEntryEntityKey("sumentry");
                srcBill.setEntryPrimaryKeyValue(entry.getKey());
                needPushRows.add(srcBill);
            }
            logger.info("\u9700\u8981\u4e0b\u63a8\u7684\u884c\u6570:" + needPushRows.size());
            pushArgs.setSelectedRows(needPushRows);
            ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
            MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)IM_MDC_MFTMANUINBILL);
            List targetBillObjs = pushResult.loadTargetDataObjects(BusinessDataReader::loadRefence, targetMainType);
            if (targetBillObjs != null && !targetBillObjs.isEmpty()) {
                logger.info("\u4e0b\u63a8\u6210\u529f\u7684\u884c\u6570:" + targetBillObjs.size());
                OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)IM_MDC_MFTMANUINBILL, (DynamicObject[])targetBillObjs.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                List successPkIds = result.getSuccessPkIds().stream().map(v -> Long.parseLong(v.toString())).collect(Collectors.toList());
                logger.info("\u4fdd\u5b58\u6210\u529f\u7684\u5b8c\u5de5\u5165\u5e93\u5355\u7684\u6761\u6570:" + successPkIds.size());
            }
        }
    }

    private Map<String, String> getProcessReportCustomParams(JSONArray array, Map<Long, Long> entryidAndMftEntryId) {
        HashMap<String, String> customParams = new HashMap<String, String>(array.size());
        HashSet<String> isconcesionFields = new HashSet<String>();
        Map<String, String> methodAndField = this.getMethodAndField(isconcesionFields, SFC_PROCESSREPORTBILL);
        HashMap<String, Map<String, BigDecimal>> entryidAndQty = new HashMap<String, Map<String, BigDecimal>>(array.size());
        for (int i = 0; i < array.size(); ++i) {
            String field;
            Long entryIdobj = array.getJSONObject(i).getLong("srcbillentryid");
            if (entryIdobj == null || entryidAndMftEntryId.get(entryIdobj) == null) continue;
            String entryId = entryidAndMftEntryId.get(entryIdobj).toString();
            String handmethod_number = array.getJSONObject(i).getString("handmethod_number");
            BigDecimal qualitybaseqty = array.getJSONObject(i).getBigDecimal("qualitybaseqty");
            BigDecimal unqualitybaseqty = array.getJSONObject(i).getBigDecimal("unqualitybaseqty");
            if (entryidAndQty.get(entryId) == null) {
                entryidAndQty.put(entryId, new HashMap(4));
            }
            Map qtyMap = (Map)entryidAndQty.get(entryId);
            this.dealQualifybsQty(entryidAndQty, qtyMap, entryId, qualitybaseqty, "qualifyqty3");
            if (StringUtils.isEmpty((CharSequence)handmethod_number) || StringUtils.isEmpty((CharSequence)(field = methodAndField.get(handmethod_number)))) continue;
            if (isconcesionFields.contains(field)) {
                this.dealQualifybsQty(entryidAndQty, qtyMap, entryId, unqualitybaseqty, "qualifyqty3");
                continue;
            }
            this.dealQualifybsQty(entryidAndQty, qtyMap, entryId, unqualitybaseqty, field);
        }
        for (Map.Entry entry : entryidAndQty.entrySet()) {
            String value = SerializationUtils.serializeToBase64(entry.getValue());
            logger.info("value:" + value);
            customParams.put((String)entry.getKey(), value);
        }
        return customParams;
    }

    private Map<String, String> getMftorderReportCustomParams(JSONArray array) {
        HashMap<String, String> customParams = new HashMap<String, String>(array.size());
        Map<String, String> methodAndField = this.getMethodAndField(new HashSet<String>(), POM_MFTORDERREPORT);
        HashMap<String, Map<String, BigDecimal>> entryidAndQty = new HashMap<String, Map<String, BigDecimal>>(array.size());
        for (int i = 0; i < array.size(); ++i) {
            String field;
            Long entryIdobj = array.getJSONObject(i).getLong("srcbillentryid");
            if (entryIdobj == null) continue;
            String entryId = ((Object)entryIdobj).toString();
            String handmethod_number = array.getJSONObject(i).getString("handmethod_number");
            BigDecimal qualitybaseqty = array.getJSONObject(i).getBigDecimal("qualitybaseqty");
            BigDecimal unqualitybaseqty = array.getJSONObject(i).getBigDecimal("unqualitybaseqty");
            if (entryidAndQty.get(entryId) == null) {
                entryidAndQty.put(entryId, new HashMap(4));
            }
            Map qtyMap = (Map)entryidAndQty.get(entryId);
            this.dealQualifybsQty(entryidAndQty, qtyMap, entryId, qualitybaseqty, KEY_QUALIFYBSQTY);
            if (StringUtils.isEmpty((CharSequence)handmethod_number) || StringUtils.isEmpty((CharSequence)(field = methodAndField.get(handmethod_number)))) continue;
            this.dealQualifybsQty(entryidAndQty, qtyMap, entryId, unqualitybaseqty, field);
        }
        for (Map.Entry entry : entryidAndQty.entrySet()) {
            String value = SerializationUtils.serializeToBase64(entry.getValue());
            logger.info("value:" + value);
            customParams.put((String)entry.getKey(), value);
        }
        return customParams;
    }

    private void dealQualifybsQty(Map<String, Map<String, BigDecimal>> entryidAndQty, Map<String, BigDecimal> qtyMap, String entryId, BigDecimal qualitybaseqty, String field) {
        if (qtyMap.get(field) == null) {
            qtyMap.put(field, qualitybaseqty);
        } else {
            qtyMap.put(field, qtyMap.get(field).add(qualitybaseqty));
        }
        entryidAndQty.put(entryId, qtyMap);
    }

    private Map<String, String> getMethodAndField(Set<String> isconcesionFields, String pomMftorderreport) {
        HashMap<String, String> methodAndField = new HashMap<String, String>(6);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("sourcebill.id", "=", (Object)pomMftorderreport));
        qFilters.add(new QFilter("targetbill.id", "=", (Object)IM_MDC_MFTMANUINBILL));
        DynamicObject handmapping = BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_handmapping", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (handmapping == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u5b57\u6bb5\u5904\u7406\u65b9\u5f0f\u6620\u5c04\u4e3a\u7a7a\u3002", (String)"InspResultGenMftmanuinbill_0", (String)"mmc-sfc-opplugin", (Object[])new Object[0]));
        }
        ArrayList<Long> handmodeids = new ArrayList<Long>(6);
        DynamicObjectCollection entrys = handmapping.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entrys) {
            handmodeids.add(entry.getLong("handmodeid"));
        }
        HashMap<Long, String> handmodeIdAndNumber = new HashMap<Long, String>(6);
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)"query_qcbd_badhandmode", (String)"qcbd_badhandmode", (String)"entryentity.id,number", (QFilter[])new QFilter("entryentity.id", "in", handmodeids).toArray(), null);){
            for (Row row : dataset) {
                handmodeIdAndNumber.put(row.getLong("entryentity.id"), row.getString("number"));
            }
        }
        for (DynamicObject entry : entrys) {
            methodAndField.put((String)handmodeIdAndNumber.get(entry.getLong("handmodeid")), entry.getString("sourcefield"));
            if (!entry.getBoolean("isconcesion")) continue;
            isconcesionFields.add(entry.getString("sourcefield"));
        }
        return methodAndField;
    }

    private void getMftorderReportBill(Map<Long, Long> entryidAndId, Set<Long> entryIds) {
        ArrayList<QFilter> qfilers = new ArrayList<QFilter>(3);
        qfilers.add(new QFilter("sumentry.id", "in", entryIds));
        qfilers.add(new QFilter("sumentry.ischeckmaterial", "=", (Object)Character.valueOf('1')));
        qfilers.add(new QFilter("transactiontype.id", "in", this.getTransactProductIds()));
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)"query_pom_mftorderreport", (String)POM_MFTORDERREPORT, (String)"id,sumentry.id entryid", (QFilter[])qfilers.toArray(new QFilter[0]), null);){
            for (Row row : dataset) {
                entryidAndId.put(row.getLong("entryid"), row.getLong("id"));
            }
        }
    }

    private void getProcessReportBill(Map<Long, Long> entryidAndId, Set<Long> entryIds, Map<Long, Long> entryidAndMftEntryId) {
        ArrayList<QFilter> qfilers = new ArrayList<QFilter>(3);
        qfilers.add(new QFilter("sumentry.id", "in", entryIds));
        qfilers.add(new QFilter("sumentry.firstinspection", "=", (Object)Character.valueOf('1')).or(new QFilter("sumentry.inspectiontype", "in", (Object)new String[]{"1012", "1013"})));
        qfilers.add(new QFilter("transactiontype.id", "in", this.getTransactProductIds()));
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)"query_sfc_processreportbill", (String)SFC_PROCESSREPORTBILL, (String)"id,sumentry.id entryid,sumentry.manufactureentryid manufactureentryid", (QFilter[])qfilers.toArray(new QFilter[0]), null);){
            for (Row row : dataset) {
                entryidAndId.put(row.getLong("entryid"), row.getLong("id"));
                entryidAndMftEntryId.put(row.getLong("entryid"), row.getLong("manufactureentryid"));
            }
        }
    }

    private Set<Long> getTransactProductIds() {
        HashSet<Long> transactProductIds = new HashSet<Long>(16);
        String algoKey = "kd.mmc.sfc.opplugin.event.InspResultGenMftmanuinbill.getTransactProductIds";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"mpdm_transactproduct", (String)"id", (QFilter[])new QFilter("isautowarehouse", "=", (Object)Character.valueOf('1')).toArray(), null);){
            for (Row row : dataSet) {
                transactProductIds.add(row.getLong("id"));
            }
        }
        return transactProductIds;
    }
}

