/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.sfc.opplugin.manuftech;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.mpdm.business.manuftech.OprUnitHelper;
import kd.bd.mpdm.common.manuftech.utils.ChangeEntryStartOrCompletionTimeUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.mmc.sfc.common.manuftech.utils.ChangeTechnicsBillEntryStatus;
import kd.mmc.sfc.common.manuftech.utils.CheckUtil;
import kd.mmc.sfc.common.manuftech.utils.ManuftechUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ChangeManuftechBeginOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        String operateKey = this.getOption().getVariableValue("operatekey");
        DynamicObject[] bills = e.getDataEntities();
        switch (operateKey) {
            case "delete": {
                break;
            }
            case "audit": {
                for (DynamicObject load : bills) {
                    DynamicObjectCollection oprentrys = load.getDynamicObjectCollection("oprentryentity");
                    Map<String, List<DynamicObject>> map = oprentrys.stream().collect(Collectors.groupingBy(x -> x.getString("oprparent")));
                    map.forEach((k, v) -> {
                        Optional<DynamicObject> optional = v.stream().min(Comparator.comparing(x -> x.getString("oprno")));
                        if (optional.isPresent()) {
                            DynamicObject object = optional.get();
                            object.set("oprtotalinqty", object.get("oprqty"));
                            object.set("oprtotalinbaseqty", (Object)OprUnitHelper.getBaseQty((Map)OprUnitHelper.getManftechMap((DynamicObject)load, (DynamicObject)object), (BigDecimal)object.getBigDecimal("oprqty")));
                        }
                    });
                }
                ManuftechUtil.updateMftStock((DynamicObject[])bills);
                break;
            }
            case "unaudit": {
                for (DynamicObject load : bills) {
                    DynamicObjectCollection oprentrys = load.getDynamicObjectCollection("oprentryentity");
                    for (DynamicObject entry : oprentrys) {
                        entry.set("oprtotalinqty", (Object)0);
                        entry.set("oprtotaloutqty", (Object)0);
                        entry.set("oprtotalinbaseqty", (Object)0);
                        entry.set("oprtotaloutbaseqty", (Object)0);
                    }
                }
                break;
            }
            case "row_cancel": {
                this.changeStatus("", true, "row_cancel", bills);
                break;
            }
            case "row_uncancel": {
                this.changeStatus("", false, "row_uncancel", bills);
                break;
            }
            case "row_confirm": {
                this.changeStatus("C", false, "row_confirm", bills);
                break;
            }
            case "row_release": {
                this.changeStatus("D", false, "row_release", bills);
                break;
            }
            case "row_start": {
                this.changeStatus("E", false, "row_start", bills);
                break;
            }
            case "row_finish": {
                this.changeStatus("F", false, "row_finish", bills);
                break;
            }
            case "row_closed": {
                this.changeStatus("G", false, "row_closed", bills);
                break;
            }
            case "row_unconfirm": {
                this.changeStatus("C", false, "row_unconfirm", bills);
                break;
            }
            case "row_unrelease": {
                this.changeStatus("D", false, "row_unrelease", bills);
                break;
            }
            case "row_unstart": {
                this.changeStatus("E", false, "row_unstart", bills);
                break;
            }
            case "row_unfinish": {
                this.changeStatus("F", false, "row_unfinish", bills);
                break;
            }
            case "row_unplan": {
                this.changeStatus("B", false, "row_unplan", bills);
                break;
            }
        }
        ManuftechUtil.updateSFCManuftech((DynamicObject[])bills);
        e.setDataEntities(bills);
    }

    private void changeStatus(String status, boolean cancel, String operateKey, DynamicObject[] bills) {
        String sb = this.getOption().getVariableValue("operateOption");
        if (sb == null || "".equals(sb) || bills == null) {
            return;
        }
        List message = JSON.parseArray((String)sb, Long.class);
        ChangeEntryStartOrCompletionTimeUtil.changeEntryStartOrCompletionTime((Date)new Date(), (String)operateKey, (Set)Sets.newHashSet((Iterable)message), (DynamicObject[])bills);
        ChangeTechnicsBillEntryStatus.changeEntryStatus2((String)status, (boolean)cancel, (String)operateKey, (Set)Sets.newHashSet((Iterable)message), (DynamicObject[])bills);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operateKey = this.getOption().getVariableValue("operatekey");
        DynamicObject[] bills = e.getDataEntities();
        if (StringUtils.equals((CharSequence)"row_release", (CharSequence)operateKey)) {
            String sb = this.getOption().getVariableValue("operateOption");
            HashMap<String, Object> calparam = new HashMap<String, Object>(16);
            calparam.put("operate", operateKey);
            calparam.put("businesskey", Joiner.on((String)",").skipNulls().join((Iterable)Arrays.stream(bills).map(x -> x.getString("id")).collect(Collectors.toSet())));
            calparam.put("oprentryids", JSON.parseArray((String)sb, String.class));
            calparam.put("appId", "sfc");
            String jsonString = JSON.toJSONString(calparam);
            EventServiceHelper.triggerEventSubscribe((String)"autoCreateOrder", (String)jsonString);
            HashSet<Object> entryInIds = new HashSet<Object>(16);
            List selectLists = CheckUtil.getManftechEntryID((String)sb);
            if (CollectionUtils.isEmpty((Collection)selectLists)) {
                return;
            }
            for (DynamicObject bill : bills) {
                for (DynamicObject entry : bill.getDynamicObjectCollection("oprentryentity")) {
                    if (!selectLists.contains(entry.getPkValue()) || !StringUtils.equals((CharSequence)"1002", (CharSequence)entry.getString("machiningtype")) || !StringUtils.equals((CharSequence)"D", (CharSequence)entry.getString("oprstatus"))) continue;
                    entryInIds.add(entry.get("id"));
                }
            }
            if (CollectionUtils.isEmpty(entryInIds)) {
                return;
            }
            ManuftechUtil.autoPushOmApply((DynamicObject[])bills, (String)"B", (String)"oprentryentity", entryInIds);
        }
    }
}

